/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.delete;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import org.flowable.batch.api.Batch;
import org.flowable.batch.api.BatchPart;
import org.flowable.batch.api.BatchPartQuery;
import org.flowable.batch.service.impl.persistence.entity.BatchEntity;
import org.flowable.cmmn.api.CmmnManagementService;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.job.service.JobHandler;
import org.flowable.job.service.impl.persistence.entity.JobEntity;
import org.flowable.variable.api.delegate.VariableScope;

public class DeleteHistoricCaseInstanceIdsStatusJobHandler
implements JobHandler {
    public static final String TYPE = "delete-historic-case-status";

    public String getType() {
        return TYPE;
    }

    public void execute(JobEntity job, String configuration, VariableScope variableScope, CommandContext commandContext) {
        long totalCompleted;
        CmmnEngineConfiguration engineConfiguration = CommandContextUtil.getCmmnEngineConfiguration(commandContext);
        CmmnManagementService managementService = engineConfiguration.getCmmnManagementService();
        Batch batch = (Batch)managementService.createBatchQuery().batchId(configuration).singleResult();
        if (batch == null) {
            throw new FlowableIllegalArgumentException("There is no batch with the id " + configuration);
        }
        if ("stopped".equals(batch.getStatus())) {
            job.setRepeat(null);
            return;
        }
        long totalBatchParts = this.createStatusQuery(batch, managementService).count();
        if (totalBatchParts == (totalCompleted = this.createStatusQuery(batch, managementService).completed().count())) {
            List failedParts = this.createStatusQuery(batch, managementService).status("failed").list();
            long totalFailed = failedParts.size();
            if (totalFailed == 0L) {
                this.completeBatch(batch, "completed", engineConfiguration);
            } else {
                this.completeBatchFail(batch, failedParts, engineConfiguration);
            }
            job.setRepeat(null);
        } else if (totalBatchParts == 0L) {
            this.completeBatch(batch, "completed", engineConfiguration);
            job.setRepeat(null);
        }
    }

    protected BatchPartQuery createStatusQuery(Batch batch, CmmnManagementService managementService) {
        return managementService.createBatchPartQuery().batchId(batch.getId()).type("deleteCase");
    }

    protected void completeBatch(Batch batch, String status, CmmnEngineConfiguration engineConfiguration) {
        engineConfiguration.getBatchServiceConfiguration().getBatchService().completeBatch(batch.getId(), status);
    }

    protected void completeBatchFail(Batch batch, List<BatchPart> failedParts, CmmnEngineConfiguration engineConfiguration) {
        this.completeBatch(batch, "failed", engineConfiguration);
        long totalFailedInstances = 0L;
        ObjectMapper objectMapper = engineConfiguration.getObjectMapper();
        for (BatchPart failedPart : failedParts) {
            JsonNode node = this.readJson(failedPart.getResultDocumentJson("cmmn"), objectMapper);
            if (node == null) continue;
            totalFailedInstances += (long)node.path("caseInstanceIdsFailedToDelete").size();
        }
        ObjectNode batchDocument = (ObjectNode)this.readJson(batch.getBatchDocumentJson("cmmn"), objectMapper);
        batchDocument.put("numberOfFailedInstances", totalFailedInstances);
        ((BatchEntity)batch).setBatchDocumentJson(batchDocument.toString(), "cmmn");
    }

    protected JsonNode readJson(String json, ObjectMapper objectMapper) {
        if (json == null) {
            return null;
        }
        try {
            return objectMapper.readTree(json);
        }
        catch (JsonProcessingException e) {
            throw new FlowableException("Failed to read json", (Throwable)e);
        }
    }
}

