/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.delete;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.flowable.batch.api.Batch;
import org.flowable.batch.api.BatchPart;
import org.flowable.batch.api.BatchService;
import org.flowable.cmmn.api.CmmnHistoryService;
import org.flowable.cmmn.api.CmmnManagementService;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.util.ExceptionUtil;
import org.flowable.job.service.JobHandler;
import org.flowable.job.service.JobService;
import org.flowable.job.service.impl.persistence.entity.JobEntity;
import org.flowable.variable.api.delegate.VariableScope;

public class DeleteHistoricCaseInstanceIdsJobHandler
implements JobHandler {
    public static final String TYPE = "delete-historic-case-ids";

    public String getType() {
        return TYPE;
    }

    public void execute(JobEntity job, String configuration, VariableScope variableScope, CommandContext commandContext) {
        CmmnEngineConfiguration engineConfiguration = CommandContextUtil.getCmmnEngineConfiguration(commandContext);
        BatchService batchService = engineConfiguration.getBatchServiceConfiguration().getBatchService();
        BatchPart batchPart = batchService.getBatchPart(configuration);
        if (batchPart == null) {
            throw new FlowableIllegalArgumentException("There is no batch part with the id " + configuration);
        }
        Batch batch = batchService.getBatch(batchPart.getBatchId());
        if ("stopped".equals(batch.getStatus())) {
            batchService.completeBatchPart(batchPart.getId(), "stopped", null);
            return;
        }
        CmmnManagementService managementService = engineConfiguration.getCmmnManagementService();
        BatchPart computeBatchPart = (BatchPart)managementService.createBatchPartQuery().id(batchPart.getSearchKey()).singleResult();
        JsonNode computeBatchPartResult = this.getBatchPartResult(computeBatchPart, engineConfiguration);
        JsonNode idsToDelete = computeBatchPartResult.path("caseInstanceIdsToDelete");
        HashSet<String> caseInstanceIdsToDelete = new HashSet<String>();
        if (idsToDelete.isArray()) {
            for (JsonNode idNode : idsToDelete) {
                caseInstanceIdsToDelete.add(idNode.textValue());
            }
        }
        if (caseInstanceIdsToDelete.isEmpty()) {
            throw new FlowableIllegalArgumentException("There are no case instance ids to delete");
        }
        String status = "completed";
        ObjectNode resultNode = engineConfiguration.getObjectMapper().createObjectNode();
        CmmnHistoryService historyService = engineConfiguration.getCmmnHistoryService();
        try {
            historyService.bulkDeleteHistoricCaseInstances(caseInstanceIdsToDelete);
            resultNode.withArray("caseInstanceIdsDeleted").addAll((ArrayNode)idsToDelete);
        }
        catch (FlowableException ex) {
            status = "failed";
            resultNode.withArray("caseInstanceIdsFailedToDelete").addObject().put("id", (String)caseInstanceIdsToDelete.iterator().next()).put("error", ex.getMessage()).put("stacktrace", ExceptionUtils.getStackTrace((Throwable)ex));
        }
        batchService.completeBatchPart(batchPart.getId(), status, resultNode.toString());
        if (computeBatchPartResult.path("sequential").booleanValue()) {
            List nextDeleteParts = engineConfiguration.getCmmnManagementService().createBatchPartQuery().batchId(batchPart.getBatchId()).status("waiting").type("deleteCase").listPage(0, 2);
            boolean completeBatch = true;
            for (BatchPart nextDeletePart : nextDeleteParts) {
                if (nextDeletePart.getId().equals(batchPart.getId())) continue;
                completeBatch = false;
                JobService jobService = engineConfiguration.getJobServiceConfiguration().getJobService();
                JobEntity nextDeleteJob = jobService.createJob();
                nextDeleteJob.setJobHandlerType(TYPE);
                nextDeleteJob.setJobHandlerConfiguration(nextDeletePart.getId());
                nextDeleteJob.setScopeType("cmmn");
                jobService.createAsyncJob(nextDeleteJob, false);
                jobService.scheduleAsyncJob(nextDeleteJob);
                break;
            }
            if (completeBatch) {
                JobService jobService = engineConfiguration.getJobServiceConfiguration().getJobService();
                JobEntity nextDeleteJob = jobService.createJob();
                nextDeleteJob.setJobHandlerType("compute-delete-historic-case-status");
                nextDeleteJob.setJobHandlerConfiguration(batchPart.getBatchId());
                nextDeleteJob.setScopeType("cmmn");
                jobService.createAsyncJob(nextDeleteJob, false);
                jobService.scheduleAsyncJob(nextDeleteJob);
            }
        }
    }

    protected JsonNode getBatchPartResult(BatchPart batchPart, CmmnEngineConfiguration engineConfiguration) {
        try {
            return engineConfiguration.getObjectMapper().readTree(batchPart.getResultDocumentJson("cfg.processEngine"));
        }
        catch (JsonProcessingException e) {
            ExceptionUtil.sneakyThrow((Throwable)e);
            return null;
        }
    }
}

