/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.cmd;

import java.util.Collection;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseInstanceEntity;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;

public class RemoveVariablesCmd
implements Command<Void> {
    protected String caseInstanceId;
    protected Collection<String> variableNames;

    public RemoveVariablesCmd(String caseInstanceId, Collection<String> variableNames) {
        this.caseInstanceId = caseInstanceId;
        this.variableNames = variableNames;
    }

    public Void execute(CommandContext commandContext) {
        if (this.caseInstanceId == null) {
            throw new FlowableIllegalArgumentException("caseInstanceId is null");
        }
        if (this.variableNames == null) {
            throw new FlowableIllegalArgumentException("variableNames is null");
        }
        CaseInstanceEntity caseInstanceEntity = (CaseInstanceEntity)CommandContextUtil.getCaseInstanceEntityManager(commandContext).findById(this.caseInstanceId);
        if (caseInstanceEntity == null) {
            throw new FlowableObjectNotFoundException("No case instance found for id " + this.caseInstanceId, CaseInstanceEntity.class);
        }
        caseInstanceEntity.removeVariables(this.variableNames);
        return null;
    }
}

