/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.cmd;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import org.flowable.cmmn.api.CmmnManagementService;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.common.engine.impl.calendar.BusinessCalendar;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.job.api.Job;
import org.flowable.job.service.TimerJobService;
import org.flowable.job.service.impl.persistence.entity.TimerJobEntity;

public class HandleHistoryCleanupTimerJobCmd
implements Command<Object>,
Serializable {
    private static final long serialVersionUID = 1L;

    public Object execute(CommandContext commandContext) {
        CmmnEngineConfiguration cmmnEngineConfiguration = CommandContextUtil.getCmmnEngineConfiguration(commandContext);
        CmmnManagementService managementService = cmmnEngineConfiguration.getCmmnManagementService();
        List cleanupJobs = managementService.createTimerJobQuery().handlerType("cmmn-history-cleanup").list();
        if (cleanupJobs.isEmpty()) {
            this.scheduleTimerJob(cmmnEngineConfiguration);
        } else if (cleanupJobs.size() == 1) {
            TimerJobEntity timerJob = (TimerJobEntity)cleanupJobs.get(0);
            if (!Objects.equals(cmmnEngineConfiguration.getHistoryCleaningTimeCycleConfig(), timerJob.getRepeat())) {
                managementService.deleteTimerJob(timerJob.getId());
                this.scheduleTimerJob(cmmnEngineConfiguration);
            }
        } else {
            TimerJobEntity timerJob = (TimerJobEntity)cleanupJobs.get(0);
            if (!Objects.equals(cmmnEngineConfiguration.getHistoryCleaningTimeCycleConfig(), timerJob.getRepeat())) {
                managementService.deleteTimerJob(timerJob.getId());
                this.scheduleTimerJob(cmmnEngineConfiguration);
            }
            for (int i = 1; i < cleanupJobs.size(); ++i) {
                managementService.deleteTimerJob(((Job)cleanupJobs.get(i)).getId());
            }
        }
        return null;
    }

    protected void scheduleTimerJob(CmmnEngineConfiguration cmmnEngineConfiguration) {
        TimerJobService timerJobService = cmmnEngineConfiguration.getJobServiceConfiguration().getTimerJobService();
        TimerJobEntity timerJob = timerJobService.createTimerJob();
        timerJob.setJobType("timer");
        timerJob.setRevision(1);
        timerJob.setJobHandlerType("cmmn-history-cleanup");
        timerJob.setScopeType("cmmn");
        BusinessCalendar businessCalendar = cmmnEngineConfiguration.getBusinessCalendarManager().getBusinessCalendar("cycle");
        timerJob.setDuedate(businessCalendar.resolveDuedate(cmmnEngineConfiguration.getHistoryCleaningTimeCycleConfig()));
        timerJob.setRepeat(cmmnEngineConfiguration.getHistoryCleaningTimeCycleConfig());
        timerJobService.scheduleTimerJob(timerJob);
    }
}

