/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.cmd;

import java.io.Serializable;
import org.flowable.cmmn.api.runtime.PlanItemInstance;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.variable.api.persistence.entity.VariableInstance;

public class GetPlanItemVariableInstanceCmd
implements Command<VariableInstance>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String planItemInstanceId;
    protected String variableName;

    public GetPlanItemVariableInstanceCmd(String planItemInstanceId, String variableName) {
        this.planItemInstanceId = planItemInstanceId;
        this.variableName = variableName;
    }

    public VariableInstance execute(CommandContext commandContext) {
        if (this.planItemInstanceId == null) {
            throw new FlowableIllegalArgumentException("planItemInstanceId is null");
        }
        if (this.variableName == null) {
            throw new FlowableIllegalArgumentException("variableName is null");
        }
        PlanItemInstanceEntity planItemInstance = (PlanItemInstanceEntity)CommandContextUtil.getPlanItemInstanceEntityManager(commandContext).findById(this.planItemInstanceId);
        if (planItemInstance == null) {
            throw new FlowableObjectNotFoundException("plan item instance " + this.planItemInstanceId + " doesn't exist", PlanItemInstance.class);
        }
        return planItemInstance.getVariableInstance(this.variableName, false);
    }
}

