/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.cmd;

import java.io.Serializable;
import java.util.List;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.identitylink.api.history.HistoricIdentityLink;
import org.flowable.identitylink.service.HistoricIdentityLinkService;
import org.flowable.identitylink.service.impl.persistence.entity.HistoricIdentityLinkEntity;
import org.flowable.task.api.history.HistoricTaskInstance;
import org.flowable.task.service.impl.persistence.entity.HistoricTaskInstanceEntity;

public class GetHistoricIdentityLinksForTaskCmd
implements Command<List<HistoricIdentityLink>>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String taskId;

    public GetHistoricIdentityLinksForTaskCmd(String taskId) {
        if (taskId == null) {
            throw new FlowableIllegalArgumentException("taskId is required");
        }
        this.taskId = taskId;
    }

    public List<HistoricIdentityLink> execute(CommandContext commandContext) {
        HistoricIdentityLinkEntity identityLink;
        CmmnEngineConfiguration cmmnEngineConfiguration = CommandContextUtil.getCmmnEngineConfiguration(commandContext);
        HistoricTaskInstanceEntity task = cmmnEngineConfiguration.getTaskServiceConfiguration().getHistoricTaskService().getHistoricTask(this.taskId);
        if (task == null) {
            throw new FlowableObjectNotFoundException("No historic task exists with the given id: " + this.taskId, HistoricTaskInstance.class);
        }
        HistoricIdentityLinkService historicIdentityLinkService = cmmnEngineConfiguration.getIdentityLinkServiceConfiguration().getHistoricIdentityLinkService();
        List identityLinks = historicIdentityLinkService.findHistoricIdentityLinksByTaskId(this.taskId);
        HistoricIdentityLinkEntity assigneeIdentityLink = null;
        HistoricIdentityLinkEntity ownerIdentityLink = null;
        for (HistoricIdentityLinkEntity historicIdentityLink : identityLinks) {
            if ("assignee".equals(historicIdentityLink.getType())) {
                assigneeIdentityLink = historicIdentityLink;
                continue;
            }
            if (!"owner".equals(historicIdentityLink.getType())) continue;
            ownerIdentityLink = historicIdentityLink;
        }
        if (task.getAssignee() != null && assigneeIdentityLink == null) {
            identityLink = historicIdentityLinkService.createHistoricIdentityLink();
            identityLink.setUserId(task.getAssignee());
            identityLink.setTaskId(task.getId());
            identityLink.setType("assignee");
            identityLinks.add(identityLink);
        }
        if (task.getOwner() != null && ownerIdentityLink == null) {
            identityLink = historicIdentityLinkService.createHistoricIdentityLink();
            identityLink.setTaskId(task.getId());
            identityLink.setUserId(task.getOwner());
            identityLink.setType("owner");
            identityLinks.add(identityLink);
        }
        return identityLinks;
    }
}

