/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.listener;

import java.util.List;
import org.flowable.cmmn.engine.impl.util.DelegateExpressionUtil;
import org.flowable.cmmn.model.FieldExtension;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.task.service.delegate.DelegateTask;
import org.flowable.task.service.delegate.TaskListener;

public class DelegateExpressionTaskListener
implements TaskListener {
    protected Expression expression;
    protected List<FieldExtension> fieldExtensions;

    public DelegateExpressionTaskListener(Expression expression, List<FieldExtension> fieldExtensions) {
        this.expression = expression;
        this.fieldExtensions = fieldExtensions;
    }

    public void notify(DelegateTask delegateTask) {
        block5: {
            try {
                Object delegate = DelegateExpressionUtil.resolveDelegateExpression(this.expression, (VariableContainer)delegateTask, this.fieldExtensions);
                if (delegate instanceof TaskListener) {
                    try {
                        TaskListener taskListener = (TaskListener)delegate;
                        taskListener.notify(delegateTask);
                        break block5;
                    }
                    catch (Exception e) {
                        throw new FlowableException("Exception while invoking TaskListener: " + e.getMessage(), (Throwable)e);
                    }
                }
                throw new FlowableIllegalArgumentException("Delegate expression " + this.expression + " did not resolve to an implementation of " + TaskListener.class);
            }
            catch (Exception e) {
                throw new FlowableException(e.getMessage(), (Throwable)e);
            }
        }
    }

    public String getExpressionText() {
        return this.expression.getExpressionText();
    }
}

