/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.behavior.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Map;
import liquibase.util.StringUtils;
import org.flowable.cmmn.api.delegate.DelegatePlanItemInstance;
import org.flowable.cmmn.engine.impl.behavior.PlanItemActivityBehavior;
import org.flowable.cmmn.engine.impl.behavior.impl.TaskActivityBehavior;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.repository.CaseDefinitionUtil;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.cmmn.model.DecisionTask;
import org.flowable.cmmn.model.FieldExtension;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.dmn.api.DecisionExecutionAuditContainer;
import org.flowable.dmn.api.DmnRuleService;
import org.flowable.dmn.api.ExecuteDecisionBuilder;

public class DecisionTaskActivityBehavior
extends TaskActivityBehavior
implements PlanItemActivityBehavior {
    protected static final String EXPRESSION_DECISION_TABLE_THROW_ERROR_FLAG = "decisionTaskThrowErrorOnNoHits";
    protected static final String STRING_DECISION_TABLE_FALLBACK_TO_DEFAULT_TENANT = "fallbackToDefaultTenant";
    protected DecisionTask decisionTask;
    protected Expression decisionRefExpression;

    public DecisionTaskActivityBehavior(Expression decisionRefExpression, DecisionTask decisionTask) {
        super(decisionTask.isBlocking(), decisionTask.getBlockingExpression());
        this.decisionTask = decisionTask;
        this.decisionRefExpression = decisionRefExpression;
    }

    @Override
    public void execute(CommandContext commandContext, PlanItemInstanceEntity planItemInstanceEntity) {
        DecisionExecutionAuditContainer decisionExecutionAuditContainer;
        DmnRuleService dmnRuleService = CommandContextUtil.getDmnRuleService(commandContext);
        if (dmnRuleService == null) {
            throw new FlowableException("Could not execute decision instance: no dmn service found.");
        }
        String externalRef = null;
        if (this.decisionTask != null && this.decisionTask.getDecision() != null && StringUtils.isNotEmpty((String)this.decisionTask.getDecision().getExternalRef())) {
            externalRef = this.decisionTask.getDecision().getExternalRef();
        } else if (this.decisionRefExpression != null) {
            Object externalRefValue = this.decisionRefExpression.getValue((VariableContainer)planItemInstanceEntity);
            if (externalRefValue != null) {
                externalRef = externalRefValue.toString();
            }
            if (StringUtils.isEmpty(externalRef)) {
                throw new FlowableException("Could not execute decision: no externalRef defined");
            }
        }
        ExecuteDecisionBuilder executeDecisionBuilder = dmnRuleService.createExecuteDecisionBuilder().parentDeploymentId(CaseDefinitionUtil.getDefinitionDeploymentId(planItemInstanceEntity.getCaseDefinitionId())).decisionKey(externalRef).instanceId(planItemInstanceEntity.getCaseInstanceId()).executionId(planItemInstanceEntity.getId()).activityId(this.decisionTask.getId()).scopeType("cmmn").variables(planItemInstanceEntity.getVariables()).tenantId(planItemInstanceEntity.getTenantId());
        String fallBackToDefaultTenantValue = this.getFieldString(STRING_DECISION_TABLE_FALLBACK_TO_DEFAULT_TENANT);
        if (fallBackToDefaultTenantValue != null && Boolean.parseBoolean(fallBackToDefaultTenantValue)) {
            executeDecisionBuilder.fallbackToDefaultTenant();
        }
        if ((decisionExecutionAuditContainer = executeDecisionBuilder.executeWithAuditTrail()) == null) {
            throw new FlowableException("DMN decision table with key " + externalRef + " was not executed.");
        }
        if (decisionExecutionAuditContainer.isFailed().booleanValue()) {
            throw new FlowableException("DMN decision table with key " + externalRef + " execution failed. Cause: " + decisionExecutionAuditContainer.getExceptionMessage());
        }
        String throwErrorFieldValue = this.getFieldString(EXPRESSION_DECISION_TABLE_THROW_ERROR_FLAG);
        if (decisionExecutionAuditContainer.getDecisionResult().isEmpty() && throwErrorFieldValue != null) {
            Expression expression;
            Object expressionValue;
            if ("true".equalsIgnoreCase(throwErrorFieldValue)) {
                throw new FlowableException("DMN decision table with key " + externalRef + " did not hit any rules for the provided input.");
            }
            if (!"false".equalsIgnoreCase(throwErrorFieldValue) && (expressionValue = (expression = CommandContextUtil.getExpressionManager(commandContext).createExpression(throwErrorFieldValue)).getValue((VariableContainer)planItemInstanceEntity)) instanceof Boolean && ((Boolean)expressionValue).booleanValue()) {
                throw new FlowableException("DMN decision table with key " + externalRef + " did not hit any rules for the provided input.");
            }
        }
        this.setVariables(decisionExecutionAuditContainer.getDecisionResult(), externalRef, planItemInstanceEntity, CommandContextUtil.getCmmnEngineConfiguration(commandContext).getObjectMapper());
        CommandContextUtil.getAgenda().planCompletePlanItemInstanceOperation(planItemInstanceEntity);
    }

    protected void setVariables(List<Map<String, Object>> executionResult, String decisionKey, PlanItemInstanceEntity planItemInstanceEntity, ObjectMapper objectMapper) {
        if (executionResult == null || executionResult.isEmpty()) {
            return;
        }
        if (executionResult.size() > 1) {
            ArrayNode ruleResultNode = objectMapper.createArrayNode();
            for (Map<String, Object> ruleResult : executionResult) {
                ObjectNode outputResultNode = objectMapper.createObjectNode();
                for (Map.Entry<String, Object> outputResult : ruleResult.entrySet()) {
                    outputResultNode.set(outputResult.getKey(), (JsonNode)objectMapper.convertValue(outputResult.getValue(), JsonNode.class));
                }
                ruleResultNode.add((JsonNode)outputResultNode);
            }
            planItemInstanceEntity.setVariable(decisionKey, ruleResultNode);
        } else {
            Map<String, Object> ruleResult = executionResult.get(0);
            for (Map.Entry<String, Object> outputResult : ruleResult.entrySet()) {
                planItemInstanceEntity.setVariable(outputResult.getKey(), outputResult.getValue());
            }
        }
    }

    protected String getFieldString(String fieldName) {
        for (FieldExtension fieldExtension : this.decisionTask.getFieldExtensions()) {
            if (!fieldName.equals(fieldExtension.getFieldName())) continue;
            if (StringUtils.isNotEmpty((String)fieldExtension.getStringValue())) {
                return fieldExtension.getStringValue();
            }
            if (!StringUtils.isNotEmpty((String)fieldExtension.getExpression())) continue;
            return fieldExtension.getExpression();
        }
        return null;
    }

    @Override
    public void onStateTransition(CommandContext commandContext, DelegatePlanItemInstance planItemInstance, String transition) {
    }
}

