/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.behavior.impl;

import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.api.delegate.DelegatePlanItemInstance;
import org.flowable.cmmn.api.runtime.CaseInstanceBuilder;
import org.flowable.cmmn.engine.impl.behavior.PlanItemActivityBehavior;
import org.flowable.cmmn.engine.impl.behavior.impl.TaskActivityBehavior;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.runtime.CaseInstanceBuilderImpl;
import org.flowable.cmmn.engine.impl.runtime.CaseInstanceHelper;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.cmmn.engine.impl.util.EntityLinkUtil;
import org.flowable.cmmn.model.CaseTask;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.interceptor.CommandContext;

public class CaseTaskActivityBehavior
extends TaskActivityBehavior
implements PlanItemActivityBehavior {
    protected Expression caseRefExpression;
    protected Boolean fallbackToDefaultTenant;

    public CaseTaskActivityBehavior(Expression caseRefExpression, CaseTask caseTask) {
        super(caseTask.isBlocking(), caseTask.getBlockingExpression());
        this.caseRefExpression = caseRefExpression;
        this.fallbackToDefaultTenant = caseTask.getFallbackToDefaultTenant();
    }

    @Override
    public void execute(CommandContext commandContext, PlanItemInstanceEntity planItemInstanceEntity) {
        CaseInstanceHelper caseInstanceHelper = CommandContextUtil.getCaseInstanceHelper(commandContext);
        CaseInstanceBuilder caseInstanceBuilder = new CaseInstanceBuilderImpl().caseDefinitionKey(this.caseRefExpression.getValue((VariableContainer)planItemInstanceEntity).toString());
        if (StringUtils.isNotEmpty((CharSequence)planItemInstanceEntity.getTenantId())) {
            caseInstanceBuilder.tenantId(planItemInstanceEntity.getTenantId());
            caseInstanceBuilder.overrideCaseDefinitionTenantId(planItemInstanceEntity.getTenantId());
        }
        caseInstanceBuilder.parentId(planItemInstanceEntity.getCaseInstanceId());
        if (this.fallbackToDefaultTenant != null && this.fallbackToDefaultTenant.booleanValue()) {
            caseInstanceBuilder.fallbackToDefaultTenant();
        }
        CaseInstanceEntity caseInstanceEntity = caseInstanceHelper.startCaseInstance(caseInstanceBuilder);
        caseInstanceEntity.setCallbackType("cmmn-1.1-to-cmmn-1.1-child-case");
        caseInstanceEntity.setCallbackId(planItemInstanceEntity.getId());
        planItemInstanceEntity.setReferenceType("cmmn-1.1-to-cmmn-1.1-child-case");
        planItemInstanceEntity.setReferenceId(caseInstanceEntity.getId());
        if (CommandContextUtil.getCmmnEngineConfiguration(commandContext).isEnableEntityLinks()) {
            EntityLinkUtil.copyExistingEntityLinks(planItemInstanceEntity.getCaseInstanceId(), caseInstanceEntity.getId(), "cmmn");
            EntityLinkUtil.createNewEntityLink(planItemInstanceEntity.getCaseInstanceId(), caseInstanceEntity.getId(), "cmmn");
        }
        if (!this.evaluateIsBlocking(planItemInstanceEntity)) {
            CommandContextUtil.getAgenda(commandContext).planCompletePlanItemInstanceOperation(planItemInstanceEntity);
        }
    }

    @Override
    public void trigger(CommandContext commandContext, PlanItemInstanceEntity planItemInstance) {
        if (!"active".equals(planItemInstance.getState())) {
            throw new FlowableException("Can only trigger a plan item that is in the ACTIVE state");
        }
        if (planItemInstance.getReferenceId() == null) {
            throw new FlowableException("Cannot trigger case task plan item instance : no reference id set");
        }
        if (!"cmmn-1.1-to-cmmn-1.1-child-case".equals(planItemInstance.getReferenceType())) {
            throw new FlowableException("Cannot trigger case task plan item instance : reference type '" + planItemInstance.getReferenceType() + "' not supported");
        }
        CommandContextUtil.getAgenda(commandContext).planManualTerminateCaseInstanceOperation(planItemInstance.getReferenceId());
        CommandContextUtil.getAgenda(commandContext).planCompletePlanItemInstanceOperation(planItemInstance);
    }

    @Override
    public void onStateTransition(CommandContext commandContext, DelegatePlanItemInstance planItemInstance, String transition) {
        if ("terminate".equals(transition) || "exit".equals(transition)) {
            CommandContextUtil.getAgenda(commandContext).planManualTerminateCaseInstanceOperation(planItemInstance.getReferenceId());
        }
    }
}

