/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.app.engine.impl.deployer;

import java.util.List;
import java.util.Map;
import org.flowable.app.api.repository.AppDefinition;
import org.flowable.app.engine.AppEngineConfiguration;
import org.flowable.app.engine.impl.persistence.entity.AppDefinitionEntity;
import org.flowable.app.engine.impl.persistence.entity.AppDefinitionEntityManager;
import org.flowable.app.engine.impl.persistence.entity.AppDeploymentEntity;
import org.flowable.app.engine.impl.persistence.entity.AppDeploymentEntityManager;
import org.flowable.app.engine.impl.persistence.entity.deploy.AppDefinitionCacheEntry;
import org.flowable.app.engine.impl.repository.AppDefinitionQueryImpl;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.engine.api.repository.EngineDeployment;
import org.flowable.common.engine.impl.EngineDeployer;
import org.flowable.common.engine.impl.persistence.deploy.DeploymentCache;

public class AppDeploymentManager {
    protected DeploymentCache<AppDefinitionCacheEntry> appDefinitionCache;
    protected List<EngineDeployer> deployers;
    protected AppEngineConfiguration appEngineConfiguration;
    protected AppDeploymentEntityManager deploymentEntityManager;
    protected AppDefinitionEntityManager appDefinitionEntityManager;

    public void deploy(EngineDeployment deployment) {
        this.deploy(deployment, null);
    }

    public void deploy(EngineDeployment deployment, Map<String, Object> deploymentSettings) {
        for (EngineDeployer deployer : this.deployers) {
            deployer.deploy(deployment, deploymentSettings);
        }
    }

    public AppDefinition findDeployedAppDefinitionById(String appDefinitionId) {
        AppDefinition appDefinition;
        if (appDefinitionId == null) {
            throw new FlowableIllegalArgumentException("Invalid app definition id : null");
        }
        AppDefinitionCacheEntry cacheEntry = (AppDefinitionCacheEntry)this.appDefinitionCache.get(appDefinitionId);
        AppDefinition appDefinition2 = appDefinition = cacheEntry != null ? cacheEntry.getAppDefinition() : null;
        if (appDefinition == null) {
            appDefinition = (AppDefinition)this.appDefinitionEntityManager.findById(appDefinitionId);
            if (appDefinition == null) {
                throw new FlowableObjectNotFoundException("no deployed app definition found with id '" + appDefinitionId + "'", AppDefinition.class);
            }
            appDefinition = this.resolveAppDefinition(appDefinition).getAppDefinition();
        }
        return appDefinition;
    }

    public AppDefinition findDeployedLatestAppDefinitionByKey(String appDefinitionKey) {
        AppDefinitionEntity appDefinition = this.appDefinitionEntityManager.findLatestAppDefinitionByKey(appDefinitionKey);
        if (appDefinition == null) {
            throw new FlowableObjectNotFoundException("no apps deployed with key '" + appDefinitionKey + "'", AppDefinition.class);
        }
        appDefinition = this.resolveAppDefinition(appDefinition).getAppDefinition();
        return appDefinition;
    }

    public AppDefinition findDeployedLatestAppDefinitionByKeyAndTenantId(String appDefinitionKey, String tenantId) {
        AppDefinitionEntity appDefinition = this.appDefinitionEntityManager.findLatestAppDefinitionByKeyAndTenantId(appDefinitionKey, tenantId);
        if (appDefinition == null) {
            throw new FlowableObjectNotFoundException("no apps deployed with key '" + appDefinitionKey + "' for tenant identifier '" + tenantId + "'", AppDefinition.class);
        }
        appDefinition = this.resolveAppDefinition(appDefinition).getAppDefinition();
        return appDefinition;
    }

    public AppDefinition findDeployedAppDefinitionByKeyAndVersionAndTenantId(String appDefinitionKey, Integer appDefinitionVersion, String tenantId) {
        AppDefinitionEntity appDefinition = (AppDefinitionEntity)this.appDefinitionEntityManager.findAppDefinitionByKeyAndVersionAndTenantId(appDefinitionKey, appDefinitionVersion, tenantId);
        if (appDefinition == null) {
            throw new FlowableObjectNotFoundException("no apps deployed with key = '" + appDefinitionKey + "' and version = '" + appDefinitionVersion + "'", AppDefinition.class);
        }
        appDefinition = this.resolveAppDefinition(appDefinition).getAppDefinition();
        return appDefinition;
    }

    public AppDefinitionCacheEntry resolveAppDefinition(AppDefinition appDefinition) {
        String appDefinitionId = appDefinition.getId();
        String deploymentId = appDefinition.getDeploymentId();
        AppDefinitionCacheEntry cachedAppDefinition = (AppDefinitionCacheEntry)this.appDefinitionCache.get(appDefinitionId);
        if (cachedAppDefinition == null) {
            AppDeploymentEntity deployment = (AppDeploymentEntity)this.deploymentEntityManager.findById(deploymentId);
            deployment.setNew(false);
            this.deploy((EngineDeployment)deployment, null);
            cachedAppDefinition = deployment.getAppDefinitionCacheEntry(appDefinitionId);
            if (cachedAppDefinition == null) {
                throw new FlowableException("deployment '" + deploymentId + "' didn't put app definition '" + appDefinitionId + "' in the cache");
            }
        }
        return cachedAppDefinition;
    }

    public void removeDeployment(String deploymentId) {
        this.removeDeployment(deploymentId, true);
    }

    public void removeDeployment(String deploymentId, boolean cascade) {
        AppDeploymentEntity deployment = (AppDeploymentEntity)this.deploymentEntityManager.findById(deploymentId);
        if (deployment == null) {
            throw new FlowableObjectNotFoundException("Could not find a deployment with id '" + deploymentId + "'.", AppDeploymentEntity.class);
        }
        for (AppDefinition appDefinition : new AppDefinitionQueryImpl().deploymentId(deploymentId).list()) {
            this.appDefinitionCache.remove(appDefinition.getId());
        }
        this.deploymentEntityManager.deleteDeploymentAndRelatedData(deploymentId, cascade);
    }

    public List<EngineDeployer> getDeployers() {
        return this.deployers;
    }

    public void setDeployers(List<EngineDeployer> deployers) {
        this.deployers = deployers;
    }

    public DeploymentCache<AppDefinitionCacheEntry> getAppDefinitionCache() {
        return this.appDefinitionCache;
    }

    public void setAppDefinitionCache(DeploymentCache<AppDefinitionCacheEntry> appDefinitionCache) {
        this.appDefinitionCache = appDefinitionCache;
    }

    public AppEngineConfiguration getAppEngineConfiguration() {
        return this.appEngineConfiguration;
    }

    public void setAppEngineConfiguration(AppEngineConfiguration appEngineConfiguration) {
        this.appEngineConfiguration = appEngineConfiguration;
    }

    public AppDefinitionEntityManager getAppDefinitionEntityManager() {
        return this.appDefinitionEntityManager;
    }

    public void setAppDefinitionEntityManager(AppDefinitionEntityManager appDefinitionEntityManager) {
        this.appDefinitionEntityManager = appDefinitionEntityManager;
    }

    public AppDeploymentEntityManager getDeploymentEntityManager() {
        return this.deploymentEntityManager;
    }

    public void setDeploymentEntityManager(AppDeploymentEntityManager deploymentEntityManager) {
        this.deploymentEntityManager = deploymentEntityManager;
    }
}

