/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.app.spring.impl.test;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import junit.framework.TestCase;
import org.flowable.app.engine.AppEngine;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestContextManager;
import org.springframework.test.context.TestExecutionListeners;
import org.springframework.test.context.support.DependencyInjectionTestExecutionListener;

@TestExecutionListeners(value={DependencyInjectionTestExecutionListener.class})
public abstract class SpringFlowableAppTestCase
extends TestCase
implements ApplicationContextAware {
    protected Map<Object, AppEngine> cachedAppEngines = new ConcurrentHashMap<Object, AppEngine>();
    protected AppEngine appEngine;
    protected TestContextManager testContextManager = new TestContextManager(((Object)((Object)this)).getClass());
    @Autowired
    protected ApplicationContext applicationContext;

    public void runBare() throws Throwable {
        this.testContextManager.prepareTestInstance((Object)this);
        super.runBare();
    }

    protected void initializeAppEngine() {
        ContextConfiguration contextConfiguration = ((Object)((Object)this)).getClass().getAnnotation(ContextConfiguration.class);
        String[] value = contextConfiguration.value();
        boolean hasOneArg = value != null && value.length == 1;
        String key = hasOneArg ? value[0] : AppEngine.class.getName();
        AppEngine engine = this.cachedAppEngines.containsKey(key) ? this.cachedAppEngines.get(key) : (AppEngine)this.applicationContext.getBean(AppEngine.class);
        this.cachedAppEngines.put(key, engine);
        this.appEngine = engine;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }
}

