/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.app.spring;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.sql.DataSource;
import org.flowable.app.engine.AppEngine;
import org.flowable.app.engine.AppEngineConfiguration;
import org.flowable.app.engine.AppEngines;
import org.flowable.app.spring.SpringTransactionContextFactory;
import org.flowable.app.spring.SpringTransactionInterceptor;
import org.flowable.app.spring.autodeployment.AutoDeploymentStrategy;
import org.flowable.app.spring.autodeployment.DefaultAutoDeploymentStrategy;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.interceptor.CommandConfig;
import org.flowable.common.engine.impl.interceptor.CommandInterceptor;
import org.flowable.common.spring.SpringEngineConfiguration;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.jdbc.datasource.TransactionAwareDataSourceProxy;
import org.springframework.transaction.PlatformTransactionManager;

public class SpringAppEngineConfiguration
extends AppEngineConfiguration
implements SpringEngineConfiguration {
    protected PlatformTransactionManager transactionManager;
    protected Resource[] deploymentResources = new Resource[0];
    protected String deploymentMode = "default";
    protected ApplicationContext applicationContext;
    protected Integer transactionSynchronizationAdapterOrder;
    protected Collection<AutoDeploymentStrategy> deploymentStrategies = new ArrayList<AutoDeploymentStrategy>();
    protected volatile boolean running = false;
    protected List<String> enginesBuild = new ArrayList<String>();
    protected final Object lifeCycleMonitor = new Object();

    public SpringAppEngineConfiguration() {
        this.transactionsExternallyManaged = true;
        this.deploymentStrategies.add(new DefaultAutoDeploymentStrategy());
    }

    public AppEngine buildAppEngine() {
        AppEngine appEngine = super.buildAppEngine();
        AppEngines.setInitialized((boolean)true);
        this.enginesBuild.add(appEngine.getName());
        return appEngine;
    }

    public void setTransactionSynchronizationAdapterOrder(Integer transactionSynchronizationAdapterOrder) {
        this.transactionSynchronizationAdapterOrder = transactionSynchronizationAdapterOrder;
    }

    public void initDefaultCommandConfig() {
        if (this.defaultCommandConfig == null) {
            this.defaultCommandConfig = new CommandConfig().setContextReusePossible(true);
        }
    }

    public CommandInterceptor createTransactionInterceptor() {
        if (this.transactionManager == null) {
            throw new FlowableException("transactionManager is required property for SpringAppEngineConfiguration, use " + AppEngineConfiguration.class.getName() + " otherwise");
        }
        return new SpringTransactionInterceptor(this.transactionManager);
    }

    public void initTransactionContextFactory() {
        if (this.transactionContextFactory == null && this.transactionManager != null) {
            this.transactionContextFactory = new SpringTransactionContextFactory(this.transactionManager, this.transactionSynchronizationAdapterOrder);
        }
    }

    protected void autoDeployResources(AppEngine appEngine) {
        if (this.deploymentResources != null && this.deploymentResources.length > 0) {
            AutoDeploymentStrategy strategy = this.getAutoDeploymentStrategy(this.deploymentMode);
            strategy.deployResources(this.deploymentResources, appEngine.getAppRepositoryService());
        }
    }

    public AppEngineConfiguration setDataSource(DataSource dataSource) {
        if (dataSource instanceof TransactionAwareDataSourceProxy) {
            return super.setDataSource(dataSource);
        }
        TransactionAwareDataSourceProxy proxiedDataSource = new TransactionAwareDataSourceProxy(dataSource);
        return super.setDataSource((DataSource)proxiedDataSource);
    }

    public PlatformTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public Resource[] getDeploymentResources() {
        return this.deploymentResources;
    }

    public void setDeploymentResources(Resource[] deploymentResources) {
        this.deploymentResources = deploymentResources;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public String getDeploymentMode() {
        return this.deploymentMode;
    }

    public void setDeploymentMode(String deploymentMode) {
        this.deploymentMode = deploymentMode;
    }

    protected AutoDeploymentStrategy getAutoDeploymentStrategy(String mode) {
        AutoDeploymentStrategy result = new DefaultAutoDeploymentStrategy();
        for (AutoDeploymentStrategy strategy : this.deploymentStrategies) {
            if (!strategy.handlesMode(mode)) continue;
            result = strategy;
            break;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.lifeCycleMonitor;
        synchronized (object) {
            if (!this.isRunning()) {
                this.enginesBuild.forEach(name -> this.autoDeployResources(AppEngines.getAppEngine((String)name)));
                this.running = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.lifeCycleMonitor;
        synchronized (object) {
            this.running = false;
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public String getDeploymentName() {
        return null;
    }

    public void setDeploymentName(String deploymentName) {
        throw new FlowableException("Setting a deployment name is not supported for apps");
    }
}

