/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.transaction.model.exception;

import java.util.Objects;
import org.fisco.bcos.sdk.client.protocol.response.Call;
import org.fisco.bcos.sdk.model.TransactionReceipt;

public class ContractException
extends Exception {
    private Call.CallOutput responseOutput = null;
    private int errorCode;
    private TransactionReceipt receipt;

    public ContractException(String errorMessage, int errorCode) {
        super(errorMessage);
        this.errorCode = errorCode;
    }

    public ContractException(String errorMessage, int errorCode, TransactionReceipt receipt) {
        super(errorMessage);
        this.errorCode = errorCode;
        this.receipt = receipt;
    }

    public ContractException(String message) {
        super(message);
    }

    public ContractException(String message, Throwable cause) {
        super(message, cause);
    }

    public ContractException(String message, Throwable cause, Call.CallOutput responseOutput) {
        super(message, cause);
        this.responseOutput = responseOutput;
    }

    public ContractException(String message, Call.CallOutput responseOutput) {
        super(message);
        this.responseOutput = responseOutput;
    }

    public Call.CallOutput getResponseOutput() {
        return this.responseOutput;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(int errorCode) {
        this.errorCode = errorCode;
    }

    public void setResponseOutput(Call.CallOutput responseOutput) {
        this.responseOutput = responseOutput;
    }

    public TransactionReceipt getReceipt() {
        return this.receipt;
    }

    public void setReceipt(TransactionReceipt receipt) {
        this.receipt = receipt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContractException that = (ContractException)o;
        return this.errorCode == that.errorCode && Objects.equals(this.responseOutput, that.responseOutput);
    }

    public int hashCode() {
        return Objects.hash(this.responseOutput, this.errorCode);
    }

    @Override
    public String toString() {
        return "ContractException{responseOutput=" + (this.responseOutput == null ? "null" : this.responseOutput.toString()) + ", errorCode=" + this.errorCode + '}';
    }
}

