/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.service;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicLong;
import org.fisco.bcos.sdk.service.GroupService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupServiceImpl
implements GroupService {
    private static Logger logger = LoggerFactory.getLogger(GroupServiceImpl.class);
    private ConcurrentHashMap<String, BigInteger> groupNodeToBlockNumber = new ConcurrentHashMap();
    private Set<String> groupNodeSet = new CopyOnWriteArraySet<String>();
    private final Integer groupId;
    private AtomicLong latestBlockNumber = new AtomicLong(0L);
    private List<String> nodeWithLatestBlockNumber = new CopyOnWriteArrayList<String>();

    public GroupServiceImpl(Integer groupId) {
        this.groupId = groupId;
    }

    public GroupServiceImpl(Integer groupId, String groupNodeAddress) {
        this.groupId = groupId;
        this.groupNodeSet.add(groupNodeAddress);
        logger.debug("insert group: {} for peer {}", (Object)groupId, (Object)groupNodeAddress);
    }

    @Override
    public Set<String> getGroupNodesInfo() {
        return this.groupNodeSet;
    }

    @Override
    public boolean removeNode(String nodeAddress) {
        boolean shouldResetLatestBlockNumber = false;
        if (this.groupNodeToBlockNumber.containsKey(nodeAddress)) {
            this.groupNodeToBlockNumber.remove(nodeAddress);
            shouldResetLatestBlockNumber = true;
        }
        if (this.nodeWithLatestBlockNumber.contains(nodeAddress)) {
            this.nodeWithLatestBlockNumber.remove(nodeAddress);
            shouldResetLatestBlockNumber = true;
        }
        if (shouldResetLatestBlockNumber) {
            this.resetLatestBlockNumber();
        }
        logger.debug("g:{}, removeNode={}, blockNumberInfoSize={}, latestBlockNumber:{}", new Object[]{this.groupId, nodeAddress, this.groupNodeToBlockNumber.size(), this.latestBlockNumber});
        if (this.groupNodeSet.contains(nodeAddress)) {
            this.groupNodeSet.remove(nodeAddress);
            return true;
        }
        return false;
    }

    @Override
    public boolean insertNode(String nodeAddress) {
        if (!this.groupNodeSet.contains(nodeAddress)) {
            this.groupNodeSet.add(nodeAddress);
            logger.debug("g:{}, insertNode={}, nodeSize={}, blockNumberInfoSize={}", new Object[]{this.groupId, nodeAddress, this.groupNodeSet.size(), this.groupNodeToBlockNumber.size()});
            return true;
        }
        if (!this.groupNodeToBlockNumber.containsKey(nodeAddress)) {
            this.groupNodeToBlockNumber.put(nodeAddress, BigInteger.valueOf(0L));
        }
        return false;
    }

    @Override
    public void updatePeersBlockNumberInfo(String peerIpAndPort, BigInteger blockNumber) {
        if (!this.groupNodeToBlockNumber.containsKey(peerIpAndPort) || !this.groupNodeToBlockNumber.get(peerIpAndPort).equals(blockNumber)) {
            logger.debug("updatePeersBlockNumberInfo for {}, updated blockNumber: {}, groupId: {}", new Object[]{peerIpAndPort, blockNumber, this.groupId});
            this.groupNodeToBlockNumber.put(peerIpAndPort, blockNumber);
        }
        if (!this.groupNodeSet.contains(peerIpAndPort)) {
            this.groupNodeSet.add(peerIpAndPort);
        }
        this.updateLatestBlockNumber(peerIpAndPort, blockNumber);
    }

    private void updateLatestBlockNumber(String peerIpAndPort, BigInteger blockNumber) {
        if (blockNumber.longValue() == this.latestBlockNumber.get() && !this.nodeWithLatestBlockNumber.contains(peerIpAndPort)) {
            this.nodeWithLatestBlockNumber.add(peerIpAndPort);
        }
        if (blockNumber.longValue() > this.latestBlockNumber.get()) {
            this.latestBlockNumber.getAndSet(blockNumber.longValue());
            this.nodeWithLatestBlockNumber.clear();
            this.nodeWithLatestBlockNumber.add(peerIpAndPort);
        }
        logger.debug("g:{}, updateLatestBlockNumber, latestBlockNumber: {}, nodeWithLatestBlockNumber:{}", new Object[]{this.groupId, this.latestBlockNumber.get(), this.nodeWithLatestBlockNumber.toString()});
    }

    private void resetLatestBlockNumber() {
        BigInteger blockNumber;
        BigInteger maxBlockNumber = null;
        if (this.groupNodeToBlockNumber.size() == 0) {
            this.latestBlockNumber.getAndSet(BigInteger.ZERO.longValue());
            return;
        }
        for (String groupNode : this.groupNodeToBlockNumber.keySet()) {
            blockNumber = this.groupNodeToBlockNumber.get(groupNode);
            if (blockNumber == null || maxBlockNumber != null && blockNumber.compareTo(maxBlockNumber) <= 0) continue;
            maxBlockNumber = blockNumber;
        }
        if (maxBlockNumber == null) {
            return;
        }
        this.latestBlockNumber.getAndSet(maxBlockNumber.longValue());
        this.nodeWithLatestBlockNumber.clear();
        for (String groupNode : this.groupNodeToBlockNumber.keySet()) {
            blockNumber = this.groupNodeToBlockNumber.get(groupNode);
            if (!this.latestBlockNumber.equals(blockNumber)) continue;
            this.nodeWithLatestBlockNumber.add(groupNode);
        }
        logger.debug("g:{}, resetLatestBlockNumber, latestBlockNumber: {}, nodeWithLatestBlockNumber:{}, maxBlockNumber: {}", new Object[]{this.groupId, this.latestBlockNumber.get(), this.nodeWithLatestBlockNumber.toString(), maxBlockNumber});
    }

    @Override
    public BigInteger getLatestBlockNumber() {
        return BigInteger.valueOf(this.latestBlockNumber.get());
    }

    @Override
    public String getNodeWithTheLatestBlockNumber() {
        try {
            ArrayList<String> tmpNodeWithLatestBlockNumber = new ArrayList<String>(this.nodeWithLatestBlockNumber);
            if (tmpNodeWithLatestBlockNumber.size() > 0) {
                int random = (int)(Math.random() * (double)tmpNodeWithLatestBlockNumber.size());
                return (String)tmpNodeWithLatestBlockNumber.get(random);
            }
        }
        catch (Exception e) {
            logger.warn("getNodeWithTheLatestBlockNumber failed for {}, select the node to send message randomly", (Throwable)e);
        }
        if (!this.groupNodeSet.isEmpty()) {
            return this.groupNodeSet.iterator().next();
        }
        return null;
    }

    @Override
    public boolean existPeer(String peer) {
        return this.groupNodeSet.contains(peer);
    }
}

