/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.config.model;

import io.netty.util.NetUtil;
import java.util.List;
import java.util.Map;
import org.fisco.bcos.sdk.config.exceptions.ConfigException;
import org.fisco.bcos.sdk.config.model.ConfigProperty;
import org.fisco.bcos.sdk.utils.Host;

public class NetworkConfig {
    private List<String> peers;

    public NetworkConfig(ConfigProperty configProperty) throws ConfigException {
        Map<String, Object> networkProperty = configProperty.getNetwork();
        if (networkProperty != null) {
            this.peers = (List)networkProperty.get("peers");
        }
        this.checkPeers(this.peers);
    }

    private void checkPeers(List<String> peers) throws ConfigException {
        if (peers == null || peers.size() == 0) {
            throw new ConfigException("Invalid configuration, peers not configured, please config peers in yaml config file.");
        }
        for (String peer : peers) {
            int index = peer.lastIndexOf(58);
            if (index == -1) {
                throw new ConfigException(" Invalid configuration, the peer value should in IP:Port format(eg: 127.0.0.1:1111), value: " + peer);
            }
            String IP = peer.substring(0, index);
            String port = peer.substring(index + 1);
            if (!NetUtil.isValidIpV4Address((String)IP) && !NetUtil.isValidIpV6Address((String)IP)) {
                throw new ConfigException(" Invalid configuration, invalid IP string format, value: " + IP);
            }
            if (Host.validPort(port)) continue;
            throw new ConfigException(" Invalid configuration, tcp port should from 1 to 65535, value: " + port);
        }
    }

    public List<String> getPeers() {
        return this.peers;
    }

    public void setPeers(List<String> peers) {
        this.peers = peers;
    }
}

