/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.config;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.fisco.bcos.sdk.config.exceptions.ConfigException;
import org.fisco.bcos.sdk.config.model.AccountConfig;
import org.fisco.bcos.sdk.config.model.AmopConfig;
import org.fisco.bcos.sdk.config.model.ConfigProperty;
import org.fisco.bcos.sdk.config.model.CryptoMaterialConfig;
import org.fisco.bcos.sdk.config.model.CryptoProviderConfig;
import org.fisco.bcos.sdk.config.model.NetworkConfig;
import org.fisco.bcos.sdk.config.model.ThreadPoolConfig;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ConfigOption {
    private CryptoMaterialConfig cryptoMaterialConfig;
    private AccountConfig accountConfig;
    private AmopConfig amopConfig;
    private NetworkConfig networkConfig;
    private ThreadPoolConfig threadPoolConfig;
    private CryptoProviderConfig cryptoProviderConfig;
    private ConfigProperty configProperty;

    public ConfigOption(ConfigProperty configProperty) throws ConfigException {
        this(configProperty, 0);
    }

    public ConfigOption(ConfigProperty configProperty, int cryptoType) throws ConfigException {
        this.cryptoMaterialConfig = new CryptoMaterialConfig(configProperty, cryptoType);
        this.accountConfig = new AccountConfig(configProperty);
        this.amopConfig = new AmopConfig(configProperty);
        this.networkConfig = new NetworkConfig(configProperty);
        this.threadPoolConfig = new ThreadPoolConfig(configProperty);
        this.cryptoProviderConfig = new CryptoProviderConfig(configProperty);
        this.configProperty = configProperty;
    }

    public void reloadConfig(int cryptoType) throws ConfigException {
        this.cryptoMaterialConfig = new CryptoMaterialConfig(this.configProperty, cryptoType);
    }

    public CryptoMaterialConfig getCryptoMaterialConfig() {
        return this.cryptoMaterialConfig;
    }

    public void setCryptoMaterialConfig(CryptoMaterialConfig cryptoMaterialConfig) {
        this.cryptoMaterialConfig = cryptoMaterialConfig;
    }

    public AccountConfig getAccountConfig() {
        return this.accountConfig;
    }

    public void setAccountConfig(AccountConfig accountConfig) {
        this.accountConfig = accountConfig;
    }

    public AmopConfig getAmopConfig() {
        return this.amopConfig;
    }

    public void setAmopConfig(AmopConfig amopConfig) {
        this.amopConfig = amopConfig;
    }

    public NetworkConfig getNetworkConfig() {
        return this.networkConfig;
    }

    public void setNetworkConfig(NetworkConfig networkConfig) {
        this.networkConfig = networkConfig;
    }

    public ThreadPoolConfig getThreadPoolConfig() {
        return this.threadPoolConfig;
    }

    public void setThreadPoolConfig(ThreadPoolConfig threadPoolConfig) {
        this.threadPoolConfig = threadPoolConfig;
    }

    public CryptoProviderConfig getCryptoProviderConfig() {
        return this.cryptoProviderConfig;
    }

    public void setCryptoProviderConfig(CryptoProviderConfig cryptoProviderConfig) {
        this.cryptoProviderConfig = cryptoProviderConfig;
    }
}

