/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.codegen;

import java.io.File;
import java.io.IOException;
import org.fisco.bcos.sdk.codegen.CodeGenUtils;
import org.fisco.bcos.sdk.codegen.SolidityContractWrapper;
import org.fisco.bcos.sdk.codegen.exceptions.CodeGenException;

public class SolidityContractGenerator {
    public static final String COMMAND_SOLIDITY = "solidity";
    public static final String COMMAND_GENERATE = "generate";
    public static final String COMMAND_PREFIX = "solidity generate";
    private final File binFile;
    private final File smBinFile;
    private final File abiFile;
    private final File destinationDir;
    private String basePackageName;

    public SolidityContractGenerator(File binFile, File smBinFile, File abiFile, File destinationDir, String basePackageName) {
        this.binFile = binFile;
        this.smBinFile = smBinFile;
        this.abiFile = abiFile;
        this.destinationDir = destinationDir;
        this.basePackageName = basePackageName;
    }

    public void generateJavaFiles() throws CodeGenException, IOException, ClassNotFoundException {
        byte[] binary = CodeGenUtils.readBytes(this.binFile);
        byte[] smBinary = CodeGenUtils.readBytes(this.smBinFile);
        byte[] abiBytes = CodeGenUtils.readBytes(this.abiFile);
        String contractName = CodeGenUtils.getFileNameNoExtension(this.abiFile.getName());
        new SolidityContractWrapper().generateJavaFiles(contractName, new String(binary), new String(smBinary), new String(abiBytes), this.destinationDir.toString(), this.basePackageName);
    }
}

