/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.codegen;

import java.io.File;
import org.fisco.bcos.sdk.codegen.CodeGenUtils;
import org.fisco.bcos.sdk.codegen.SolidityContractGenerator;
import org.fisco.bcos.sdk.utils.Collection;
import picocli.CommandLine;

public class CodeGenMain {
    public static final String COMMAND_SOLIDITY = "solidity";
    public static final String COMMAND_GENERATE = "generate";
    public static final String COMMAND_PREFIX = "solidity generate";

    public static void main(String[] args) {
        if (args.length > 0 && (args[0].equals(COMMAND_SOLIDITY) || args[0].equals(COMMAND_GENERATE))) {
            args = Collection.tail(args);
        }
        CommandLine.run((Runnable)new PicocliRunner(), (String[])args);
    }

    @CommandLine.Command(name="solidity generate", mixinStandardHelpOptions=true, version={"4.0"}, sortOptions=false)
    static class PicocliRunner
    implements Runnable {
        @CommandLine.Option(names={"-a", "--abiFile"}, description={"abi file with contract definition."}, required=true)
        private File abiFile;
        @CommandLine.Option(names={"-b", "--binFile"}, description={"bin file with contract compiled code in order to generate deploy methods."}, required=true)
        private File binFile;
        @CommandLine.Option(names={"-s", "--smBinFile"}, description={"sm bin file with contract compiled code in order to generate deploy methods."}, required=true)
        private File smBinFile;
        @CommandLine.Option(names={"-o", "--outputDir"}, description={"destination base directory."}, required=true)
        private File destinationFileDir;
        @CommandLine.Option(names={"-p", "--package"}, description={"base package name."}, required=true)
        private String packageName;

        PicocliRunner() {
        }

        @Override
        public void run() {
            try {
                new SolidityContractGenerator(this.binFile, this.smBinFile, this.abiFile, this.destinationFileDir, this.packageName).generateJavaFiles();
            }
            catch (Exception e) {
                CodeGenUtils.exitError(e);
            }
        }
    }
}

