/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.client;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Semaphore;
import org.fisco.bcos.sdk.channel.Channel;
import org.fisco.bcos.sdk.client.Client;
import org.fisco.bcos.sdk.client.JsonRpcService;
import org.fisco.bcos.sdk.client.RespCallback;
import org.fisco.bcos.sdk.client.protocol.request.GenerateGroupParam;
import org.fisco.bcos.sdk.client.protocol.request.JsonRpcRequest;
import org.fisco.bcos.sdk.client.protocol.request.Transaction;
import org.fisco.bcos.sdk.client.protocol.response.AddPeers;
import org.fisco.bcos.sdk.client.protocol.response.BcosBlock;
import org.fisco.bcos.sdk.client.protocol.response.BcosBlockHeader;
import org.fisco.bcos.sdk.client.protocol.response.BcosTransaction;
import org.fisco.bcos.sdk.client.protocol.response.BcosTransactionReceipt;
import org.fisco.bcos.sdk.client.protocol.response.BcosTransactionReceiptsDecoder;
import org.fisco.bcos.sdk.client.protocol.response.BlockHash;
import org.fisco.bcos.sdk.client.protocol.response.BlockNumber;
import org.fisco.bcos.sdk.client.protocol.response.Call;
import org.fisco.bcos.sdk.client.protocol.response.Code;
import org.fisco.bcos.sdk.client.protocol.response.ConsensusStatus;
import org.fisco.bcos.sdk.client.protocol.response.ErasePeers;
import org.fisco.bcos.sdk.client.protocol.response.GenerateGroup;
import org.fisco.bcos.sdk.client.protocol.response.GroupList;
import org.fisco.bcos.sdk.client.protocol.response.GroupPeers;
import org.fisco.bcos.sdk.client.protocol.response.NodeIDList;
import org.fisco.bcos.sdk.client.protocol.response.NodeInfo;
import org.fisco.bcos.sdk.client.protocol.response.ObserverList;
import org.fisco.bcos.sdk.client.protocol.response.PbftView;
import org.fisco.bcos.sdk.client.protocol.response.Peers;
import org.fisco.bcos.sdk.client.protocol.response.PendingTransactions;
import org.fisco.bcos.sdk.client.protocol.response.PendingTxSize;
import org.fisco.bcos.sdk.client.protocol.response.QueryGroupStatus;
import org.fisco.bcos.sdk.client.protocol.response.QueryPeers;
import org.fisco.bcos.sdk.client.protocol.response.RecoverGroup;
import org.fisco.bcos.sdk.client.protocol.response.RemoveGroup;
import org.fisco.bcos.sdk.client.protocol.response.SealerList;
import org.fisco.bcos.sdk.client.protocol.response.SendTransaction;
import org.fisco.bcos.sdk.client.protocol.response.StartGroup;
import org.fisco.bcos.sdk.client.protocol.response.StopGroup;
import org.fisco.bcos.sdk.client.protocol.response.SyncStatus;
import org.fisco.bcos.sdk.client.protocol.response.SystemConfig;
import org.fisco.bcos.sdk.client.protocol.response.TotalTransactionCount;
import org.fisco.bcos.sdk.client.protocol.response.TransactionReceiptWithProof;
import org.fisco.bcos.sdk.client.protocol.response.TransactionWithProof;
import org.fisco.bcos.sdk.crypto.CryptoSuite;
import org.fisco.bcos.sdk.eventsub.EventResource;
import org.fisco.bcos.sdk.model.NodeVersion;
import org.fisco.bcos.sdk.model.TransactionReceipt;
import org.fisco.bcos.sdk.model.callback.TransactionCallback;
import org.fisco.bcos.sdk.service.GroupManagerService;
import org.fisco.bcos.sdk.utils.Numeric;

public class ClientImpl
implements Client {
    private final JsonRpcService jsonRpcService;
    private final Integer groupId;
    private final Integer DefaultGroupId = 1;
    private final CryptoSuite cryptoSuite;
    private final NodeVersion nodeVersion;
    private final GroupManagerService groupManagerService;
    private EventResource eventResource;

    protected ClientImpl(GroupManagerService groupManagerService, Channel channel, Integer groupId, CryptoSuite cryptoSuite, NodeVersion nodeVersion, EventResource eventResource) {
        this.jsonRpcService = new JsonRpcService(groupManagerService, channel, groupId);
        this.groupId = groupId;
        this.cryptoSuite = cryptoSuite;
        this.nodeVersion = nodeVersion;
        this.groupManagerService = groupManagerService;
        this.eventResource = eventResource;
        this.getBlockLimit();
    }

    protected ClientImpl(Channel channel) {
        this.jsonRpcService = new JsonRpcService(null, channel, null);
        this.groupId = null;
        this.cryptoSuite = null;
        this.nodeVersion = null;
        this.groupManagerService = null;
    }

    @Override
    public GroupManagerService getGroupManagerService() {
        return this.groupManagerService;
    }

    @Override
    public CryptoSuite getCryptoSuite() {
        return this.cryptoSuite;
    }

    @Override
    public NodeVersion getClientNodeVersion() {
        return this.nodeVersion;
    }

    @Override
    public Integer getCryptoType() {
        return this.cryptoSuite.getCryptoTypeConfig();
    }

    @Override
    public Integer getGroupId() {
        return this.groupId;
    }

    @Override
    public SendTransaction sendRawTransaction(String signedTransactionData) {
        return this.jsonRpcService.sendRequestToGroup(new JsonRpcRequest<Serializable>("sendRawTransaction", Arrays.asList(this.groupId, signedTransactionData)), SendTransaction.class);
    }

    @Override
    public void sendRawTransactionAsync(String signedTransactionData, RespCallback<SendTransaction> callback) {
        this.jsonRpcService.asyncSendRequestToGroup(new JsonRpcRequest<Serializable>("sendRawTransaction", Arrays.asList(this.groupId, signedTransactionData)), SendTransaction.class, callback);
    }

    @Override
    public Call call(Transaction transaction) {
        return this.jsonRpcService.sendRequestToGroup(new JsonRpcRequest<Object>("call", Arrays.asList(this.groupId, transaction)), Call.class);
    }

    @Override
    public void callAsync(Transaction transaction, RespCallback<Call> callback) {
        this.jsonRpcService.asyncSendRequestToGroup(new JsonRpcRequest<Object>("call", Arrays.asList(this.groupId, transaction)), Call.class, callback);
    }

    @Override
    public SendTransaction sendRawTransactionAndGetProof(String signedTransactionData) {
        return this.jsonRpcService.sendRequestToGroup(new JsonRpcRequest<Serializable>("sendRawTransactionAndGetProof", Arrays.asList(this.groupId, signedTransactionData)), SendTransaction.class);
    }

    @Override
    public void sendRawTransactionAndGetProofAsync(String signedTransactionData, RespCallback<SendTransaction> callback) {
        this.jsonRpcService.asyncSendRequestToGroup(new JsonRpcRequest<Serializable>("sendRawTransactionAndGetProof", Arrays.asList(this.groupId, signedTransactionData)), SendTransaction.class, callback);
    }

    @Override
    public BlockNumber getBlockNumber() {
        JsonRpcRequest<Integer> request = new JsonRpcRequest<Integer>("getBlockNumber", Arrays.asList(this.groupId));
        return this.jsonRpcService.sendRequestToGroup(request, BlockNumber.class);
    }

    @Override
    public BlockNumber getBlockNumber(Integer groupId, String peerIpAndPort) {
        JsonRpcRequest<Integer> request = new JsonRpcRequest<Integer>("getBlockNumber", Arrays.asList(groupId));
        return this.jsonRpcService.sendRequestToPeer(request, peerIpAndPort, BlockNumber.class);
    }

    @Override
    public void getBlockNumberAsync(RespCallback<BlockNumber> callback) {
        this.jsonRpcService.asyncSendRequestToGroup(new JsonRpcRequest<Integer>("getBlockNumber", Arrays.asList(this.groupId)), BlockNumber.class, callback);
    }

    @Override
    public Code getCode(String address) {
        JsonRpcRequest<Serializable> request = new JsonRpcRequest<Serializable>("getCode", Arrays.asList(this.groupId, address));
        return this.jsonRpcService.sendRequestToGroup(request, Code.class);
    }

    @Override
    public void getCodeAsync(String address, RespCallback<Code> callback) {
        this.jsonRpcService.asyncSendRequestToGroup(new JsonRpcRequest<Serializable>("getCode", Arrays.asList(this.groupId, address)), Code.class, callback);
    }

    @Override
    public TotalTransactionCount getTotalTransactionCount() {
        JsonRpcRequest<Integer> request = new JsonRpcRequest<Integer>("getTotalTransactionCount", Arrays.asList(this.groupId));
        return this.jsonRpcService.sendRequestToGroup(request, TotalTransactionCount.class);
    }

    @Override
    public void getTotalTransactionCountAsync(RespCallback<TotalTransactionCount> callback) {
        this.jsonRpcService.asyncSendRequestToGroup(new JsonRpcRequest<Integer>("getTotalTransactionCount", Arrays.asList(this.groupId)), TotalTransactionCount.class, callback);
    }

    @Override
    public BcosBlock getBlockByHash(String blockHash, boolean returnFullTransactionObjects) {
        return this.jsonRpcService.sendRequestToGroup(new JsonRpcRequest<Serializable>("getBlockByHash", Arrays.asList(this.groupId, blockHash, returnFullTransactionObjects)), BcosBlock.class);
    }

    @Override
    public void getBlockByHashAsync(String blockHash, boolean returnFullTransactionObjects, RespCallback<BcosBlock> callback) {
        this.jsonRpcService.asyncSendRequestToGroup(new JsonRpcRequest<Serializable>("getBlockByHash", Arrays.asList(this.groupId, blockHash, returnFullTransactionObjects)), BcosBlock.class, callback);
    }

    @Override
    public BcosBlock getBlockByNumber(BigInteger blockNumber, boolean returnFullTransactionObjects) {
        return this.jsonRpcService.sendRequestToGroup(new JsonRpcRequest<Serializable>("getBlockByNumber", Arrays.asList(this.groupId, String.valueOf(blockNumber), returnFullTransactionObjects)), BcosBlock.class);
    }

    @Override
    public void getBlockByNumberAsync(BigInteger blockNumber, boolean returnFullTransactionObjects, RespCallback<BcosBlock> callback) {
        this.jsonRpcService.asyncSendRequestToGroup(new JsonRpcRequest<Serializable>("getBlockByNumber", Arrays.asList(this.groupId, String.valueOf(blockNumber), returnFullTransactionObjects)), BcosBlock.class, callback);
    }

    @Override
    public BlockHash getBlockHashByNumber(BigInteger blockNumber) {
        return this.jsonRpcService.sendRequestToGroup(new JsonRpcRequest<Serializable>("getBlockHashByNumber", Arrays.asList(this.groupId, String.valueOf(blockNumber))), BlockHash.class);
    }

    @Override
    public void getBlockHashByNumberAsync(BigInteger blockNumber, RespCallback<BlockHash> callback) {
        this.jsonRpcService.asyncSendRequestToGroup(new JsonRpcRequest<Serializable>("getBlockHashByNumber", Arrays.asList(this.groupId, String.valueOf(blockNumber))), BlockHash.class, callback);
    }

    @Override
    public BcosBlockHeader getBlockHeaderByHash(String blockHash, boolean returnSignatureList) {
        return this.jsonRpcService.sendRequestToGroup(new JsonRpcRequest<Serializable>("getBlockHeaderByHash", Arrays.asList(this.groupId, blockHash, returnSignatureList)), BcosBlockHeader.class);
    }

    @Override
    public void getBlockHeaderByHashAsync(String blockHash, boolean returnSignatureList, RespCallback<BcosBlockHeader> callback) {
        this.jsonRpcService.asyncSendRequestToGroup(new JsonRpcRequest<Serializable>("getBlockHeaderByHash", Arrays.asList(this.groupId, blockHash, returnSignatureList)), BcosBlockHeader.class, callback);
    }

    @Override
    public BcosBlockHeader getBlockHeaderByNumber(BigInteger blockNumber, boolean returnSignatureList) {
        return this.jsonRpcService.sendRequestToGroup(new JsonRpcRequest<Serializable>("getBlockHeaderByNumber", Arrays.asList(this.groupId, String.valueOf(blockNumber), returnSignatureList)), BcosBlockHeader.class);
    }

    @Override
    public void getBlockHeaderByNumberAsync(BigInteger blockNumber, boolean returnSignatureList, RespCallback<BcosBlockHeader> callback) {
        this.jsonRpcService.asyncSendRequestToGroup(new JsonRpcRequest<Serializable>("getBlockHeaderByNumber", Arrays.asList(this.groupId, String.valueOf(blockNumber), returnSignatureList)), BcosBlockHeader.class, callback);
    }

    @Override
    public BcosTransaction getTransactionByHash(String transactionHash) {
        return this.jsonRpcService.sendRequestToGroup(new JsonRpcRequest<Serializable>("getTransactionByHash", Arrays.asList(this.groupId, transactionHash)), BcosTransaction.class);
    }

    @Override
    public void getTransactionByHashAsync(String transactionHash, RespCallback<BcosTransaction> callback) {
        this.jsonRpcService.asyncSendRequestToGroup(new JsonRpcRequest<Serializable>("getTransactionByHash", Arrays.asList(this.groupId, transactionHash)), BcosTransaction.class, callback);
    }

    @Override
    public TransactionWithProof getTransactionByHashWithProof(String transactionHash) {
        return this.jsonRpcService.sendRequestToGroup(new JsonRpcRequest<Serializable>("getTransactionByHashWithProof", Arrays.asList(this.groupId, transactionHash)), TransactionWithProof.class);
    }

    @Override
    public void getTransactionByHashWithProofAsync(String transactionHash, RespCallback<TransactionWithProof> callback) {
        this.jsonRpcService.asyncSendRequestToGroup(new JsonRpcRequest<Serializable>("getTransactionByHashWithProof", Arrays.asList(this.groupId, transactionHash)), TransactionWithProof.class, callback);
    }

    @Override
    public BcosTransaction getTransactionByBlockNumberAndIndex(BigInteger blockNumber, BigInteger transactionIndex) {
        return this.jsonRpcService.sendRequestToGroup(new JsonRpcRequest<Serializable>("getTransactionByBlockNumberAndIndex", Arrays.asList(this.groupId, String.valueOf(blockNumber), Numeric.encodeQuantity(transactionIndex))), BcosTransaction.class);
    }

    @Override
    public void getTransactionByBlockNumberAndIndexAsync(BigInteger blockNumber, BigInteger transactionIndex, RespCallback<BcosTransaction> callback) {
        this.jsonRpcService.asyncSendRequestToGroup(new JsonRpcRequest<Serializable>("getTransactionByBlockNumberAndIndex", Arrays.asList(this.groupId, String.valueOf(blockNumber), Numeric.encodeQuantity(transactionIndex))), BcosTransaction.class, callback);
    }

    @Override
    public BcosTransaction getTransactionByBlockHashAndIndex(String blockHash, BigInteger transactionIndex) {
        return this.jsonRpcService.sendRequestToGroup(new JsonRpcRequest<Serializable>("getTransactionByBlockHashAndIndex", Arrays.asList(this.groupId, blockHash, Numeric.encodeQuantity(transactionIndex))), BcosTransaction.class);
    }

    @Override
    public void getTransactionByBlockHashAndIndexAsync(String blockHash, BigInteger transactionIndex, RespCallback<BcosTransaction> callback) {
        this.jsonRpcService.asyncSendRequestToGroup(new JsonRpcRequest<Serializable>("getTransactionByBlockHashAndIndex", Arrays.asList(this.groupId, blockHash, Numeric.encodeQuantity(transactionIndex))), BcosTransaction.class, callback);
    }

    @Override
    public BcosTransactionReceipt getTransactionReceipt(String transactionHash) {
        return this.jsonRpcService.sendRequestToGroup(new JsonRpcRequest<Serializable>("getTransactionReceipt", Arrays.asList(this.groupId, transactionHash)), BcosTransactionReceipt.class);
    }

    @Override
    public void getTransactionReceiptAsync(String transactionHash, RespCallback<BcosTransactionReceipt> callback) {
        this.jsonRpcService.asyncSendRequestToGroup(new JsonRpcRequest<Serializable>("getTransactionReceipt", Arrays.asList(this.groupId, transactionHash)), BcosTransactionReceipt.class, callback);
    }

    @Override
    public TransactionReceiptWithProof getTransactionReceiptByHashWithProof(String transactionHash) {
        return this.jsonRpcService.sendRequestToGroup(new JsonRpcRequest<Serializable>("getTransactionReceiptByHashWithProof", Arrays.asList(this.groupId, transactionHash)), TransactionReceiptWithProof.class);
    }

    @Override
    public void getTransactionReceiptByHashWithProofAsync(String transactionHash, RespCallback<TransactionReceiptWithProof> callback) {
        this.jsonRpcService.asyncSendRequestToGroup(new JsonRpcRequest<Serializable>("getTransactionReceiptByHashWithProof", Arrays.asList(this.groupId, transactionHash)), TransactionReceiptWithProof.class, callback);
    }

    @Override
    public PendingTransactions getPendingTransaction() {
        return this.jsonRpcService.sendRequestToGroup(new JsonRpcRequest<Integer>("getPendingTransactions", Arrays.asList(this.groupId)), PendingTransactions.class);
    }

    @Override
    public void getPendingTransactionAsync(RespCallback<PendingTransactions> callback) {
        this.jsonRpcService.asyncSendRequestToGroup(new JsonRpcRequest<Integer>("getPendingTransactions", Arrays.asList(this.groupId)), PendingTransactions.class, callback);
    }

    @Override
    public PendingTxSize getPendingTxSize() {
        return this.jsonRpcService.sendRequestToGroup(new JsonRpcRequest<Integer>("getPendingTxSize", Arrays.asList(this.groupId)), PendingTxSize.class);
    }

    @Override
    public void getPendingTxSizeAsync(RespCallback<PendingTxSize> callback) {
        this.jsonRpcService.asyncSendRequestToGroup(new JsonRpcRequest<Integer>("getPendingTxSize", Arrays.asList(this.groupId)), PendingTxSize.class, callback);
    }

    @Override
    public BigInteger getBlockLimit() {
        Integer groupId = (int)this.groupId;
        return this.jsonRpcService.getGroupManagerService().getBlockLimitByGroup(groupId);
    }

    @Override
    public GenerateGroup generateGroup(Integer groupId, long timestamp, boolean enableFreeStorage, List<String> nodeList, String peerIpPort) {
        GenerateGroupParam generateGroupParam = new GenerateGroupParam(String.valueOf(timestamp), enableFreeStorage, nodeList);
        JsonRpcRequest<Object> request = new JsonRpcRequest<Object>("generateGroup", Arrays.asList(groupId, generateGroupParam));
        return this.jsonRpcService.sendRequestToPeer(request, peerIpPort, GenerateGroup.class);
    }

    @Override
    public void generateGroupAsync(Integer groupId, long timestamp, boolean enableFreeStorage, List<String> nodeList, String peerIpPort, RespCallback<GenerateGroup> callback) {
        GenerateGroupParam generateGroupParam = new GenerateGroupParam(String.valueOf(timestamp), enableFreeStorage, nodeList);
        JsonRpcRequest<Object> request = new JsonRpcRequest<Object>("generateGroup", Arrays.asList(groupId, generateGroupParam));
        this.jsonRpcService.asyncSendRequestToPeer(request, peerIpPort, GenerateGroup.class, callback);
    }

    @Override
    public StartGroup startGroup(Integer groupId, String peerIpPort) {
        return this.jsonRpcService.sendRequestToPeer(new JsonRpcRequest<Integer>("startGroup", Arrays.asList(groupId)), peerIpPort, StartGroup.class);
    }

    @Override
    public void startGroupAsync(Integer groupId, String peerIpPort, RespCallback<StartGroup> callback) {
        this.jsonRpcService.asyncSendRequestToPeer(new JsonRpcRequest<Integer>("startGroup", Arrays.asList(this.groupId)), peerIpPort, StartGroup.class, callback);
    }

    @Override
    public StopGroup stopGroup(Integer groupId, String peerIpPort) {
        return this.jsonRpcService.sendRequestToPeer(new JsonRpcRequest<Integer>("stopGroup", Arrays.asList(groupId)), peerIpPort, StopGroup.class);
    }

    @Override
    public void stopGroupAsync(Integer groupId, String peerIpPort, RespCallback<StopGroup> callback) {
        this.jsonRpcService.asyncSendRequestToPeer(new JsonRpcRequest<Integer>("stopGroup", Arrays.asList(this.groupId)), peerIpPort, StopGroup.class, callback);
    }

    @Override
    public RemoveGroup removeGroup(Integer groupId, String peerIpPort) {
        return this.jsonRpcService.sendRequestToPeer(new JsonRpcRequest<Integer>("removeGroup", Arrays.asList(groupId)), peerIpPort, RemoveGroup.class);
    }

    @Override
    public void removeGroupAsync(Integer groupId, String peerIpPort, RespCallback<RemoveGroup> callback) {
        this.jsonRpcService.asyncSendRequestToPeer(new JsonRpcRequest<Integer>("removeGroup", Arrays.asList(this.groupId)), peerIpPort, RemoveGroup.class, callback);
    }

    @Override
    public RecoverGroup recoverGroup(Integer groupId, String peerIpPort) {
        return this.jsonRpcService.sendRequestToPeer(new JsonRpcRequest<Integer>("recoverGroup", Arrays.asList(groupId)), peerIpPort, RecoverGroup.class);
    }

    @Override
    public void recoverGroupAsync(Integer groupId, String peerIpPort, RespCallback<RecoverGroup> callback) {
        this.jsonRpcService.asyncSendRequestToPeer(new JsonRpcRequest<Integer>("recoverGroup", Arrays.asList(this.groupId)), peerIpPort, RecoverGroup.class, callback);
    }

    @Override
    public QueryGroupStatus queryGroupStatus(Integer groupId) {
        return this.jsonRpcService.sendRequestToGroup(new JsonRpcRequest<Integer>("queryGroupStatus", Arrays.asList(groupId)), QueryGroupStatus.class);
    }

    @Override
    public QueryGroupStatus queryGroupStatus(Integer groupId, String peerIpPort) {
        return this.jsonRpcService.sendRequestToPeer(new JsonRpcRequest<Integer>("queryGroupStatus", Arrays.asList(groupId)), peerIpPort, QueryGroupStatus.class);
    }

    @Override
    public void queryGroupStatusAsync(Integer groupId, RespCallback<QueryGroupStatus> callback) {
        this.jsonRpcService.asyncSendRequestToGroup(new JsonRpcRequest<Integer>("queryGroupStatus", Arrays.asList(this.groupId)), QueryGroupStatus.class, callback);
    }

    @Override
    public void queryGroupStatusAsync(Integer groupId, String peerIpPort, RespCallback<QueryGroupStatus> callback) {
        this.jsonRpcService.asyncSendRequestToPeer(new JsonRpcRequest<Integer>("queryGroupStatus", Arrays.asList(this.groupId)), peerIpPort, QueryGroupStatus.class, callback);
    }

    @Override
    public GroupList getGroupList() {
        return this.jsonRpcService.sendRequestToGroup(new JsonRpcRequest<Object>("getGroupList", Arrays.asList(new Object[0])), GroupList.class);
    }

    @Override
    public GroupList getGroupList(String peerIpPort) {
        return this.jsonRpcService.sendRequestToPeer(new JsonRpcRequest<Object>("getGroupList", Arrays.asList(new Object[0])), peerIpPort, GroupList.class);
    }

    @Override
    public void getGroupListAsync(RespCallback<GroupList> callback) {
        this.jsonRpcService.asyncSendRequestToGroup(new JsonRpcRequest<Object>("getGroupList", Arrays.asList(new Object[0])), GroupList.class, callback);
    }

    @Override
    public void getGroupListAsync(String peerIpPort, RespCallback<GroupList> callback) {
        this.jsonRpcService.asyncSendRequestToPeer(new JsonRpcRequest<Object>("getGroupList", Arrays.asList(new Object[0])), peerIpPort, GroupList.class, callback);
    }

    @Override
    public GroupPeers getGroupPeers() {
        return this.jsonRpcService.sendRequestToGroup(new JsonRpcRequest<Integer>("getGroupPeers", Arrays.asList(this.groupId)), GroupPeers.class);
    }

    @Override
    public GroupPeers getGroupPeers(String peerIpPort) {
        return this.jsonRpcService.sendRequestToPeer(new JsonRpcRequest<Integer>("getGroupPeers", Arrays.asList(this.groupId)), peerIpPort, GroupPeers.class);
    }

    @Override
    public void getGroupPeersAsync(RespCallback<GroupPeers> callback) {
        this.jsonRpcService.asyncSendRequestToGroup(new JsonRpcRequest<Integer>("getGroupPeers", Arrays.asList(this.groupId)), GroupPeers.class, callback);
    }

    @Override
    public void getGroupPeersAsync(String peerIpPort, RespCallback<GroupPeers> callback) {
        this.jsonRpcService.asyncSendRequestToPeer(new JsonRpcRequest<Integer>("getGroupPeers", Arrays.asList(this.groupId)), peerIpPort, GroupPeers.class, callback);
    }

    @Override
    public Peers getPeers() {
        return this.jsonRpcService.sendRequestToGroup(new JsonRpcRequest<Integer>("getPeers", Arrays.asList(this.DefaultGroupId)), Peers.class);
    }

    @Override
    public Peers getPeers(String endpoint) {
        return this.jsonRpcService.sendRequestToPeer(new JsonRpcRequest<Integer>("getPeers", Arrays.asList(this.DefaultGroupId)), endpoint, Peers.class);
    }

    @Override
    public void getPeersAsync(RespCallback<Peers> callback) {
        this.jsonRpcService.asyncSendRequestToGroup(new JsonRpcRequest<Integer>("getPeers", Arrays.asList(this.groupId)), Peers.class, callback);
    }

    @Override
    public QueryPeers queryPeers(String peerIpPort) {
        return this.jsonRpcService.sendRequestToPeer(new JsonRpcRequest<Integer>("queryPeers", Arrays.asList(this.DefaultGroupId)), peerIpPort, QueryPeers.class);
    }

    @Override
    public ErasePeers erasePeers(String peerIpPort, List<String> peers) {
        return this.jsonRpcService.sendRequestToPeer(new JsonRpcRequest<List>("erasePeers", Arrays.asList(peers)), peerIpPort, ErasePeers.class);
    }

    @Override
    public AddPeers addPeers(String peerIpPort, List<String> peers) {
        return this.jsonRpcService.sendRequestToPeer(new JsonRpcRequest<List>("addPeers", Arrays.asList(peers)), peerIpPort, AddPeers.class);
    }

    @Override
    public NodeInfo getNodeInfo(String endpoint) {
        return this.jsonRpcService.sendRequestToPeer(new JsonRpcRequest<Object>("getNodeInfo", Arrays.asList(new Object[0])), endpoint, NodeInfo.class);
    }

    @Override
    public void getNodeInfoAsync(String endpoint, RespCallback<NodeInfo> callback) {
        this.jsonRpcService.asyncSendRequestToPeer(new JsonRpcRequest<Object>("getNodeInfo", Arrays.asList(new Object[0])), endpoint, NodeInfo.class, callback);
    }

    @Override
    public NodeIDList getNodeIDList() {
        return this.jsonRpcService.sendRequestToGroup(new JsonRpcRequest<Integer>("getNodeIDList", Arrays.asList(this.DefaultGroupId)), NodeIDList.class);
    }

    @Override
    public NodeIDList getNodeIDList(String endpoint) {
        return this.jsonRpcService.sendRequestToPeer(new JsonRpcRequest<Integer>("getNodeIDList", Arrays.asList(this.DefaultGroupId)), endpoint, NodeIDList.class);
    }

    @Override
    public void getNodeIDListAsync(RespCallback<NodeIDList> callback) {
        this.jsonRpcService.asyncSendRequestToGroup(new JsonRpcRequest<Object>("getNodeIDList", Arrays.asList(new Object[0])), NodeIDList.class, callback);
    }

    @Override
    public ObserverList getObserverList() {
        return this.jsonRpcService.sendRequestToGroup(new JsonRpcRequest<Integer>("getObserverList", Arrays.asList(this.groupId)), ObserverList.class);
    }

    @Override
    public void getObserverList(RespCallback<ObserverList> callback) {
        this.jsonRpcService.asyncSendRequestToGroup(new JsonRpcRequest<Integer>("getObserverList", Arrays.asList(this.groupId)), ObserverList.class, callback);
    }

    @Override
    public SealerList getSealerList() {
        return this.jsonRpcService.sendRequestToGroup(new JsonRpcRequest<Integer>("getSealerList", Arrays.asList(this.groupId)), SealerList.class);
    }

    @Override
    public void getSealerListAsync(RespCallback<SealerList> callback) {
        this.jsonRpcService.asyncSendRequestToGroup(new JsonRpcRequest<Integer>("getSealerList", Arrays.asList(this.groupId)), SealerList.class, callback);
    }

    @Override
    public PbftView getPbftView() {
        return this.jsonRpcService.sendRequestToGroup(new JsonRpcRequest<Integer>("getPbftView", Arrays.asList(this.groupId)), PbftView.class);
    }

    @Override
    public void getPbftViewAsync(RespCallback<PbftView> callback) {
        this.jsonRpcService.asyncSendRequestToGroup(new JsonRpcRequest<Integer>("getPbftView", Arrays.asList(this.groupId)), PbftView.class, callback);
    }

    @Override
    public NodeVersion getNodeVersion() {
        return this.jsonRpcService.sendRequestToGroup(new JsonRpcRequest<Object>("getClientVersion", Arrays.asList(new Object[0])), NodeVersion.class);
    }

    @Override
    public NodeVersion getNodeVersion(String ipAndPort) {
        return this.jsonRpcService.sendRequestToPeer(new JsonRpcRequest<Object>("getClientVersion", Arrays.asList(new Object[0])), ipAndPort, NodeVersion.class);
    }

    @Override
    public void getNodeVersion(RespCallback<NodeVersion> callback) {
        this.jsonRpcService.asyncSendRequestToGroup(new JsonRpcRequest<Object>("getClientVersion", Arrays.asList(new Object[0])), NodeVersion.class, callback);
    }

    @Override
    public ConsensusStatus getConsensusStatus() {
        return this.jsonRpcService.sendRequestToGroup(new JsonRpcRequest<Integer>("getConsensusStatus", Arrays.asList(this.groupId)), ConsensusStatus.class);
    }

    @Override
    public void getConsensusStates(RespCallback<ConsensusStatus> callback) {
        this.jsonRpcService.asyncSendRequestToGroup(new JsonRpcRequest<Integer>("getConsensusStatus", Arrays.asList(this.groupId)), ConsensusStatus.class, callback);
    }

    @Override
    public SystemConfig getSystemConfigByKey(String key) {
        return this.jsonRpcService.sendRequestToGroup(new JsonRpcRequest<Serializable>("getSystemConfigByKey", Arrays.asList(this.groupId, key)), SystemConfig.class);
    }

    @Override
    public SystemConfig getSystemConfigByKey(String key, String peerIpPort) {
        return this.jsonRpcService.sendRequestToPeer(new JsonRpcRequest<Serializable>("getSystemConfigByKey", Arrays.asList(this.groupId, key)), peerIpPort, SystemConfig.class);
    }

    @Override
    public void getSystemConfigByKeyAsync(String key, RespCallback<SystemConfig> callback) {
        this.jsonRpcService.asyncSendRequestToGroup(new JsonRpcRequest<Integer>("getSystemConfigByKey", Arrays.asList(this.groupId)), SystemConfig.class, callback);
    }

    @Override
    public void getSystemConfigByKeyAsync(String key, String peerIpPort, RespCallback<SystemConfig> callback) {
        this.jsonRpcService.asyncSendRequestToPeer(new JsonRpcRequest<Integer>("getSystemConfigByKey", Arrays.asList(this.groupId)), peerIpPort, SystemConfig.class, callback);
    }

    @Override
    public SyncStatus getSyncStatus() {
        return this.jsonRpcService.sendRequestToGroup(new JsonRpcRequest<Integer>("getSyncStatus", Arrays.asList(this.groupId)), SyncStatus.class);
    }

    @Override
    public void getSyncStatus(RespCallback<SyncStatus> callback) {
        this.jsonRpcService.asyncSendRequestToGroup(new JsonRpcRequest<Integer>("getSyncStatus", Arrays.asList(this.groupId)), SyncStatus.class, callback);
    }

    @Override
    public TransactionReceipt sendRawTransactionAndGetReceipt(String signedTransactionData) {
        SynchronousTransactionCallback callback = new SynchronousTransactionCallback();
        this.sendRawTransactionAndGetReceiptAsync(signedTransactionData, callback);
        try {
            callback.semaphore.acquire(1);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return callback.receipt;
    }

    @Override
    public void sendRawTransactionAndGetReceiptAsync(String signedTransactionData, TransactionCallback callback) {
        this.jsonRpcService.asyncSendTransactionToGroup(new JsonRpcRequest<Serializable>("sendRawTransaction", Arrays.asList(this.groupId, signedTransactionData)), callback, SendTransaction.class);
    }

    @Override
    public void sendRawTransactionAndGetReceiptWithProofAsync(String signedTransactionData, TransactionCallback callback) {
        this.jsonRpcService.asyncSendTransactionToGroup(new JsonRpcRequest<Serializable>("sendRawTransactionAndGetProof", Arrays.asList(this.groupId, signedTransactionData)), callback, SendTransaction.class);
    }

    @Override
    public TransactionReceipt sendRawTransactionAndGetReceiptWithProof(String signedTransactionData) {
        SynchronousTransactionCallback callback = new SynchronousTransactionCallback();
        this.sendRawTransactionAndGetReceiptWithProofAsync(signedTransactionData, callback);
        try {
            callback.semaphore.acquire(1);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return callback.receipt;
    }

    @Override
    public BcosTransactionReceiptsDecoder getBatchReceiptsByBlockNumberAndRange(BigInteger blockNumber, String from, String count) {
        return this.jsonRpcService.sendRequestToGroup(new JsonRpcRequest<Serializable>("getBatchReceiptsByBlockNumberAndRange", Arrays.asList(this.groupId, String.valueOf(blockNumber), from, count, true)), BcosTransactionReceiptsDecoder.class);
    }

    @Override
    public BcosTransactionReceiptsDecoder getBatchReceiptsByBlockHashAndRange(String blockHash, String from, String count) {
        return this.jsonRpcService.sendRequestToGroup(new JsonRpcRequest<Serializable>("getBatchReceiptsByBlockHashAndRange", Arrays.asList(this.groupId, blockHash, from, count, true)), BcosTransactionReceiptsDecoder.class);
    }

    @Override
    public EventResource getEventResource() {
        return this.eventResource;
    }

    @Override
    public void stop() {
        Thread.currentThread().interrupt();
    }

    class SynchronousTransactionCallback
    extends TransactionCallback {
        public TransactionReceipt receipt;
        public Semaphore semaphore = new Semaphore(1, true);

        SynchronousTransactionCallback() {
            try {
                this.semaphore.acquire(1);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }

        @Override
        public void onTimeout() {
            super.onTimeout();
            this.semaphore.release();
        }

        @Override
        public void onResponse(TransactionReceipt receipt) {
            this.receipt = receipt;
            this.semaphore.release();
        }
    }
}

