/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.channel;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.AttributeKey;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.fisco.bcos.sdk.channel.ChannelImp;
import org.fisco.bcos.sdk.channel.ChannelVersionNegotiation;
import org.fisco.bcos.sdk.channel.ResponseCallback;
import org.fisco.bcos.sdk.channel.model.ChannelHandshake;
import org.fisco.bcos.sdk.channel.model.ChannelMessageError;
import org.fisco.bcos.sdk.channel.model.ChannelPrococolExceiption;
import org.fisco.bcos.sdk.channel.model.ChannelProtocol;
import org.fisco.bcos.sdk.channel.model.ChannelRequest;
import org.fisco.bcos.sdk.channel.model.EnumChannelProtocolVersion;
import org.fisco.bcos.sdk.channel.model.EnumNodeVersion;
import org.fisco.bcos.sdk.channel.model.EnumSocketChannelAttributeKey;
import org.fisco.bcos.sdk.model.Message;
import org.fisco.bcos.sdk.model.MsgType;
import org.fisco.bcos.sdk.model.NodeVersion;
import org.fisco.bcos.sdk.model.Response;
import org.fisco.bcos.sdk.network.MsgHandler;
import org.fisco.bcos.sdk.utils.ChannelUtils;
import org.fisco.bcos.sdk.utils.ObjectMapperFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelMsgHandler
implements MsgHandler {
    private static Logger logger = LoggerFactory.getLogger(ChannelImp.class);
    private final ObjectMapper objectMapper = ObjectMapperFactory.getObjectMapper();
    private List<MsgHandler> msgConnectHandlerList = new CopyOnWriteArrayList<MsgHandler>();
    private List<MsgHandler> msgDisconnectHandleList = new CopyOnWriteArrayList<MsgHandler>();
    private Map<Integer, MsgHandler> msgHandlers = new ConcurrentHashMap<Integer, MsgHandler>();
    private List<MsgHandler> msgEstablishHandlerList = new CopyOnWriteArrayList<MsgHandler>();
    private Map<String, ResponseCallback> seq2Callback = new ConcurrentHashMap<String, ResponseCallback>();
    private Map<String, ChannelHandlerContext> availablePeer = new ConcurrentHashMap<String, ChannelHandlerContext>();

    public Map<String, ChannelHandlerContext> getAvailablePeer() {
        return this.availablePeer;
    }

    public void addConnectHandler(MsgHandler handler) {
        this.msgConnectHandlerList.add(handler);
    }

    public void addEstablishHandler(MsgHandler handler) {
        this.msgEstablishHandlerList.add(handler);
    }

    public void addMessageHandler(MsgType type, MsgHandler handler) {
        this.msgHandlers.put(type.getType(), handler);
    }

    public void addDisconnectHandler(MsgHandler handler) {
        this.msgDisconnectHandleList.add(handler);
    }

    public void addSeq2CallBack(String seq, ResponseCallback callback) {
        this.seq2Callback.put(seq, callback);
    }

    public void removeSeq(String seq) {
        this.seq2Callback.remove(seq);
    }

    private void addAvailablePeer(String host, ChannelHandlerContext ctx) {
        this.availablePeer.put(host, ctx);
        for (MsgHandler msgHandler : this.msgEstablishHandlerList) {
            msgHandler.onConnect(ctx);
        }
    }

    private void removeAvailablePeers(String host) {
        if (this.availablePeer.containsKey(host)) {
            this.availablePeer.remove(host);
        }
    }

    private ResponseCallback getAndRemoveSeq(String seq) {
        ResponseCallback callback = this.seq2Callback.get(seq);
        this.seq2Callback.remove(seq);
        return callback;
    }

    @Override
    public void onConnect(ChannelHandlerContext ctx) {
        logger.debug("onConnect in ChannelMsgHandler called, host : {}", (Object)ChannelVersionNegotiation.getPeerHost(ctx));
        this.queryNodeVersion(ctx);
        for (MsgHandler msgHandler : this.msgConnectHandlerList) {
            msgHandler.onConnect(ctx);
        }
    }

    @Override
    public void onMessage(ChannelHandlerContext ctx, Message msg) {
        logger.debug("onMessage in ChannelMsgHandler called, host : {}, seq : {}, msgType : {}", new Object[]{ChannelVersionNegotiation.getPeerHost(ctx), msg.getSeq(), (int)msg.getType().shortValue()});
        ResponseCallback callback = this.getAndRemoveSeq(msg.getSeq());
        if (callback != null) {
            callback.cancelTimeout();
            logger.trace(" call registered callback, seq: {}, type: {} ,result: {}", new Object[]{msg.getSeq(), msg.getType(), msg.getResult()});
            Response response = new Response();
            if (msg.getResult() != 0) {
                response.setErrorMessage("Response error");
            }
            response.setErrorCode(msg.getResult());
            response.setMessageID(msg.getSeq());
            response.setContentBytes(msg.getData());
            response.setCtx(ctx);
            callback.onResponse(response);
        } else {
            MsgHandler msgHandler = this.msgHandlers.get(msg.getType().intValue());
            if (msgHandler != null) {
                logger.trace(" receive message, no callback, call handler, seq:{} , type: {}, result: {}", new Object[]{msg.getSeq(), (int)msg.getType().shortValue(), msg.getResult()});
                msgHandler.onMessage(ctx, msg);
            }
            logger.debug(" call ");
        }
    }

    @Override
    public void onDisconnect(ChannelHandlerContext ctx) {
        String host = ChannelVersionNegotiation.getPeerHost(ctx);
        logger.debug("onDisconnect in ChannelMsgHandler called, host : {}", (Object)host);
        for (MsgHandler handle : this.msgDisconnectHandleList) {
            handle.onDisconnect(ctx);
        }
        this.removeAvailablePeers(host);
    }

    private void queryNodeVersion(final ChannelHandlerContext ctx) {
        ChannelRequest<Object> request = new ChannelRequest<Object>("getClientVersion", Arrays.asList(new Object[0]));
        String seq = ChannelUtils.newSeq();
        Message message = new Message();
        try {
            byte[] payload = this.objectMapper.writeValueAsBytes(request);
            message.setSeq(seq);
            message.setResult(0);
            message.setType((short)MsgType.CHANNEL_RPC_REQUEST.getType());
            message.setData(payload);
            logger.trace("encodeRequestToMessage, seq: {}, method: {}, messageType: {}", new Object[]{message.getSeq(), request.getMethod(), message.getType()});
        }
        catch (JsonProcessingException e) {
            logger.error("encodeRequestToMessage failed for decode the message exception, errorMessage: {}", (Object)e.getMessage());
        }
        ResponseCallback callback = new ResponseCallback(){

            @Override
            public void onResponse(Response response) {
                Boolean disconnect = true;
                try {
                    if (response.getErrorCode().intValue() == ChannelMessageError.MESSAGE_TIMEOUT.getError()) {
                        ChannelVersionNegotiation.setProtocolVersion(ctx, EnumChannelProtocolVersion.VERSION_1, "below-2.1.0-timeout");
                        logger.info(" query node version timeout, content: {}", (Object)response.getContent());
                        return;
                    }
                    if (response.getErrorCode() != 0) {
                        logger.error(" node version response, code: {}, message: {}", (Object)response.getErrorCode(), (Object)response.getErrorMessage());
                        throw new ChannelPrococolExceiption(" query node version failed, code: " + response.getErrorCode() + ", message: " + response.getErrorMessage());
                    }
                    NodeVersion nodeVersion = (NodeVersion)ChannelMsgHandler.this.objectMapper.readValue(response.getContent(), NodeVersion.class);
                    logger.info(" node: {}, content: {}", nodeVersion.getResult(), (Object)response.getContent());
                    if (EnumNodeVersion.channelProtocolHandleShakeSupport(((NodeVersion.ClientVersion)nodeVersion.getResult()).getSupportedVersion())) {
                        logger.info(" support channel handshake node");
                        ChannelMsgHandler.this.queryChannelProtocolVersion(ctx);
                    } else {
                        logger.info(" not support channel handshake set default");
                        ChannelVersionNegotiation.setProtocolVersion(ctx, EnumChannelProtocolVersion.VERSION_1, ((NodeVersion.ClientVersion)nodeVersion.getResult()).getSupportedVersion());
                        ChannelMsgHandler.this.addPeerHost(ctx);
                    }
                    disconnect = false;
                }
                catch (Exception e) {
                    logger.error(" query node version failed, message: {}", (Object)e.getMessage());
                }
                if (disconnect.booleanValue()) {
                    ctx.disconnect();
                    ctx.close();
                }
            }
        };
        ctx.writeAndFlush((Object)message);
        this.addSeq2CallBack(seq, callback);
    }

    private void queryChannelProtocolVersion(final ChannelHandlerContext ctx) throws ChannelPrococolExceiption {
        final String host = ChannelVersionNegotiation.getPeerHost(ctx);
        String seq = ChannelUtils.newSeq();
        Message message = new Message();
        try {
            ChannelHandshake channelHandshake = new ChannelHandshake();
            byte[] payload = this.objectMapper.writeValueAsBytes((Object)channelHandshake);
            message.setSeq(seq);
            message.setResult(0);
            message.setType((short)MsgType.CLIENT_HANDSHAKE.getType());
            message.setData(payload);
            logger.trace("encodeChannelHandshakeToMessage, seq: {}, data: {}, messageType: {}", new Object[]{message.getSeq(), channelHandshake.toString(), message.getType()});
        }
        catch (JsonProcessingException e) {
            logger.error("queryChannelProtocolVersion failed for decode the message exception, errorMessage: {}", (Object)e.getMessage());
            throw new ChannelPrococolExceiption(e.getMessage());
        }
        ResponseCallback callback = new ResponseCallback(){

            @Override
            public void onResponse(Response response) {
                Boolean disconnect = true;
                try {
                    if (response.getErrorCode() != 0) {
                        logger.error(" channel protocol handshake request failed, code: {}, message: {}", (Object)response.getErrorCode(), (Object)response.getErrorMessage());
                        throw new ChannelPrococolExceiption(" channel protocol handshake request failed, code: " + response.getErrorCode() + ", message: " + response.getErrorMessage());
                    }
                    ChannelProtocol channelProtocol = (ChannelProtocol)ChannelMsgHandler.this.objectMapper.readValue(response.getContent(), ChannelProtocol.class);
                    EnumChannelProtocolVersion enumChannelProtocolVersion = EnumChannelProtocolVersion.toEnum(channelProtocol.getProtocol());
                    channelProtocol.setEnumProtocol(enumChannelProtocolVersion);
                    logger.info(" channel protocol handshake success, set socket channel protocol, host: {}, channel protocol: {}", (Object)host, (Object)channelProtocol);
                    ctx.channel().attr(AttributeKey.valueOf((String)EnumSocketChannelAttributeKey.CHANNEL_PROTOCOL_KEY.getKey())).set((Object)channelProtocol);
                    disconnect = false;
                }
                catch (Exception e) {
                    logger.error(" channel protocol handshake failed, exception: {}", (Object)e.getMessage());
                }
                if (disconnect.booleanValue()) {
                    ctx.disconnect();
                    ctx.close();
                } else {
                    ChannelMsgHandler.this.addPeerHost(ctx);
                }
            }
        };
        ctx.writeAndFlush((Object)message);
        this.addSeq2CallBack(seq, callback);
    }

    private void addPeerHost(ChannelHandlerContext ctx) {
        String host = ChannelVersionNegotiation.getPeerHost(ctx);
        this.addAvailablePeer(host, ctx);
    }
}

