/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.abi.datatypes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.fisco.bcos.sdk.abi.datatypes.Array;
import org.fisco.bcos.sdk.abi.datatypes.DynamicArray;
import org.fisco.bcos.sdk.abi.datatypes.StructType;
import org.fisco.bcos.sdk.abi.datatypes.Type;
import org.fisco.bcos.sdk.abi.datatypes.generated.AbiTypes;

public class DynamicStruct
extends DynamicArray<Type>
implements StructType {
    private final List<Class<Type>> itemTypes = new ArrayList<Class<Type>>();
    private final List<Type> componentTypes = new ArrayList<Type>();

    private DynamicStruct(Class<Type> type, List<Type> values) {
        super(values);
        for (Type value : values) {
            this.itemTypes.add(value.getClass());
            this.componentTypes.add(value);
        }
    }

    public DynamicStruct(List<Type> values) {
        super(values);
        for (Type value : values) {
            this.itemTypes.add(value.getClass());
            this.componentTypes.add(value);
        }
    }

    @SafeVarargs
    public DynamicStruct(Class<Type> type, Type ... values) {
        this(type, Arrays.asList(values));
    }

    public DynamicStruct(Type ... values) {
        this(Type.class, Arrays.asList(values));
    }

    @Override
    public String getTypeAsString() {
        StringBuilder type = new StringBuilder("(");
        for (int i = 0; i < this.itemTypes.size(); ++i) {
            Class<Type> cls = this.itemTypes.get(i);
            if (StructType.class.isAssignableFrom(cls) || Array.class.isAssignableFrom(cls)) {
                type.append(((Type)this.getValue().get(i)).getTypeAsString());
            } else {
                type.append(AbiTypes.getTypeAString(cls));
            }
            if (i >= this.itemTypes.size() - 1) continue;
            type.append(",");
        }
        type.append(")");
        return type.toString();
    }

    @Override
    public List<Type> getComponentTypes() {
        return this.componentTypes;
    }
}

