/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk;

import io.netty.channel.ChannelException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.fisco.bcos.sdk.BcosSDKException;
import org.fisco.bcos.sdk.amop.Amop;
import org.fisco.bcos.sdk.channel.Channel;
import org.fisco.bcos.sdk.client.Client;
import org.fisco.bcos.sdk.config.Config;
import org.fisco.bcos.sdk.config.ConfigOption;
import org.fisco.bcos.sdk.config.exceptions.ConfigException;
import org.fisco.bcos.sdk.eventsub.EventResource;
import org.fisco.bcos.sdk.eventsub.EventSubscribe;
import org.fisco.bcos.sdk.model.ConstantConfig;
import org.fisco.bcos.sdk.service.GroupManagerService;
import org.fisco.bcos.sdk.service.GroupManagerServiceImpl;
import org.fisco.bcos.sdk.utils.ThreadPoolService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BcosSDK {
    private static Logger logger = LoggerFactory.getLogger(BcosSDK.class);
    public static final String ECDSA_TYPE_STR = "ecdsa";
    public static final String SM_TYPE_STR = "sm";
    private final ConfigOption config;
    private final Channel channel;
    private final GroupManagerService groupManagerService;
    private ConcurrentHashMap<Integer, Client> groupToClient = new ConcurrentHashMap();
    private long maxWaitEstablishConnectionTime = 30000L;
    private Amop amop;
    private EventResource eventResource;
    private ThreadPoolService threadPoolService;

    public static BcosSDK build(String tomlConfigFilePath) throws BcosSDKException {
        try {
            ConfigOption configOption = Config.load(tomlConfigFilePath);
            logger.info("create BcosSDK, configPath: {}", (Object)tomlConfigFilePath);
            return new BcosSDK(configOption);
        }
        catch (ConfigException e) {
            throw new BcosSDKException("create BcosSDK failed, error info: " + e.getMessage(), e);
        }
    }

    public BcosSDK(ConfigOption configOption) throws BcosSDKException {
        try {
            this.channel = Channel.build(configOption);
            this.channel.start();
            this.config = this.channel.getNetwork().getConfigOption();
            logger.info("create BcosSDK, start channel success, cryptoType: {}", (Object)this.channel.getNetwork().getSslCryptoType());
            this.threadPoolService = new ThreadPoolService("channelProcessor", this.config.getThreadPoolConfig().getChannelProcessorThreadSize(), this.config.getThreadPoolConfig().getMaxBlockingQueueSize());
            this.channel.setThreadPool(this.threadPoolService.getThreadPool());
            logger.info("create BcosSDK, start channel succ, channelProcessorThreadSize: {}, receiptProcessorThreadSize: {}", (Object)this.config.getThreadPoolConfig().getChannelProcessorThreadSize(), (Object)this.config.getThreadPoolConfig().getReceiptProcessorThreadSize());
            if (!this.waitForEstablishConnection()) {
                logger.error("create BcosSDK failed for the number of available peers is 0");
                throw new BcosSDKException("create BcosSDK failed for the number of available peers is 0");
            }
            this.groupManagerService = new GroupManagerServiceImpl(this.channel, this.config);
            logger.info("create BcosSDK, create groupManagerService success");
            this.amop = Amop.build(this.channel, this.config);
            this.groupManagerService.setAmop(this.amop);
            this.amop.start();
            logger.info("create BcosSDK, create Amop success");
            this.eventResource = new EventResource();
        }
        catch (ChannelException | ConfigException e) {
            this.stopAll();
            throw new BcosSDKException("create BcosSDK failed, error info: " + e.getMessage(), e);
        }
    }

    private boolean waitForEstablishConnection() {
        long startTime = System.currentTimeMillis();
        try {
            while (System.currentTimeMillis() - startTime < this.maxWaitEstablishConnectionTime && this.channel.getAvailablePeer().size() == 0) {
                Thread.sleep(1000L);
            }
        }
        catch (InterruptedException e) {
            logger.warn("waitForEstablishConnection exceptioned, error info: {}", (Object)e.getMessage());
        }
        return this.channel.getAvailablePeer().size() > 0;
    }

    public void checkGroupId(Integer groupId) {
        if (groupId < ConstantConfig.MIN_GROUPID || groupId > ConstantConfig.MAX_GROUPID) {
            throw new BcosSDKException("create client for group " + groupId + " failed for invalid groupId! The groupID must be no smaller than " + ConstantConfig.MIN_GROUPID + " and no more than " + ConstantConfig.MAX_GROUPID);
        }
    }

    public Client getClient(Integer groupId) {
        this.checkGroupId(groupId);
        if (!this.waitForEstablishConnection()) {
            logger.error("get client for group: {} failed for the number of available peers is 0", (Object)groupId);
            throw new BcosSDKException("get client for group " + groupId + " failed for the number of available peers is 0");
        }
        if (!this.groupToClient.containsKey(groupId)) {
            Client client = Client.build(this.groupManagerService, this.channel, this.eventResource, groupId);
            if (client == null) {
                throw new BcosSDKException("create client for group " + groupId + " failed! Please check the existence of group " + groupId + " of the connected node!");
            }
            this.groupToClient.put(groupId, client);
            logger.info("create client for group {} success", (Object)groupId);
        }
        this.groupManagerService.fetchGroupList();
        Set<String> nodeList = this.groupManagerService.getGroupNodeList(groupId);
        if (nodeList.size() == 0) {
            this.groupToClient.remove(groupId);
            throw new BcosSDKException("create client for group " + groupId + " failed for no peers set up the group!");
        }
        return this.groupToClient.get(groupId);
    }

    public int getSSLCryptoType() {
        return this.channel.getNetwork().getSslCryptoType();
    }

    public GroupManagerService getGroupManagerService() {
        return this.groupManagerService;
    }

    public ConfigOption getConfig() {
        return this.config;
    }

    public Amop getAmop() {
        return this.amop;
    }

    public EventResource getEventResource() {
        return this.eventResource;
    }

    public EventSubscribe getEventSubscribe(Integer groupId) {
        return EventSubscribe.build(this.groupManagerService, this.eventResource, groupId);
    }

    public Channel getChannel() {
        return this.channel;
    }

    public void stopAll() {
        if (this.channel != null) {
            this.channel.stop();
        }
        if (this.threadPoolService != null) {
            this.threadPoolService.stop();
        }
        if (this.groupManagerService != null) {
            this.groupManagerService.stop();
        }
        if (this.amop != null) {
            this.amop.stop();
        }
        for (Integer groupId : this.groupToClient.keySet()) {
            this.groupToClient.get(groupId).stop();
            EventSubscribe event = this.getEventSubscribe(groupId);
            if (event == null) continue;
            event.stop();
        }
    }
}

