/*
 * Decompiled with CFR 0.152.
 */
package fpml.custom.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import fpml.consolidated.shared.Rate;
import fpml.custom.RateChoice;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=ToRateChoiceDefault.class)
public abstract class ToRateChoice
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;

    public RateChoice evaluate(Rate rate) {
        RateChoice rateChoice;
        RateChoice.RateChoiceBuilder rateChoiceBuilder = this.doEvaluate(rate);
        if (rateChoiceBuilder == null) {
            rateChoice = null;
        } else {
            rateChoice = rateChoiceBuilder.build();
            this.objectValidator.validate(RateChoice.class, (RosettaModelObject)rateChoice);
        }
        return rateChoice;
    }

    protected abstract RateChoice.RateChoiceBuilder doEvaluate(Rate var1);

    public static class ToRateChoiceDefault
    extends ToRateChoice {
        @Override
        protected RateChoice.RateChoiceBuilder doEvaluate(Rate rate) {
            RateChoice.RateChoiceBuilder rateChoice = RateChoice.builder();
            return this.assignOutput(rateChoice, rate);
        }

        protected RateChoice.RateChoiceBuilder assignOutput(RateChoice.RateChoiceBuilder rateChoice, Rate rate) {
            return Optional.ofNullable(rateChoice).map(o -> o.prune()).orElse(null);
        }
    }
}

