/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.shared;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.shared.Money;
import fpml.consolidated.shared.Routing;
import fpml.consolidated.shared.meta.SplitSettlementMeta;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="SplitSettlement", builder=SplitSettlementBuilderImpl.class, version="1.1.0")
@RuneDataType(value="SplitSettlement", model="fpml", builder=SplitSettlementBuilderImpl.class, version="1.1.0")
public interface SplitSettlement
extends RosettaModelObject {
    public static final SplitSettlementMeta metaData = new SplitSettlementMeta();

    public Money getSplitSettlementAmount();

    public Routing getBeneficiaryBank();

    public Routing getBeneficiary();

    public SplitSettlement build();

    public SplitSettlementBuilder toBuilder();

    public static SplitSettlementBuilder builder() {
        return new SplitSettlementBuilderImpl();
    }

    default public RosettaMetaData<? extends SplitSettlement> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends SplitSettlement> getType() {
        return SplitSettlement.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("splitSettlementAmount"), processor, Money.class, this.getSplitSettlementAmount(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("beneficiaryBank"), processor, Routing.class, this.getBeneficiaryBank(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("beneficiary"), processor, Routing.class, this.getBeneficiary(), new AttributeMeta[0]);
    }

    public static class SplitSettlementBuilderImpl
    implements SplitSettlementBuilder {
        protected Money.MoneyBuilder splitSettlementAmount;
        protected Routing.RoutingBuilder beneficiaryBank;
        protected Routing.RoutingBuilder beneficiary;

        @Override
        @RosettaAttribute(value="splitSettlementAmount")
        @RuneAttribute(value="splitSettlementAmount")
        public Money.MoneyBuilder getSplitSettlementAmount() {
            return this.splitSettlementAmount;
        }

        @Override
        public Money.MoneyBuilder getOrCreateSplitSettlementAmount() {
            Money.MoneyBuilder result = this.splitSettlementAmount != null ? this.splitSettlementAmount : (this.splitSettlementAmount = Money.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="beneficiaryBank")
        @RuneAttribute(value="beneficiaryBank")
        public Routing.RoutingBuilder getBeneficiaryBank() {
            return this.beneficiaryBank;
        }

        @Override
        public Routing.RoutingBuilder getOrCreateBeneficiaryBank() {
            Routing.RoutingBuilder result = this.beneficiaryBank != null ? this.beneficiaryBank : (this.beneficiaryBank = Routing.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="beneficiary")
        @RuneAttribute(value="beneficiary")
        public Routing.RoutingBuilder getBeneficiary() {
            return this.beneficiary;
        }

        @Override
        public Routing.RoutingBuilder getOrCreateBeneficiary() {
            Routing.RoutingBuilder result = this.beneficiary != null ? this.beneficiary : (this.beneficiary = Routing.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="splitSettlementAmount")
        @RuneAttribute(value="splitSettlementAmount")
        public SplitSettlementBuilder setSplitSettlementAmount(Money _splitSettlementAmount) {
            this.splitSettlementAmount = _splitSettlementAmount == null ? null : _splitSettlementAmount.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="beneficiaryBank")
        @RuneAttribute(value="beneficiaryBank")
        public SplitSettlementBuilder setBeneficiaryBank(Routing _beneficiaryBank) {
            this.beneficiaryBank = _beneficiaryBank == null ? null : _beneficiaryBank.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="beneficiary")
        @RuneAttribute(value="beneficiary")
        public SplitSettlementBuilder setBeneficiary(Routing _beneficiary) {
            this.beneficiary = _beneficiary == null ? null : _beneficiary.toBuilder();
            return this;
        }

        @Override
        public SplitSettlement build() {
            return new SplitSettlementImpl(this);
        }

        @Override
        public SplitSettlementBuilder toBuilder() {
            return this;
        }

        @Override
        public SplitSettlementBuilder prune() {
            if (this.splitSettlementAmount != null && !this.splitSettlementAmount.prune().hasData()) {
                this.splitSettlementAmount = null;
            }
            if (this.beneficiaryBank != null && !this.beneficiaryBank.prune().hasData()) {
                this.beneficiaryBank = null;
            }
            if (this.beneficiary != null && !this.beneficiary.prune().hasData()) {
                this.beneficiary = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getSplitSettlementAmount() != null && this.getSplitSettlementAmount().hasData()) {
                return true;
            }
            if (this.getBeneficiaryBank() != null && this.getBeneficiaryBank().hasData()) {
                return true;
            }
            return this.getBeneficiary() != null && this.getBeneficiary().hasData();
        }

        public SplitSettlementBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            SplitSettlementBuilder o = (SplitSettlementBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSplitSettlementAmount(), (RosettaModelObjectBuilder)o.getSplitSettlementAmount(), this::setSplitSettlementAmount);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getBeneficiaryBank(), (RosettaModelObjectBuilder)o.getBeneficiaryBank(), this::setBeneficiaryBank);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getBeneficiary(), (RosettaModelObjectBuilder)o.getBeneficiary(), this::setBeneficiary);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            SplitSettlement _that = this.getType().cast(o);
            if (!Objects.equals(this.splitSettlementAmount, _that.getSplitSettlementAmount())) {
                return false;
            }
            if (!Objects.equals(this.beneficiaryBank, _that.getBeneficiaryBank())) {
                return false;
            }
            return Objects.equals(this.beneficiary, _that.getBeneficiary());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.splitSettlementAmount != null ? this.splitSettlementAmount.hashCode() : 0);
            _result = 31 * _result + (this.beneficiaryBank != null ? this.beneficiaryBank.hashCode() : 0);
            _result = 31 * _result + (this.beneficiary != null ? this.beneficiary.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "SplitSettlementBuilder {splitSettlementAmount=" + this.splitSettlementAmount + ", beneficiaryBank=" + this.beneficiaryBank + ", beneficiary=" + this.beneficiary + '}';
        }
    }

    public static interface SplitSettlementBuilder
    extends SplitSettlement,
    RosettaModelObjectBuilder {
        public Money.MoneyBuilder getOrCreateSplitSettlementAmount();

        @Override
        public Money.MoneyBuilder getSplitSettlementAmount();

        public Routing.RoutingBuilder getOrCreateBeneficiaryBank();

        @Override
        public Routing.RoutingBuilder getBeneficiaryBank();

        public Routing.RoutingBuilder getOrCreateBeneficiary();

        @Override
        public Routing.RoutingBuilder getBeneficiary();

        public SplitSettlementBuilder setSplitSettlementAmount(Money var1);

        public SplitSettlementBuilder setBeneficiaryBank(Routing var1);

        public SplitSettlementBuilder setBeneficiary(Routing var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("splitSettlementAmount"), processor, Money.MoneyBuilder.class, this.getSplitSettlementAmount(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("beneficiaryBank"), processor, Routing.RoutingBuilder.class, this.getBeneficiaryBank(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("beneficiary"), processor, Routing.RoutingBuilder.class, this.getBeneficiary(), new AttributeMeta[0]);
        }

        public SplitSettlementBuilder prune();
    }

    public static class SplitSettlementImpl
    implements SplitSettlement {
        private final Money splitSettlementAmount;
        private final Routing beneficiaryBank;
        private final Routing beneficiary;

        protected SplitSettlementImpl(SplitSettlementBuilder builder) {
            this.splitSettlementAmount = Optional.ofNullable(builder.getSplitSettlementAmount()).map(f -> f.build()).orElse(null);
            this.beneficiaryBank = Optional.ofNullable(builder.getBeneficiaryBank()).map(f -> f.build()).orElse(null);
            this.beneficiary = Optional.ofNullable(builder.getBeneficiary()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="splitSettlementAmount")
        @RuneAttribute(value="splitSettlementAmount")
        public Money getSplitSettlementAmount() {
            return this.splitSettlementAmount;
        }

        @Override
        @RosettaAttribute(value="beneficiaryBank")
        @RuneAttribute(value="beneficiaryBank")
        public Routing getBeneficiaryBank() {
            return this.beneficiaryBank;
        }

        @Override
        @RosettaAttribute(value="beneficiary")
        @RuneAttribute(value="beneficiary")
        public Routing getBeneficiary() {
            return this.beneficiary;
        }

        @Override
        public SplitSettlement build() {
            return this;
        }

        @Override
        public SplitSettlementBuilder toBuilder() {
            SplitSettlementBuilder builder = SplitSettlement.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(SplitSettlementBuilder builder) {
            Optional.ofNullable(this.getSplitSettlementAmount()).ifPresent(builder::setSplitSettlementAmount);
            Optional.ofNullable(this.getBeneficiaryBank()).ifPresent(builder::setBeneficiaryBank);
            Optional.ofNullable(this.getBeneficiary()).ifPresent(builder::setBeneficiary);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            SplitSettlement _that = this.getType().cast(o);
            if (!Objects.equals(this.splitSettlementAmount, _that.getSplitSettlementAmount())) {
                return false;
            }
            if (!Objects.equals(this.beneficiaryBank, _that.getBeneficiaryBank())) {
                return false;
            }
            return Objects.equals(this.beneficiary, _that.getBeneficiary());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.splitSettlementAmount != null ? this.splitSettlementAmount.hashCode() : 0);
            _result = 31 * _result + (this.beneficiaryBank != null ? this.beneficiaryBank.hashCode() : 0);
            _result = 31 * _result + (this.beneficiary != null ? this.beneficiary.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "SplitSettlement {splitSettlementAmount=" + this.splitSettlementAmount + ", beneficiaryBank=" + this.beneficiaryBank + ", beneficiary=" + this.beneficiary + '}';
        }
    }
}

