/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.shared;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.shared.AccountReference;
import fpml.consolidated.shared.PartyReference;
import fpml.consolidated.shared.meta.OnBehalfOfMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="OnBehalfOf", builder=OnBehalfOfBuilderImpl.class, version="1.1.0")
@RuneDataType(value="OnBehalfOf", model="fpml", builder=OnBehalfOfBuilderImpl.class, version="1.1.0")
public interface OnBehalfOf
extends RosettaModelObject {
    public static final OnBehalfOfMeta metaData = new OnBehalfOfMeta();

    public PartyReference getPartyReference();

    public List<? extends AccountReference> getAccountReference();

    public OnBehalfOf build();

    public OnBehalfOfBuilder toBuilder();

    public static OnBehalfOfBuilder builder() {
        return new OnBehalfOfBuilderImpl();
    }

    default public RosettaMetaData<? extends OnBehalfOf> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends OnBehalfOf> getType() {
        return OnBehalfOf.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("partyReference"), processor, PartyReference.class, this.getPartyReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("accountReference"), processor, AccountReference.class, this.getAccountReference(), new AttributeMeta[0]);
    }

    public static class OnBehalfOfBuilderImpl
    implements OnBehalfOfBuilder {
        protected PartyReference.PartyReferenceBuilder partyReference;
        protected List<AccountReference.AccountReferenceBuilder> accountReference = new ArrayList<AccountReference.AccountReferenceBuilder>();

        @Override
        @RosettaAttribute(value="partyReference")
        @RuneAttribute(value="partyReference")
        public PartyReference.PartyReferenceBuilder getPartyReference() {
            return this.partyReference;
        }

        @Override
        public PartyReference.PartyReferenceBuilder getOrCreatePartyReference() {
            PartyReference.PartyReferenceBuilder result = this.partyReference != null ? this.partyReference : (this.partyReference = PartyReference.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="accountReference")
        @RuneAttribute(value="accountReference")
        public List<? extends AccountReference.AccountReferenceBuilder> getAccountReference() {
            return this.accountReference;
        }

        @Override
        public AccountReference.AccountReferenceBuilder getOrCreateAccountReference(int index) {
            if (this.accountReference == null) {
                this.accountReference = new ArrayList<AccountReference.AccountReferenceBuilder>();
            }
            return (AccountReference.AccountReferenceBuilder)this.getIndex(this.accountReference, index, () -> {
                AccountReference.AccountReferenceBuilder newAccountReference = AccountReference.builder();
                return newAccountReference;
            });
        }

        @Override
        @RosettaAttribute(value="partyReference")
        @RuneAttribute(value="partyReference")
        public OnBehalfOfBuilder setPartyReference(PartyReference _partyReference) {
            this.partyReference = _partyReference == null ? null : _partyReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="accountReference")
        @RuneAttribute(value="accountReference")
        public OnBehalfOfBuilder addAccountReference(AccountReference _accountReference) {
            if (_accountReference != null) {
                this.accountReference.add(_accountReference.toBuilder());
            }
            return this;
        }

        @Override
        public OnBehalfOfBuilder addAccountReference(AccountReference _accountReference, int idx) {
            this.getIndex(this.accountReference, idx, () -> _accountReference.toBuilder());
            return this;
        }

        @Override
        public OnBehalfOfBuilder addAccountReference(List<? extends AccountReference> accountReferences) {
            if (accountReferences != null) {
                for (AccountReference accountReference : accountReferences) {
                    this.accountReference.add(accountReference.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="accountReference")
        public OnBehalfOfBuilder setAccountReference(List<? extends AccountReference> accountReferences) {
            this.accountReference = accountReferences == null ? new ArrayList<AccountReference.AccountReferenceBuilder>() : (List)accountReferences.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public OnBehalfOf build() {
            return new OnBehalfOfImpl(this);
        }

        @Override
        public OnBehalfOfBuilder toBuilder() {
            return this;
        }

        @Override
        public OnBehalfOfBuilder prune() {
            if (this.partyReference != null && !this.partyReference.prune().hasData()) {
                this.partyReference = null;
            }
            this.accountReference = this.accountReference.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getPartyReference() != null && this.getPartyReference().hasData()) {
                return true;
            }
            return this.getAccountReference() != null && this.getAccountReference().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public OnBehalfOfBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            OnBehalfOfBuilder o = (OnBehalfOfBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPartyReference(), (RosettaModelObjectBuilder)o.getPartyReference(), this::setPartyReference);
            merger.mergeRosetta(this.getAccountReference(), o.getAccountReference(), this::getOrCreateAccountReference);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            OnBehalfOf _that = this.getType().cast(o);
            if (!Objects.equals(this.partyReference, _that.getPartyReference())) {
                return false;
            }
            return ListEquals.listEquals(this.accountReference, _that.getAccountReference());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.partyReference != null ? this.partyReference.hashCode() : 0);
            _result = 31 * _result + (this.accountReference != null ? this.accountReference.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "OnBehalfOfBuilder {partyReference=" + this.partyReference + ", accountReference=" + this.accountReference + '}';
        }
    }

    public static interface OnBehalfOfBuilder
    extends OnBehalfOf,
    RosettaModelObjectBuilder {
        public PartyReference.PartyReferenceBuilder getOrCreatePartyReference();

        @Override
        public PartyReference.PartyReferenceBuilder getPartyReference();

        public AccountReference.AccountReferenceBuilder getOrCreateAccountReference(int var1);

        public List<? extends AccountReference.AccountReferenceBuilder> getAccountReference();

        public OnBehalfOfBuilder setPartyReference(PartyReference var1);

        public OnBehalfOfBuilder addAccountReference(AccountReference var1);

        public OnBehalfOfBuilder addAccountReference(AccountReference var1, int var2);

        public OnBehalfOfBuilder addAccountReference(List<? extends AccountReference> var1);

        public OnBehalfOfBuilder setAccountReference(List<? extends AccountReference> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("partyReference"), processor, PartyReference.PartyReferenceBuilder.class, this.getPartyReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("accountReference"), processor, AccountReference.AccountReferenceBuilder.class, this.getAccountReference(), new AttributeMeta[0]);
        }

        public OnBehalfOfBuilder prune();
    }

    public static class OnBehalfOfImpl
    implements OnBehalfOf {
        private final PartyReference partyReference;
        private final List<? extends AccountReference> accountReference;

        protected OnBehalfOfImpl(OnBehalfOfBuilder builder) {
            this.partyReference = Optional.ofNullable(builder.getPartyReference()).map(f -> f.build()).orElse(null);
            this.accountReference = Optional.ofNullable(builder.getAccountReference()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="partyReference")
        @RuneAttribute(value="partyReference")
        public PartyReference getPartyReference() {
            return this.partyReference;
        }

        @Override
        @RosettaAttribute(value="accountReference")
        @RuneAttribute(value="accountReference")
        public List<? extends AccountReference> getAccountReference() {
            return this.accountReference;
        }

        @Override
        public OnBehalfOf build() {
            return this;
        }

        @Override
        public OnBehalfOfBuilder toBuilder() {
            OnBehalfOfBuilder builder = OnBehalfOf.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(OnBehalfOfBuilder builder) {
            Optional.ofNullable(this.getPartyReference()).ifPresent(builder::setPartyReference);
            Optional.ofNullable(this.getAccountReference()).ifPresent(builder::setAccountReference);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            OnBehalfOf _that = this.getType().cast(o);
            if (!Objects.equals(this.partyReference, _that.getPartyReference())) {
                return false;
            }
            return ListEquals.listEquals(this.accountReference, _that.getAccountReference());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.partyReference != null ? this.partyReference.hashCode() : 0);
            _result = 31 * _result + (this.accountReference != null ? this.accountReference.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "OnBehalfOf {partyReference=" + this.partyReference + ", accountReference=" + this.accountReference + '}';
        }
    }
}

