/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.shared;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.fpmlenum.CollateralValueAllocationEnum;
import fpml.consolidated.shared.Money;
import fpml.consolidated.shared.meta.CollateralValueAllocationMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="CollateralValueAllocation", builder=CollateralValueAllocationBuilderImpl.class, version="1.1.0")
@RuneDataType(value="CollateralValueAllocation", model="fpml", builder=CollateralValueAllocationBuilderImpl.class, version="1.1.0")
public interface CollateralValueAllocation
extends RosettaModelObject {
    public static final CollateralValueAllocationMeta metaData = new CollateralValueAllocationMeta();

    public CollateralValueAllocationEnum _getType();

    public List<? extends Money> getValue();

    public CollateralValueAllocation build();

    public CollateralValueAllocationBuilder toBuilder();

    public static CollateralValueAllocationBuilder builder() {
        return new CollateralValueAllocationBuilderImpl();
    }

    default public RosettaMetaData<? extends CollateralValueAllocation> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends CollateralValueAllocation> getType() {
        return CollateralValueAllocation.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("type"), CollateralValueAllocationEnum.class, (Object)this._getType(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("value"), processor, Money.class, this.getValue(), new AttributeMeta[0]);
    }

    public static class CollateralValueAllocationBuilderImpl
    implements CollateralValueAllocationBuilder {
        protected CollateralValueAllocationEnum type;
        protected List<Money.MoneyBuilder> value = new ArrayList<Money.MoneyBuilder>();

        @Override
        @RosettaAttribute(value="type", isRequired=true)
        @RuneAttribute(value="type", isRequired=true)
        public CollateralValueAllocationEnum _getType() {
            return this.type;
        }

        @Override
        @RosettaAttribute(value="value", isRequired=true)
        @RuneAttribute(value="value", isRequired=true)
        public List<? extends Money.MoneyBuilder> getValue() {
            return this.value;
        }

        @Override
        public Money.MoneyBuilder getOrCreateValue(int index) {
            if (this.value == null) {
                this.value = new ArrayList<Money.MoneyBuilder>();
            }
            return (Money.MoneyBuilder)this.getIndex(this.value, index, () -> {
                Money.MoneyBuilder newValue = Money.builder();
                return newValue;
            });
        }

        @Override
        @RosettaAttribute(value="type", isRequired=true)
        @RuneAttribute(value="type", isRequired=true)
        public CollateralValueAllocationBuilder setType(CollateralValueAllocationEnum _type) {
            this.type = _type == null ? null : _type;
            return this;
        }

        @Override
        @RosettaAttribute(value="value", isRequired=true)
        @RuneAttribute(value="value", isRequired=true)
        public CollateralValueAllocationBuilder addValue(Money _value) {
            if (_value != null) {
                this.value.add(_value.toBuilder());
            }
            return this;
        }

        @Override
        public CollateralValueAllocationBuilder addValue(Money _value, int idx) {
            this.getIndex(this.value, idx, () -> _value.toBuilder());
            return this;
        }

        @Override
        public CollateralValueAllocationBuilder addValue(List<? extends Money> values) {
            if (values != null) {
                for (Money money : values) {
                    this.value.add(money.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="value")
        public CollateralValueAllocationBuilder setValue(List<? extends Money> values) {
            this.value = values == null ? new ArrayList<Money.MoneyBuilder>() : (List)values.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public CollateralValueAllocation build() {
            return new CollateralValueAllocationImpl(this);
        }

        @Override
        public CollateralValueAllocationBuilder toBuilder() {
            return this;
        }

        @Override
        public CollateralValueAllocationBuilder prune() {
            this.value = this.value.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this._getType() != null) {
                return true;
            }
            return this.getValue() != null && this.getValue().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public CollateralValueAllocationBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            CollateralValueAllocationBuilder o = (CollateralValueAllocationBuilder)other;
            merger.mergeRosetta(this.getValue(), o.getValue(), this::getOrCreateValue);
            merger.mergeBasic((Object)this._getType(), (Object)o._getType(), this::setType, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CollateralValueAllocation _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.type, (Object)_that._getType())) {
                return false;
            }
            return ListEquals.listEquals(this.value, _that.getValue());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.type != null ? ((Object)((Object)this.type)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.value != null ? this.value.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CollateralValueAllocationBuilder {type=" + (Object)((Object)this.type) + ", value=" + this.value + '}';
        }
    }

    public static interface CollateralValueAllocationBuilder
    extends CollateralValueAllocation,
    RosettaModelObjectBuilder {
        public Money.MoneyBuilder getOrCreateValue(int var1);

        public List<? extends Money.MoneyBuilder> getValue();

        public CollateralValueAllocationBuilder setType(CollateralValueAllocationEnum var1);

        public CollateralValueAllocationBuilder addValue(Money var1);

        public CollateralValueAllocationBuilder addValue(Money var1, int var2);

        public CollateralValueAllocationBuilder addValue(List<? extends Money> var1);

        public CollateralValueAllocationBuilder setValue(List<? extends Money> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("type"), CollateralValueAllocationEnum.class, (Object)this._getType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("value"), processor, Money.MoneyBuilder.class, this.getValue(), new AttributeMeta[0]);
        }

        public CollateralValueAllocationBuilder prune();
    }

    public static class CollateralValueAllocationImpl
    implements CollateralValueAllocation {
        private final CollateralValueAllocationEnum type;
        private final List<? extends Money> value;

        protected CollateralValueAllocationImpl(CollateralValueAllocationBuilder builder) {
            this.type = builder._getType();
            this.value = Optional.ofNullable(builder.getValue()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="type", isRequired=true)
        @RuneAttribute(value="type", isRequired=true)
        public CollateralValueAllocationEnum _getType() {
            return this.type;
        }

        @Override
        @RosettaAttribute(value="value", isRequired=true)
        @RuneAttribute(value="value", isRequired=true)
        public List<? extends Money> getValue() {
            return this.value;
        }

        @Override
        public CollateralValueAllocation build() {
            return this;
        }

        @Override
        public CollateralValueAllocationBuilder toBuilder() {
            CollateralValueAllocationBuilder builder = CollateralValueAllocation.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CollateralValueAllocationBuilder builder) {
            Optional.ofNullable(this._getType()).ifPresent(builder::setType);
            Optional.ofNullable(this.getValue()).ifPresent(builder::setValue);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CollateralValueAllocation _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.type, (Object)_that._getType())) {
                return false;
            }
            return ListEquals.listEquals(this.value, _that.getValue());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.type != null ? ((Object)((Object)this.type)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.value != null ? this.value.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CollateralValueAllocation {type=" + (Object)((Object)this.type) + ", value=" + this.value + '}';
        }
    }
}

