/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.sec.lending;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.sec.lending.meta.DividendsAndPaymentModelMeta;
import fpml.consolidated.shared.Frequency;
import fpml.consolidated.shared.PositiveMoney;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="DividendsAndPaymentModel", builder=DividendsAndPaymentModelBuilderImpl.class, version="1.1.0")
@RuneDataType(value="DividendsAndPaymentModel", model="fpml", builder=DividendsAndPaymentModelBuilderImpl.class, version="1.1.0")
public interface DividendsAndPaymentModel
extends RosettaModelObject {
    public static final DividendsAndPaymentModelMeta metaData = new DividendsAndPaymentModelMeta();

    public BigDecimal getDividendRate();

    public PositiveMoney getMinimumBillingAmount();

    public Frequency getRebatePaymentFrequency();

    public DividendsAndPaymentModel build();

    public DividendsAndPaymentModelBuilder toBuilder();

    public static DividendsAndPaymentModelBuilder builder() {
        return new DividendsAndPaymentModelBuilderImpl();
    }

    default public RosettaMetaData<? extends DividendsAndPaymentModel> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends DividendsAndPaymentModel> getType() {
        return DividendsAndPaymentModel.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("dividendRate"), BigDecimal.class, (Object)this.getDividendRate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("minimumBillingAmount"), processor, PositiveMoney.class, this.getMinimumBillingAmount(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("rebatePaymentFrequency"), processor, Frequency.class, this.getRebatePaymentFrequency(), new AttributeMeta[0]);
    }

    public static class DividendsAndPaymentModelBuilderImpl
    implements DividendsAndPaymentModelBuilder {
        protected BigDecimal dividendRate;
        protected PositiveMoney.PositiveMoneyBuilder minimumBillingAmount;
        protected Frequency.FrequencyBuilder rebatePaymentFrequency;

        @Override
        @RosettaAttribute(value="dividendRate")
        @RuneAttribute(value="dividendRate")
        public BigDecimal getDividendRate() {
            return this.dividendRate;
        }

        @Override
        @RosettaAttribute(value="minimumBillingAmount")
        @RuneAttribute(value="minimumBillingAmount")
        public PositiveMoney.PositiveMoneyBuilder getMinimumBillingAmount() {
            return this.minimumBillingAmount;
        }

        @Override
        public PositiveMoney.PositiveMoneyBuilder getOrCreateMinimumBillingAmount() {
            PositiveMoney.PositiveMoneyBuilder result = this.minimumBillingAmount != null ? this.minimumBillingAmount : (this.minimumBillingAmount = PositiveMoney.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="rebatePaymentFrequency")
        @RuneAttribute(value="rebatePaymentFrequency")
        public Frequency.FrequencyBuilder getRebatePaymentFrequency() {
            return this.rebatePaymentFrequency;
        }

        @Override
        public Frequency.FrequencyBuilder getOrCreateRebatePaymentFrequency() {
            Frequency.FrequencyBuilder result = this.rebatePaymentFrequency != null ? this.rebatePaymentFrequency : (this.rebatePaymentFrequency = Frequency.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="dividendRate")
        @RuneAttribute(value="dividendRate")
        public DividendsAndPaymentModelBuilder setDividendRate(BigDecimal _dividendRate) {
            this.dividendRate = _dividendRate == null ? null : _dividendRate;
            return this;
        }

        @Override
        @RosettaAttribute(value="minimumBillingAmount")
        @RuneAttribute(value="minimumBillingAmount")
        public DividendsAndPaymentModelBuilder setMinimumBillingAmount(PositiveMoney _minimumBillingAmount) {
            this.minimumBillingAmount = _minimumBillingAmount == null ? null : _minimumBillingAmount.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="rebatePaymentFrequency")
        @RuneAttribute(value="rebatePaymentFrequency")
        public DividendsAndPaymentModelBuilder setRebatePaymentFrequency(Frequency _rebatePaymentFrequency) {
            this.rebatePaymentFrequency = _rebatePaymentFrequency == null ? null : _rebatePaymentFrequency.toBuilder();
            return this;
        }

        @Override
        public DividendsAndPaymentModel build() {
            return new DividendsAndPaymentModelImpl(this);
        }

        @Override
        public DividendsAndPaymentModelBuilder toBuilder() {
            return this;
        }

        @Override
        public DividendsAndPaymentModelBuilder prune() {
            if (this.minimumBillingAmount != null && !this.minimumBillingAmount.prune().hasData()) {
                this.minimumBillingAmount = null;
            }
            if (this.rebatePaymentFrequency != null && !this.rebatePaymentFrequency.prune().hasData()) {
                this.rebatePaymentFrequency = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getDividendRate() != null) {
                return true;
            }
            if (this.getMinimumBillingAmount() != null && this.getMinimumBillingAmount().hasData()) {
                return true;
            }
            return this.getRebatePaymentFrequency() != null && this.getRebatePaymentFrequency().hasData();
        }

        public DividendsAndPaymentModelBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            DividendsAndPaymentModelBuilder o = (DividendsAndPaymentModelBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMinimumBillingAmount(), (RosettaModelObjectBuilder)o.getMinimumBillingAmount(), this::setMinimumBillingAmount);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getRebatePaymentFrequency(), (RosettaModelObjectBuilder)o.getRebatePaymentFrequency(), this::setRebatePaymentFrequency);
            merger.mergeBasic((Object)this.getDividendRate(), (Object)o.getDividendRate(), this::setDividendRate, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            DividendsAndPaymentModel _that = this.getType().cast(o);
            if (!Objects.equals(this.dividendRate, _that.getDividendRate())) {
                return false;
            }
            if (!Objects.equals(this.minimumBillingAmount, _that.getMinimumBillingAmount())) {
                return false;
            }
            return Objects.equals(this.rebatePaymentFrequency, _that.getRebatePaymentFrequency());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.dividendRate != null ? this.dividendRate.hashCode() : 0);
            _result = 31 * _result + (this.minimumBillingAmount != null ? this.minimumBillingAmount.hashCode() : 0);
            _result = 31 * _result + (this.rebatePaymentFrequency != null ? this.rebatePaymentFrequency.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "DividendsAndPaymentModelBuilder {dividendRate=" + this.dividendRate + ", minimumBillingAmount=" + this.minimumBillingAmount + ", rebatePaymentFrequency=" + this.rebatePaymentFrequency + '}';
        }
    }

    public static interface DividendsAndPaymentModelBuilder
    extends DividendsAndPaymentModel,
    RosettaModelObjectBuilder {
        public PositiveMoney.PositiveMoneyBuilder getOrCreateMinimumBillingAmount();

        @Override
        public PositiveMoney.PositiveMoneyBuilder getMinimumBillingAmount();

        public Frequency.FrequencyBuilder getOrCreateRebatePaymentFrequency();

        @Override
        public Frequency.FrequencyBuilder getRebatePaymentFrequency();

        public DividendsAndPaymentModelBuilder setDividendRate(BigDecimal var1);

        public DividendsAndPaymentModelBuilder setMinimumBillingAmount(PositiveMoney var1);

        public DividendsAndPaymentModelBuilder setRebatePaymentFrequency(Frequency var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("dividendRate"), BigDecimal.class, (Object)this.getDividendRate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("minimumBillingAmount"), processor, PositiveMoney.PositiveMoneyBuilder.class, this.getMinimumBillingAmount(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("rebatePaymentFrequency"), processor, Frequency.FrequencyBuilder.class, this.getRebatePaymentFrequency(), new AttributeMeta[0]);
        }

        public DividendsAndPaymentModelBuilder prune();
    }

    public static class DividendsAndPaymentModelImpl
    implements DividendsAndPaymentModel {
        private final BigDecimal dividendRate;
        private final PositiveMoney minimumBillingAmount;
        private final Frequency rebatePaymentFrequency;

        protected DividendsAndPaymentModelImpl(DividendsAndPaymentModelBuilder builder) {
            this.dividendRate = builder.getDividendRate();
            this.minimumBillingAmount = Optional.ofNullable(builder.getMinimumBillingAmount()).map(f -> f.build()).orElse(null);
            this.rebatePaymentFrequency = Optional.ofNullable(builder.getRebatePaymentFrequency()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="dividendRate")
        @RuneAttribute(value="dividendRate")
        public BigDecimal getDividendRate() {
            return this.dividendRate;
        }

        @Override
        @RosettaAttribute(value="minimumBillingAmount")
        @RuneAttribute(value="minimumBillingAmount")
        public PositiveMoney getMinimumBillingAmount() {
            return this.minimumBillingAmount;
        }

        @Override
        @RosettaAttribute(value="rebatePaymentFrequency")
        @RuneAttribute(value="rebatePaymentFrequency")
        public Frequency getRebatePaymentFrequency() {
            return this.rebatePaymentFrequency;
        }

        @Override
        public DividendsAndPaymentModel build() {
            return this;
        }

        @Override
        public DividendsAndPaymentModelBuilder toBuilder() {
            DividendsAndPaymentModelBuilder builder = DividendsAndPaymentModel.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(DividendsAndPaymentModelBuilder builder) {
            Optional.ofNullable(this.getDividendRate()).ifPresent(builder::setDividendRate);
            Optional.ofNullable(this.getMinimumBillingAmount()).ifPresent(builder::setMinimumBillingAmount);
            Optional.ofNullable(this.getRebatePaymentFrequency()).ifPresent(builder::setRebatePaymentFrequency);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            DividendsAndPaymentModel _that = this.getType().cast(o);
            if (!Objects.equals(this.dividendRate, _that.getDividendRate())) {
                return false;
            }
            if (!Objects.equals(this.minimumBillingAmount, _that.getMinimumBillingAmount())) {
                return false;
            }
            return Objects.equals(this.rebatePaymentFrequency, _that.getRebatePaymentFrequency());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.dividendRate != null ? this.dividendRate.hashCode() : 0);
            _result = 31 * _result + (this.minimumBillingAmount != null ? this.minimumBillingAmount.hashCode() : 0);
            _result = 31 * _result + (this.rebatePaymentFrequency != null ? this.rebatePaymentFrequency.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "DividendsAndPaymentModel {dividendRate=" + this.dividendRate + ", minimumBillingAmount=" + this.minimumBillingAmount + ", rebatePaymentFrequency=" + this.rebatePaymentFrequency + '}';
        }
    }
}

