/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.msg;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.doc.ValidationModel;
import fpml.consolidated.msg.CorrelationAndOptionalSequenceModel;
import fpml.consolidated.msg.EventStatusItem;
import fpml.consolidated.msg.ResponseMessage;
import fpml.consolidated.msg.ResponseMessageHeader;
import fpml.consolidated.msg.meta.EventStatusResponseMeta;
import fpml.consolidated.shared.OnBehalfOfModel;
import fpml.consolidated.shared.PartiesAndAccountsModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="EventStatusResponse", builder=EventStatusResponseBuilderImpl.class, version="1.1.0")
@RuneDataType(value="EventStatusResponse", model="fpml", builder=EventStatusResponseBuilderImpl.class, version="1.1.0")
public interface EventStatusResponse
extends ResponseMessage {
    public static final EventStatusResponseMeta metaData = new EventStatusResponseMeta();

    public List<? extends EventStatusItem> getStatusItem();

    public PartiesAndAccountsModel getPartiesAndAccountsModel();

    @Override
    public EventStatusResponse build();

    @Override
    public EventStatusResponseBuilder toBuilder();

    public static EventStatusResponseBuilder builder() {
        return new EventStatusResponseBuilderImpl();
    }

    default public RosettaMetaData<? extends EventStatusResponse> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends EventStatusResponse> getType() {
        return EventStatusResponse.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("fpmlVersion"), String.class, (Object)this.getFpmlVersion(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("expectedBuild"), Integer.class, (Object)this.getExpectedBuild(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("actualBuild"), Integer.class, (Object)this.getActualBuild(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("header"), processor, ResponseMessageHeader.class, this.getHeader(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("validationModel"), processor, ValidationModel.class, this.getValidationModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("correlationAndOptionalSequenceModel"), processor, CorrelationAndOptionalSequenceModel.class, this.getCorrelationAndOptionalSequenceModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("onBehalfOfModel"), processor, OnBehalfOfModel.class, this.getOnBehalfOfModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("statusItem"), processor, EventStatusItem.class, this.getStatusItem(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("partiesAndAccountsModel"), processor, PartiesAndAccountsModel.class, this.getPartiesAndAccountsModel(), new AttributeMeta[0]);
    }

    public static class EventStatusResponseBuilderImpl
    extends ResponseMessage.ResponseMessageBuilderImpl
    implements EventStatusResponseBuilder {
        protected List<EventStatusItem.EventStatusItemBuilder> statusItem = new ArrayList<EventStatusItem.EventStatusItemBuilder>();
        protected PartiesAndAccountsModel.PartiesAndAccountsModelBuilder partiesAndAccountsModel;

        @Override
        @RosettaAttribute(value="statusItem")
        @RuneAttribute(value="statusItem")
        public List<? extends EventStatusItem.EventStatusItemBuilder> getStatusItem() {
            return this.statusItem;
        }

        @Override
        public EventStatusItem.EventStatusItemBuilder getOrCreateStatusItem(int index) {
            if (this.statusItem == null) {
                this.statusItem = new ArrayList<EventStatusItem.EventStatusItemBuilder>();
            }
            return (EventStatusItem.EventStatusItemBuilder)this.getIndex(this.statusItem, index, () -> {
                EventStatusItem.EventStatusItemBuilder newStatusItem = EventStatusItem.builder();
                return newStatusItem;
            });
        }

        @Override
        @RosettaAttribute(value="partiesAndAccountsModel")
        @RuneAttribute(value="partiesAndAccountsModel")
        public PartiesAndAccountsModel.PartiesAndAccountsModelBuilder getPartiesAndAccountsModel() {
            return this.partiesAndAccountsModel;
        }

        @Override
        public PartiesAndAccountsModel.PartiesAndAccountsModelBuilder getOrCreatePartiesAndAccountsModel() {
            PartiesAndAccountsModel.PartiesAndAccountsModelBuilder result = this.partiesAndAccountsModel != null ? this.partiesAndAccountsModel : (this.partiesAndAccountsModel = PartiesAndAccountsModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="fpmlVersion", isRequired=true)
        @RuneAttribute(value="fpmlVersion", isRequired=true)
        public EventStatusResponseBuilder setFpmlVersion(String _fpmlVersion) {
            this.fpmlVersion = _fpmlVersion == null ? null : _fpmlVersion;
            return this;
        }

        @Override
        @RosettaAttribute(value="expectedBuild")
        @RuneAttribute(value="expectedBuild")
        public EventStatusResponseBuilder setExpectedBuild(Integer _expectedBuild) {
            this.expectedBuild = _expectedBuild == null ? null : _expectedBuild;
            return this;
        }

        @Override
        @RosettaAttribute(value="actualBuild")
        @RuneAttribute(value="actualBuild")
        public EventStatusResponseBuilder setActualBuild(Integer _actualBuild) {
            this.actualBuild = _actualBuild == null ? null : _actualBuild;
            return this;
        }

        @Override
        @RosettaAttribute(value="header")
        @RuneAttribute(value="header")
        public EventStatusResponseBuilder setHeader(ResponseMessageHeader _header) {
            this.header = _header == null ? null : _header.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="validationModel", isRequired=true)
        @RuneAttribute(value="validationModel", isRequired=true)
        public EventStatusResponseBuilder setValidationModel(ValidationModel _validationModel) {
            this.validationModel = _validationModel == null ? null : _validationModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="correlationAndOptionalSequenceModel", isRequired=true)
        @RuneAttribute(value="correlationAndOptionalSequenceModel", isRequired=true)
        public EventStatusResponseBuilder setCorrelationAndOptionalSequenceModel(CorrelationAndOptionalSequenceModel _correlationAndOptionalSequenceModel) {
            this.correlationAndOptionalSequenceModel = _correlationAndOptionalSequenceModel == null ? null : _correlationAndOptionalSequenceModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="onBehalfOfModel")
        @RuneAttribute(value="onBehalfOfModel")
        public EventStatusResponseBuilder setOnBehalfOfModel(OnBehalfOfModel _onBehalfOfModel) {
            this.onBehalfOfModel = _onBehalfOfModel == null ? null : _onBehalfOfModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="statusItem")
        @RuneAttribute(value="statusItem")
        public EventStatusResponseBuilder addStatusItem(EventStatusItem _statusItem) {
            if (_statusItem != null) {
                this.statusItem.add(_statusItem.toBuilder());
            }
            return this;
        }

        @Override
        public EventStatusResponseBuilder addStatusItem(EventStatusItem _statusItem, int idx) {
            this.getIndex(this.statusItem, idx, () -> _statusItem.toBuilder());
            return this;
        }

        @Override
        public EventStatusResponseBuilder addStatusItem(List<? extends EventStatusItem> statusItems) {
            if (statusItems != null) {
                for (EventStatusItem eventStatusItem : statusItems) {
                    this.statusItem.add(eventStatusItem.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="statusItem")
        public EventStatusResponseBuilder setStatusItem(List<? extends EventStatusItem> statusItems) {
            this.statusItem = statusItems == null ? new ArrayList<EventStatusItem.EventStatusItemBuilder>() : (List)statusItems.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="partiesAndAccountsModel")
        @RuneAttribute(value="partiesAndAccountsModel")
        public EventStatusResponseBuilder setPartiesAndAccountsModel(PartiesAndAccountsModel _partiesAndAccountsModel) {
            this.partiesAndAccountsModel = _partiesAndAccountsModel == null ? null : _partiesAndAccountsModel.toBuilder();
            return this;
        }

        @Override
        public EventStatusResponse build() {
            return new EventStatusResponseImpl(this);
        }

        @Override
        public EventStatusResponseBuilder toBuilder() {
            return this;
        }

        @Override
        public EventStatusResponseBuilder prune() {
            super.prune();
            this.statusItem = this.statusItem.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.partiesAndAccountsModel != null && !this.partiesAndAccountsModel.prune().hasData()) {
                this.partiesAndAccountsModel = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getStatusItem() != null && this.getStatusItem().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getPartiesAndAccountsModel() != null && this.getPartiesAndAccountsModel().hasData();
        }

        @Override
        public EventStatusResponseBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            EventStatusResponseBuilder o = (EventStatusResponseBuilder)other;
            merger.mergeRosetta(this.getStatusItem(), o.getStatusItem(), this::getOrCreateStatusItem);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPartiesAndAccountsModel(), (RosettaModelObjectBuilder)o.getPartiesAndAccountsModel(), this::setPartiesAndAccountsModel);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            EventStatusResponse _that = (EventStatusResponse)this.getType().cast(o);
            if (!ListEquals.listEquals(this.statusItem, _that.getStatusItem())) {
                return false;
            }
            return Objects.equals(this.partiesAndAccountsModel, _that.getPartiesAndAccountsModel());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.statusItem != null ? this.statusItem.hashCode() : 0);
            _result = 31 * _result + (this.partiesAndAccountsModel != null ? this.partiesAndAccountsModel.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "EventStatusResponseBuilder {statusItem=" + this.statusItem + ", partiesAndAccountsModel=" + this.partiesAndAccountsModel + '}' + " " + super.toString();
        }
    }

    public static interface EventStatusResponseBuilder
    extends EventStatusResponse,
    ResponseMessage.ResponseMessageBuilder {
        public EventStatusItem.EventStatusItemBuilder getOrCreateStatusItem(int var1);

        public List<? extends EventStatusItem.EventStatusItemBuilder> getStatusItem();

        public PartiesAndAccountsModel.PartiesAndAccountsModelBuilder getOrCreatePartiesAndAccountsModel();

        @Override
        public PartiesAndAccountsModel.PartiesAndAccountsModelBuilder getPartiesAndAccountsModel();

        @Override
        public EventStatusResponseBuilder setFpmlVersion(String var1);

        @Override
        public EventStatusResponseBuilder setExpectedBuild(Integer var1);

        @Override
        public EventStatusResponseBuilder setActualBuild(Integer var1);

        @Override
        public EventStatusResponseBuilder setHeader(ResponseMessageHeader var1);

        @Override
        public EventStatusResponseBuilder setValidationModel(ValidationModel var1);

        @Override
        public EventStatusResponseBuilder setCorrelationAndOptionalSequenceModel(CorrelationAndOptionalSequenceModel var1);

        @Override
        public EventStatusResponseBuilder setOnBehalfOfModel(OnBehalfOfModel var1);

        public EventStatusResponseBuilder addStatusItem(EventStatusItem var1);

        public EventStatusResponseBuilder addStatusItem(EventStatusItem var1, int var2);

        public EventStatusResponseBuilder addStatusItem(List<? extends EventStatusItem> var1);

        public EventStatusResponseBuilder setStatusItem(List<? extends EventStatusItem> var1);

        public EventStatusResponseBuilder setPartiesAndAccountsModel(PartiesAndAccountsModel var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("fpmlVersion"), String.class, (Object)this.getFpmlVersion(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("expectedBuild"), Integer.class, (Object)this.getExpectedBuild(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("actualBuild"), Integer.class, (Object)this.getActualBuild(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("header"), processor, ResponseMessageHeader.ResponseMessageHeaderBuilder.class, (RosettaModelObjectBuilder)this.getHeader(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("validationModel"), processor, ValidationModel.ValidationModelBuilder.class, (RosettaModelObjectBuilder)this.getValidationModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("correlationAndOptionalSequenceModel"), processor, CorrelationAndOptionalSequenceModel.CorrelationAndOptionalSequenceModelBuilder.class, (RosettaModelObjectBuilder)this.getCorrelationAndOptionalSequenceModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("onBehalfOfModel"), processor, OnBehalfOfModel.OnBehalfOfModelBuilder.class, (RosettaModelObjectBuilder)this.getOnBehalfOfModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("statusItem"), processor, EventStatusItem.EventStatusItemBuilder.class, this.getStatusItem(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("partiesAndAccountsModel"), processor, PartiesAndAccountsModel.PartiesAndAccountsModelBuilder.class, this.getPartiesAndAccountsModel(), new AttributeMeta[0]);
        }

        @Override
        public EventStatusResponseBuilder prune();
    }

    public static class EventStatusResponseImpl
    extends ResponseMessage.ResponseMessageImpl
    implements EventStatusResponse {
        private final List<? extends EventStatusItem> statusItem;
        private final PartiesAndAccountsModel partiesAndAccountsModel;

        protected EventStatusResponseImpl(EventStatusResponseBuilder builder) {
            super(builder);
            this.statusItem = Optional.ofNullable(builder.getStatusItem()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.partiesAndAccountsModel = Optional.ofNullable(builder.getPartiesAndAccountsModel()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="statusItem")
        @RuneAttribute(value="statusItem")
        public List<? extends EventStatusItem> getStatusItem() {
            return this.statusItem;
        }

        @Override
        @RosettaAttribute(value="partiesAndAccountsModel")
        @RuneAttribute(value="partiesAndAccountsModel")
        public PartiesAndAccountsModel getPartiesAndAccountsModel() {
            return this.partiesAndAccountsModel;
        }

        @Override
        public EventStatusResponse build() {
            return this;
        }

        @Override
        public EventStatusResponseBuilder toBuilder() {
            EventStatusResponseBuilder builder = EventStatusResponse.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(EventStatusResponseBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getStatusItem()).ifPresent(builder::setStatusItem);
            Optional.ofNullable(this.getPartiesAndAccountsModel()).ifPresent(builder::setPartiesAndAccountsModel);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            EventStatusResponse _that = (EventStatusResponse)this.getType().cast(o);
            if (!ListEquals.listEquals(this.statusItem, _that.getStatusItem())) {
                return false;
            }
            return Objects.equals(this.partiesAndAccountsModel, _that.getPartiesAndAccountsModel());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.statusItem != null ? this.statusItem.hashCode() : 0);
            _result = 31 * _result + (this.partiesAndAccountsModel != null ? this.partiesAndAccountsModel.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "EventStatusResponse {statusItem=" + this.statusItem + ", partiesAndAccountsModel=" + this.partiesAndAccountsModel + '}' + " " + super.toString();
        }
    }
}

