/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.mktenv;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.asset.AnyAssetReference;
import fpml.consolidated.mktenv.FxRateSet;
import fpml.consolidated.mktenv.TermCurve;
import fpml.consolidated.mktenv.meta.FxCurveValuationMeta;
import fpml.consolidated.riskdef.PricingInputDatesModel;
import fpml.consolidated.riskdef.PricingStructureValuation;
import fpml.consolidated.riskdef.ValuationScenarioReference;
import fpml.consolidated.shared.PricingStructureReference;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="FxCurveValuation", builder=FxCurveValuationBuilderImpl.class, version="1.1.0")
@RuneDataType(value="FxCurveValuation", model="fpml", builder=FxCurveValuationBuilderImpl.class, version="1.1.0")
public interface FxCurveValuation
extends PricingStructureValuation {
    public static final FxCurveValuationMeta metaData = new FxCurveValuationMeta();

    public PricingStructureReference getSettlementCurrencyYieldCurve();

    public PricingStructureReference getForecastCurrencyYieldCurve();

    public FxRateSet getSpotRate();

    public TermCurve getFxForwardCurve();

    public TermCurve getFxForwardPointsCurve();

    @Override
    public FxCurveValuation build();

    @Override
    public FxCurveValuationBuilder toBuilder();

    public static FxCurveValuationBuilder builder() {
        return new FxCurveValuationBuilderImpl();
    }

    default public RosettaMetaData<? extends FxCurveValuation> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends FxCurveValuation> getType() {
        return FxCurveValuation.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("objectReference"), processor, AnyAssetReference.class, this.getObjectReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("valuationScenarioReference"), processor, ValuationScenarioReference.class, this.getValuationScenarioReference(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("definitionRef"), String.class, (Object)this.getDefinitionRef(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("pricingInputDatesModel"), processor, PricingInputDatesModel.class, this.getPricingInputDatesModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("settlementCurrencyYieldCurve"), processor, PricingStructureReference.class, this.getSettlementCurrencyYieldCurve(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("forecastCurrencyYieldCurve"), processor, PricingStructureReference.class, this.getForecastCurrencyYieldCurve(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("spotRate"), processor, FxRateSet.class, this.getSpotRate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("fxForwardCurve"), processor, TermCurve.class, this.getFxForwardCurve(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("fxForwardPointsCurve"), processor, TermCurve.class, this.getFxForwardPointsCurve(), new AttributeMeta[0]);
    }

    public static class FxCurveValuationBuilderImpl
    extends PricingStructureValuation.PricingStructureValuationBuilderImpl
    implements FxCurveValuationBuilder {
        protected PricingStructureReference.PricingStructureReferenceBuilder settlementCurrencyYieldCurve;
        protected PricingStructureReference.PricingStructureReferenceBuilder forecastCurrencyYieldCurve;
        protected FxRateSet.FxRateSetBuilder spotRate;
        protected TermCurve.TermCurveBuilder fxForwardCurve;
        protected TermCurve.TermCurveBuilder fxForwardPointsCurve;

        @Override
        @RosettaAttribute(value="settlementCurrencyYieldCurve")
        @RuneAttribute(value="settlementCurrencyYieldCurve")
        public PricingStructureReference.PricingStructureReferenceBuilder getSettlementCurrencyYieldCurve() {
            return this.settlementCurrencyYieldCurve;
        }

        @Override
        public PricingStructureReference.PricingStructureReferenceBuilder getOrCreateSettlementCurrencyYieldCurve() {
            PricingStructureReference.PricingStructureReferenceBuilder result = this.settlementCurrencyYieldCurve != null ? this.settlementCurrencyYieldCurve : (this.settlementCurrencyYieldCurve = PricingStructureReference.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="forecastCurrencyYieldCurve")
        @RuneAttribute(value="forecastCurrencyYieldCurve")
        public PricingStructureReference.PricingStructureReferenceBuilder getForecastCurrencyYieldCurve() {
            return this.forecastCurrencyYieldCurve;
        }

        @Override
        public PricingStructureReference.PricingStructureReferenceBuilder getOrCreateForecastCurrencyYieldCurve() {
            PricingStructureReference.PricingStructureReferenceBuilder result = this.forecastCurrencyYieldCurve != null ? this.forecastCurrencyYieldCurve : (this.forecastCurrencyYieldCurve = PricingStructureReference.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="spotRate")
        @RuneAttribute(value="spotRate")
        public FxRateSet.FxRateSetBuilder getSpotRate() {
            return this.spotRate;
        }

        @Override
        public FxRateSet.FxRateSetBuilder getOrCreateSpotRate() {
            FxRateSet.FxRateSetBuilder result = this.spotRate != null ? this.spotRate : (this.spotRate = FxRateSet.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="fxForwardCurve")
        @RuneAttribute(value="fxForwardCurve")
        public TermCurve.TermCurveBuilder getFxForwardCurve() {
            return this.fxForwardCurve;
        }

        @Override
        public TermCurve.TermCurveBuilder getOrCreateFxForwardCurve() {
            TermCurve.TermCurveBuilder result = this.fxForwardCurve != null ? this.fxForwardCurve : (this.fxForwardCurve = TermCurve.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="fxForwardPointsCurve")
        @RuneAttribute(value="fxForwardPointsCurve")
        public TermCurve.TermCurveBuilder getFxForwardPointsCurve() {
            return this.fxForwardPointsCurve;
        }

        @Override
        public TermCurve.TermCurveBuilder getOrCreateFxForwardPointsCurve() {
            TermCurve.TermCurveBuilder result = this.fxForwardPointsCurve != null ? this.fxForwardPointsCurve : (this.fxForwardPointsCurve = TermCurve.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="objectReference")
        @RuneAttribute(value="objectReference")
        public FxCurveValuationBuilder setObjectReference(AnyAssetReference _objectReference) {
            this.objectReference = _objectReference == null ? null : _objectReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="valuationScenarioReference")
        @RuneAttribute(value="valuationScenarioReference")
        public FxCurveValuationBuilder setValuationScenarioReference(ValuationScenarioReference _valuationScenarioReference) {
            this.valuationScenarioReference = _valuationScenarioReference == null ? null : _valuationScenarioReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public FxCurveValuationBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="definitionRef")
        @RuneAttribute(value="definitionRef")
        public FxCurveValuationBuilder setDefinitionRef(String _definitionRef) {
            this.definitionRef = _definitionRef == null ? null : _definitionRef;
            return this;
        }

        @Override
        @RosettaAttribute(value="pricingInputDatesModel", isRequired=true)
        @RuneAttribute(value="pricingInputDatesModel", isRequired=true)
        public FxCurveValuationBuilder setPricingInputDatesModel(PricingInputDatesModel _pricingInputDatesModel) {
            this.pricingInputDatesModel = _pricingInputDatesModel == null ? null : _pricingInputDatesModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="settlementCurrencyYieldCurve")
        @RuneAttribute(value="settlementCurrencyYieldCurve")
        public FxCurveValuationBuilder setSettlementCurrencyYieldCurve(PricingStructureReference _settlementCurrencyYieldCurve) {
            this.settlementCurrencyYieldCurve = _settlementCurrencyYieldCurve == null ? null : _settlementCurrencyYieldCurve.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="forecastCurrencyYieldCurve")
        @RuneAttribute(value="forecastCurrencyYieldCurve")
        public FxCurveValuationBuilder setForecastCurrencyYieldCurve(PricingStructureReference _forecastCurrencyYieldCurve) {
            this.forecastCurrencyYieldCurve = _forecastCurrencyYieldCurve == null ? null : _forecastCurrencyYieldCurve.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="spotRate")
        @RuneAttribute(value="spotRate")
        public FxCurveValuationBuilder setSpotRate(FxRateSet _spotRate) {
            this.spotRate = _spotRate == null ? null : _spotRate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="fxForwardCurve")
        @RuneAttribute(value="fxForwardCurve")
        public FxCurveValuationBuilder setFxForwardCurve(TermCurve _fxForwardCurve) {
            this.fxForwardCurve = _fxForwardCurve == null ? null : _fxForwardCurve.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="fxForwardPointsCurve")
        @RuneAttribute(value="fxForwardPointsCurve")
        public FxCurveValuationBuilder setFxForwardPointsCurve(TermCurve _fxForwardPointsCurve) {
            this.fxForwardPointsCurve = _fxForwardPointsCurve == null ? null : _fxForwardPointsCurve.toBuilder();
            return this;
        }

        @Override
        public FxCurveValuation build() {
            return new FxCurveValuationImpl(this);
        }

        @Override
        public FxCurveValuationBuilder toBuilder() {
            return this;
        }

        @Override
        public FxCurveValuationBuilder prune() {
            super.prune();
            if (this.settlementCurrencyYieldCurve != null && !this.settlementCurrencyYieldCurve.prune().hasData()) {
                this.settlementCurrencyYieldCurve = null;
            }
            if (this.forecastCurrencyYieldCurve != null && !this.forecastCurrencyYieldCurve.prune().hasData()) {
                this.forecastCurrencyYieldCurve = null;
            }
            if (this.spotRate != null && !this.spotRate.prune().hasData()) {
                this.spotRate = null;
            }
            if (this.fxForwardCurve != null && !this.fxForwardCurve.prune().hasData()) {
                this.fxForwardCurve = null;
            }
            if (this.fxForwardPointsCurve != null && !this.fxForwardPointsCurve.prune().hasData()) {
                this.fxForwardPointsCurve = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getSettlementCurrencyYieldCurve() != null && this.getSettlementCurrencyYieldCurve().hasData()) {
                return true;
            }
            if (this.getForecastCurrencyYieldCurve() != null && this.getForecastCurrencyYieldCurve().hasData()) {
                return true;
            }
            if (this.getSpotRate() != null && this.getSpotRate().hasData()) {
                return true;
            }
            if (this.getFxForwardCurve() != null && this.getFxForwardCurve().hasData()) {
                return true;
            }
            return this.getFxForwardPointsCurve() != null && this.getFxForwardPointsCurve().hasData();
        }

        @Override
        public FxCurveValuationBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            FxCurveValuationBuilder o = (FxCurveValuationBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSettlementCurrencyYieldCurve(), (RosettaModelObjectBuilder)o.getSettlementCurrencyYieldCurve(), this::setSettlementCurrencyYieldCurve);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getForecastCurrencyYieldCurve(), (RosettaModelObjectBuilder)o.getForecastCurrencyYieldCurve(), this::setForecastCurrencyYieldCurve);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSpotRate(), (RosettaModelObjectBuilder)o.getSpotRate(), this::setSpotRate);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFxForwardCurve(), (RosettaModelObjectBuilder)o.getFxForwardCurve(), this::setFxForwardCurve);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFxForwardPointsCurve(), (RosettaModelObjectBuilder)o.getFxForwardPointsCurve(), this::setFxForwardPointsCurve);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            FxCurveValuation _that = (FxCurveValuation)this.getType().cast(o);
            if (!Objects.equals(this.settlementCurrencyYieldCurve, _that.getSettlementCurrencyYieldCurve())) {
                return false;
            }
            if (!Objects.equals(this.forecastCurrencyYieldCurve, _that.getForecastCurrencyYieldCurve())) {
                return false;
            }
            if (!Objects.equals(this.spotRate, _that.getSpotRate())) {
                return false;
            }
            if (!Objects.equals(this.fxForwardCurve, _that.getFxForwardCurve())) {
                return false;
            }
            return Objects.equals(this.fxForwardPointsCurve, _that.getFxForwardPointsCurve());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.settlementCurrencyYieldCurve != null ? this.settlementCurrencyYieldCurve.hashCode() : 0);
            _result = 31 * _result + (this.forecastCurrencyYieldCurve != null ? this.forecastCurrencyYieldCurve.hashCode() : 0);
            _result = 31 * _result + (this.spotRate != null ? this.spotRate.hashCode() : 0);
            _result = 31 * _result + (this.fxForwardCurve != null ? this.fxForwardCurve.hashCode() : 0);
            _result = 31 * _result + (this.fxForwardPointsCurve != null ? this.fxForwardPointsCurve.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "FxCurveValuationBuilder {settlementCurrencyYieldCurve=" + this.settlementCurrencyYieldCurve + ", forecastCurrencyYieldCurve=" + this.forecastCurrencyYieldCurve + ", spotRate=" + this.spotRate + ", fxForwardCurve=" + this.fxForwardCurve + ", fxForwardPointsCurve=" + this.fxForwardPointsCurve + '}' + " " + super.toString();
        }
    }

    public static interface FxCurveValuationBuilder
    extends FxCurveValuation,
    PricingStructureValuation.PricingStructureValuationBuilder {
        public PricingStructureReference.PricingStructureReferenceBuilder getOrCreateSettlementCurrencyYieldCurve();

        @Override
        public PricingStructureReference.PricingStructureReferenceBuilder getSettlementCurrencyYieldCurve();

        public PricingStructureReference.PricingStructureReferenceBuilder getOrCreateForecastCurrencyYieldCurve();

        @Override
        public PricingStructureReference.PricingStructureReferenceBuilder getForecastCurrencyYieldCurve();

        public FxRateSet.FxRateSetBuilder getOrCreateSpotRate();

        @Override
        public FxRateSet.FxRateSetBuilder getSpotRate();

        public TermCurve.TermCurveBuilder getOrCreateFxForwardCurve();

        @Override
        public TermCurve.TermCurveBuilder getFxForwardCurve();

        public TermCurve.TermCurveBuilder getOrCreateFxForwardPointsCurve();

        @Override
        public TermCurve.TermCurveBuilder getFxForwardPointsCurve();

        @Override
        public FxCurveValuationBuilder setObjectReference(AnyAssetReference var1);

        @Override
        public FxCurveValuationBuilder setValuationScenarioReference(ValuationScenarioReference var1);

        @Override
        public FxCurveValuationBuilder setId(String var1);

        @Override
        public FxCurveValuationBuilder setDefinitionRef(String var1);

        @Override
        public FxCurveValuationBuilder setPricingInputDatesModel(PricingInputDatesModel var1);

        public FxCurveValuationBuilder setSettlementCurrencyYieldCurve(PricingStructureReference var1);

        public FxCurveValuationBuilder setForecastCurrencyYieldCurve(PricingStructureReference var1);

        public FxCurveValuationBuilder setSpotRate(FxRateSet var1);

        public FxCurveValuationBuilder setFxForwardCurve(TermCurve var1);

        public FxCurveValuationBuilder setFxForwardPointsCurve(TermCurve var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("objectReference"), processor, AnyAssetReference.AnyAssetReferenceBuilder.class, (RosettaModelObjectBuilder)this.getObjectReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("valuationScenarioReference"), processor, ValuationScenarioReference.ValuationScenarioReferenceBuilder.class, (RosettaModelObjectBuilder)this.getValuationScenarioReference(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("definitionRef"), String.class, (Object)this.getDefinitionRef(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("pricingInputDatesModel"), processor, PricingInputDatesModel.PricingInputDatesModelBuilder.class, (RosettaModelObjectBuilder)this.getPricingInputDatesModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("settlementCurrencyYieldCurve"), processor, PricingStructureReference.PricingStructureReferenceBuilder.class, this.getSettlementCurrencyYieldCurve(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("forecastCurrencyYieldCurve"), processor, PricingStructureReference.PricingStructureReferenceBuilder.class, this.getForecastCurrencyYieldCurve(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("spotRate"), processor, FxRateSet.FxRateSetBuilder.class, this.getSpotRate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("fxForwardCurve"), processor, TermCurve.TermCurveBuilder.class, this.getFxForwardCurve(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("fxForwardPointsCurve"), processor, TermCurve.TermCurveBuilder.class, this.getFxForwardPointsCurve(), new AttributeMeta[0]);
        }

        @Override
        public FxCurveValuationBuilder prune();
    }

    public static class FxCurveValuationImpl
    extends PricingStructureValuation.PricingStructureValuationImpl
    implements FxCurveValuation {
        private final PricingStructureReference settlementCurrencyYieldCurve;
        private final PricingStructureReference forecastCurrencyYieldCurve;
        private final FxRateSet spotRate;
        private final TermCurve fxForwardCurve;
        private final TermCurve fxForwardPointsCurve;

        protected FxCurveValuationImpl(FxCurveValuationBuilder builder) {
            super(builder);
            this.settlementCurrencyYieldCurve = Optional.ofNullable(builder.getSettlementCurrencyYieldCurve()).map(f -> f.build()).orElse(null);
            this.forecastCurrencyYieldCurve = Optional.ofNullable(builder.getForecastCurrencyYieldCurve()).map(f -> f.build()).orElse(null);
            this.spotRate = Optional.ofNullable(builder.getSpotRate()).map(f -> f.build()).orElse(null);
            this.fxForwardCurve = Optional.ofNullable(builder.getFxForwardCurve()).map(f -> f.build()).orElse(null);
            this.fxForwardPointsCurve = Optional.ofNullable(builder.getFxForwardPointsCurve()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="settlementCurrencyYieldCurve")
        @RuneAttribute(value="settlementCurrencyYieldCurve")
        public PricingStructureReference getSettlementCurrencyYieldCurve() {
            return this.settlementCurrencyYieldCurve;
        }

        @Override
        @RosettaAttribute(value="forecastCurrencyYieldCurve")
        @RuneAttribute(value="forecastCurrencyYieldCurve")
        public PricingStructureReference getForecastCurrencyYieldCurve() {
            return this.forecastCurrencyYieldCurve;
        }

        @Override
        @RosettaAttribute(value="spotRate")
        @RuneAttribute(value="spotRate")
        public FxRateSet getSpotRate() {
            return this.spotRate;
        }

        @Override
        @RosettaAttribute(value="fxForwardCurve")
        @RuneAttribute(value="fxForwardCurve")
        public TermCurve getFxForwardCurve() {
            return this.fxForwardCurve;
        }

        @Override
        @RosettaAttribute(value="fxForwardPointsCurve")
        @RuneAttribute(value="fxForwardPointsCurve")
        public TermCurve getFxForwardPointsCurve() {
            return this.fxForwardPointsCurve;
        }

        @Override
        public FxCurveValuation build() {
            return this;
        }

        @Override
        public FxCurveValuationBuilder toBuilder() {
            FxCurveValuationBuilder builder = FxCurveValuation.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(FxCurveValuationBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getSettlementCurrencyYieldCurve()).ifPresent(builder::setSettlementCurrencyYieldCurve);
            Optional.ofNullable(this.getForecastCurrencyYieldCurve()).ifPresent(builder::setForecastCurrencyYieldCurve);
            Optional.ofNullable(this.getSpotRate()).ifPresent(builder::setSpotRate);
            Optional.ofNullable(this.getFxForwardCurve()).ifPresent(builder::setFxForwardCurve);
            Optional.ofNullable(this.getFxForwardPointsCurve()).ifPresent(builder::setFxForwardPointsCurve);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            FxCurveValuation _that = (FxCurveValuation)this.getType().cast(o);
            if (!Objects.equals(this.settlementCurrencyYieldCurve, _that.getSettlementCurrencyYieldCurve())) {
                return false;
            }
            if (!Objects.equals(this.forecastCurrencyYieldCurve, _that.getForecastCurrencyYieldCurve())) {
                return false;
            }
            if (!Objects.equals(this.spotRate, _that.getSpotRate())) {
                return false;
            }
            if (!Objects.equals(this.fxForwardCurve, _that.getFxForwardCurve())) {
                return false;
            }
            return Objects.equals(this.fxForwardPointsCurve, _that.getFxForwardPointsCurve());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.settlementCurrencyYieldCurve != null ? this.settlementCurrencyYieldCurve.hashCode() : 0);
            _result = 31 * _result + (this.forecastCurrencyYieldCurve != null ? this.forecastCurrencyYieldCurve.hashCode() : 0);
            _result = 31 * _result + (this.spotRate != null ? this.spotRate.hashCode() : 0);
            _result = 31 * _result + (this.fxForwardCurve != null ? this.fxForwardCurve.hashCode() : 0);
            _result = 31 * _result + (this.fxForwardPointsCurve != null ? this.fxForwardPointsCurve.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "FxCurveValuation {settlementCurrencyYieldCurve=" + this.settlementCurrencyYieldCurve + ", forecastCurrencyYieldCurve=" + this.forecastCurrencyYieldCurve + ", spotRate=" + this.spotRate + ", fxForwardCurve=" + this.fxForwardCurve + ", fxForwardPointsCurve=" + this.fxForwardPointsCurve + '}' + " " + super.toString();
        }
    }
}

