/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.main;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.doc.Document;
import fpml.consolidated.doc.Portfolio;
import fpml.consolidated.doc.Trade;
import fpml.consolidated.doc.ValidationModel;
import fpml.consolidated.main.meta.DataDocumentMeta;
import fpml.consolidated.shared.OnBehalfOf;
import fpml.consolidated.shared.OriginatingEvent;
import fpml.consolidated.shared.PartiesAndAccountsModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="DataDocument", builder=DataDocumentBuilderImpl.class, version="1.1.0")
@RuneDataType(value="DataDocument", model="fpml", builder=DataDocumentBuilderImpl.class, version="1.1.0")
public interface DataDocument
extends Document {
    public static final DataDocumentMeta metaData = new DataDocumentMeta();

    public ValidationModel getValidationModel();

    public OnBehalfOf getOnBehalfOf();

    public OriginatingEvent getOriginatingEvent();

    public List<? extends Trade> getTrade();

    public PartiesAndAccountsModel getPartiesAndAccountsModel();

    public List<? extends Portfolio> getPortfolio();

    @Override
    public DataDocument build();

    @Override
    public DataDocumentBuilder toBuilder();

    public static DataDocumentBuilder builder() {
        return new DataDocumentBuilderImpl();
    }

    default public RosettaMetaData<? extends DataDocument> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends DataDocument> getType() {
        return DataDocument.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("fpmlVersion"), String.class, (Object)this.getFpmlVersion(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("expectedBuild"), Integer.class, (Object)this.getExpectedBuild(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("actualBuild"), Integer.class, (Object)this.getActualBuild(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("validationModel"), processor, ValidationModel.class, this.getValidationModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("onBehalfOf"), processor, OnBehalfOf.class, this.getOnBehalfOf(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("originatingEvent"), processor, OriginatingEvent.class, this.getOriginatingEvent(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("trade"), processor, Trade.class, this.getTrade(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("partiesAndAccountsModel"), processor, PartiesAndAccountsModel.class, this.getPartiesAndAccountsModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("portfolio"), processor, Portfolio.class, this.getPortfolio(), new AttributeMeta[0]);
    }

    public static class DataDocumentBuilderImpl
    extends Document.DocumentBuilderImpl
    implements DataDocumentBuilder {
        protected ValidationModel.ValidationModelBuilder validationModel;
        protected OnBehalfOf.OnBehalfOfBuilder onBehalfOf;
        protected OriginatingEvent.OriginatingEventBuilder originatingEvent;
        protected List<Trade.TradeBuilder> trade = new ArrayList<Trade.TradeBuilder>();
        protected PartiesAndAccountsModel.PartiesAndAccountsModelBuilder partiesAndAccountsModel;
        protected List<Portfolio.PortfolioBuilder> portfolio = new ArrayList<Portfolio.PortfolioBuilder>();

        @Override
        @RosettaAttribute(value="validationModel", isRequired=true)
        @RuneAttribute(value="validationModel", isRequired=true)
        public ValidationModel.ValidationModelBuilder getValidationModel() {
            return this.validationModel;
        }

        @Override
        public ValidationModel.ValidationModelBuilder getOrCreateValidationModel() {
            ValidationModel.ValidationModelBuilder result = this.validationModel != null ? this.validationModel : (this.validationModel = ValidationModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="onBehalfOf")
        @RuneAttribute(value="onBehalfOf")
        public OnBehalfOf.OnBehalfOfBuilder getOnBehalfOf() {
            return this.onBehalfOf;
        }

        @Override
        public OnBehalfOf.OnBehalfOfBuilder getOrCreateOnBehalfOf() {
            OnBehalfOf.OnBehalfOfBuilder result = this.onBehalfOf != null ? this.onBehalfOf : (this.onBehalfOf = OnBehalfOf.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="originatingEvent")
        @RuneAttribute(value="originatingEvent")
        public OriginatingEvent.OriginatingEventBuilder getOriginatingEvent() {
            return this.originatingEvent;
        }

        @Override
        public OriginatingEvent.OriginatingEventBuilder getOrCreateOriginatingEvent() {
            OriginatingEvent.OriginatingEventBuilder result = this.originatingEvent != null ? this.originatingEvent : (this.originatingEvent = OriginatingEvent.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="trade")
        @RuneAttribute(value="trade")
        public List<? extends Trade.TradeBuilder> getTrade() {
            return this.trade;
        }

        @Override
        public Trade.TradeBuilder getOrCreateTrade(int index) {
            if (this.trade == null) {
                this.trade = new ArrayList<Trade.TradeBuilder>();
            }
            return (Trade.TradeBuilder)this.getIndex(this.trade, index, () -> {
                Trade.TradeBuilder newTrade = Trade.builder();
                return newTrade;
            });
        }

        @Override
        @RosettaAttribute(value="partiesAndAccountsModel")
        @RuneAttribute(value="partiesAndAccountsModel")
        public PartiesAndAccountsModel.PartiesAndAccountsModelBuilder getPartiesAndAccountsModel() {
            return this.partiesAndAccountsModel;
        }

        @Override
        public PartiesAndAccountsModel.PartiesAndAccountsModelBuilder getOrCreatePartiesAndAccountsModel() {
            PartiesAndAccountsModel.PartiesAndAccountsModelBuilder result = this.partiesAndAccountsModel != null ? this.partiesAndAccountsModel : (this.partiesAndAccountsModel = PartiesAndAccountsModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="portfolio")
        @RuneAttribute(value="portfolio")
        public List<? extends Portfolio.PortfolioBuilder> getPortfolio() {
            return this.portfolio;
        }

        @Override
        public Portfolio.PortfolioBuilder getOrCreatePortfolio(int index) {
            if (this.portfolio == null) {
                this.portfolio = new ArrayList<Portfolio.PortfolioBuilder>();
            }
            return (Portfolio.PortfolioBuilder)this.getIndex(this.portfolio, index, () -> {
                Portfolio.PortfolioBuilder newPortfolio = Portfolio.builder();
                return newPortfolio;
            });
        }

        @Override
        @RosettaAttribute(value="fpmlVersion", isRequired=true)
        @RuneAttribute(value="fpmlVersion", isRequired=true)
        public DataDocumentBuilder setFpmlVersion(String _fpmlVersion) {
            this.fpmlVersion = _fpmlVersion == null ? null : _fpmlVersion;
            return this;
        }

        @Override
        @RosettaAttribute(value="expectedBuild")
        @RuneAttribute(value="expectedBuild")
        public DataDocumentBuilder setExpectedBuild(Integer _expectedBuild) {
            this.expectedBuild = _expectedBuild == null ? null : _expectedBuild;
            return this;
        }

        @Override
        @RosettaAttribute(value="actualBuild")
        @RuneAttribute(value="actualBuild")
        public DataDocumentBuilder setActualBuild(Integer _actualBuild) {
            this.actualBuild = _actualBuild == null ? null : _actualBuild;
            return this;
        }

        @Override
        @RosettaAttribute(value="validationModel", isRequired=true)
        @RuneAttribute(value="validationModel", isRequired=true)
        public DataDocumentBuilder setValidationModel(ValidationModel _validationModel) {
            this.validationModel = _validationModel == null ? null : _validationModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="onBehalfOf")
        @RuneAttribute(value="onBehalfOf")
        public DataDocumentBuilder setOnBehalfOf(OnBehalfOf _onBehalfOf) {
            this.onBehalfOf = _onBehalfOf == null ? null : _onBehalfOf.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="originatingEvent")
        @RuneAttribute(value="originatingEvent")
        public DataDocumentBuilder setOriginatingEvent(OriginatingEvent _originatingEvent) {
            this.originatingEvent = _originatingEvent == null ? null : _originatingEvent.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="trade")
        @RuneAttribute(value="trade")
        public DataDocumentBuilder addTrade(Trade _trade) {
            if (_trade != null) {
                this.trade.add(_trade.toBuilder());
            }
            return this;
        }

        @Override
        public DataDocumentBuilder addTrade(Trade _trade, int idx) {
            this.getIndex(this.trade, idx, () -> _trade.toBuilder());
            return this;
        }

        @Override
        public DataDocumentBuilder addTrade(List<? extends Trade> trades) {
            if (trades != null) {
                for (Trade trade : trades) {
                    this.trade.add(trade.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="trade")
        public DataDocumentBuilder setTrade(List<? extends Trade> trades) {
            this.trade = trades == null ? new ArrayList<Trade.TradeBuilder>() : (List)trades.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="partiesAndAccountsModel")
        @RuneAttribute(value="partiesAndAccountsModel")
        public DataDocumentBuilder setPartiesAndAccountsModel(PartiesAndAccountsModel _partiesAndAccountsModel) {
            this.partiesAndAccountsModel = _partiesAndAccountsModel == null ? null : _partiesAndAccountsModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="portfolio")
        @RuneAttribute(value="portfolio")
        public DataDocumentBuilder addPortfolio(Portfolio _portfolio) {
            if (_portfolio != null) {
                this.portfolio.add(_portfolio.toBuilder());
            }
            return this;
        }

        @Override
        public DataDocumentBuilder addPortfolio(Portfolio _portfolio, int idx) {
            this.getIndex(this.portfolio, idx, () -> _portfolio.toBuilder());
            return this;
        }

        @Override
        public DataDocumentBuilder addPortfolio(List<? extends Portfolio> portfolios) {
            if (portfolios != null) {
                for (Portfolio portfolio : portfolios) {
                    this.portfolio.add(portfolio.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="portfolio")
        public DataDocumentBuilder setPortfolio(List<? extends Portfolio> portfolios) {
            this.portfolio = portfolios == null ? new ArrayList<Portfolio.PortfolioBuilder>() : (List)portfolios.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public DataDocument build() {
            return new DataDocumentImpl(this);
        }

        @Override
        public DataDocumentBuilder toBuilder() {
            return this;
        }

        @Override
        public DataDocumentBuilder prune() {
            super.prune();
            if (this.validationModel != null && !this.validationModel.prune().hasData()) {
                this.validationModel = null;
            }
            if (this.onBehalfOf != null && !this.onBehalfOf.prune().hasData()) {
                this.onBehalfOf = null;
            }
            if (this.originatingEvent != null && !this.originatingEvent.prune().hasData()) {
                this.originatingEvent = null;
            }
            this.trade = this.trade.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.partiesAndAccountsModel != null && !this.partiesAndAccountsModel.prune().hasData()) {
                this.partiesAndAccountsModel = null;
            }
            this.portfolio = this.portfolio.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getValidationModel() != null && this.getValidationModel().hasData()) {
                return true;
            }
            if (this.getOnBehalfOf() != null && this.getOnBehalfOf().hasData()) {
                return true;
            }
            if (this.getOriginatingEvent() != null && this.getOriginatingEvent().hasData()) {
                return true;
            }
            if (this.getTrade() != null && this.getTrade().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getPartiesAndAccountsModel() != null && this.getPartiesAndAccountsModel().hasData()) {
                return true;
            }
            return this.getPortfolio() != null && this.getPortfolio().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        @Override
        public DataDocumentBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            DataDocumentBuilder o = (DataDocumentBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getValidationModel(), (RosettaModelObjectBuilder)o.getValidationModel(), this::setValidationModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getOnBehalfOf(), (RosettaModelObjectBuilder)o.getOnBehalfOf(), this::setOnBehalfOf);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getOriginatingEvent(), (RosettaModelObjectBuilder)o.getOriginatingEvent(), this::setOriginatingEvent);
            merger.mergeRosetta(this.getTrade(), o.getTrade(), this::getOrCreateTrade);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPartiesAndAccountsModel(), (RosettaModelObjectBuilder)o.getPartiesAndAccountsModel(), this::setPartiesAndAccountsModel);
            merger.mergeRosetta(this.getPortfolio(), o.getPortfolio(), this::getOrCreatePortfolio);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            DataDocument _that = (DataDocument)this.getType().cast(o);
            if (!Objects.equals(this.validationModel, _that.getValidationModel())) {
                return false;
            }
            if (!Objects.equals(this.onBehalfOf, _that.getOnBehalfOf())) {
                return false;
            }
            if (!Objects.equals(this.originatingEvent, _that.getOriginatingEvent())) {
                return false;
            }
            if (!ListEquals.listEquals(this.trade, _that.getTrade())) {
                return false;
            }
            if (!Objects.equals(this.partiesAndAccountsModel, _that.getPartiesAndAccountsModel())) {
                return false;
            }
            return ListEquals.listEquals(this.portfolio, _that.getPortfolio());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.validationModel != null ? this.validationModel.hashCode() : 0);
            _result = 31 * _result + (this.onBehalfOf != null ? this.onBehalfOf.hashCode() : 0);
            _result = 31 * _result + (this.originatingEvent != null ? this.originatingEvent.hashCode() : 0);
            _result = 31 * _result + (this.trade != null ? this.trade.hashCode() : 0);
            _result = 31 * _result + (this.partiesAndAccountsModel != null ? this.partiesAndAccountsModel.hashCode() : 0);
            _result = 31 * _result + (this.portfolio != null ? this.portfolio.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "DataDocumentBuilder {validationModel=" + this.validationModel + ", onBehalfOf=" + this.onBehalfOf + ", originatingEvent=" + this.originatingEvent + ", trade=" + this.trade + ", partiesAndAccountsModel=" + this.partiesAndAccountsModel + ", portfolio=" + this.portfolio + '}' + " " + super.toString();
        }
    }

    public static interface DataDocumentBuilder
    extends DataDocument,
    Document.DocumentBuilder {
        public ValidationModel.ValidationModelBuilder getOrCreateValidationModel();

        @Override
        public ValidationModel.ValidationModelBuilder getValidationModel();

        public OnBehalfOf.OnBehalfOfBuilder getOrCreateOnBehalfOf();

        @Override
        public OnBehalfOf.OnBehalfOfBuilder getOnBehalfOf();

        public OriginatingEvent.OriginatingEventBuilder getOrCreateOriginatingEvent();

        @Override
        public OriginatingEvent.OriginatingEventBuilder getOriginatingEvent();

        public Trade.TradeBuilder getOrCreateTrade(int var1);

        public List<? extends Trade.TradeBuilder> getTrade();

        public PartiesAndAccountsModel.PartiesAndAccountsModelBuilder getOrCreatePartiesAndAccountsModel();

        @Override
        public PartiesAndAccountsModel.PartiesAndAccountsModelBuilder getPartiesAndAccountsModel();

        public Portfolio.PortfolioBuilder getOrCreatePortfolio(int var1);

        public List<? extends Portfolio.PortfolioBuilder> getPortfolio();

        @Override
        public DataDocumentBuilder setFpmlVersion(String var1);

        @Override
        public DataDocumentBuilder setExpectedBuild(Integer var1);

        @Override
        public DataDocumentBuilder setActualBuild(Integer var1);

        public DataDocumentBuilder setValidationModel(ValidationModel var1);

        public DataDocumentBuilder setOnBehalfOf(OnBehalfOf var1);

        public DataDocumentBuilder setOriginatingEvent(OriginatingEvent var1);

        public DataDocumentBuilder addTrade(Trade var1);

        public DataDocumentBuilder addTrade(Trade var1, int var2);

        public DataDocumentBuilder addTrade(List<? extends Trade> var1);

        public DataDocumentBuilder setTrade(List<? extends Trade> var1);

        public DataDocumentBuilder setPartiesAndAccountsModel(PartiesAndAccountsModel var1);

        public DataDocumentBuilder addPortfolio(Portfolio var1);

        public DataDocumentBuilder addPortfolio(Portfolio var1, int var2);

        public DataDocumentBuilder addPortfolio(List<? extends Portfolio> var1);

        public DataDocumentBuilder setPortfolio(List<? extends Portfolio> var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("fpmlVersion"), String.class, (Object)this.getFpmlVersion(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("expectedBuild"), Integer.class, (Object)this.getExpectedBuild(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("actualBuild"), Integer.class, (Object)this.getActualBuild(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("validationModel"), processor, ValidationModel.ValidationModelBuilder.class, this.getValidationModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("onBehalfOf"), processor, OnBehalfOf.OnBehalfOfBuilder.class, this.getOnBehalfOf(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("originatingEvent"), processor, OriginatingEvent.OriginatingEventBuilder.class, this.getOriginatingEvent(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("trade"), processor, Trade.TradeBuilder.class, this.getTrade(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("partiesAndAccountsModel"), processor, PartiesAndAccountsModel.PartiesAndAccountsModelBuilder.class, this.getPartiesAndAccountsModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("portfolio"), processor, Portfolio.PortfolioBuilder.class, this.getPortfolio(), new AttributeMeta[0]);
        }

        @Override
        public DataDocumentBuilder prune();
    }

    public static class DataDocumentImpl
    extends Document.DocumentImpl
    implements DataDocument {
        private final ValidationModel validationModel;
        private final OnBehalfOf onBehalfOf;
        private final OriginatingEvent originatingEvent;
        private final List<? extends Trade> trade;
        private final PartiesAndAccountsModel partiesAndAccountsModel;
        private final List<? extends Portfolio> portfolio;

        protected DataDocumentImpl(DataDocumentBuilder builder) {
            super(builder);
            this.validationModel = Optional.ofNullable(builder.getValidationModel()).map(f -> f.build()).orElse(null);
            this.onBehalfOf = Optional.ofNullable(builder.getOnBehalfOf()).map(f -> f.build()).orElse(null);
            this.originatingEvent = Optional.ofNullable(builder.getOriginatingEvent()).map(f -> f.build()).orElse(null);
            this.trade = Optional.ofNullable(builder.getTrade()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.partiesAndAccountsModel = Optional.ofNullable(builder.getPartiesAndAccountsModel()).map(f -> f.build()).orElse(null);
            this.portfolio = Optional.ofNullable(builder.getPortfolio()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="validationModel", isRequired=true)
        @RuneAttribute(value="validationModel", isRequired=true)
        public ValidationModel getValidationModel() {
            return this.validationModel;
        }

        @Override
        @RosettaAttribute(value="onBehalfOf")
        @RuneAttribute(value="onBehalfOf")
        public OnBehalfOf getOnBehalfOf() {
            return this.onBehalfOf;
        }

        @Override
        @RosettaAttribute(value="originatingEvent")
        @RuneAttribute(value="originatingEvent")
        public OriginatingEvent getOriginatingEvent() {
            return this.originatingEvent;
        }

        @Override
        @RosettaAttribute(value="trade")
        @RuneAttribute(value="trade")
        public List<? extends Trade> getTrade() {
            return this.trade;
        }

        @Override
        @RosettaAttribute(value="partiesAndAccountsModel")
        @RuneAttribute(value="partiesAndAccountsModel")
        public PartiesAndAccountsModel getPartiesAndAccountsModel() {
            return this.partiesAndAccountsModel;
        }

        @Override
        @RosettaAttribute(value="portfolio")
        @RuneAttribute(value="portfolio")
        public List<? extends Portfolio> getPortfolio() {
            return this.portfolio;
        }

        @Override
        public DataDocument build() {
            return this;
        }

        @Override
        public DataDocumentBuilder toBuilder() {
            DataDocumentBuilder builder = DataDocument.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(DataDocumentBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getValidationModel()).ifPresent(builder::setValidationModel);
            Optional.ofNullable(this.getOnBehalfOf()).ifPresent(builder::setOnBehalfOf);
            Optional.ofNullable(this.getOriginatingEvent()).ifPresent(builder::setOriginatingEvent);
            Optional.ofNullable(this.getTrade()).ifPresent(builder::setTrade);
            Optional.ofNullable(this.getPartiesAndAccountsModel()).ifPresent(builder::setPartiesAndAccountsModel);
            Optional.ofNullable(this.getPortfolio()).ifPresent(builder::setPortfolio);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            DataDocument _that = (DataDocument)this.getType().cast(o);
            if (!Objects.equals(this.validationModel, _that.getValidationModel())) {
                return false;
            }
            if (!Objects.equals(this.onBehalfOf, _that.getOnBehalfOf())) {
                return false;
            }
            if (!Objects.equals(this.originatingEvent, _that.getOriginatingEvent())) {
                return false;
            }
            if (!ListEquals.listEquals(this.trade, _that.getTrade())) {
                return false;
            }
            if (!Objects.equals(this.partiesAndAccountsModel, _that.getPartiesAndAccountsModel())) {
                return false;
            }
            return ListEquals.listEquals(this.portfolio, _that.getPortfolio());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.validationModel != null ? this.validationModel.hashCode() : 0);
            _result = 31 * _result + (this.onBehalfOf != null ? this.onBehalfOf.hashCode() : 0);
            _result = 31 * _result + (this.originatingEvent != null ? this.originatingEvent.hashCode() : 0);
            _result = 31 * _result + (this.trade != null ? this.trade.hashCode() : 0);
            _result = 31 * _result + (this.partiesAndAccountsModel != null ? this.partiesAndAccountsModel.hashCode() : 0);
            _result = 31 * _result + (this.portfolio != null ? this.portfolio.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "DataDocument {validationModel=" + this.validationModel + ", onBehalfOf=" + this.onBehalfOf + ", originatingEvent=" + this.originatingEvent + ", trade=" + this.trade + ", partiesAndAccountsModel=" + this.partiesAndAccountsModel + ", portfolio=" + this.portfolio + '}' + " " + super.toString();
        }
    }
}

