/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.loan;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.doc.ContractId;
import fpml.consolidated.doc.ContractIdentifier;
import fpml.consolidated.doc.VersionedContractId;
import fpml.consolidated.loan.FacilityReference;
import fpml.consolidated.loan.meta.LoanContractIdentifierMeta;
import fpml.consolidated.shared.PartyReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="LoanContractIdentifier", builder=LoanContractIdentifierBuilderImpl.class, version="1.1.0")
@RuneDataType(value="LoanContractIdentifier", model="fpml", builder=LoanContractIdentifierBuilderImpl.class, version="1.1.0")
public interface LoanContractIdentifier
extends ContractIdentifier {
    public static final LoanContractIdentifierMeta metaData = new LoanContractIdentifierMeta();

    public FacilityReference getFacilityReference();

    @Override
    public LoanContractIdentifier build();

    @Override
    public LoanContractIdentifierBuilder toBuilder();

    public static LoanContractIdentifierBuilder builder() {
        return new LoanContractIdentifierBuilderImpl();
    }

    default public RosettaMetaData<? extends LoanContractIdentifier> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends LoanContractIdentifier> getType() {
        return LoanContractIdentifier.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("partyReference"), processor, PartyReference.class, this.getPartyReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("contractId"), processor, ContractId.class, this.getContractId(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("versionedContractId"), processor, VersionedContractId.class, this.getVersionedContractId(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("facilityReference"), processor, FacilityReference.class, this.getFacilityReference(), new AttributeMeta[0]);
    }

    public static class LoanContractIdentifierBuilderImpl
    extends ContractIdentifier.ContractIdentifierBuilderImpl
    implements LoanContractIdentifierBuilder {
        protected FacilityReference.FacilityReferenceBuilder facilityReference;

        @Override
        @RosettaAttribute(value="facilityReference", isRequired=true)
        @RuneAttribute(value="facilityReference", isRequired=true)
        public FacilityReference.FacilityReferenceBuilder getFacilityReference() {
            return this.facilityReference;
        }

        @Override
        public FacilityReference.FacilityReferenceBuilder getOrCreateFacilityReference() {
            FacilityReference.FacilityReferenceBuilder result = this.facilityReference != null ? this.facilityReference : (this.facilityReference = FacilityReference.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="partyReference", isRequired=true)
        @RuneAttribute(value="partyReference", isRequired=true)
        public LoanContractIdentifierBuilder setPartyReference(PartyReference _partyReference) {
            this.partyReference = _partyReference == null ? null : _partyReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="contractId")
        @RuneAttribute(value="contractId")
        public LoanContractIdentifierBuilder addContractId(ContractId _contractId) {
            if (_contractId != null) {
                this.contractId.add(_contractId.toBuilder());
            }
            return this;
        }

        @Override
        public LoanContractIdentifierBuilder addContractId(ContractId _contractId, int idx) {
            this.getIndex(this.contractId, idx, () -> _contractId.toBuilder());
            return this;
        }

        @Override
        public LoanContractIdentifierBuilder addContractId(List<? extends ContractId> contractIds) {
            if (contractIds != null) {
                for (ContractId contractId : contractIds) {
                    this.contractId.add(contractId.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="contractId")
        public LoanContractIdentifierBuilder setContractId(List<? extends ContractId> contractIds) {
            this.contractId = contractIds == null ? new ArrayList() : (List)contractIds.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="versionedContractId")
        @RuneAttribute(value="versionedContractId")
        public LoanContractIdentifierBuilder addVersionedContractId(VersionedContractId _versionedContractId) {
            if (_versionedContractId != null) {
                this.versionedContractId.add(_versionedContractId.toBuilder());
            }
            return this;
        }

        @Override
        public LoanContractIdentifierBuilder addVersionedContractId(VersionedContractId _versionedContractId, int idx) {
            this.getIndex(this.versionedContractId, idx, () -> _versionedContractId.toBuilder());
            return this;
        }

        @Override
        public LoanContractIdentifierBuilder addVersionedContractId(List<? extends VersionedContractId> versionedContractIds) {
            if (versionedContractIds != null) {
                for (VersionedContractId versionedContractId : versionedContractIds) {
                    this.versionedContractId.add(versionedContractId.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="versionedContractId")
        public LoanContractIdentifierBuilder setVersionedContractId(List<? extends VersionedContractId> versionedContractIds) {
            this.versionedContractId = versionedContractIds == null ? new ArrayList() : (List)versionedContractIds.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public LoanContractIdentifierBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="facilityReference", isRequired=true)
        @RuneAttribute(value="facilityReference", isRequired=true)
        public LoanContractIdentifierBuilder setFacilityReference(FacilityReference _facilityReference) {
            this.facilityReference = _facilityReference == null ? null : _facilityReference.toBuilder();
            return this;
        }

        @Override
        public LoanContractIdentifier build() {
            return new LoanContractIdentifierImpl(this);
        }

        @Override
        public LoanContractIdentifierBuilder toBuilder() {
            return this;
        }

        @Override
        public LoanContractIdentifierBuilder prune() {
            super.prune();
            if (this.facilityReference != null && !this.facilityReference.prune().hasData()) {
                this.facilityReference = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            return this.getFacilityReference() != null && this.getFacilityReference().hasData();
        }

        @Override
        public LoanContractIdentifierBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            LoanContractIdentifierBuilder o = (LoanContractIdentifierBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFacilityReference(), (RosettaModelObjectBuilder)o.getFacilityReference(), this::setFacilityReference);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LoanContractIdentifier _that = (LoanContractIdentifier)this.getType().cast(o);
            return Objects.equals(this.facilityReference, _that.getFacilityReference());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.facilityReference != null ? this.facilityReference.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "LoanContractIdentifierBuilder {facilityReference=" + this.facilityReference + '}' + " " + super.toString();
        }
    }

    public static interface LoanContractIdentifierBuilder
    extends LoanContractIdentifier,
    ContractIdentifier.ContractIdentifierBuilder {
        public FacilityReference.FacilityReferenceBuilder getOrCreateFacilityReference();

        @Override
        public FacilityReference.FacilityReferenceBuilder getFacilityReference();

        @Override
        public LoanContractIdentifierBuilder setPartyReference(PartyReference var1);

        @Override
        public LoanContractIdentifierBuilder addContractId(ContractId var1);

        @Override
        public LoanContractIdentifierBuilder addContractId(ContractId var1, int var2);

        @Override
        public LoanContractIdentifierBuilder addContractId(List<? extends ContractId> var1);

        @Override
        public LoanContractIdentifierBuilder setContractId(List<? extends ContractId> var1);

        @Override
        public LoanContractIdentifierBuilder addVersionedContractId(VersionedContractId var1);

        @Override
        public LoanContractIdentifierBuilder addVersionedContractId(VersionedContractId var1, int var2);

        @Override
        public LoanContractIdentifierBuilder addVersionedContractId(List<? extends VersionedContractId> var1);

        @Override
        public LoanContractIdentifierBuilder setVersionedContractId(List<? extends VersionedContractId> var1);

        @Override
        public LoanContractIdentifierBuilder setId(String var1);

        public LoanContractIdentifierBuilder setFacilityReference(FacilityReference var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("partyReference"), processor, PartyReference.PartyReferenceBuilder.class, (RosettaModelObjectBuilder)this.getPartyReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("contractId"), processor, ContractId.ContractIdBuilder.class, this.getContractId(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("versionedContractId"), processor, VersionedContractId.VersionedContractIdBuilder.class, this.getVersionedContractId(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("facilityReference"), processor, FacilityReference.FacilityReferenceBuilder.class, this.getFacilityReference(), new AttributeMeta[0]);
        }

        @Override
        public LoanContractIdentifierBuilder prune();
    }

    public static class LoanContractIdentifierImpl
    extends ContractIdentifier.ContractIdentifierImpl
    implements LoanContractIdentifier {
        private final FacilityReference facilityReference;

        protected LoanContractIdentifierImpl(LoanContractIdentifierBuilder builder) {
            super(builder);
            this.facilityReference = Optional.ofNullable(builder.getFacilityReference()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="facilityReference", isRequired=true)
        @RuneAttribute(value="facilityReference", isRequired=true)
        public FacilityReference getFacilityReference() {
            return this.facilityReference;
        }

        @Override
        public LoanContractIdentifier build() {
            return this;
        }

        @Override
        public LoanContractIdentifierBuilder toBuilder() {
            LoanContractIdentifierBuilder builder = LoanContractIdentifier.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(LoanContractIdentifierBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getFacilityReference()).ifPresent(builder::setFacilityReference);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LoanContractIdentifier _that = (LoanContractIdentifier)this.getType().cast(o);
            return Objects.equals(this.facilityReference, _that.getFacilityReference());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.facilityReference != null ? this.facilityReference.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "LoanContractIdentifier {facilityReference=" + this.facilityReference + '}' + " " + super.toString();
        }
    }
}

