/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.loan;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.loan.DealRolesModelSequence;
import fpml.consolidated.loan.meta.DealRolesModelMeta;
import fpml.consolidated.shared.PartyReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="DealRolesModel", builder=DealRolesModelBuilderImpl.class, version="1.1.0")
@RuneDataType(value="DealRolesModel", model="fpml", builder=DealRolesModelBuilderImpl.class, version="1.1.0")
public interface DealRolesModel
extends RosettaModelObject {
    public static final DealRolesModelMeta metaData = new DealRolesModelMeta();

    public PartyReference getIssuerPartyReference();

    public List<? extends PartyReference> getGuarantorPartyReference();

    public PartyReference getAgentPartyReference();

    public DealRolesModelSequence getDealRolesModelSequence();

    public DealRolesModel build();

    public DealRolesModelBuilder toBuilder();

    public static DealRolesModelBuilder builder() {
        return new DealRolesModelBuilderImpl();
    }

    default public RosettaMetaData<? extends DealRolesModel> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends DealRolesModel> getType() {
        return DealRolesModel.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("issuerPartyReference"), processor, PartyReference.class, this.getIssuerPartyReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("guarantorPartyReference"), processor, PartyReference.class, this.getGuarantorPartyReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("agentPartyReference"), processor, PartyReference.class, this.getAgentPartyReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("dealRolesModelSequence"), processor, DealRolesModelSequence.class, this.getDealRolesModelSequence(), new AttributeMeta[0]);
    }

    public static class DealRolesModelBuilderImpl
    implements DealRolesModelBuilder {
        protected PartyReference.PartyReferenceBuilder issuerPartyReference;
        protected List<PartyReference.PartyReferenceBuilder> guarantorPartyReference = new ArrayList<PartyReference.PartyReferenceBuilder>();
        protected PartyReference.PartyReferenceBuilder agentPartyReference;
        protected DealRolesModelSequence.DealRolesModelSequenceBuilder dealRolesModelSequence;

        @Override
        @RosettaAttribute(value="issuerPartyReference", isRequired=true)
        @RuneAttribute(value="issuerPartyReference", isRequired=true)
        public PartyReference.PartyReferenceBuilder getIssuerPartyReference() {
            return this.issuerPartyReference;
        }

        @Override
        public PartyReference.PartyReferenceBuilder getOrCreateIssuerPartyReference() {
            PartyReference.PartyReferenceBuilder result = this.issuerPartyReference != null ? this.issuerPartyReference : (this.issuerPartyReference = PartyReference.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="guarantorPartyReference")
        @RuneAttribute(value="guarantorPartyReference")
        public List<? extends PartyReference.PartyReferenceBuilder> getGuarantorPartyReference() {
            return this.guarantorPartyReference;
        }

        @Override
        public PartyReference.PartyReferenceBuilder getOrCreateGuarantorPartyReference(int index) {
            if (this.guarantorPartyReference == null) {
                this.guarantorPartyReference = new ArrayList<PartyReference.PartyReferenceBuilder>();
            }
            return (PartyReference.PartyReferenceBuilder)this.getIndex(this.guarantorPartyReference, index, () -> {
                PartyReference.PartyReferenceBuilder newGuarantorPartyReference = PartyReference.builder();
                return newGuarantorPartyReference;
            });
        }

        @Override
        @RosettaAttribute(value="agentPartyReference", isRequired=true)
        @RuneAttribute(value="agentPartyReference", isRequired=true)
        public PartyReference.PartyReferenceBuilder getAgentPartyReference() {
            return this.agentPartyReference;
        }

        @Override
        public PartyReference.PartyReferenceBuilder getOrCreateAgentPartyReference() {
            PartyReference.PartyReferenceBuilder result = this.agentPartyReference != null ? this.agentPartyReference : (this.agentPartyReference = PartyReference.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="dealRolesModelSequence")
        @RuneAttribute(value="dealRolesModelSequence")
        public DealRolesModelSequence.DealRolesModelSequenceBuilder getDealRolesModelSequence() {
            return this.dealRolesModelSequence;
        }

        @Override
        public DealRolesModelSequence.DealRolesModelSequenceBuilder getOrCreateDealRolesModelSequence() {
            DealRolesModelSequence.DealRolesModelSequenceBuilder result = this.dealRolesModelSequence != null ? this.dealRolesModelSequence : (this.dealRolesModelSequence = DealRolesModelSequence.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="issuerPartyReference", isRequired=true)
        @RuneAttribute(value="issuerPartyReference", isRequired=true)
        public DealRolesModelBuilder setIssuerPartyReference(PartyReference _issuerPartyReference) {
            this.issuerPartyReference = _issuerPartyReference == null ? null : _issuerPartyReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="guarantorPartyReference")
        @RuneAttribute(value="guarantorPartyReference")
        public DealRolesModelBuilder addGuarantorPartyReference(PartyReference _guarantorPartyReference) {
            if (_guarantorPartyReference != null) {
                this.guarantorPartyReference.add(_guarantorPartyReference.toBuilder());
            }
            return this;
        }

        @Override
        public DealRolesModelBuilder addGuarantorPartyReference(PartyReference _guarantorPartyReference, int idx) {
            this.getIndex(this.guarantorPartyReference, idx, () -> _guarantorPartyReference.toBuilder());
            return this;
        }

        @Override
        public DealRolesModelBuilder addGuarantorPartyReference(List<? extends PartyReference> guarantorPartyReferences) {
            if (guarantorPartyReferences != null) {
                for (PartyReference partyReference : guarantorPartyReferences) {
                    this.guarantorPartyReference.add(partyReference.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="guarantorPartyReference")
        public DealRolesModelBuilder setGuarantorPartyReference(List<? extends PartyReference> guarantorPartyReferences) {
            this.guarantorPartyReference = guarantorPartyReferences == null ? new ArrayList<PartyReference.PartyReferenceBuilder>() : (List)guarantorPartyReferences.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="agentPartyReference", isRequired=true)
        @RuneAttribute(value="agentPartyReference", isRequired=true)
        public DealRolesModelBuilder setAgentPartyReference(PartyReference _agentPartyReference) {
            this.agentPartyReference = _agentPartyReference == null ? null : _agentPartyReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="dealRolesModelSequence")
        @RuneAttribute(value="dealRolesModelSequence")
        public DealRolesModelBuilder setDealRolesModelSequence(DealRolesModelSequence _dealRolesModelSequence) {
            this.dealRolesModelSequence = _dealRolesModelSequence == null ? null : _dealRolesModelSequence.toBuilder();
            return this;
        }

        @Override
        public DealRolesModel build() {
            return new DealRolesModelImpl(this);
        }

        @Override
        public DealRolesModelBuilder toBuilder() {
            return this;
        }

        @Override
        public DealRolesModelBuilder prune() {
            if (this.issuerPartyReference != null && !this.issuerPartyReference.prune().hasData()) {
                this.issuerPartyReference = null;
            }
            this.guarantorPartyReference = this.guarantorPartyReference.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.agentPartyReference != null && !this.agentPartyReference.prune().hasData()) {
                this.agentPartyReference = null;
            }
            if (this.dealRolesModelSequence != null && !this.dealRolesModelSequence.prune().hasData()) {
                this.dealRolesModelSequence = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getIssuerPartyReference() != null && this.getIssuerPartyReference().hasData()) {
                return true;
            }
            if (this.getGuarantorPartyReference() != null && this.getGuarantorPartyReference().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getAgentPartyReference() != null && this.getAgentPartyReference().hasData()) {
                return true;
            }
            return this.getDealRolesModelSequence() != null && this.getDealRolesModelSequence().hasData();
        }

        public DealRolesModelBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            DealRolesModelBuilder o = (DealRolesModelBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getIssuerPartyReference(), (RosettaModelObjectBuilder)o.getIssuerPartyReference(), this::setIssuerPartyReference);
            merger.mergeRosetta(this.getGuarantorPartyReference(), o.getGuarantorPartyReference(), this::getOrCreateGuarantorPartyReference);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAgentPartyReference(), (RosettaModelObjectBuilder)o.getAgentPartyReference(), this::setAgentPartyReference);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDealRolesModelSequence(), (RosettaModelObjectBuilder)o.getDealRolesModelSequence(), this::setDealRolesModelSequence);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            DealRolesModel _that = this.getType().cast(o);
            if (!Objects.equals(this.issuerPartyReference, _that.getIssuerPartyReference())) {
                return false;
            }
            if (!ListEquals.listEquals(this.guarantorPartyReference, _that.getGuarantorPartyReference())) {
                return false;
            }
            if (!Objects.equals(this.agentPartyReference, _that.getAgentPartyReference())) {
                return false;
            }
            return Objects.equals(this.dealRolesModelSequence, _that.getDealRolesModelSequence());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.issuerPartyReference != null ? this.issuerPartyReference.hashCode() : 0);
            _result = 31 * _result + (this.guarantorPartyReference != null ? this.guarantorPartyReference.hashCode() : 0);
            _result = 31 * _result + (this.agentPartyReference != null ? this.agentPartyReference.hashCode() : 0);
            _result = 31 * _result + (this.dealRolesModelSequence != null ? this.dealRolesModelSequence.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "DealRolesModelBuilder {issuerPartyReference=" + this.issuerPartyReference + ", guarantorPartyReference=" + this.guarantorPartyReference + ", agentPartyReference=" + this.agentPartyReference + ", dealRolesModelSequence=" + this.dealRolesModelSequence + '}';
        }
    }

    public static interface DealRolesModelBuilder
    extends DealRolesModel,
    RosettaModelObjectBuilder {
        public PartyReference.PartyReferenceBuilder getOrCreateIssuerPartyReference();

        @Override
        public PartyReference.PartyReferenceBuilder getIssuerPartyReference();

        public PartyReference.PartyReferenceBuilder getOrCreateGuarantorPartyReference(int var1);

        public List<? extends PartyReference.PartyReferenceBuilder> getGuarantorPartyReference();

        public PartyReference.PartyReferenceBuilder getOrCreateAgentPartyReference();

        @Override
        public PartyReference.PartyReferenceBuilder getAgentPartyReference();

        public DealRolesModelSequence.DealRolesModelSequenceBuilder getOrCreateDealRolesModelSequence();

        @Override
        public DealRolesModelSequence.DealRolesModelSequenceBuilder getDealRolesModelSequence();

        public DealRolesModelBuilder setIssuerPartyReference(PartyReference var1);

        public DealRolesModelBuilder addGuarantorPartyReference(PartyReference var1);

        public DealRolesModelBuilder addGuarantorPartyReference(PartyReference var1, int var2);

        public DealRolesModelBuilder addGuarantorPartyReference(List<? extends PartyReference> var1);

        public DealRolesModelBuilder setGuarantorPartyReference(List<? extends PartyReference> var1);

        public DealRolesModelBuilder setAgentPartyReference(PartyReference var1);

        public DealRolesModelBuilder setDealRolesModelSequence(DealRolesModelSequence var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("issuerPartyReference"), processor, PartyReference.PartyReferenceBuilder.class, this.getIssuerPartyReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("guarantorPartyReference"), processor, PartyReference.PartyReferenceBuilder.class, this.getGuarantorPartyReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("agentPartyReference"), processor, PartyReference.PartyReferenceBuilder.class, this.getAgentPartyReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("dealRolesModelSequence"), processor, DealRolesModelSequence.DealRolesModelSequenceBuilder.class, this.getDealRolesModelSequence(), new AttributeMeta[0]);
        }

        public DealRolesModelBuilder prune();
    }

    public static class DealRolesModelImpl
    implements DealRolesModel {
        private final PartyReference issuerPartyReference;
        private final List<? extends PartyReference> guarantorPartyReference;
        private final PartyReference agentPartyReference;
        private final DealRolesModelSequence dealRolesModelSequence;

        protected DealRolesModelImpl(DealRolesModelBuilder builder) {
            this.issuerPartyReference = Optional.ofNullable(builder.getIssuerPartyReference()).map(f -> f.build()).orElse(null);
            this.guarantorPartyReference = Optional.ofNullable(builder.getGuarantorPartyReference()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.agentPartyReference = Optional.ofNullable(builder.getAgentPartyReference()).map(f -> f.build()).orElse(null);
            this.dealRolesModelSequence = Optional.ofNullable(builder.getDealRolesModelSequence()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="issuerPartyReference", isRequired=true)
        @RuneAttribute(value="issuerPartyReference", isRequired=true)
        public PartyReference getIssuerPartyReference() {
            return this.issuerPartyReference;
        }

        @Override
        @RosettaAttribute(value="guarantorPartyReference")
        @RuneAttribute(value="guarantorPartyReference")
        public List<? extends PartyReference> getGuarantorPartyReference() {
            return this.guarantorPartyReference;
        }

        @Override
        @RosettaAttribute(value="agentPartyReference", isRequired=true)
        @RuneAttribute(value="agentPartyReference", isRequired=true)
        public PartyReference getAgentPartyReference() {
            return this.agentPartyReference;
        }

        @Override
        @RosettaAttribute(value="dealRolesModelSequence")
        @RuneAttribute(value="dealRolesModelSequence")
        public DealRolesModelSequence getDealRolesModelSequence() {
            return this.dealRolesModelSequence;
        }

        @Override
        public DealRolesModel build() {
            return this;
        }

        @Override
        public DealRolesModelBuilder toBuilder() {
            DealRolesModelBuilder builder = DealRolesModel.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(DealRolesModelBuilder builder) {
            Optional.ofNullable(this.getIssuerPartyReference()).ifPresent(builder::setIssuerPartyReference);
            Optional.ofNullable(this.getGuarantorPartyReference()).ifPresent(builder::setGuarantorPartyReference);
            Optional.ofNullable(this.getAgentPartyReference()).ifPresent(builder::setAgentPartyReference);
            Optional.ofNullable(this.getDealRolesModelSequence()).ifPresent(builder::setDealRolesModelSequence);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            DealRolesModel _that = this.getType().cast(o);
            if (!Objects.equals(this.issuerPartyReference, _that.getIssuerPartyReference())) {
                return false;
            }
            if (!ListEquals.listEquals(this.guarantorPartyReference, _that.getGuarantorPartyReference())) {
                return false;
            }
            if (!Objects.equals(this.agentPartyReference, _that.getAgentPartyReference())) {
                return false;
            }
            return Objects.equals(this.dealRolesModelSequence, _that.getDealRolesModelSequence());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.issuerPartyReference != null ? this.issuerPartyReference.hashCode() : 0);
            _result = 31 * _result + (this.guarantorPartyReference != null ? this.guarantorPartyReference.hashCode() : 0);
            _result = 31 * _result + (this.agentPartyReference != null ? this.agentPartyReference.hashCode() : 0);
            _result = 31 * _result + (this.dealRolesModelSequence != null ? this.dealRolesModelSequence.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "DealRolesModel {issuerPartyReference=" + this.issuerPartyReference + ", guarantorPartyReference=" + this.guarantorPartyReference + ", agentPartyReference=" + this.agentPartyReference + ", dealRolesModelSequence=" + this.dealRolesModelSequence + '}';
        }
    }
}

