/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.loan;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.business.events.BusinessEventIdentifier;
import fpml.consolidated.loan.AbstractLoanEvent;
import fpml.consolidated.loan.AbstractLoanEventSequence;
import fpml.consolidated.loan.LenderAndCashDetailsModel;
import fpml.consolidated.loan.LoanTradeReference;
import fpml.consolidated.loan.meta.AbstractLoanTradeEventMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="AbstractLoanTradeEvent", builder=AbstractLoanTradeEventBuilderImpl.class, version="1.1.0")
@RuneDataType(value="AbstractLoanTradeEvent", model="fpml", builder=AbstractLoanTradeEventBuilderImpl.class, version="1.1.0")
public interface AbstractLoanTradeEvent
extends AbstractLoanEvent {
    public static final AbstractLoanTradeEventMeta metaData = new AbstractLoanTradeEventMeta();

    public LoanTradeReference getLoanTradeReference();

    @Override
    public AbstractLoanTradeEvent build();

    @Override
    public AbstractLoanTradeEventBuilder toBuilder();

    public static AbstractLoanTradeEventBuilder builder() {
        return new AbstractLoanTradeEventBuilderImpl();
    }

    default public RosettaMetaData<? extends AbstractLoanTradeEvent> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends AbstractLoanTradeEvent> getType() {
        return AbstractLoanTradeEvent.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("eventIdentifier"), processor, BusinessEventIdentifier.class, this.getEventIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("abstractLoanEventSequence"), processor, AbstractLoanEventSequence.class, this.getAbstractLoanEventSequence(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("lenderAndCashDetailsModel"), processor, LenderAndCashDetailsModel.class, this.getLenderAndCashDetailsModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("comment"), String.class, (Object)this.getComment(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("loanTradeReference"), processor, LoanTradeReference.class, this.getLoanTradeReference(), new AttributeMeta[0]);
    }

    public static class AbstractLoanTradeEventBuilderImpl
    extends AbstractLoanEvent.AbstractLoanEventBuilderImpl
    implements AbstractLoanTradeEventBuilder {
        protected LoanTradeReference.LoanTradeReferenceBuilder loanTradeReference;

        @Override
        @RosettaAttribute(value="loanTradeReference", isRequired=true)
        @RuneAttribute(value="loanTradeReference", isRequired=true)
        public LoanTradeReference.LoanTradeReferenceBuilder getLoanTradeReference() {
            return this.loanTradeReference;
        }

        @Override
        public LoanTradeReference.LoanTradeReferenceBuilder getOrCreateLoanTradeReference() {
            LoanTradeReference.LoanTradeReferenceBuilder result = this.loanTradeReference != null ? this.loanTradeReference : (this.loanTradeReference = LoanTradeReference.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="eventIdentifier", isRequired=true)
        @RuneAttribute(value="eventIdentifier", isRequired=true)
        public AbstractLoanTradeEventBuilder addEventIdentifier(BusinessEventIdentifier _eventIdentifier) {
            if (_eventIdentifier != null) {
                this.eventIdentifier.add(_eventIdentifier.toBuilder());
            }
            return this;
        }

        @Override
        public AbstractLoanTradeEventBuilder addEventIdentifier(BusinessEventIdentifier _eventIdentifier, int idx) {
            this.getIndex(this.eventIdentifier, idx, () -> _eventIdentifier.toBuilder());
            return this;
        }

        @Override
        public AbstractLoanTradeEventBuilder addEventIdentifier(List<? extends BusinessEventIdentifier> eventIdentifiers) {
            if (eventIdentifiers != null) {
                for (BusinessEventIdentifier businessEventIdentifier : eventIdentifiers) {
                    this.eventIdentifier.add(businessEventIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="eventIdentifier")
        public AbstractLoanTradeEventBuilder setEventIdentifier(List<? extends BusinessEventIdentifier> eventIdentifiers) {
            this.eventIdentifier = eventIdentifiers == null ? new ArrayList() : (List)eventIdentifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="abstractLoanEventSequence")
        @RuneAttribute(value="abstractLoanEventSequence")
        public AbstractLoanTradeEventBuilder setAbstractLoanEventSequence(AbstractLoanEventSequence _abstractLoanEventSequence) {
            this.abstractLoanEventSequence = _abstractLoanEventSequence == null ? null : _abstractLoanEventSequence.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="lenderAndCashDetailsModel")
        @RuneAttribute(value="lenderAndCashDetailsModel")
        public AbstractLoanTradeEventBuilder setLenderAndCashDetailsModel(LenderAndCashDetailsModel _lenderAndCashDetailsModel) {
            this.lenderAndCashDetailsModel = _lenderAndCashDetailsModel == null ? null : _lenderAndCashDetailsModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="comment")
        @RuneAttribute(value="comment")
        public AbstractLoanTradeEventBuilder setComment(String _comment) {
            this.comment = _comment == null ? null : _comment;
            return this;
        }

        @Override
        @RosettaAttribute(value="loanTradeReference", isRequired=true)
        @RuneAttribute(value="loanTradeReference", isRequired=true)
        public AbstractLoanTradeEventBuilder setLoanTradeReference(LoanTradeReference _loanTradeReference) {
            this.loanTradeReference = _loanTradeReference == null ? null : _loanTradeReference.toBuilder();
            return this;
        }

        @Override
        public AbstractLoanTradeEvent build() {
            return new AbstractLoanTradeEventImpl(this);
        }

        @Override
        public AbstractLoanTradeEventBuilder toBuilder() {
            return this;
        }

        @Override
        public AbstractLoanTradeEventBuilder prune() {
            super.prune();
            if (this.loanTradeReference != null && !this.loanTradeReference.prune().hasData()) {
                this.loanTradeReference = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            return this.getLoanTradeReference() != null && this.getLoanTradeReference().hasData();
        }

        @Override
        public AbstractLoanTradeEventBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            AbstractLoanTradeEventBuilder o = (AbstractLoanTradeEventBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getLoanTradeReference(), (RosettaModelObjectBuilder)o.getLoanTradeReference(), this::setLoanTradeReference);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            AbstractLoanTradeEvent _that = (AbstractLoanTradeEvent)this.getType().cast(o);
            return Objects.equals(this.loanTradeReference, _that.getLoanTradeReference());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.loanTradeReference != null ? this.loanTradeReference.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "AbstractLoanTradeEventBuilder {loanTradeReference=" + this.loanTradeReference + '}' + " " + super.toString();
        }
    }

    public static interface AbstractLoanTradeEventBuilder
    extends AbstractLoanTradeEvent,
    AbstractLoanEvent.AbstractLoanEventBuilder {
        public LoanTradeReference.LoanTradeReferenceBuilder getOrCreateLoanTradeReference();

        @Override
        public LoanTradeReference.LoanTradeReferenceBuilder getLoanTradeReference();

        @Override
        public AbstractLoanTradeEventBuilder addEventIdentifier(BusinessEventIdentifier var1);

        @Override
        public AbstractLoanTradeEventBuilder addEventIdentifier(BusinessEventIdentifier var1, int var2);

        @Override
        public AbstractLoanTradeEventBuilder addEventIdentifier(List<? extends BusinessEventIdentifier> var1);

        @Override
        public AbstractLoanTradeEventBuilder setEventIdentifier(List<? extends BusinessEventIdentifier> var1);

        @Override
        public AbstractLoanTradeEventBuilder setAbstractLoanEventSequence(AbstractLoanEventSequence var1);

        @Override
        public AbstractLoanTradeEventBuilder setLenderAndCashDetailsModel(LenderAndCashDetailsModel var1);

        @Override
        public AbstractLoanTradeEventBuilder setComment(String var1);

        public AbstractLoanTradeEventBuilder setLoanTradeReference(LoanTradeReference var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("eventIdentifier"), processor, BusinessEventIdentifier.BusinessEventIdentifierBuilder.class, this.getEventIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("abstractLoanEventSequence"), processor, AbstractLoanEventSequence.AbstractLoanEventSequenceBuilder.class, (RosettaModelObjectBuilder)this.getAbstractLoanEventSequence(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("lenderAndCashDetailsModel"), processor, LenderAndCashDetailsModel.LenderAndCashDetailsModelBuilder.class, (RosettaModelObjectBuilder)this.getLenderAndCashDetailsModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("comment"), String.class, (Object)this.getComment(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("loanTradeReference"), processor, LoanTradeReference.LoanTradeReferenceBuilder.class, this.getLoanTradeReference(), new AttributeMeta[0]);
        }

        @Override
        public AbstractLoanTradeEventBuilder prune();
    }

    public static class AbstractLoanTradeEventImpl
    extends AbstractLoanEvent.AbstractLoanEventImpl
    implements AbstractLoanTradeEvent {
        private final LoanTradeReference loanTradeReference;

        protected AbstractLoanTradeEventImpl(AbstractLoanTradeEventBuilder builder) {
            super(builder);
            this.loanTradeReference = Optional.ofNullable(builder.getLoanTradeReference()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="loanTradeReference", isRequired=true)
        @RuneAttribute(value="loanTradeReference", isRequired=true)
        public LoanTradeReference getLoanTradeReference() {
            return this.loanTradeReference;
        }

        @Override
        public AbstractLoanTradeEvent build() {
            return this;
        }

        @Override
        public AbstractLoanTradeEventBuilder toBuilder() {
            AbstractLoanTradeEventBuilder builder = AbstractLoanTradeEvent.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(AbstractLoanTradeEventBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getLoanTradeReference()).ifPresent(builder::setLoanTradeReference);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            AbstractLoanTradeEvent _that = (AbstractLoanTradeEvent)this.getType().cast(o);
            return Objects.equals(this.loanTradeReference, _that.getLoanTradeReference());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.loanTradeReference != null ? this.loanTradeReference.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "AbstractLoanTradeEvent {loanTradeReference=" + this.loanTradeReference + '}' + " " + super.toString();
        }
    }
}

