/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.loan;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.loan.AccrualTypeId;
import fpml.consolidated.loan.meta.AbstractAccrualOptionBaseMeta;
import fpml.consolidated.shared.DayCountFraction;
import fpml.consolidated.shared.Period;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="AbstractAccrualOptionBase", builder=AbstractAccrualOptionBaseBuilderImpl.class, version="1.1.0")
@RuneDataType(value="AbstractAccrualOptionBase", model="fpml", builder=AbstractAccrualOptionBaseBuilderImpl.class, version="1.1.0")
public interface AbstractAccrualOptionBase
extends RosettaModelObject {
    public static final AbstractAccrualOptionBaseMeta metaData = new AbstractAccrualOptionBaseMeta();

    public AccrualTypeId getAccrualOptionId();

    public DayCountFraction getDayCountFraction();

    public Period getPaymentFrequency();

    public AbstractAccrualOptionBase build();

    public AbstractAccrualOptionBaseBuilder toBuilder();

    public static AbstractAccrualOptionBaseBuilder builder() {
        return new AbstractAccrualOptionBaseBuilderImpl();
    }

    default public RosettaMetaData<? extends AbstractAccrualOptionBase> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends AbstractAccrualOptionBase> getType() {
        return AbstractAccrualOptionBase.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("accrualOptionId"), processor, AccrualTypeId.class, this.getAccrualOptionId(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("dayCountFraction"), processor, DayCountFraction.class, this.getDayCountFraction(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("paymentFrequency"), processor, Period.class, this.getPaymentFrequency(), new AttributeMeta[0]);
    }

    public static class AbstractAccrualOptionBaseBuilderImpl
    implements AbstractAccrualOptionBaseBuilder {
        protected AccrualTypeId.AccrualTypeIdBuilder accrualOptionId;
        protected DayCountFraction.DayCountFractionBuilder dayCountFraction;
        protected Period.PeriodBuilder paymentFrequency;

        @Override
        @RosettaAttribute(value="accrualOptionId", isRequired=true)
        @RuneAttribute(value="accrualOptionId", isRequired=true)
        public AccrualTypeId.AccrualTypeIdBuilder getAccrualOptionId() {
            return this.accrualOptionId;
        }

        @Override
        public AccrualTypeId.AccrualTypeIdBuilder getOrCreateAccrualOptionId() {
            AccrualTypeId.AccrualTypeIdBuilder result = this.accrualOptionId != null ? this.accrualOptionId : (this.accrualOptionId = AccrualTypeId.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="dayCountFraction", isRequired=true)
        @RuneAttribute(value="dayCountFraction", isRequired=true)
        public DayCountFraction.DayCountFractionBuilder getDayCountFraction() {
            return this.dayCountFraction;
        }

        @Override
        public DayCountFraction.DayCountFractionBuilder getOrCreateDayCountFraction() {
            DayCountFraction.DayCountFractionBuilder result = this.dayCountFraction != null ? this.dayCountFraction : (this.dayCountFraction = DayCountFraction.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="paymentFrequency")
        @RuneAttribute(value="paymentFrequency")
        public Period.PeriodBuilder getPaymentFrequency() {
            return this.paymentFrequency;
        }

        @Override
        public Period.PeriodBuilder getOrCreatePaymentFrequency() {
            Period.PeriodBuilder result = this.paymentFrequency != null ? this.paymentFrequency : (this.paymentFrequency = Period.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="accrualOptionId", isRequired=true)
        @RuneAttribute(value="accrualOptionId", isRequired=true)
        public AbstractAccrualOptionBaseBuilder setAccrualOptionId(AccrualTypeId _accrualOptionId) {
            this.accrualOptionId = _accrualOptionId == null ? null : _accrualOptionId.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="dayCountFraction", isRequired=true)
        @RuneAttribute(value="dayCountFraction", isRequired=true)
        public AbstractAccrualOptionBaseBuilder setDayCountFraction(DayCountFraction _dayCountFraction) {
            this.dayCountFraction = _dayCountFraction == null ? null : _dayCountFraction.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="paymentFrequency")
        @RuneAttribute(value="paymentFrequency")
        public AbstractAccrualOptionBaseBuilder setPaymentFrequency(Period _paymentFrequency) {
            this.paymentFrequency = _paymentFrequency == null ? null : _paymentFrequency.toBuilder();
            return this;
        }

        @Override
        public AbstractAccrualOptionBase build() {
            return new AbstractAccrualOptionBaseImpl(this);
        }

        @Override
        public AbstractAccrualOptionBaseBuilder toBuilder() {
            return this;
        }

        @Override
        public AbstractAccrualOptionBaseBuilder prune() {
            if (this.accrualOptionId != null && !this.accrualOptionId.prune().hasData()) {
                this.accrualOptionId = null;
            }
            if (this.dayCountFraction != null && !this.dayCountFraction.prune().hasData()) {
                this.dayCountFraction = null;
            }
            if (this.paymentFrequency != null && !this.paymentFrequency.prune().hasData()) {
                this.paymentFrequency = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getAccrualOptionId() != null && this.getAccrualOptionId().hasData()) {
                return true;
            }
            if (this.getDayCountFraction() != null && this.getDayCountFraction().hasData()) {
                return true;
            }
            return this.getPaymentFrequency() != null && this.getPaymentFrequency().hasData();
        }

        public AbstractAccrualOptionBaseBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            AbstractAccrualOptionBaseBuilder o = (AbstractAccrualOptionBaseBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAccrualOptionId(), (RosettaModelObjectBuilder)o.getAccrualOptionId(), this::setAccrualOptionId);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDayCountFraction(), (RosettaModelObjectBuilder)o.getDayCountFraction(), this::setDayCountFraction);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPaymentFrequency(), (RosettaModelObjectBuilder)o.getPaymentFrequency(), this::setPaymentFrequency);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            AbstractAccrualOptionBase _that = this.getType().cast(o);
            if (!Objects.equals(this.accrualOptionId, _that.getAccrualOptionId())) {
                return false;
            }
            if (!Objects.equals(this.dayCountFraction, _that.getDayCountFraction())) {
                return false;
            }
            return Objects.equals(this.paymentFrequency, _that.getPaymentFrequency());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.accrualOptionId != null ? this.accrualOptionId.hashCode() : 0);
            _result = 31 * _result + (this.dayCountFraction != null ? this.dayCountFraction.hashCode() : 0);
            _result = 31 * _result + (this.paymentFrequency != null ? this.paymentFrequency.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "AbstractAccrualOptionBaseBuilder {accrualOptionId=" + this.accrualOptionId + ", dayCountFraction=" + this.dayCountFraction + ", paymentFrequency=" + this.paymentFrequency + '}';
        }
    }

    public static interface AbstractAccrualOptionBaseBuilder
    extends AbstractAccrualOptionBase,
    RosettaModelObjectBuilder {
        public AccrualTypeId.AccrualTypeIdBuilder getOrCreateAccrualOptionId();

        @Override
        public AccrualTypeId.AccrualTypeIdBuilder getAccrualOptionId();

        public DayCountFraction.DayCountFractionBuilder getOrCreateDayCountFraction();

        @Override
        public DayCountFraction.DayCountFractionBuilder getDayCountFraction();

        public Period.PeriodBuilder getOrCreatePaymentFrequency();

        @Override
        public Period.PeriodBuilder getPaymentFrequency();

        public AbstractAccrualOptionBaseBuilder setAccrualOptionId(AccrualTypeId var1);

        public AbstractAccrualOptionBaseBuilder setDayCountFraction(DayCountFraction var1);

        public AbstractAccrualOptionBaseBuilder setPaymentFrequency(Period var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("accrualOptionId"), processor, AccrualTypeId.AccrualTypeIdBuilder.class, this.getAccrualOptionId(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("dayCountFraction"), processor, DayCountFraction.DayCountFractionBuilder.class, this.getDayCountFraction(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("paymentFrequency"), processor, Period.PeriodBuilder.class, this.getPaymentFrequency(), new AttributeMeta[0]);
        }

        public AbstractAccrualOptionBaseBuilder prune();
    }

    public static class AbstractAccrualOptionBaseImpl
    implements AbstractAccrualOptionBase {
        private final AccrualTypeId accrualOptionId;
        private final DayCountFraction dayCountFraction;
        private final Period paymentFrequency;

        protected AbstractAccrualOptionBaseImpl(AbstractAccrualOptionBaseBuilder builder) {
            this.accrualOptionId = Optional.ofNullable(builder.getAccrualOptionId()).map(f -> f.build()).orElse(null);
            this.dayCountFraction = Optional.ofNullable(builder.getDayCountFraction()).map(f -> f.build()).orElse(null);
            this.paymentFrequency = Optional.ofNullable(builder.getPaymentFrequency()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="accrualOptionId", isRequired=true)
        @RuneAttribute(value="accrualOptionId", isRequired=true)
        public AccrualTypeId getAccrualOptionId() {
            return this.accrualOptionId;
        }

        @Override
        @RosettaAttribute(value="dayCountFraction", isRequired=true)
        @RuneAttribute(value="dayCountFraction", isRequired=true)
        public DayCountFraction getDayCountFraction() {
            return this.dayCountFraction;
        }

        @Override
        @RosettaAttribute(value="paymentFrequency")
        @RuneAttribute(value="paymentFrequency")
        public Period getPaymentFrequency() {
            return this.paymentFrequency;
        }

        @Override
        public AbstractAccrualOptionBase build() {
            return this;
        }

        @Override
        public AbstractAccrualOptionBaseBuilder toBuilder() {
            AbstractAccrualOptionBaseBuilder builder = AbstractAccrualOptionBase.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(AbstractAccrualOptionBaseBuilder builder) {
            Optional.ofNullable(this.getAccrualOptionId()).ifPresent(builder::setAccrualOptionId);
            Optional.ofNullable(this.getDayCountFraction()).ifPresent(builder::setDayCountFraction);
            Optional.ofNullable(this.getPaymentFrequency()).ifPresent(builder::setPaymentFrequency);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            AbstractAccrualOptionBase _that = this.getType().cast(o);
            if (!Objects.equals(this.accrualOptionId, _that.getAccrualOptionId())) {
                return false;
            }
            if (!Objects.equals(this.dayCountFraction, _that.getDayCountFraction())) {
                return false;
            }
            return Objects.equals(this.paymentFrequency, _that.getPaymentFrequency());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.accrualOptionId != null ? this.accrualOptionId.hashCode() : 0);
            _result = 31 * _result + (this.dayCountFraction != null ? this.dayCountFraction.hashCode() : 0);
            _result = 31 * _result + (this.paymentFrequency != null ? this.paymentFrequency.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "AbstractAccrualOptionBase {accrualOptionId=" + this.accrualOptionId + ", dayCountFraction=" + this.dayCountFraction + ", paymentFrequency=" + this.paymentFrequency + '}';
        }
    }
}

