/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.ird;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.ird.FloatingRateDefinition;
import fpml.consolidated.ird.FxLinkedNotionalAmount;
import fpml.consolidated.ird.meta.CalculationPeriodMeta;
import fpml.consolidated.shared.Money;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="CalculationPeriod", builder=CalculationPeriodBuilderImpl.class, version="1.1.0")
@RuneDataType(value="CalculationPeriod", model="fpml", builder=CalculationPeriodBuilderImpl.class, version="1.1.0")
public interface CalculationPeriod
extends RosettaModelObject {
    public static final CalculationPeriodMeta metaData = new CalculationPeriodMeta();

    public ZonedDateTime getUnadjustedStartDate();

    public ZonedDateTime getUnadjustedEndDate();

    public ZonedDateTime getAdjustedStartDate();

    public ZonedDateTime getAdjustedEndDate();

    public Integer getCalculationPeriodNumberOfDays();

    public BigDecimal getNotionalAmount();

    public FxLinkedNotionalAmount getFxLinkedNotionalAmount();

    public FloatingRateDefinition getFloatingRateDefinition();

    public BigDecimal getFixedRate();

    public BigDecimal getDayCountYearFraction();

    public Money getForecastAmount();

    public BigDecimal getForecastRate();

    public String getId();

    public CalculationPeriod build();

    public CalculationPeriodBuilder toBuilder();

    public static CalculationPeriodBuilder builder() {
        return new CalculationPeriodBuilderImpl();
    }

    default public RosettaMetaData<? extends CalculationPeriod> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends CalculationPeriod> getType() {
        return CalculationPeriod.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("unadjustedStartDate"), ZonedDateTime.class, (Object)this.getUnadjustedStartDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("unadjustedEndDate"), ZonedDateTime.class, (Object)this.getUnadjustedEndDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("adjustedStartDate"), ZonedDateTime.class, (Object)this.getAdjustedStartDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("adjustedEndDate"), ZonedDateTime.class, (Object)this.getAdjustedEndDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("calculationPeriodNumberOfDays"), Integer.class, (Object)this.getCalculationPeriodNumberOfDays(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("notionalAmount"), BigDecimal.class, (Object)this.getNotionalAmount(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("fxLinkedNotionalAmount"), processor, FxLinkedNotionalAmount.class, this.getFxLinkedNotionalAmount(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("floatingRateDefinition"), processor, FloatingRateDefinition.class, this.getFloatingRateDefinition(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("fixedRate"), BigDecimal.class, (Object)this.getFixedRate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("dayCountYearFraction"), BigDecimal.class, (Object)this.getDayCountYearFraction(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("forecastAmount"), processor, Money.class, this.getForecastAmount(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("forecastRate"), BigDecimal.class, (Object)this.getForecastRate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class CalculationPeriodBuilderImpl
    implements CalculationPeriodBuilder {
        protected ZonedDateTime unadjustedStartDate;
        protected ZonedDateTime unadjustedEndDate;
        protected ZonedDateTime adjustedStartDate;
        protected ZonedDateTime adjustedEndDate;
        protected Integer calculationPeriodNumberOfDays;
        protected BigDecimal notionalAmount;
        protected FxLinkedNotionalAmount.FxLinkedNotionalAmountBuilder fxLinkedNotionalAmount;
        protected FloatingRateDefinition.FloatingRateDefinitionBuilder floatingRateDefinition;
        protected BigDecimal fixedRate;
        protected BigDecimal dayCountYearFraction;
        protected Money.MoneyBuilder forecastAmount;
        protected BigDecimal forecastRate;
        protected String id;

        @Override
        @RosettaAttribute(value="unadjustedStartDate")
        @RuneAttribute(value="unadjustedStartDate")
        public ZonedDateTime getUnadjustedStartDate() {
            return this.unadjustedStartDate;
        }

        @Override
        @RosettaAttribute(value="unadjustedEndDate")
        @RuneAttribute(value="unadjustedEndDate")
        public ZonedDateTime getUnadjustedEndDate() {
            return this.unadjustedEndDate;
        }

        @Override
        @RosettaAttribute(value="adjustedStartDate")
        @RuneAttribute(value="adjustedStartDate")
        public ZonedDateTime getAdjustedStartDate() {
            return this.adjustedStartDate;
        }

        @Override
        @RosettaAttribute(value="adjustedEndDate")
        @RuneAttribute(value="adjustedEndDate")
        public ZonedDateTime getAdjustedEndDate() {
            return this.adjustedEndDate;
        }

        @Override
        @RosettaAttribute(value="calculationPeriodNumberOfDays")
        @RuneAttribute(value="calculationPeriodNumberOfDays")
        public Integer getCalculationPeriodNumberOfDays() {
            return this.calculationPeriodNumberOfDays;
        }

        @Override
        @RosettaAttribute(value="notionalAmount")
        @RuneAttribute(value="notionalAmount")
        public BigDecimal getNotionalAmount() {
            return this.notionalAmount;
        }

        @Override
        @RosettaAttribute(value="fxLinkedNotionalAmount")
        @RuneAttribute(value="fxLinkedNotionalAmount")
        public FxLinkedNotionalAmount.FxLinkedNotionalAmountBuilder getFxLinkedNotionalAmount() {
            return this.fxLinkedNotionalAmount;
        }

        @Override
        public FxLinkedNotionalAmount.FxLinkedNotionalAmountBuilder getOrCreateFxLinkedNotionalAmount() {
            FxLinkedNotionalAmount.FxLinkedNotionalAmountBuilder result = this.fxLinkedNotionalAmount != null ? this.fxLinkedNotionalAmount : (this.fxLinkedNotionalAmount = FxLinkedNotionalAmount.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="floatingRateDefinition")
        @RuneAttribute(value="floatingRateDefinition")
        public FloatingRateDefinition.FloatingRateDefinitionBuilder getFloatingRateDefinition() {
            return this.floatingRateDefinition;
        }

        @Override
        public FloatingRateDefinition.FloatingRateDefinitionBuilder getOrCreateFloatingRateDefinition() {
            FloatingRateDefinition.FloatingRateDefinitionBuilder result = this.floatingRateDefinition != null ? this.floatingRateDefinition : (this.floatingRateDefinition = FloatingRateDefinition.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="fixedRate")
        @RuneAttribute(value="fixedRate")
        public BigDecimal getFixedRate() {
            return this.fixedRate;
        }

        @Override
        @RosettaAttribute(value="dayCountYearFraction")
        @RuneAttribute(value="dayCountYearFraction")
        public BigDecimal getDayCountYearFraction() {
            return this.dayCountYearFraction;
        }

        @Override
        @RosettaAttribute(value="forecastAmount")
        @RuneAttribute(value="forecastAmount")
        public Money.MoneyBuilder getForecastAmount() {
            return this.forecastAmount;
        }

        @Override
        public Money.MoneyBuilder getOrCreateForecastAmount() {
            Money.MoneyBuilder result = this.forecastAmount != null ? this.forecastAmount : (this.forecastAmount = Money.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="forecastRate")
        @RuneAttribute(value="forecastRate")
        public BigDecimal getForecastRate() {
            return this.forecastRate;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public String getId() {
            return this.id;
        }

        @Override
        @RosettaAttribute(value="unadjustedStartDate")
        @RuneAttribute(value="unadjustedStartDate")
        public CalculationPeriodBuilder setUnadjustedStartDate(ZonedDateTime _unadjustedStartDate) {
            this.unadjustedStartDate = _unadjustedStartDate == null ? null : _unadjustedStartDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="unadjustedEndDate")
        @RuneAttribute(value="unadjustedEndDate")
        public CalculationPeriodBuilder setUnadjustedEndDate(ZonedDateTime _unadjustedEndDate) {
            this.unadjustedEndDate = _unadjustedEndDate == null ? null : _unadjustedEndDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="adjustedStartDate")
        @RuneAttribute(value="adjustedStartDate")
        public CalculationPeriodBuilder setAdjustedStartDate(ZonedDateTime _adjustedStartDate) {
            this.adjustedStartDate = _adjustedStartDate == null ? null : _adjustedStartDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="adjustedEndDate")
        @RuneAttribute(value="adjustedEndDate")
        public CalculationPeriodBuilder setAdjustedEndDate(ZonedDateTime _adjustedEndDate) {
            this.adjustedEndDate = _adjustedEndDate == null ? null : _adjustedEndDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="calculationPeriodNumberOfDays")
        @RuneAttribute(value="calculationPeriodNumberOfDays")
        public CalculationPeriodBuilder setCalculationPeriodNumberOfDays(Integer _calculationPeriodNumberOfDays) {
            this.calculationPeriodNumberOfDays = _calculationPeriodNumberOfDays == null ? null : _calculationPeriodNumberOfDays;
            return this;
        }

        @Override
        @RosettaAttribute(value="notionalAmount")
        @RuneAttribute(value="notionalAmount")
        public CalculationPeriodBuilder setNotionalAmount(BigDecimal _notionalAmount) {
            this.notionalAmount = _notionalAmount == null ? null : _notionalAmount;
            return this;
        }

        @Override
        @RosettaAttribute(value="fxLinkedNotionalAmount")
        @RuneAttribute(value="fxLinkedNotionalAmount")
        public CalculationPeriodBuilder setFxLinkedNotionalAmount(FxLinkedNotionalAmount _fxLinkedNotionalAmount) {
            this.fxLinkedNotionalAmount = _fxLinkedNotionalAmount == null ? null : _fxLinkedNotionalAmount.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="floatingRateDefinition")
        @RuneAttribute(value="floatingRateDefinition")
        public CalculationPeriodBuilder setFloatingRateDefinition(FloatingRateDefinition _floatingRateDefinition) {
            this.floatingRateDefinition = _floatingRateDefinition == null ? null : _floatingRateDefinition.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="fixedRate")
        @RuneAttribute(value="fixedRate")
        public CalculationPeriodBuilder setFixedRate(BigDecimal _fixedRate) {
            this.fixedRate = _fixedRate == null ? null : _fixedRate;
            return this;
        }

        @Override
        @RosettaAttribute(value="dayCountYearFraction")
        @RuneAttribute(value="dayCountYearFraction")
        public CalculationPeriodBuilder setDayCountYearFraction(BigDecimal _dayCountYearFraction) {
            this.dayCountYearFraction = _dayCountYearFraction == null ? null : _dayCountYearFraction;
            return this;
        }

        @Override
        @RosettaAttribute(value="forecastAmount")
        @RuneAttribute(value="forecastAmount")
        public CalculationPeriodBuilder setForecastAmount(Money _forecastAmount) {
            this.forecastAmount = _forecastAmount == null ? null : _forecastAmount.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="forecastRate")
        @RuneAttribute(value="forecastRate")
        public CalculationPeriodBuilder setForecastRate(BigDecimal _forecastRate) {
            this.forecastRate = _forecastRate == null ? null : _forecastRate;
            return this;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public CalculationPeriodBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        public CalculationPeriod build() {
            return new CalculationPeriodImpl(this);
        }

        @Override
        public CalculationPeriodBuilder toBuilder() {
            return this;
        }

        @Override
        public CalculationPeriodBuilder prune() {
            if (this.fxLinkedNotionalAmount != null && !this.fxLinkedNotionalAmount.prune().hasData()) {
                this.fxLinkedNotionalAmount = null;
            }
            if (this.floatingRateDefinition != null && !this.floatingRateDefinition.prune().hasData()) {
                this.floatingRateDefinition = null;
            }
            if (this.forecastAmount != null && !this.forecastAmount.prune().hasData()) {
                this.forecastAmount = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getUnadjustedStartDate() != null) {
                return true;
            }
            if (this.getUnadjustedEndDate() != null) {
                return true;
            }
            if (this.getAdjustedStartDate() != null) {
                return true;
            }
            if (this.getAdjustedEndDate() != null) {
                return true;
            }
            if (this.getCalculationPeriodNumberOfDays() != null) {
                return true;
            }
            if (this.getNotionalAmount() != null) {
                return true;
            }
            if (this.getFxLinkedNotionalAmount() != null && this.getFxLinkedNotionalAmount().hasData()) {
                return true;
            }
            if (this.getFloatingRateDefinition() != null && this.getFloatingRateDefinition().hasData()) {
                return true;
            }
            if (this.getFixedRate() != null) {
                return true;
            }
            if (this.getDayCountYearFraction() != null) {
                return true;
            }
            if (this.getForecastAmount() != null && this.getForecastAmount().hasData()) {
                return true;
            }
            if (this.getForecastRate() != null) {
                return true;
            }
            return this.getId() != null;
        }

        public CalculationPeriodBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            CalculationPeriodBuilder o = (CalculationPeriodBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFxLinkedNotionalAmount(), (RosettaModelObjectBuilder)o.getFxLinkedNotionalAmount(), this::setFxLinkedNotionalAmount);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFloatingRateDefinition(), (RosettaModelObjectBuilder)o.getFloatingRateDefinition(), this::setFloatingRateDefinition);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getForecastAmount(), (RosettaModelObjectBuilder)o.getForecastAmount(), this::setForecastAmount);
            merger.mergeBasic((Object)this.getUnadjustedStartDate(), (Object)o.getUnadjustedStartDate(), this::setUnadjustedStartDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getUnadjustedEndDate(), (Object)o.getUnadjustedEndDate(), this::setUnadjustedEndDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getAdjustedStartDate(), (Object)o.getAdjustedStartDate(), this::setAdjustedStartDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getAdjustedEndDate(), (Object)o.getAdjustedEndDate(), this::setAdjustedEndDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCalculationPeriodNumberOfDays(), (Object)o.getCalculationPeriodNumberOfDays(), this::setCalculationPeriodNumberOfDays, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getNotionalAmount(), (Object)o.getNotionalAmount(), this::setNotionalAmount, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFixedRate(), (Object)o.getFixedRate(), this::setFixedRate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getDayCountYearFraction(), (Object)o.getDayCountYearFraction(), this::setDayCountYearFraction, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getForecastRate(), (Object)o.getForecastRate(), this::setForecastRate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getId(), (Object)o.getId(), this::setId, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CalculationPeriod _that = this.getType().cast(o);
            if (!Objects.equals(this.unadjustedStartDate, _that.getUnadjustedStartDate())) {
                return false;
            }
            if (!Objects.equals(this.unadjustedEndDate, _that.getUnadjustedEndDate())) {
                return false;
            }
            if (!Objects.equals(this.adjustedStartDate, _that.getAdjustedStartDate())) {
                return false;
            }
            if (!Objects.equals(this.adjustedEndDate, _that.getAdjustedEndDate())) {
                return false;
            }
            if (!Objects.equals(this.calculationPeriodNumberOfDays, _that.getCalculationPeriodNumberOfDays())) {
                return false;
            }
            if (!Objects.equals(this.notionalAmount, _that.getNotionalAmount())) {
                return false;
            }
            if (!Objects.equals(this.fxLinkedNotionalAmount, _that.getFxLinkedNotionalAmount())) {
                return false;
            }
            if (!Objects.equals(this.floatingRateDefinition, _that.getFloatingRateDefinition())) {
                return false;
            }
            if (!Objects.equals(this.fixedRate, _that.getFixedRate())) {
                return false;
            }
            if (!Objects.equals(this.dayCountYearFraction, _that.getDayCountYearFraction())) {
                return false;
            }
            if (!Objects.equals(this.forecastAmount, _that.getForecastAmount())) {
                return false;
            }
            if (!Objects.equals(this.forecastRate, _that.getForecastRate())) {
                return false;
            }
            return Objects.equals(this.id, _that.getId());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.unadjustedStartDate != null ? this.unadjustedStartDate.hashCode() : 0);
            _result = 31 * _result + (this.unadjustedEndDate != null ? this.unadjustedEndDate.hashCode() : 0);
            _result = 31 * _result + (this.adjustedStartDate != null ? this.adjustedStartDate.hashCode() : 0);
            _result = 31 * _result + (this.adjustedEndDate != null ? this.adjustedEndDate.hashCode() : 0);
            _result = 31 * _result + (this.calculationPeriodNumberOfDays != null ? this.calculationPeriodNumberOfDays.hashCode() : 0);
            _result = 31 * _result + (this.notionalAmount != null ? this.notionalAmount.hashCode() : 0);
            _result = 31 * _result + (this.fxLinkedNotionalAmount != null ? this.fxLinkedNotionalAmount.hashCode() : 0);
            _result = 31 * _result + (this.floatingRateDefinition != null ? this.floatingRateDefinition.hashCode() : 0);
            _result = 31 * _result + (this.fixedRate != null ? this.fixedRate.hashCode() : 0);
            _result = 31 * _result + (this.dayCountYearFraction != null ? this.dayCountYearFraction.hashCode() : 0);
            _result = 31 * _result + (this.forecastAmount != null ? this.forecastAmount.hashCode() : 0);
            _result = 31 * _result + (this.forecastRate != null ? this.forecastRate.hashCode() : 0);
            _result = 31 * _result + (this.id != null ? this.id.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CalculationPeriodBuilder {unadjustedStartDate=" + this.unadjustedStartDate + ", unadjustedEndDate=" + this.unadjustedEndDate + ", adjustedStartDate=" + this.adjustedStartDate + ", adjustedEndDate=" + this.adjustedEndDate + ", calculationPeriodNumberOfDays=" + this.calculationPeriodNumberOfDays + ", notionalAmount=" + this.notionalAmount + ", fxLinkedNotionalAmount=" + this.fxLinkedNotionalAmount + ", floatingRateDefinition=" + this.floatingRateDefinition + ", fixedRate=" + this.fixedRate + ", dayCountYearFraction=" + this.dayCountYearFraction + ", forecastAmount=" + this.forecastAmount + ", forecastRate=" + this.forecastRate + ", id=" + this.id + '}';
        }
    }

    public static interface CalculationPeriodBuilder
    extends CalculationPeriod,
    RosettaModelObjectBuilder {
        public FxLinkedNotionalAmount.FxLinkedNotionalAmountBuilder getOrCreateFxLinkedNotionalAmount();

        @Override
        public FxLinkedNotionalAmount.FxLinkedNotionalAmountBuilder getFxLinkedNotionalAmount();

        public FloatingRateDefinition.FloatingRateDefinitionBuilder getOrCreateFloatingRateDefinition();

        @Override
        public FloatingRateDefinition.FloatingRateDefinitionBuilder getFloatingRateDefinition();

        public Money.MoneyBuilder getOrCreateForecastAmount();

        @Override
        public Money.MoneyBuilder getForecastAmount();

        public CalculationPeriodBuilder setUnadjustedStartDate(ZonedDateTime var1);

        public CalculationPeriodBuilder setUnadjustedEndDate(ZonedDateTime var1);

        public CalculationPeriodBuilder setAdjustedStartDate(ZonedDateTime var1);

        public CalculationPeriodBuilder setAdjustedEndDate(ZonedDateTime var1);

        public CalculationPeriodBuilder setCalculationPeriodNumberOfDays(Integer var1);

        public CalculationPeriodBuilder setNotionalAmount(BigDecimal var1);

        public CalculationPeriodBuilder setFxLinkedNotionalAmount(FxLinkedNotionalAmount var1);

        public CalculationPeriodBuilder setFloatingRateDefinition(FloatingRateDefinition var1);

        public CalculationPeriodBuilder setFixedRate(BigDecimal var1);

        public CalculationPeriodBuilder setDayCountYearFraction(BigDecimal var1);

        public CalculationPeriodBuilder setForecastAmount(Money var1);

        public CalculationPeriodBuilder setForecastRate(BigDecimal var1);

        public CalculationPeriodBuilder setId(String var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("unadjustedStartDate"), ZonedDateTime.class, (Object)this.getUnadjustedStartDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("unadjustedEndDate"), ZonedDateTime.class, (Object)this.getUnadjustedEndDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("adjustedStartDate"), ZonedDateTime.class, (Object)this.getAdjustedStartDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("adjustedEndDate"), ZonedDateTime.class, (Object)this.getAdjustedEndDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("calculationPeriodNumberOfDays"), Integer.class, (Object)this.getCalculationPeriodNumberOfDays(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("notionalAmount"), BigDecimal.class, (Object)this.getNotionalAmount(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("fxLinkedNotionalAmount"), processor, FxLinkedNotionalAmount.FxLinkedNotionalAmountBuilder.class, this.getFxLinkedNotionalAmount(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("floatingRateDefinition"), processor, FloatingRateDefinition.FloatingRateDefinitionBuilder.class, this.getFloatingRateDefinition(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("fixedRate"), BigDecimal.class, (Object)this.getFixedRate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("dayCountYearFraction"), BigDecimal.class, (Object)this.getDayCountYearFraction(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("forecastAmount"), processor, Money.MoneyBuilder.class, this.getForecastAmount(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("forecastRate"), BigDecimal.class, (Object)this.getForecastRate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public CalculationPeriodBuilder prune();
    }

    public static class CalculationPeriodImpl
    implements CalculationPeriod {
        private final ZonedDateTime unadjustedStartDate;
        private final ZonedDateTime unadjustedEndDate;
        private final ZonedDateTime adjustedStartDate;
        private final ZonedDateTime adjustedEndDate;
        private final Integer calculationPeriodNumberOfDays;
        private final BigDecimal notionalAmount;
        private final FxLinkedNotionalAmount fxLinkedNotionalAmount;
        private final FloatingRateDefinition floatingRateDefinition;
        private final BigDecimal fixedRate;
        private final BigDecimal dayCountYearFraction;
        private final Money forecastAmount;
        private final BigDecimal forecastRate;
        private final String id;

        protected CalculationPeriodImpl(CalculationPeriodBuilder builder) {
            this.unadjustedStartDate = builder.getUnadjustedStartDate();
            this.unadjustedEndDate = builder.getUnadjustedEndDate();
            this.adjustedStartDate = builder.getAdjustedStartDate();
            this.adjustedEndDate = builder.getAdjustedEndDate();
            this.calculationPeriodNumberOfDays = builder.getCalculationPeriodNumberOfDays();
            this.notionalAmount = builder.getNotionalAmount();
            this.fxLinkedNotionalAmount = Optional.ofNullable(builder.getFxLinkedNotionalAmount()).map(f -> f.build()).orElse(null);
            this.floatingRateDefinition = Optional.ofNullable(builder.getFloatingRateDefinition()).map(f -> f.build()).orElse(null);
            this.fixedRate = builder.getFixedRate();
            this.dayCountYearFraction = builder.getDayCountYearFraction();
            this.forecastAmount = Optional.ofNullable(builder.getForecastAmount()).map(f -> f.build()).orElse(null);
            this.forecastRate = builder.getForecastRate();
            this.id = builder.getId();
        }

        @Override
        @RosettaAttribute(value="unadjustedStartDate")
        @RuneAttribute(value="unadjustedStartDate")
        public ZonedDateTime getUnadjustedStartDate() {
            return this.unadjustedStartDate;
        }

        @Override
        @RosettaAttribute(value="unadjustedEndDate")
        @RuneAttribute(value="unadjustedEndDate")
        public ZonedDateTime getUnadjustedEndDate() {
            return this.unadjustedEndDate;
        }

        @Override
        @RosettaAttribute(value="adjustedStartDate")
        @RuneAttribute(value="adjustedStartDate")
        public ZonedDateTime getAdjustedStartDate() {
            return this.adjustedStartDate;
        }

        @Override
        @RosettaAttribute(value="adjustedEndDate")
        @RuneAttribute(value="adjustedEndDate")
        public ZonedDateTime getAdjustedEndDate() {
            return this.adjustedEndDate;
        }

        @Override
        @RosettaAttribute(value="calculationPeriodNumberOfDays")
        @RuneAttribute(value="calculationPeriodNumberOfDays")
        public Integer getCalculationPeriodNumberOfDays() {
            return this.calculationPeriodNumberOfDays;
        }

        @Override
        @RosettaAttribute(value="notionalAmount")
        @RuneAttribute(value="notionalAmount")
        public BigDecimal getNotionalAmount() {
            return this.notionalAmount;
        }

        @Override
        @RosettaAttribute(value="fxLinkedNotionalAmount")
        @RuneAttribute(value="fxLinkedNotionalAmount")
        public FxLinkedNotionalAmount getFxLinkedNotionalAmount() {
            return this.fxLinkedNotionalAmount;
        }

        @Override
        @RosettaAttribute(value="floatingRateDefinition")
        @RuneAttribute(value="floatingRateDefinition")
        public FloatingRateDefinition getFloatingRateDefinition() {
            return this.floatingRateDefinition;
        }

        @Override
        @RosettaAttribute(value="fixedRate")
        @RuneAttribute(value="fixedRate")
        public BigDecimal getFixedRate() {
            return this.fixedRate;
        }

        @Override
        @RosettaAttribute(value="dayCountYearFraction")
        @RuneAttribute(value="dayCountYearFraction")
        public BigDecimal getDayCountYearFraction() {
            return this.dayCountYearFraction;
        }

        @Override
        @RosettaAttribute(value="forecastAmount")
        @RuneAttribute(value="forecastAmount")
        public Money getForecastAmount() {
            return this.forecastAmount;
        }

        @Override
        @RosettaAttribute(value="forecastRate")
        @RuneAttribute(value="forecastRate")
        public BigDecimal getForecastRate() {
            return this.forecastRate;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public String getId() {
            return this.id;
        }

        @Override
        public CalculationPeriod build() {
            return this;
        }

        @Override
        public CalculationPeriodBuilder toBuilder() {
            CalculationPeriodBuilder builder = CalculationPeriod.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CalculationPeriodBuilder builder) {
            Optional.ofNullable(this.getUnadjustedStartDate()).ifPresent(builder::setUnadjustedStartDate);
            Optional.ofNullable(this.getUnadjustedEndDate()).ifPresent(builder::setUnadjustedEndDate);
            Optional.ofNullable(this.getAdjustedStartDate()).ifPresent(builder::setAdjustedStartDate);
            Optional.ofNullable(this.getAdjustedEndDate()).ifPresent(builder::setAdjustedEndDate);
            Optional.ofNullable(this.getCalculationPeriodNumberOfDays()).ifPresent(builder::setCalculationPeriodNumberOfDays);
            Optional.ofNullable(this.getNotionalAmount()).ifPresent(builder::setNotionalAmount);
            Optional.ofNullable(this.getFxLinkedNotionalAmount()).ifPresent(builder::setFxLinkedNotionalAmount);
            Optional.ofNullable(this.getFloatingRateDefinition()).ifPresent(builder::setFloatingRateDefinition);
            Optional.ofNullable(this.getFixedRate()).ifPresent(builder::setFixedRate);
            Optional.ofNullable(this.getDayCountYearFraction()).ifPresent(builder::setDayCountYearFraction);
            Optional.ofNullable(this.getForecastAmount()).ifPresent(builder::setForecastAmount);
            Optional.ofNullable(this.getForecastRate()).ifPresent(builder::setForecastRate);
            Optional.ofNullable(this.getId()).ifPresent(builder::setId);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CalculationPeriod _that = this.getType().cast(o);
            if (!Objects.equals(this.unadjustedStartDate, _that.getUnadjustedStartDate())) {
                return false;
            }
            if (!Objects.equals(this.unadjustedEndDate, _that.getUnadjustedEndDate())) {
                return false;
            }
            if (!Objects.equals(this.adjustedStartDate, _that.getAdjustedStartDate())) {
                return false;
            }
            if (!Objects.equals(this.adjustedEndDate, _that.getAdjustedEndDate())) {
                return false;
            }
            if (!Objects.equals(this.calculationPeriodNumberOfDays, _that.getCalculationPeriodNumberOfDays())) {
                return false;
            }
            if (!Objects.equals(this.notionalAmount, _that.getNotionalAmount())) {
                return false;
            }
            if (!Objects.equals(this.fxLinkedNotionalAmount, _that.getFxLinkedNotionalAmount())) {
                return false;
            }
            if (!Objects.equals(this.floatingRateDefinition, _that.getFloatingRateDefinition())) {
                return false;
            }
            if (!Objects.equals(this.fixedRate, _that.getFixedRate())) {
                return false;
            }
            if (!Objects.equals(this.dayCountYearFraction, _that.getDayCountYearFraction())) {
                return false;
            }
            if (!Objects.equals(this.forecastAmount, _that.getForecastAmount())) {
                return false;
            }
            if (!Objects.equals(this.forecastRate, _that.getForecastRate())) {
                return false;
            }
            return Objects.equals(this.id, _that.getId());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.unadjustedStartDate != null ? this.unadjustedStartDate.hashCode() : 0);
            _result = 31 * _result + (this.unadjustedEndDate != null ? this.unadjustedEndDate.hashCode() : 0);
            _result = 31 * _result + (this.adjustedStartDate != null ? this.adjustedStartDate.hashCode() : 0);
            _result = 31 * _result + (this.adjustedEndDate != null ? this.adjustedEndDate.hashCode() : 0);
            _result = 31 * _result + (this.calculationPeriodNumberOfDays != null ? this.calculationPeriodNumberOfDays.hashCode() : 0);
            _result = 31 * _result + (this.notionalAmount != null ? this.notionalAmount.hashCode() : 0);
            _result = 31 * _result + (this.fxLinkedNotionalAmount != null ? this.fxLinkedNotionalAmount.hashCode() : 0);
            _result = 31 * _result + (this.floatingRateDefinition != null ? this.floatingRateDefinition.hashCode() : 0);
            _result = 31 * _result + (this.fixedRate != null ? this.fixedRate.hashCode() : 0);
            _result = 31 * _result + (this.dayCountYearFraction != null ? this.dayCountYearFraction.hashCode() : 0);
            _result = 31 * _result + (this.forecastAmount != null ? this.forecastAmount.hashCode() : 0);
            _result = 31 * _result + (this.forecastRate != null ? this.forecastRate.hashCode() : 0);
            _result = 31 * _result + (this.id != null ? this.id.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CalculationPeriod {unadjustedStartDate=" + this.unadjustedStartDate + ", unadjustedEndDate=" + this.unadjustedEndDate + ", adjustedStartDate=" + this.adjustedStartDate + ", adjustedEndDate=" + this.adjustedEndDate + ", calculationPeriodNumberOfDays=" + this.calculationPeriodNumberOfDays + ", notionalAmount=" + this.notionalAmount + ", fxLinkedNotionalAmount=" + this.fxLinkedNotionalAmount + ", floatingRateDefinition=" + this.floatingRateDefinition + ", fixedRate=" + this.fixedRate + ", dayCountYearFraction=" + this.dayCountYearFraction + ", forecastAmount=" + this.forecastAmount + ", forecastRate=" + this.forecastRate + ", id=" + this.id + '}';
        }
    }
}

