/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.fx.accruals;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.fpmlenum.FxAveragingMethodEnum;
import fpml.consolidated.fx.accruals.FxAveragingProcess;
import fpml.consolidated.fx.accruals.FxCrossRateObservable;
import fpml.consolidated.fx.accruals.FxWeightedFixingSchedule;
import fpml.consolidated.fx.accruals.meta.FxAverageStrikeMeta;
import fpml.consolidated.shared.FxInformationSource;
import fpml.consolidated.shared.QuotedCurrencyPair;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="FxAverageStrike", builder=FxAverageStrikeBuilderImpl.class, version="1.1.0")
@RuneDataType(value="FxAverageStrike", model="fpml", builder=FxAverageStrikeBuilderImpl.class, version="1.1.0")
public interface FxAverageStrike
extends FxAveragingProcess {
    public static final FxAverageStrikeMeta metaData = new FxAverageStrikeMeta();

    public BigDecimal getStrikeAdjustment();

    @Override
    public FxAverageStrike build();

    @Override
    public FxAverageStrikeBuilder toBuilder();

    public static FxAverageStrikeBuilder builder() {
        return new FxAverageStrikeBuilderImpl();
    }

    default public RosettaMetaData<? extends FxAverageStrike> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends FxAverageStrike> getType() {
        return FxAverageStrike.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("quotedCurrencyPair"), processor, QuotedCurrencyPair.class, this.getQuotedCurrencyPair(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("informationSource"), processor, FxInformationSource.class, this.getInformationSource(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("crossRate"), processor, FxCrossRateObservable.class, this.getCrossRate(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("fixingSchedule"), processor, FxWeightedFixingSchedule.class, this.getFixingSchedule(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("averagingMethod"), FxAveragingMethodEnum.class, (Object)this.getAveragingMethod(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("precision"), Integer.class, (Object)this.getPrecision(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("strikeAdjustment"), BigDecimal.class, (Object)this.getStrikeAdjustment(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class FxAverageStrikeBuilderImpl
    extends FxAveragingProcess.FxAveragingProcessBuilderImpl
    implements FxAverageStrikeBuilder {
        protected BigDecimal strikeAdjustment;

        @Override
        @RosettaAttribute(value="strikeAdjustment")
        @RuneAttribute(value="strikeAdjustment")
        public BigDecimal getStrikeAdjustment() {
            return this.strikeAdjustment;
        }

        @Override
        @RosettaAttribute(value="quotedCurrencyPair", isRequired=true)
        @RuneAttribute(value="quotedCurrencyPair", isRequired=true)
        public FxAverageStrikeBuilder setQuotedCurrencyPair(QuotedCurrencyPair _quotedCurrencyPair) {
            this.quotedCurrencyPair = _quotedCurrencyPair == null ? null : _quotedCurrencyPair.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="informationSource")
        @RuneAttribute(value="informationSource")
        public FxAverageStrikeBuilder setInformationSource(FxInformationSource _informationSource) {
            this.informationSource = _informationSource == null ? null : _informationSource.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="crossRate")
        @RuneAttribute(value="crossRate")
        public FxAverageStrikeBuilder addCrossRate(FxCrossRateObservable _crossRate) {
            if (_crossRate != null) {
                this.crossRate.add(_crossRate.toBuilder());
            }
            return this;
        }

        @Override
        public FxAverageStrikeBuilder addCrossRate(FxCrossRateObservable _crossRate, int idx) {
            this.getIndex(this.crossRate, idx, () -> _crossRate.toBuilder());
            return this;
        }

        @Override
        public FxAverageStrikeBuilder addCrossRate(List<? extends FxCrossRateObservable> crossRates) {
            if (crossRates != null) {
                for (FxCrossRateObservable fxCrossRateObservable : crossRates) {
                    this.crossRate.add(fxCrossRateObservable.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="crossRate")
        public FxAverageStrikeBuilder setCrossRate(List<? extends FxCrossRateObservable> crossRates) {
            this.crossRate = crossRates == null ? new ArrayList() : (List)crossRates.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public FxAverageStrikeBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="fixingSchedule", isRequired=true)
        @RuneAttribute(value="fixingSchedule", isRequired=true)
        public FxAverageStrikeBuilder setFixingSchedule(FxWeightedFixingSchedule _fixingSchedule) {
            this.fixingSchedule = _fixingSchedule == null ? null : _fixingSchedule.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="averagingMethod", isRequired=true)
        @RuneAttribute(value="averagingMethod", isRequired=true)
        public FxAverageStrikeBuilder setAveragingMethod(FxAveragingMethodEnum _averagingMethod) {
            this.averagingMethod = _averagingMethod == null ? null : _averagingMethod;
            return this;
        }

        @Override
        @RosettaAttribute(value="precision")
        @RuneAttribute(value="precision")
        public FxAverageStrikeBuilder setPrecision(Integer _precision) {
            this.precision = _precision == null ? null : _precision;
            return this;
        }

        @Override
        @RosettaAttribute(value="strikeAdjustment")
        @RuneAttribute(value="strikeAdjustment")
        public FxAverageStrikeBuilder setStrikeAdjustment(BigDecimal _strikeAdjustment) {
            this.strikeAdjustment = _strikeAdjustment == null ? null : _strikeAdjustment;
            return this;
        }

        @Override
        public FxAverageStrike build() {
            return new FxAverageStrikeImpl(this);
        }

        @Override
        public FxAverageStrikeBuilder toBuilder() {
            return this;
        }

        @Override
        public FxAverageStrikeBuilder prune() {
            super.prune();
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            return this.getStrikeAdjustment() != null;
        }

        @Override
        public FxAverageStrikeBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            FxAverageStrikeBuilder o = (FxAverageStrikeBuilder)other;
            merger.mergeBasic((Object)this.getStrikeAdjustment(), (Object)o.getStrikeAdjustment(), this::setStrikeAdjustment, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            FxAverageStrike _that = (FxAverageStrike)this.getType().cast(o);
            return Objects.equals(this.strikeAdjustment, _that.getStrikeAdjustment());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.strikeAdjustment != null ? this.strikeAdjustment.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "FxAverageStrikeBuilder {strikeAdjustment=" + this.strikeAdjustment + '}' + " " + super.toString();
        }
    }

    public static interface FxAverageStrikeBuilder
    extends FxAverageStrike,
    FxAveragingProcess.FxAveragingProcessBuilder {
        @Override
        public FxAverageStrikeBuilder setQuotedCurrencyPair(QuotedCurrencyPair var1);

        @Override
        public FxAverageStrikeBuilder setInformationSource(FxInformationSource var1);

        @Override
        public FxAverageStrikeBuilder addCrossRate(FxCrossRateObservable var1);

        @Override
        public FxAverageStrikeBuilder addCrossRate(FxCrossRateObservable var1, int var2);

        @Override
        public FxAverageStrikeBuilder addCrossRate(List<? extends FxCrossRateObservable> var1);

        @Override
        public FxAverageStrikeBuilder setCrossRate(List<? extends FxCrossRateObservable> var1);

        @Override
        public FxAverageStrikeBuilder setId(String var1);

        @Override
        public FxAverageStrikeBuilder setFixingSchedule(FxWeightedFixingSchedule var1);

        @Override
        public FxAverageStrikeBuilder setAveragingMethod(FxAveragingMethodEnum var1);

        @Override
        public FxAverageStrikeBuilder setPrecision(Integer var1);

        public FxAverageStrikeBuilder setStrikeAdjustment(BigDecimal var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("quotedCurrencyPair"), processor, QuotedCurrencyPair.QuotedCurrencyPairBuilder.class, (RosettaModelObjectBuilder)this.getQuotedCurrencyPair(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("informationSource"), processor, FxInformationSource.FxInformationSourceBuilder.class, (RosettaModelObjectBuilder)this.getInformationSource(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("crossRate"), processor, FxCrossRateObservable.FxCrossRateObservableBuilder.class, this.getCrossRate(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("fixingSchedule"), processor, FxWeightedFixingSchedule.FxWeightedFixingScheduleBuilder.class, (RosettaModelObjectBuilder)this.getFixingSchedule(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("averagingMethod"), FxAveragingMethodEnum.class, (Object)this.getAveragingMethod(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("precision"), Integer.class, (Object)this.getPrecision(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("strikeAdjustment"), BigDecimal.class, (Object)this.getStrikeAdjustment(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        @Override
        public FxAverageStrikeBuilder prune();
    }

    public static class FxAverageStrikeImpl
    extends FxAveragingProcess.FxAveragingProcessImpl
    implements FxAverageStrike {
        private final BigDecimal strikeAdjustment;

        protected FxAverageStrikeImpl(FxAverageStrikeBuilder builder) {
            super(builder);
            this.strikeAdjustment = builder.getStrikeAdjustment();
        }

        @Override
        @RosettaAttribute(value="strikeAdjustment")
        @RuneAttribute(value="strikeAdjustment")
        public BigDecimal getStrikeAdjustment() {
            return this.strikeAdjustment;
        }

        @Override
        public FxAverageStrike build() {
            return this;
        }

        @Override
        public FxAverageStrikeBuilder toBuilder() {
            FxAverageStrikeBuilder builder = FxAverageStrike.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(FxAverageStrikeBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getStrikeAdjustment()).ifPresent(builder::setStrikeAdjustment);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            FxAverageStrike _that = (FxAverageStrike)this.getType().cast(o);
            return Objects.equals(this.strikeAdjustment, _that.getStrikeAdjustment());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.strikeAdjustment != null ? this.strikeAdjustment.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "FxAverageStrike {strikeAdjustment=" + this.strikeAdjustment + '}' + " " + super.toString();
        }
    }
}

