/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.eq.shared;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.eq.shared.ExtraordinaryEvents;
import fpml.consolidated.eq.shared.meta.NettedSwapBaseMeta;
import fpml.consolidated.option.shared.ClassifiablePayment;
import fpml.consolidated.shared.Product;
import fpml.consolidated.shared.ProductModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="NettedSwapBase", builder=NettedSwapBaseBuilderImpl.class, version="1.1.0")
@RuneDataType(value="NettedSwapBase", model="fpml", builder=NettedSwapBaseBuilderImpl.class, version="1.1.0")
public interface NettedSwapBase
extends Product {
    public static final NettedSwapBaseMeta metaData = new NettedSwapBaseMeta();

    public List<? extends ClassifiablePayment> getAdditionalPayment();

    public ExtraordinaryEvents getExtraordinaryEvents();

    @Override
    public NettedSwapBase build();

    @Override
    public NettedSwapBaseBuilder toBuilder();

    public static NettedSwapBaseBuilder builder() {
        return new NettedSwapBaseBuilderImpl();
    }

    default public RosettaMetaData<? extends NettedSwapBase> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends NettedSwapBase> getType() {
        return NettedSwapBase.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("productModel"), processor, ProductModel.class, this.getProductModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("additionalPayment"), processor, ClassifiablePayment.class, this.getAdditionalPayment(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("extraordinaryEvents"), processor, ExtraordinaryEvents.class, this.getExtraordinaryEvents(), new AttributeMeta[0]);
    }

    public static class NettedSwapBaseBuilderImpl
    extends Product.ProductBuilderImpl
    implements NettedSwapBaseBuilder {
        protected List<ClassifiablePayment.ClassifiablePaymentBuilder> additionalPayment = new ArrayList<ClassifiablePayment.ClassifiablePaymentBuilder>();
        protected ExtraordinaryEvents.ExtraordinaryEventsBuilder extraordinaryEvents;

        @Override
        @RosettaAttribute(value="additionalPayment")
        @RuneAttribute(value="additionalPayment")
        public List<? extends ClassifiablePayment.ClassifiablePaymentBuilder> getAdditionalPayment() {
            return this.additionalPayment;
        }

        @Override
        public ClassifiablePayment.ClassifiablePaymentBuilder getOrCreateAdditionalPayment(int index) {
            if (this.additionalPayment == null) {
                this.additionalPayment = new ArrayList<ClassifiablePayment.ClassifiablePaymentBuilder>();
            }
            return (ClassifiablePayment.ClassifiablePaymentBuilder)this.getIndex(this.additionalPayment, index, () -> {
                ClassifiablePayment.ClassifiablePaymentBuilder newAdditionalPayment = ClassifiablePayment.builder();
                return newAdditionalPayment;
            });
        }

        @Override
        @RosettaAttribute(value="extraordinaryEvents")
        @RuneAttribute(value="extraordinaryEvents")
        public ExtraordinaryEvents.ExtraordinaryEventsBuilder getExtraordinaryEvents() {
            return this.extraordinaryEvents;
        }

        @Override
        public ExtraordinaryEvents.ExtraordinaryEventsBuilder getOrCreateExtraordinaryEvents() {
            ExtraordinaryEvents.ExtraordinaryEventsBuilder result = this.extraordinaryEvents != null ? this.extraordinaryEvents : (this.extraordinaryEvents = ExtraordinaryEvents.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="productModel")
        @RuneAttribute(value="productModel")
        public NettedSwapBaseBuilder setProductModel(ProductModel _productModel) {
            this.productModel = _productModel == null ? null : _productModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public NettedSwapBaseBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="additionalPayment")
        @RuneAttribute(value="additionalPayment")
        public NettedSwapBaseBuilder addAdditionalPayment(ClassifiablePayment _additionalPayment) {
            if (_additionalPayment != null) {
                this.additionalPayment.add(_additionalPayment.toBuilder());
            }
            return this;
        }

        @Override
        public NettedSwapBaseBuilder addAdditionalPayment(ClassifiablePayment _additionalPayment, int idx) {
            this.getIndex(this.additionalPayment, idx, () -> _additionalPayment.toBuilder());
            return this;
        }

        @Override
        public NettedSwapBaseBuilder addAdditionalPayment(List<? extends ClassifiablePayment> additionalPayments) {
            if (additionalPayments != null) {
                for (ClassifiablePayment classifiablePayment : additionalPayments) {
                    this.additionalPayment.add(classifiablePayment.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="additionalPayment")
        public NettedSwapBaseBuilder setAdditionalPayment(List<? extends ClassifiablePayment> additionalPayments) {
            this.additionalPayment = additionalPayments == null ? new ArrayList<ClassifiablePayment.ClassifiablePaymentBuilder>() : (List)additionalPayments.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="extraordinaryEvents")
        @RuneAttribute(value="extraordinaryEvents")
        public NettedSwapBaseBuilder setExtraordinaryEvents(ExtraordinaryEvents _extraordinaryEvents) {
            this.extraordinaryEvents = _extraordinaryEvents == null ? null : _extraordinaryEvents.toBuilder();
            return this;
        }

        @Override
        public NettedSwapBase build() {
            return new NettedSwapBaseImpl(this);
        }

        @Override
        public NettedSwapBaseBuilder toBuilder() {
            return this;
        }

        @Override
        public NettedSwapBaseBuilder prune() {
            super.prune();
            this.additionalPayment = this.additionalPayment.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.extraordinaryEvents != null && !this.extraordinaryEvents.prune().hasData()) {
                this.extraordinaryEvents = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getAdditionalPayment() != null && this.getAdditionalPayment().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getExtraordinaryEvents() != null && this.getExtraordinaryEvents().hasData();
        }

        @Override
        public NettedSwapBaseBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            NettedSwapBaseBuilder o = (NettedSwapBaseBuilder)other;
            merger.mergeRosetta(this.getAdditionalPayment(), o.getAdditionalPayment(), this::getOrCreateAdditionalPayment);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getExtraordinaryEvents(), (RosettaModelObjectBuilder)o.getExtraordinaryEvents(), this::setExtraordinaryEvents);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            NettedSwapBase _that = (NettedSwapBase)this.getType().cast(o);
            if (!ListEquals.listEquals(this.additionalPayment, _that.getAdditionalPayment())) {
                return false;
            }
            return Objects.equals(this.extraordinaryEvents, _that.getExtraordinaryEvents());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.additionalPayment != null ? this.additionalPayment.hashCode() : 0);
            _result = 31 * _result + (this.extraordinaryEvents != null ? this.extraordinaryEvents.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "NettedSwapBaseBuilder {additionalPayment=" + this.additionalPayment + ", extraordinaryEvents=" + this.extraordinaryEvents + '}' + " " + super.toString();
        }
    }

    public static interface NettedSwapBaseBuilder
    extends NettedSwapBase,
    Product.ProductBuilder {
        public ClassifiablePayment.ClassifiablePaymentBuilder getOrCreateAdditionalPayment(int var1);

        public List<? extends ClassifiablePayment.ClassifiablePaymentBuilder> getAdditionalPayment();

        public ExtraordinaryEvents.ExtraordinaryEventsBuilder getOrCreateExtraordinaryEvents();

        @Override
        public ExtraordinaryEvents.ExtraordinaryEventsBuilder getExtraordinaryEvents();

        @Override
        public NettedSwapBaseBuilder setProductModel(ProductModel var1);

        @Override
        public NettedSwapBaseBuilder setId(String var1);

        public NettedSwapBaseBuilder addAdditionalPayment(ClassifiablePayment var1);

        public NettedSwapBaseBuilder addAdditionalPayment(ClassifiablePayment var1, int var2);

        public NettedSwapBaseBuilder addAdditionalPayment(List<? extends ClassifiablePayment> var1);

        public NettedSwapBaseBuilder setAdditionalPayment(List<? extends ClassifiablePayment> var1);

        public NettedSwapBaseBuilder setExtraordinaryEvents(ExtraordinaryEvents var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("productModel"), processor, ProductModel.ProductModelBuilder.class, (RosettaModelObjectBuilder)this.getProductModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("additionalPayment"), processor, ClassifiablePayment.ClassifiablePaymentBuilder.class, this.getAdditionalPayment(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("extraordinaryEvents"), processor, ExtraordinaryEvents.ExtraordinaryEventsBuilder.class, this.getExtraordinaryEvents(), new AttributeMeta[0]);
        }

        @Override
        public NettedSwapBaseBuilder prune();
    }

    public static class NettedSwapBaseImpl
    extends Product.ProductImpl
    implements NettedSwapBase {
        private final List<? extends ClassifiablePayment> additionalPayment;
        private final ExtraordinaryEvents extraordinaryEvents;

        protected NettedSwapBaseImpl(NettedSwapBaseBuilder builder) {
            super(builder);
            this.additionalPayment = Optional.ofNullable(builder.getAdditionalPayment()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.extraordinaryEvents = Optional.ofNullable(builder.getExtraordinaryEvents()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="additionalPayment")
        @RuneAttribute(value="additionalPayment")
        public List<? extends ClassifiablePayment> getAdditionalPayment() {
            return this.additionalPayment;
        }

        @Override
        @RosettaAttribute(value="extraordinaryEvents")
        @RuneAttribute(value="extraordinaryEvents")
        public ExtraordinaryEvents getExtraordinaryEvents() {
            return this.extraordinaryEvents;
        }

        @Override
        public NettedSwapBase build() {
            return this;
        }

        @Override
        public NettedSwapBaseBuilder toBuilder() {
            NettedSwapBaseBuilder builder = NettedSwapBase.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(NettedSwapBaseBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getAdditionalPayment()).ifPresent(builder::setAdditionalPayment);
            Optional.ofNullable(this.getExtraordinaryEvents()).ifPresent(builder::setExtraordinaryEvents);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            NettedSwapBase _that = (NettedSwapBase)this.getType().cast(o);
            if (!ListEquals.listEquals(this.additionalPayment, _that.getAdditionalPayment())) {
                return false;
            }
            return Objects.equals(this.extraordinaryEvents, _that.getExtraordinaryEvents());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.additionalPayment != null ? this.additionalPayment.hashCode() : 0);
            _result = 31 * _result + (this.extraordinaryEvents != null ? this.extraordinaryEvents.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "NettedSwapBase {additionalPayment=" + this.additionalPayment + ", extraordinaryEvents=" + this.extraordinaryEvents + '}' + " " + super.toString();
        }
    }
}

