/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.eq.shared;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.eq.shared.BoundedCorrelation;
import fpml.consolidated.eq.shared.CalculationFromObservation;
import fpml.consolidated.eq.shared.CalculationFromObservationChoice;
import fpml.consolidated.eq.shared.meta.CorrelationMeta;
import fpml.consolidated.shared.NonNegativeMoney;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="Correlation", builder=CorrelationBuilderImpl.class, version="1.1.0")
@RuneDataType(value="Correlation", model="fpml", builder=CorrelationBuilderImpl.class, version="1.1.0")
public interface Correlation
extends CalculationFromObservation {
    public static final CorrelationMeta metaData = new CorrelationMeta();

    public NonNegativeMoney getNotionalAmount();

    public BigDecimal getCorrelationStrikePrice();

    public BoundedCorrelation getBoundedCorrelation();

    public Integer getNumberOfDataSeries();

    @Override
    public Correlation build();

    @Override
    public CorrelationBuilder toBuilder();

    public static CorrelationBuilder builder() {
        return new CorrelationBuilderImpl();
    }

    default public RosettaMetaData<? extends Correlation> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends Correlation> getType() {
        return Correlation.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("calculationFromObservationChoice"), processor, CalculationFromObservationChoice.class, this.getCalculationFromObservationChoice(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("closingLevel"), Boolean.class, (Object)this.getClosingLevel(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("expiringLevel"), Boolean.class, (Object)this.getExpiringLevel(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("expectedN"), Integer.class, (Object)this.getExpectedN(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("notionalAmount"), processor, NonNegativeMoney.class, this.getNotionalAmount(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("correlationStrikePrice"), BigDecimal.class, (Object)this.getCorrelationStrikePrice(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("boundedCorrelation"), processor, BoundedCorrelation.class, this.getBoundedCorrelation(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("numberOfDataSeries"), Integer.class, (Object)this.getNumberOfDataSeries(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class CorrelationBuilderImpl
    extends CalculationFromObservation.CalculationFromObservationBuilderImpl
    implements CorrelationBuilder {
        protected NonNegativeMoney.NonNegativeMoneyBuilder notionalAmount;
        protected BigDecimal correlationStrikePrice;
        protected BoundedCorrelation.BoundedCorrelationBuilder boundedCorrelation;
        protected Integer numberOfDataSeries;

        @Override
        @RosettaAttribute(value="notionalAmount", isRequired=true)
        @RuneAttribute(value="notionalAmount", isRequired=true)
        public NonNegativeMoney.NonNegativeMoneyBuilder getNotionalAmount() {
            return this.notionalAmount;
        }

        @Override
        public NonNegativeMoney.NonNegativeMoneyBuilder getOrCreateNotionalAmount() {
            NonNegativeMoney.NonNegativeMoneyBuilder result = this.notionalAmount != null ? this.notionalAmount : (this.notionalAmount = NonNegativeMoney.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="correlationStrikePrice", isRequired=true)
        @RuneAttribute(value="correlationStrikePrice", isRequired=true)
        public BigDecimal getCorrelationStrikePrice() {
            return this.correlationStrikePrice;
        }

        @Override
        @RosettaAttribute(value="boundedCorrelation")
        @RuneAttribute(value="boundedCorrelation")
        public BoundedCorrelation.BoundedCorrelationBuilder getBoundedCorrelation() {
            return this.boundedCorrelation;
        }

        @Override
        public BoundedCorrelation.BoundedCorrelationBuilder getOrCreateBoundedCorrelation() {
            BoundedCorrelation.BoundedCorrelationBuilder result = this.boundedCorrelation != null ? this.boundedCorrelation : (this.boundedCorrelation = BoundedCorrelation.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="numberOfDataSeries")
        @RuneAttribute(value="numberOfDataSeries")
        public Integer getNumberOfDataSeries() {
            return this.numberOfDataSeries;
        }

        @Override
        @RosettaAttribute(value="calculationFromObservationChoice")
        @RuneAttribute(value="calculationFromObservationChoice")
        public CorrelationBuilder setCalculationFromObservationChoice(CalculationFromObservationChoice _calculationFromObservationChoice) {
            this.calculationFromObservationChoice = _calculationFromObservationChoice == null ? null : _calculationFromObservationChoice.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="closingLevel")
        @RuneAttribute(value="closingLevel")
        public CorrelationBuilder setClosingLevel(Boolean _closingLevel) {
            this.closingLevel = _closingLevel == null ? null : _closingLevel;
            return this;
        }

        @Override
        @RosettaAttribute(value="expiringLevel")
        @RuneAttribute(value="expiringLevel")
        public CorrelationBuilder setExpiringLevel(Boolean _expiringLevel) {
            this.expiringLevel = _expiringLevel == null ? null : _expiringLevel;
            return this;
        }

        @Override
        @RosettaAttribute(value="expectedN")
        @RuneAttribute(value="expectedN")
        public CorrelationBuilder setExpectedN(Integer _expectedN) {
            this.expectedN = _expectedN == null ? null : _expectedN;
            return this;
        }

        @Override
        @RosettaAttribute(value="notionalAmount", isRequired=true)
        @RuneAttribute(value="notionalAmount", isRequired=true)
        public CorrelationBuilder setNotionalAmount(NonNegativeMoney _notionalAmount) {
            this.notionalAmount = _notionalAmount == null ? null : _notionalAmount.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="correlationStrikePrice", isRequired=true)
        @RuneAttribute(value="correlationStrikePrice", isRequired=true)
        public CorrelationBuilder setCorrelationStrikePrice(BigDecimal _correlationStrikePrice) {
            this.correlationStrikePrice = _correlationStrikePrice == null ? null : _correlationStrikePrice;
            return this;
        }

        @Override
        @RosettaAttribute(value="boundedCorrelation")
        @RuneAttribute(value="boundedCorrelation")
        public CorrelationBuilder setBoundedCorrelation(BoundedCorrelation _boundedCorrelation) {
            this.boundedCorrelation = _boundedCorrelation == null ? null : _boundedCorrelation.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="numberOfDataSeries")
        @RuneAttribute(value="numberOfDataSeries")
        public CorrelationBuilder setNumberOfDataSeries(Integer _numberOfDataSeries) {
            this.numberOfDataSeries = _numberOfDataSeries == null ? null : _numberOfDataSeries;
            return this;
        }

        @Override
        public Correlation build() {
            return new CorrelationImpl(this);
        }

        @Override
        public CorrelationBuilder toBuilder() {
            return this;
        }

        @Override
        public CorrelationBuilder prune() {
            super.prune();
            if (this.notionalAmount != null && !this.notionalAmount.prune().hasData()) {
                this.notionalAmount = null;
            }
            if (this.boundedCorrelation != null && !this.boundedCorrelation.prune().hasData()) {
                this.boundedCorrelation = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getNotionalAmount() != null && this.getNotionalAmount().hasData()) {
                return true;
            }
            if (this.getCorrelationStrikePrice() != null) {
                return true;
            }
            if (this.getBoundedCorrelation() != null && this.getBoundedCorrelation().hasData()) {
                return true;
            }
            return this.getNumberOfDataSeries() != null;
        }

        @Override
        public CorrelationBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            CorrelationBuilder o = (CorrelationBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getNotionalAmount(), (RosettaModelObjectBuilder)o.getNotionalAmount(), this::setNotionalAmount);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getBoundedCorrelation(), (RosettaModelObjectBuilder)o.getBoundedCorrelation(), this::setBoundedCorrelation);
            merger.mergeBasic((Object)this.getCorrelationStrikePrice(), (Object)o.getCorrelationStrikePrice(), this::setCorrelationStrikePrice, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getNumberOfDataSeries(), (Object)o.getNumberOfDataSeries(), this::setNumberOfDataSeries, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Correlation _that = (Correlation)this.getType().cast(o);
            if (!Objects.equals(this.notionalAmount, _that.getNotionalAmount())) {
                return false;
            }
            if (!Objects.equals(this.correlationStrikePrice, _that.getCorrelationStrikePrice())) {
                return false;
            }
            if (!Objects.equals(this.boundedCorrelation, _that.getBoundedCorrelation())) {
                return false;
            }
            return Objects.equals(this.numberOfDataSeries, _that.getNumberOfDataSeries());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.notionalAmount != null ? this.notionalAmount.hashCode() : 0);
            _result = 31 * _result + (this.correlationStrikePrice != null ? this.correlationStrikePrice.hashCode() : 0);
            _result = 31 * _result + (this.boundedCorrelation != null ? this.boundedCorrelation.hashCode() : 0);
            _result = 31 * _result + (this.numberOfDataSeries != null ? this.numberOfDataSeries.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "CorrelationBuilder {notionalAmount=" + this.notionalAmount + ", correlationStrikePrice=" + this.correlationStrikePrice + ", boundedCorrelation=" + this.boundedCorrelation + ", numberOfDataSeries=" + this.numberOfDataSeries + '}' + " " + super.toString();
        }
    }

    public static interface CorrelationBuilder
    extends Correlation,
    CalculationFromObservation.CalculationFromObservationBuilder {
        public NonNegativeMoney.NonNegativeMoneyBuilder getOrCreateNotionalAmount();

        @Override
        public NonNegativeMoney.NonNegativeMoneyBuilder getNotionalAmount();

        public BoundedCorrelation.BoundedCorrelationBuilder getOrCreateBoundedCorrelation();

        @Override
        public BoundedCorrelation.BoundedCorrelationBuilder getBoundedCorrelation();

        @Override
        public CorrelationBuilder setCalculationFromObservationChoice(CalculationFromObservationChoice var1);

        @Override
        public CorrelationBuilder setClosingLevel(Boolean var1);

        @Override
        public CorrelationBuilder setExpiringLevel(Boolean var1);

        @Override
        public CorrelationBuilder setExpectedN(Integer var1);

        public CorrelationBuilder setNotionalAmount(NonNegativeMoney var1);

        public CorrelationBuilder setCorrelationStrikePrice(BigDecimal var1);

        public CorrelationBuilder setBoundedCorrelation(BoundedCorrelation var1);

        public CorrelationBuilder setNumberOfDataSeries(Integer var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("calculationFromObservationChoice"), processor, CalculationFromObservationChoice.CalculationFromObservationChoiceBuilder.class, (RosettaModelObjectBuilder)this.getCalculationFromObservationChoice(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("closingLevel"), Boolean.class, (Object)this.getClosingLevel(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("expiringLevel"), Boolean.class, (Object)this.getExpiringLevel(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("expectedN"), Integer.class, (Object)this.getExpectedN(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("notionalAmount"), processor, NonNegativeMoney.NonNegativeMoneyBuilder.class, this.getNotionalAmount(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("correlationStrikePrice"), BigDecimal.class, (Object)this.getCorrelationStrikePrice(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("boundedCorrelation"), processor, BoundedCorrelation.BoundedCorrelationBuilder.class, this.getBoundedCorrelation(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("numberOfDataSeries"), Integer.class, (Object)this.getNumberOfDataSeries(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        @Override
        public CorrelationBuilder prune();
    }

    public static class CorrelationImpl
    extends CalculationFromObservation.CalculationFromObservationImpl
    implements Correlation {
        private final NonNegativeMoney notionalAmount;
        private final BigDecimal correlationStrikePrice;
        private final BoundedCorrelation boundedCorrelation;
        private final Integer numberOfDataSeries;

        protected CorrelationImpl(CorrelationBuilder builder) {
            super(builder);
            this.notionalAmount = Optional.ofNullable(builder.getNotionalAmount()).map(f -> f.build()).orElse(null);
            this.correlationStrikePrice = builder.getCorrelationStrikePrice();
            this.boundedCorrelation = Optional.ofNullable(builder.getBoundedCorrelation()).map(f -> f.build()).orElse(null);
            this.numberOfDataSeries = builder.getNumberOfDataSeries();
        }

        @Override
        @RosettaAttribute(value="notionalAmount", isRequired=true)
        @RuneAttribute(value="notionalAmount", isRequired=true)
        public NonNegativeMoney getNotionalAmount() {
            return this.notionalAmount;
        }

        @Override
        @RosettaAttribute(value="correlationStrikePrice", isRequired=true)
        @RuneAttribute(value="correlationStrikePrice", isRequired=true)
        public BigDecimal getCorrelationStrikePrice() {
            return this.correlationStrikePrice;
        }

        @Override
        @RosettaAttribute(value="boundedCorrelation")
        @RuneAttribute(value="boundedCorrelation")
        public BoundedCorrelation getBoundedCorrelation() {
            return this.boundedCorrelation;
        }

        @Override
        @RosettaAttribute(value="numberOfDataSeries")
        @RuneAttribute(value="numberOfDataSeries")
        public Integer getNumberOfDataSeries() {
            return this.numberOfDataSeries;
        }

        @Override
        public Correlation build() {
            return this;
        }

        @Override
        public CorrelationBuilder toBuilder() {
            CorrelationBuilder builder = Correlation.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CorrelationBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getNotionalAmount()).ifPresent(builder::setNotionalAmount);
            Optional.ofNullable(this.getCorrelationStrikePrice()).ifPresent(builder::setCorrelationStrikePrice);
            Optional.ofNullable(this.getBoundedCorrelation()).ifPresent(builder::setBoundedCorrelation);
            Optional.ofNullable(this.getNumberOfDataSeries()).ifPresent(builder::setNumberOfDataSeries);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Correlation _that = (Correlation)this.getType().cast(o);
            if (!Objects.equals(this.notionalAmount, _that.getNotionalAmount())) {
                return false;
            }
            if (!Objects.equals(this.correlationStrikePrice, _that.getCorrelationStrikePrice())) {
                return false;
            }
            if (!Objects.equals(this.boundedCorrelation, _that.getBoundedCorrelation())) {
                return false;
            }
            return Objects.equals(this.numberOfDataSeries, _that.getNumberOfDataSeries());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.notionalAmount != null ? this.notionalAmount.hashCode() : 0);
            _result = 31 * _result + (this.correlationStrikePrice != null ? this.correlationStrikePrice.hashCode() : 0);
            _result = 31 * _result + (this.boundedCorrelation != null ? this.boundedCorrelation.hashCode() : 0);
            _result = 31 * _result + (this.numberOfDataSeries != null ? this.numberOfDataSeries.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "Correlation {notionalAmount=" + this.notionalAmount + ", correlationStrikePrice=" + this.correlationStrikePrice + ", boundedCorrelation=" + this.boundedCorrelation + ", numberOfDataSeries=" + this.numberOfDataSeries + '}' + " " + super.toString();
        }
    }
}

