/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.confirmation.processes;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.business.events.OptionExercise;
import fpml.consolidated.business.events.TradingAndPostTradeEventsModel;
import fpml.consolidated.confirmation.processes.meta.RequestConfirmationMeta;
import fpml.consolidated.doc.ValidationModel;
import fpml.consolidated.msg.CorrectableRequestMessage;
import fpml.consolidated.msg.CorrelationAndSequenceModel;
import fpml.consolidated.msg.RequestMessageHeader;
import fpml.consolidated.shared.OnBehalfOfModel;
import fpml.consolidated.shared.PartiesAndAccountsModel;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="RequestConfirmation", builder=RequestConfirmationBuilderImpl.class, version="1.1.0")
@RuneDataType(value="RequestConfirmation", model="fpml", builder=RequestConfirmationBuilderImpl.class, version="1.1.0")
public interface RequestConfirmation
extends CorrectableRequestMessage {
    public static final RequestConfirmationMeta metaData = new RequestConfirmationMeta();

    public TradingAndPostTradeEventsModel getTradingAndPostTradeEventsModel();

    public OptionExercise getOptionExercise();

    public PartiesAndAccountsModel getPartiesAndAccountsModel();

    @Override
    public RequestConfirmation build();

    @Override
    public RequestConfirmationBuilder toBuilder();

    public static RequestConfirmationBuilder builder() {
        return new RequestConfirmationBuilderImpl();
    }

    default public RosettaMetaData<? extends RequestConfirmation> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends RequestConfirmation> getType() {
        return RequestConfirmation.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("fpmlVersion"), String.class, (Object)this.getFpmlVersion(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("expectedBuild"), Integer.class, (Object)this.getExpectedBuild(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("actualBuild"), Integer.class, (Object)this.getActualBuild(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("header"), processor, RequestMessageHeader.class, this.getHeader(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("validationModel"), processor, ValidationModel.class, this.getValidationModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("isCorrection"), Boolean.class, (Object)this.getIsCorrection(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("correlationAndSequenceModel"), processor, CorrelationAndSequenceModel.class, this.getCorrelationAndSequenceModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("onBehalfOfModel"), processor, OnBehalfOfModel.class, this.getOnBehalfOfModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("tradingAndPostTradeEventsModel"), processor, TradingAndPostTradeEventsModel.class, this.getTradingAndPostTradeEventsModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("optionExercise"), processor, OptionExercise.class, this.getOptionExercise(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("partiesAndAccountsModel"), processor, PartiesAndAccountsModel.class, this.getPartiesAndAccountsModel(), new AttributeMeta[0]);
    }

    public static class RequestConfirmationBuilderImpl
    extends CorrectableRequestMessage.CorrectableRequestMessageBuilderImpl
    implements RequestConfirmationBuilder {
        protected TradingAndPostTradeEventsModel.TradingAndPostTradeEventsModelBuilder tradingAndPostTradeEventsModel;
        protected OptionExercise.OptionExerciseBuilder optionExercise;
        protected PartiesAndAccountsModel.PartiesAndAccountsModelBuilder partiesAndAccountsModel;

        @Override
        @RosettaAttribute(value="tradingAndPostTradeEventsModel")
        @RuneAttribute(value="tradingAndPostTradeEventsModel")
        public TradingAndPostTradeEventsModel.TradingAndPostTradeEventsModelBuilder getTradingAndPostTradeEventsModel() {
            return this.tradingAndPostTradeEventsModel;
        }

        @Override
        public TradingAndPostTradeEventsModel.TradingAndPostTradeEventsModelBuilder getOrCreateTradingAndPostTradeEventsModel() {
            TradingAndPostTradeEventsModel.TradingAndPostTradeEventsModelBuilder result = this.tradingAndPostTradeEventsModel != null ? this.tradingAndPostTradeEventsModel : (this.tradingAndPostTradeEventsModel = TradingAndPostTradeEventsModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="optionExercise")
        @RuneAttribute(value="optionExercise")
        public OptionExercise.OptionExerciseBuilder getOptionExercise() {
            return this.optionExercise;
        }

        @Override
        public OptionExercise.OptionExerciseBuilder getOrCreateOptionExercise() {
            OptionExercise.OptionExerciseBuilder result = this.optionExercise != null ? this.optionExercise : (this.optionExercise = OptionExercise.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="partiesAndAccountsModel", isRequired=true)
        @RuneAttribute(value="partiesAndAccountsModel", isRequired=true)
        public PartiesAndAccountsModel.PartiesAndAccountsModelBuilder getPartiesAndAccountsModel() {
            return this.partiesAndAccountsModel;
        }

        @Override
        public PartiesAndAccountsModel.PartiesAndAccountsModelBuilder getOrCreatePartiesAndAccountsModel() {
            PartiesAndAccountsModel.PartiesAndAccountsModelBuilder result = this.partiesAndAccountsModel != null ? this.partiesAndAccountsModel : (this.partiesAndAccountsModel = PartiesAndAccountsModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="fpmlVersion", isRequired=true)
        @RuneAttribute(value="fpmlVersion", isRequired=true)
        public RequestConfirmationBuilder setFpmlVersion(String _fpmlVersion) {
            this.fpmlVersion = _fpmlVersion == null ? null : _fpmlVersion;
            return this;
        }

        @Override
        @RosettaAttribute(value="expectedBuild")
        @RuneAttribute(value="expectedBuild")
        public RequestConfirmationBuilder setExpectedBuild(Integer _expectedBuild) {
            this.expectedBuild = _expectedBuild == null ? null : _expectedBuild;
            return this;
        }

        @Override
        @RosettaAttribute(value="actualBuild")
        @RuneAttribute(value="actualBuild")
        public RequestConfirmationBuilder setActualBuild(Integer _actualBuild) {
            this.actualBuild = _actualBuild == null ? null : _actualBuild;
            return this;
        }

        @Override
        @RosettaAttribute(value="header")
        @RuneAttribute(value="header")
        public RequestConfirmationBuilder setHeader(RequestMessageHeader _header) {
            this.header = _header == null ? null : _header.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="validationModel", isRequired=true)
        @RuneAttribute(value="validationModel", isRequired=true)
        public RequestConfirmationBuilder setValidationModel(ValidationModel _validationModel) {
            this.validationModel = _validationModel == null ? null : _validationModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="isCorrection")
        @RuneAttribute(value="isCorrection")
        public RequestConfirmationBuilder setIsCorrection(Boolean _isCorrection) {
            this.isCorrection = _isCorrection == null ? null : _isCorrection;
            return this;
        }

        @Override
        @RosettaAttribute(value="correlationAndSequenceModel")
        @RuneAttribute(value="correlationAndSequenceModel")
        public RequestConfirmationBuilder setCorrelationAndSequenceModel(CorrelationAndSequenceModel _correlationAndSequenceModel) {
            this.correlationAndSequenceModel = _correlationAndSequenceModel == null ? null : _correlationAndSequenceModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="onBehalfOfModel")
        @RuneAttribute(value="onBehalfOfModel")
        public RequestConfirmationBuilder setOnBehalfOfModel(OnBehalfOfModel _onBehalfOfModel) {
            this.onBehalfOfModel = _onBehalfOfModel == null ? null : _onBehalfOfModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="tradingAndPostTradeEventsModel")
        @RuneAttribute(value="tradingAndPostTradeEventsModel")
        public RequestConfirmationBuilder setTradingAndPostTradeEventsModel(TradingAndPostTradeEventsModel _tradingAndPostTradeEventsModel) {
            this.tradingAndPostTradeEventsModel = _tradingAndPostTradeEventsModel == null ? null : _tradingAndPostTradeEventsModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="optionExercise")
        @RuneAttribute(value="optionExercise")
        public RequestConfirmationBuilder setOptionExercise(OptionExercise _optionExercise) {
            this.optionExercise = _optionExercise == null ? null : _optionExercise.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="partiesAndAccountsModel", isRequired=true)
        @RuneAttribute(value="partiesAndAccountsModel", isRequired=true)
        public RequestConfirmationBuilder setPartiesAndAccountsModel(PartiesAndAccountsModel _partiesAndAccountsModel) {
            this.partiesAndAccountsModel = _partiesAndAccountsModel == null ? null : _partiesAndAccountsModel.toBuilder();
            return this;
        }

        @Override
        public RequestConfirmation build() {
            return new RequestConfirmationImpl(this);
        }

        @Override
        public RequestConfirmationBuilder toBuilder() {
            return this;
        }

        @Override
        public RequestConfirmationBuilder prune() {
            super.prune();
            if (this.tradingAndPostTradeEventsModel != null && !this.tradingAndPostTradeEventsModel.prune().hasData()) {
                this.tradingAndPostTradeEventsModel = null;
            }
            if (this.optionExercise != null && !this.optionExercise.prune().hasData()) {
                this.optionExercise = null;
            }
            if (this.partiesAndAccountsModel != null && !this.partiesAndAccountsModel.prune().hasData()) {
                this.partiesAndAccountsModel = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getTradingAndPostTradeEventsModel() != null && this.getTradingAndPostTradeEventsModel().hasData()) {
                return true;
            }
            if (this.getOptionExercise() != null && this.getOptionExercise().hasData()) {
                return true;
            }
            return this.getPartiesAndAccountsModel() != null && this.getPartiesAndAccountsModel().hasData();
        }

        @Override
        public RequestConfirmationBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            RequestConfirmationBuilder o = (RequestConfirmationBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getTradingAndPostTradeEventsModel(), (RosettaModelObjectBuilder)o.getTradingAndPostTradeEventsModel(), this::setTradingAndPostTradeEventsModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getOptionExercise(), (RosettaModelObjectBuilder)o.getOptionExercise(), this::setOptionExercise);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPartiesAndAccountsModel(), (RosettaModelObjectBuilder)o.getPartiesAndAccountsModel(), this::setPartiesAndAccountsModel);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            RequestConfirmation _that = (RequestConfirmation)this.getType().cast(o);
            if (!Objects.equals(this.tradingAndPostTradeEventsModel, _that.getTradingAndPostTradeEventsModel())) {
                return false;
            }
            if (!Objects.equals(this.optionExercise, _that.getOptionExercise())) {
                return false;
            }
            return Objects.equals(this.partiesAndAccountsModel, _that.getPartiesAndAccountsModel());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.tradingAndPostTradeEventsModel != null ? this.tradingAndPostTradeEventsModel.hashCode() : 0);
            _result = 31 * _result + (this.optionExercise != null ? this.optionExercise.hashCode() : 0);
            _result = 31 * _result + (this.partiesAndAccountsModel != null ? this.partiesAndAccountsModel.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "RequestConfirmationBuilder {tradingAndPostTradeEventsModel=" + this.tradingAndPostTradeEventsModel + ", optionExercise=" + this.optionExercise + ", partiesAndAccountsModel=" + this.partiesAndAccountsModel + '}' + " " + super.toString();
        }
    }

    public static interface RequestConfirmationBuilder
    extends RequestConfirmation,
    CorrectableRequestMessage.CorrectableRequestMessageBuilder {
        public TradingAndPostTradeEventsModel.TradingAndPostTradeEventsModelBuilder getOrCreateTradingAndPostTradeEventsModel();

        @Override
        public TradingAndPostTradeEventsModel.TradingAndPostTradeEventsModelBuilder getTradingAndPostTradeEventsModel();

        public OptionExercise.OptionExerciseBuilder getOrCreateOptionExercise();

        @Override
        public OptionExercise.OptionExerciseBuilder getOptionExercise();

        public PartiesAndAccountsModel.PartiesAndAccountsModelBuilder getOrCreatePartiesAndAccountsModel();

        @Override
        public PartiesAndAccountsModel.PartiesAndAccountsModelBuilder getPartiesAndAccountsModel();

        @Override
        public RequestConfirmationBuilder setFpmlVersion(String var1);

        @Override
        public RequestConfirmationBuilder setExpectedBuild(Integer var1);

        @Override
        public RequestConfirmationBuilder setActualBuild(Integer var1);

        @Override
        public RequestConfirmationBuilder setHeader(RequestMessageHeader var1);

        @Override
        public RequestConfirmationBuilder setValidationModel(ValidationModel var1);

        @Override
        public RequestConfirmationBuilder setIsCorrection(Boolean var1);

        @Override
        public RequestConfirmationBuilder setCorrelationAndSequenceModel(CorrelationAndSequenceModel var1);

        @Override
        public RequestConfirmationBuilder setOnBehalfOfModel(OnBehalfOfModel var1);

        public RequestConfirmationBuilder setTradingAndPostTradeEventsModel(TradingAndPostTradeEventsModel var1);

        public RequestConfirmationBuilder setOptionExercise(OptionExercise var1);

        public RequestConfirmationBuilder setPartiesAndAccountsModel(PartiesAndAccountsModel var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("fpmlVersion"), String.class, (Object)this.getFpmlVersion(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("expectedBuild"), Integer.class, (Object)this.getExpectedBuild(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("actualBuild"), Integer.class, (Object)this.getActualBuild(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("header"), processor, RequestMessageHeader.RequestMessageHeaderBuilder.class, (RosettaModelObjectBuilder)this.getHeader(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("validationModel"), processor, ValidationModel.ValidationModelBuilder.class, (RosettaModelObjectBuilder)this.getValidationModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("isCorrection"), Boolean.class, (Object)this.getIsCorrection(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("correlationAndSequenceModel"), processor, CorrelationAndSequenceModel.CorrelationAndSequenceModelBuilder.class, (RosettaModelObjectBuilder)this.getCorrelationAndSequenceModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("onBehalfOfModel"), processor, OnBehalfOfModel.OnBehalfOfModelBuilder.class, (RosettaModelObjectBuilder)this.getOnBehalfOfModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("tradingAndPostTradeEventsModel"), processor, TradingAndPostTradeEventsModel.TradingAndPostTradeEventsModelBuilder.class, this.getTradingAndPostTradeEventsModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("optionExercise"), processor, OptionExercise.OptionExerciseBuilder.class, this.getOptionExercise(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("partiesAndAccountsModel"), processor, PartiesAndAccountsModel.PartiesAndAccountsModelBuilder.class, this.getPartiesAndAccountsModel(), new AttributeMeta[0]);
        }

        @Override
        public RequestConfirmationBuilder prune();
    }

    public static class RequestConfirmationImpl
    extends CorrectableRequestMessage.CorrectableRequestMessageImpl
    implements RequestConfirmation {
        private final TradingAndPostTradeEventsModel tradingAndPostTradeEventsModel;
        private final OptionExercise optionExercise;
        private final PartiesAndAccountsModel partiesAndAccountsModel;

        protected RequestConfirmationImpl(RequestConfirmationBuilder builder) {
            super(builder);
            this.tradingAndPostTradeEventsModel = Optional.ofNullable(builder.getTradingAndPostTradeEventsModel()).map(f -> f.build()).orElse(null);
            this.optionExercise = Optional.ofNullable(builder.getOptionExercise()).map(f -> f.build()).orElse(null);
            this.partiesAndAccountsModel = Optional.ofNullable(builder.getPartiesAndAccountsModel()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="tradingAndPostTradeEventsModel")
        @RuneAttribute(value="tradingAndPostTradeEventsModel")
        public TradingAndPostTradeEventsModel getTradingAndPostTradeEventsModel() {
            return this.tradingAndPostTradeEventsModel;
        }

        @Override
        @RosettaAttribute(value="optionExercise")
        @RuneAttribute(value="optionExercise")
        public OptionExercise getOptionExercise() {
            return this.optionExercise;
        }

        @Override
        @RosettaAttribute(value="partiesAndAccountsModel", isRequired=true)
        @RuneAttribute(value="partiesAndAccountsModel", isRequired=true)
        public PartiesAndAccountsModel getPartiesAndAccountsModel() {
            return this.partiesAndAccountsModel;
        }

        @Override
        public RequestConfirmation build() {
            return this;
        }

        @Override
        public RequestConfirmationBuilder toBuilder() {
            RequestConfirmationBuilder builder = RequestConfirmation.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(RequestConfirmationBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getTradingAndPostTradeEventsModel()).ifPresent(builder::setTradingAndPostTradeEventsModel);
            Optional.ofNullable(this.getOptionExercise()).ifPresent(builder::setOptionExercise);
            Optional.ofNullable(this.getPartiesAndAccountsModel()).ifPresent(builder::setPartiesAndAccountsModel);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            RequestConfirmation _that = (RequestConfirmation)this.getType().cast(o);
            if (!Objects.equals(this.tradingAndPostTradeEventsModel, _that.getTradingAndPostTradeEventsModel())) {
                return false;
            }
            if (!Objects.equals(this.optionExercise, _that.getOptionExercise())) {
                return false;
            }
            return Objects.equals(this.partiesAndAccountsModel, _that.getPartiesAndAccountsModel());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.tradingAndPostTradeEventsModel != null ? this.tradingAndPostTradeEventsModel.hashCode() : 0);
            _result = 31 * _result + (this.optionExercise != null ? this.optionExercise.hashCode() : 0);
            _result = 31 * _result + (this.partiesAndAccountsModel != null ? this.partiesAndAccountsModel.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "RequestConfirmation {tradingAndPostTradeEventsModel=" + this.tradingAndPostTradeEventsModel + ", optionExercise=" + this.optionExercise + ", partiesAndAccountsModel=" + this.partiesAndAccountsModel + '}' + " " + super.toString();
        }
    }
}

