/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.com;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.com.CommodityDeliveryPoint;
import fpml.consolidated.com.CommodityDeliveryRisk;
import fpml.consolidated.com.CommodityPipeline;
import fpml.consolidated.com.CommodityPipelineCycle;
import fpml.consolidated.com.meta.OilPipelineDeliveryMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="OilPipelineDelivery", builder=OilPipelineDeliveryBuilderImpl.class, version="1.1.0")
@RuneDataType(value="OilPipelineDelivery", model="fpml", builder=OilPipelineDeliveryBuilderImpl.class, version="1.1.0")
public interface OilPipelineDelivery
extends RosettaModelObject {
    public static final OilPipelineDeliveryMeta metaData = new OilPipelineDeliveryMeta();

    public CommodityPipeline getPipelineName();

    public CommodityDeliveryPoint getWithdrawalPoint();

    public CommodityDeliveryPoint getEntryPoint();

    public Boolean getDeliverableByBarge();

    public CommodityDeliveryRisk getRisk();

    public List<? extends CommodityPipelineCycle> getCycle();

    public OilPipelineDelivery build();

    public OilPipelineDeliveryBuilder toBuilder();

    public static OilPipelineDeliveryBuilder builder() {
        return new OilPipelineDeliveryBuilderImpl();
    }

    default public RosettaMetaData<? extends OilPipelineDelivery> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends OilPipelineDelivery> getType() {
        return OilPipelineDelivery.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("pipelineName"), processor, CommodityPipeline.class, this.getPipelineName(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("withdrawalPoint"), processor, CommodityDeliveryPoint.class, this.getWithdrawalPoint(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("entryPoint"), processor, CommodityDeliveryPoint.class, this.getEntryPoint(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("deliverableByBarge"), Boolean.class, (Object)this.getDeliverableByBarge(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("risk"), processor, CommodityDeliveryRisk.class, this.getRisk(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("cycle"), processor, CommodityPipelineCycle.class, this.getCycle(), new AttributeMeta[0]);
    }

    public static class OilPipelineDeliveryBuilderImpl
    implements OilPipelineDeliveryBuilder {
        protected CommodityPipeline.CommodityPipelineBuilder pipelineName;
        protected CommodityDeliveryPoint.CommodityDeliveryPointBuilder withdrawalPoint;
        protected CommodityDeliveryPoint.CommodityDeliveryPointBuilder entryPoint;
        protected Boolean deliverableByBarge;
        protected CommodityDeliveryRisk.CommodityDeliveryRiskBuilder risk;
        protected List<CommodityPipelineCycle.CommodityPipelineCycleBuilder> cycle = new ArrayList<CommodityPipelineCycle.CommodityPipelineCycleBuilder>();

        @Override
        @RosettaAttribute(value="pipelineName")
        @RuneAttribute(value="pipelineName")
        public CommodityPipeline.CommodityPipelineBuilder getPipelineName() {
            return this.pipelineName;
        }

        @Override
        public CommodityPipeline.CommodityPipelineBuilder getOrCreatePipelineName() {
            CommodityPipeline.CommodityPipelineBuilder result = this.pipelineName != null ? this.pipelineName : (this.pipelineName = CommodityPipeline.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="withdrawalPoint")
        @RuneAttribute(value="withdrawalPoint")
        public CommodityDeliveryPoint.CommodityDeliveryPointBuilder getWithdrawalPoint() {
            return this.withdrawalPoint;
        }

        @Override
        public CommodityDeliveryPoint.CommodityDeliveryPointBuilder getOrCreateWithdrawalPoint() {
            CommodityDeliveryPoint.CommodityDeliveryPointBuilder result = this.withdrawalPoint != null ? this.withdrawalPoint : (this.withdrawalPoint = CommodityDeliveryPoint.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="entryPoint")
        @RuneAttribute(value="entryPoint")
        public CommodityDeliveryPoint.CommodityDeliveryPointBuilder getEntryPoint() {
            return this.entryPoint;
        }

        @Override
        public CommodityDeliveryPoint.CommodityDeliveryPointBuilder getOrCreateEntryPoint() {
            CommodityDeliveryPoint.CommodityDeliveryPointBuilder result = this.entryPoint != null ? this.entryPoint : (this.entryPoint = CommodityDeliveryPoint.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="deliverableByBarge")
        @RuneAttribute(value="deliverableByBarge")
        public Boolean getDeliverableByBarge() {
            return this.deliverableByBarge;
        }

        @Override
        @RosettaAttribute(value="risk")
        @RuneAttribute(value="risk")
        public CommodityDeliveryRisk.CommodityDeliveryRiskBuilder getRisk() {
            return this.risk;
        }

        @Override
        public CommodityDeliveryRisk.CommodityDeliveryRiskBuilder getOrCreateRisk() {
            CommodityDeliveryRisk.CommodityDeliveryRiskBuilder result = this.risk != null ? this.risk : (this.risk = CommodityDeliveryRisk.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="cycle")
        @RuneAttribute(value="cycle")
        public List<? extends CommodityPipelineCycle.CommodityPipelineCycleBuilder> getCycle() {
            return this.cycle;
        }

        @Override
        public CommodityPipelineCycle.CommodityPipelineCycleBuilder getOrCreateCycle(int index) {
            if (this.cycle == null) {
                this.cycle = new ArrayList<CommodityPipelineCycle.CommodityPipelineCycleBuilder>();
            }
            return (CommodityPipelineCycle.CommodityPipelineCycleBuilder)this.getIndex(this.cycle, index, () -> {
                CommodityPipelineCycle.CommodityPipelineCycleBuilder newCycle = CommodityPipelineCycle.builder();
                return newCycle;
            });
        }

        @Override
        @RosettaAttribute(value="pipelineName")
        @RuneAttribute(value="pipelineName")
        public OilPipelineDeliveryBuilder setPipelineName(CommodityPipeline _pipelineName) {
            this.pipelineName = _pipelineName == null ? null : _pipelineName.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="withdrawalPoint")
        @RuneAttribute(value="withdrawalPoint")
        public OilPipelineDeliveryBuilder setWithdrawalPoint(CommodityDeliveryPoint _withdrawalPoint) {
            this.withdrawalPoint = _withdrawalPoint == null ? null : _withdrawalPoint.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="entryPoint")
        @RuneAttribute(value="entryPoint")
        public OilPipelineDeliveryBuilder setEntryPoint(CommodityDeliveryPoint _entryPoint) {
            this.entryPoint = _entryPoint == null ? null : _entryPoint.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="deliverableByBarge")
        @RuneAttribute(value="deliverableByBarge")
        public OilPipelineDeliveryBuilder setDeliverableByBarge(Boolean _deliverableByBarge) {
            this.deliverableByBarge = _deliverableByBarge == null ? null : _deliverableByBarge;
            return this;
        }

        @Override
        @RosettaAttribute(value="risk")
        @RuneAttribute(value="risk")
        public OilPipelineDeliveryBuilder setRisk(CommodityDeliveryRisk _risk) {
            this.risk = _risk == null ? null : _risk.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="cycle")
        @RuneAttribute(value="cycle")
        public OilPipelineDeliveryBuilder addCycle(CommodityPipelineCycle _cycle) {
            if (_cycle != null) {
                this.cycle.add(_cycle.toBuilder());
            }
            return this;
        }

        @Override
        public OilPipelineDeliveryBuilder addCycle(CommodityPipelineCycle _cycle, int idx) {
            this.getIndex(this.cycle, idx, () -> _cycle.toBuilder());
            return this;
        }

        @Override
        public OilPipelineDeliveryBuilder addCycle(List<? extends CommodityPipelineCycle> cycles) {
            if (cycles != null) {
                for (CommodityPipelineCycle commodityPipelineCycle : cycles) {
                    this.cycle.add(commodityPipelineCycle.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="cycle")
        public OilPipelineDeliveryBuilder setCycle(List<? extends CommodityPipelineCycle> cycles) {
            this.cycle = cycles == null ? new ArrayList<CommodityPipelineCycle.CommodityPipelineCycleBuilder>() : (List)cycles.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public OilPipelineDelivery build() {
            return new OilPipelineDeliveryImpl(this);
        }

        @Override
        public OilPipelineDeliveryBuilder toBuilder() {
            return this;
        }

        @Override
        public OilPipelineDeliveryBuilder prune() {
            if (this.pipelineName != null && !this.pipelineName.prune().hasData()) {
                this.pipelineName = null;
            }
            if (this.withdrawalPoint != null && !this.withdrawalPoint.prune().hasData()) {
                this.withdrawalPoint = null;
            }
            if (this.entryPoint != null && !this.entryPoint.prune().hasData()) {
                this.entryPoint = null;
            }
            if (this.risk != null && !this.risk.prune().hasData()) {
                this.risk = null;
            }
            this.cycle = this.cycle.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getPipelineName() != null && this.getPipelineName().hasData()) {
                return true;
            }
            if (this.getWithdrawalPoint() != null && this.getWithdrawalPoint().hasData()) {
                return true;
            }
            if (this.getEntryPoint() != null && this.getEntryPoint().hasData()) {
                return true;
            }
            if (this.getDeliverableByBarge() != null) {
                return true;
            }
            if (this.getRisk() != null && this.getRisk().hasData()) {
                return true;
            }
            return this.getCycle() != null && this.getCycle().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public OilPipelineDeliveryBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            OilPipelineDeliveryBuilder o = (OilPipelineDeliveryBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPipelineName(), (RosettaModelObjectBuilder)o.getPipelineName(), this::setPipelineName);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getWithdrawalPoint(), (RosettaModelObjectBuilder)o.getWithdrawalPoint(), this::setWithdrawalPoint);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getEntryPoint(), (RosettaModelObjectBuilder)o.getEntryPoint(), this::setEntryPoint);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getRisk(), (RosettaModelObjectBuilder)o.getRisk(), this::setRisk);
            merger.mergeRosetta(this.getCycle(), o.getCycle(), this::getOrCreateCycle);
            merger.mergeBasic((Object)this.getDeliverableByBarge(), (Object)o.getDeliverableByBarge(), this::setDeliverableByBarge, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            OilPipelineDelivery _that = this.getType().cast(o);
            if (!Objects.equals(this.pipelineName, _that.getPipelineName())) {
                return false;
            }
            if (!Objects.equals(this.withdrawalPoint, _that.getWithdrawalPoint())) {
                return false;
            }
            if (!Objects.equals(this.entryPoint, _that.getEntryPoint())) {
                return false;
            }
            if (!Objects.equals(this.deliverableByBarge, _that.getDeliverableByBarge())) {
                return false;
            }
            if (!Objects.equals(this.risk, _that.getRisk())) {
                return false;
            }
            return ListEquals.listEquals(this.cycle, _that.getCycle());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.pipelineName != null ? this.pipelineName.hashCode() : 0);
            _result = 31 * _result + (this.withdrawalPoint != null ? this.withdrawalPoint.hashCode() : 0);
            _result = 31 * _result + (this.entryPoint != null ? this.entryPoint.hashCode() : 0);
            _result = 31 * _result + (this.deliverableByBarge != null ? this.deliverableByBarge.hashCode() : 0);
            _result = 31 * _result + (this.risk != null ? this.risk.hashCode() : 0);
            _result = 31 * _result + (this.cycle != null ? this.cycle.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "OilPipelineDeliveryBuilder {pipelineName=" + this.pipelineName + ", withdrawalPoint=" + this.withdrawalPoint + ", entryPoint=" + this.entryPoint + ", deliverableByBarge=" + this.deliverableByBarge + ", risk=" + this.risk + ", cycle=" + this.cycle + '}';
        }
    }

    public static interface OilPipelineDeliveryBuilder
    extends OilPipelineDelivery,
    RosettaModelObjectBuilder {
        public CommodityPipeline.CommodityPipelineBuilder getOrCreatePipelineName();

        @Override
        public CommodityPipeline.CommodityPipelineBuilder getPipelineName();

        public CommodityDeliveryPoint.CommodityDeliveryPointBuilder getOrCreateWithdrawalPoint();

        @Override
        public CommodityDeliveryPoint.CommodityDeliveryPointBuilder getWithdrawalPoint();

        public CommodityDeliveryPoint.CommodityDeliveryPointBuilder getOrCreateEntryPoint();

        @Override
        public CommodityDeliveryPoint.CommodityDeliveryPointBuilder getEntryPoint();

        public CommodityDeliveryRisk.CommodityDeliveryRiskBuilder getOrCreateRisk();

        @Override
        public CommodityDeliveryRisk.CommodityDeliveryRiskBuilder getRisk();

        public CommodityPipelineCycle.CommodityPipelineCycleBuilder getOrCreateCycle(int var1);

        public List<? extends CommodityPipelineCycle.CommodityPipelineCycleBuilder> getCycle();

        public OilPipelineDeliveryBuilder setPipelineName(CommodityPipeline var1);

        public OilPipelineDeliveryBuilder setWithdrawalPoint(CommodityDeliveryPoint var1);

        public OilPipelineDeliveryBuilder setEntryPoint(CommodityDeliveryPoint var1);

        public OilPipelineDeliveryBuilder setDeliverableByBarge(Boolean var1);

        public OilPipelineDeliveryBuilder setRisk(CommodityDeliveryRisk var1);

        public OilPipelineDeliveryBuilder addCycle(CommodityPipelineCycle var1);

        public OilPipelineDeliveryBuilder addCycle(CommodityPipelineCycle var1, int var2);

        public OilPipelineDeliveryBuilder addCycle(List<? extends CommodityPipelineCycle> var1);

        public OilPipelineDeliveryBuilder setCycle(List<? extends CommodityPipelineCycle> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("pipelineName"), processor, CommodityPipeline.CommodityPipelineBuilder.class, this.getPipelineName(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("withdrawalPoint"), processor, CommodityDeliveryPoint.CommodityDeliveryPointBuilder.class, this.getWithdrawalPoint(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("entryPoint"), processor, CommodityDeliveryPoint.CommodityDeliveryPointBuilder.class, this.getEntryPoint(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("deliverableByBarge"), Boolean.class, (Object)this.getDeliverableByBarge(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("risk"), processor, CommodityDeliveryRisk.CommodityDeliveryRiskBuilder.class, this.getRisk(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("cycle"), processor, CommodityPipelineCycle.CommodityPipelineCycleBuilder.class, this.getCycle(), new AttributeMeta[0]);
        }

        public OilPipelineDeliveryBuilder prune();
    }

    public static class OilPipelineDeliveryImpl
    implements OilPipelineDelivery {
        private final CommodityPipeline pipelineName;
        private final CommodityDeliveryPoint withdrawalPoint;
        private final CommodityDeliveryPoint entryPoint;
        private final Boolean deliverableByBarge;
        private final CommodityDeliveryRisk risk;
        private final List<? extends CommodityPipelineCycle> cycle;

        protected OilPipelineDeliveryImpl(OilPipelineDeliveryBuilder builder) {
            this.pipelineName = Optional.ofNullable(builder.getPipelineName()).map(f -> f.build()).orElse(null);
            this.withdrawalPoint = Optional.ofNullable(builder.getWithdrawalPoint()).map(f -> f.build()).orElse(null);
            this.entryPoint = Optional.ofNullable(builder.getEntryPoint()).map(f -> f.build()).orElse(null);
            this.deliverableByBarge = builder.getDeliverableByBarge();
            this.risk = Optional.ofNullable(builder.getRisk()).map(f -> f.build()).orElse(null);
            this.cycle = Optional.ofNullable(builder.getCycle()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="pipelineName")
        @RuneAttribute(value="pipelineName")
        public CommodityPipeline getPipelineName() {
            return this.pipelineName;
        }

        @Override
        @RosettaAttribute(value="withdrawalPoint")
        @RuneAttribute(value="withdrawalPoint")
        public CommodityDeliveryPoint getWithdrawalPoint() {
            return this.withdrawalPoint;
        }

        @Override
        @RosettaAttribute(value="entryPoint")
        @RuneAttribute(value="entryPoint")
        public CommodityDeliveryPoint getEntryPoint() {
            return this.entryPoint;
        }

        @Override
        @RosettaAttribute(value="deliverableByBarge")
        @RuneAttribute(value="deliverableByBarge")
        public Boolean getDeliverableByBarge() {
            return this.deliverableByBarge;
        }

        @Override
        @RosettaAttribute(value="risk")
        @RuneAttribute(value="risk")
        public CommodityDeliveryRisk getRisk() {
            return this.risk;
        }

        @Override
        @RosettaAttribute(value="cycle")
        @RuneAttribute(value="cycle")
        public List<? extends CommodityPipelineCycle> getCycle() {
            return this.cycle;
        }

        @Override
        public OilPipelineDelivery build() {
            return this;
        }

        @Override
        public OilPipelineDeliveryBuilder toBuilder() {
            OilPipelineDeliveryBuilder builder = OilPipelineDelivery.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(OilPipelineDeliveryBuilder builder) {
            Optional.ofNullable(this.getPipelineName()).ifPresent(builder::setPipelineName);
            Optional.ofNullable(this.getWithdrawalPoint()).ifPresent(builder::setWithdrawalPoint);
            Optional.ofNullable(this.getEntryPoint()).ifPresent(builder::setEntryPoint);
            Optional.ofNullable(this.getDeliverableByBarge()).ifPresent(builder::setDeliverableByBarge);
            Optional.ofNullable(this.getRisk()).ifPresent(builder::setRisk);
            Optional.ofNullable(this.getCycle()).ifPresent(builder::setCycle);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            OilPipelineDelivery _that = this.getType().cast(o);
            if (!Objects.equals(this.pipelineName, _that.getPipelineName())) {
                return false;
            }
            if (!Objects.equals(this.withdrawalPoint, _that.getWithdrawalPoint())) {
                return false;
            }
            if (!Objects.equals(this.entryPoint, _that.getEntryPoint())) {
                return false;
            }
            if (!Objects.equals(this.deliverableByBarge, _that.getDeliverableByBarge())) {
                return false;
            }
            if (!Objects.equals(this.risk, _that.getRisk())) {
                return false;
            }
            return ListEquals.listEquals(this.cycle, _that.getCycle());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.pipelineName != null ? this.pipelineName.hashCode() : 0);
            _result = 31 * _result + (this.withdrawalPoint != null ? this.withdrawalPoint.hashCode() : 0);
            _result = 31 * _result + (this.entryPoint != null ? this.entryPoint.hashCode() : 0);
            _result = 31 * _result + (this.deliverableByBarge != null ? this.deliverableByBarge.hashCode() : 0);
            _result = 31 * _result + (this.risk != null ? this.risk.hashCode() : 0);
            _result = 31 * _result + (this.cycle != null ? this.cycle.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "OilPipelineDelivery {pipelineName=" + this.pipelineName + ", withdrawalPoint=" + this.withdrawalPoint + ", entryPoint=" + this.entryPoint + ", deliverableByBarge=" + this.deliverableByBarge + ", risk=" + this.risk + ", cycle=" + this.cycle + '}';
        }
    }
}

