/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.clearing.processes;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.business.events.DeClear;
import fpml.consolidated.business.events.TradingEventsModel;
import fpml.consolidated.clearing.processes.ClearingRequirements;
import fpml.consolidated.clearing.processes.meta.ClearingEligibilityMeta;
import fpml.consolidated.doc.PartyTradeIdentifier;
import fpml.consolidated.doc.ValidationModel;
import fpml.consolidated.msg.CorrelationAndOptionalSequenceModel;
import fpml.consolidated.msg.ResponseMessage;
import fpml.consolidated.msg.ResponseMessageHeader;
import fpml.consolidated.shared.OnBehalfOfModel;
import fpml.consolidated.shared.PartiesAndAccountsModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="ClearingEligibility", builder=ClearingEligibilityBuilderImpl.class, version="1.1.0")
@RuneDataType(value="ClearingEligibility", model="fpml", builder=ClearingEligibilityBuilderImpl.class, version="1.1.0")
public interface ClearingEligibility
extends ResponseMessage {
    public static final ClearingEligibilityMeta metaData = new ClearingEligibilityMeta();

    public TradingEventsModel getTradingEventsModel();

    public DeClear getDeClear();

    public PartyTradeIdentifier getPartyTradeIdentifier();

    public Boolean getEligibleForClearing();

    public List<? extends ClearingRequirements> getClearingRequirements();

    public PartiesAndAccountsModel getPartiesAndAccountsModel();

    @Override
    public ClearingEligibility build();

    @Override
    public ClearingEligibilityBuilder toBuilder();

    public static ClearingEligibilityBuilder builder() {
        return new ClearingEligibilityBuilderImpl();
    }

    default public RosettaMetaData<? extends ClearingEligibility> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends ClearingEligibility> getType() {
        return ClearingEligibility.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("fpmlVersion"), String.class, (Object)this.getFpmlVersion(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("expectedBuild"), Integer.class, (Object)this.getExpectedBuild(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("actualBuild"), Integer.class, (Object)this.getActualBuild(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("header"), processor, ResponseMessageHeader.class, this.getHeader(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("validationModel"), processor, ValidationModel.class, this.getValidationModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("correlationAndOptionalSequenceModel"), processor, CorrelationAndOptionalSequenceModel.class, this.getCorrelationAndOptionalSequenceModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("onBehalfOfModel"), processor, OnBehalfOfModel.class, this.getOnBehalfOfModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("tradingEventsModel"), processor, TradingEventsModel.class, this.getTradingEventsModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("deClear"), processor, DeClear.class, this.getDeClear(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("partyTradeIdentifier"), processor, PartyTradeIdentifier.class, this.getPartyTradeIdentifier(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("eligibleForClearing"), Boolean.class, (Object)this.getEligibleForClearing(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("clearingRequirements"), processor, ClearingRequirements.class, this.getClearingRequirements(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("partiesAndAccountsModel"), processor, PartiesAndAccountsModel.class, this.getPartiesAndAccountsModel(), new AttributeMeta[0]);
    }

    public static class ClearingEligibilityBuilderImpl
    extends ResponseMessage.ResponseMessageBuilderImpl
    implements ClearingEligibilityBuilder {
        protected TradingEventsModel.TradingEventsModelBuilder tradingEventsModel;
        protected DeClear.DeClearBuilder deClear;
        protected PartyTradeIdentifier.PartyTradeIdentifierBuilder partyTradeIdentifier;
        protected Boolean eligibleForClearing;
        protected List<ClearingRequirements.ClearingRequirementsBuilder> clearingRequirements = new ArrayList<ClearingRequirements.ClearingRequirementsBuilder>();
        protected PartiesAndAccountsModel.PartiesAndAccountsModelBuilder partiesAndAccountsModel;

        @Override
        @RosettaAttribute(value="tradingEventsModel")
        @RuneAttribute(value="tradingEventsModel")
        public TradingEventsModel.TradingEventsModelBuilder getTradingEventsModel() {
            return this.tradingEventsModel;
        }

        @Override
        public TradingEventsModel.TradingEventsModelBuilder getOrCreateTradingEventsModel() {
            TradingEventsModel.TradingEventsModelBuilder result = this.tradingEventsModel != null ? this.tradingEventsModel : (this.tradingEventsModel = TradingEventsModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="deClear")
        @RuneAttribute(value="deClear")
        public DeClear.DeClearBuilder getDeClear() {
            return this.deClear;
        }

        @Override
        public DeClear.DeClearBuilder getOrCreateDeClear() {
            DeClear.DeClearBuilder result = this.deClear != null ? this.deClear : (this.deClear = DeClear.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="partyTradeIdentifier")
        @RuneAttribute(value="partyTradeIdentifier")
        public PartyTradeIdentifier.PartyTradeIdentifierBuilder getPartyTradeIdentifier() {
            return this.partyTradeIdentifier;
        }

        @Override
        public PartyTradeIdentifier.PartyTradeIdentifierBuilder getOrCreatePartyTradeIdentifier() {
            PartyTradeIdentifier.PartyTradeIdentifierBuilder result = this.partyTradeIdentifier != null ? this.partyTradeIdentifier : (this.partyTradeIdentifier = PartyTradeIdentifier.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="eligibleForClearing", isRequired=true)
        @RuneAttribute(value="eligibleForClearing", isRequired=true)
        public Boolean getEligibleForClearing() {
            return this.eligibleForClearing;
        }

        @Override
        @RosettaAttribute(value="clearingRequirements")
        @RuneAttribute(value="clearingRequirements")
        public List<? extends ClearingRequirements.ClearingRequirementsBuilder> getClearingRequirements() {
            return this.clearingRequirements;
        }

        @Override
        public ClearingRequirements.ClearingRequirementsBuilder getOrCreateClearingRequirements(int index) {
            if (this.clearingRequirements == null) {
                this.clearingRequirements = new ArrayList<ClearingRequirements.ClearingRequirementsBuilder>();
            }
            return (ClearingRequirements.ClearingRequirementsBuilder)this.getIndex(this.clearingRequirements, index, () -> {
                ClearingRequirements.ClearingRequirementsBuilder newClearingRequirements = ClearingRequirements.builder();
                return newClearingRequirements;
            });
        }

        @Override
        @RosettaAttribute(value="partiesAndAccountsModel", isRequired=true)
        @RuneAttribute(value="partiesAndAccountsModel", isRequired=true)
        public PartiesAndAccountsModel.PartiesAndAccountsModelBuilder getPartiesAndAccountsModel() {
            return this.partiesAndAccountsModel;
        }

        @Override
        public PartiesAndAccountsModel.PartiesAndAccountsModelBuilder getOrCreatePartiesAndAccountsModel() {
            PartiesAndAccountsModel.PartiesAndAccountsModelBuilder result = this.partiesAndAccountsModel != null ? this.partiesAndAccountsModel : (this.partiesAndAccountsModel = PartiesAndAccountsModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="fpmlVersion", isRequired=true)
        @RuneAttribute(value="fpmlVersion", isRequired=true)
        public ClearingEligibilityBuilder setFpmlVersion(String _fpmlVersion) {
            this.fpmlVersion = _fpmlVersion == null ? null : _fpmlVersion;
            return this;
        }

        @Override
        @RosettaAttribute(value="expectedBuild")
        @RuneAttribute(value="expectedBuild")
        public ClearingEligibilityBuilder setExpectedBuild(Integer _expectedBuild) {
            this.expectedBuild = _expectedBuild == null ? null : _expectedBuild;
            return this;
        }

        @Override
        @RosettaAttribute(value="actualBuild")
        @RuneAttribute(value="actualBuild")
        public ClearingEligibilityBuilder setActualBuild(Integer _actualBuild) {
            this.actualBuild = _actualBuild == null ? null : _actualBuild;
            return this;
        }

        @Override
        @RosettaAttribute(value="header")
        @RuneAttribute(value="header")
        public ClearingEligibilityBuilder setHeader(ResponseMessageHeader _header) {
            this.header = _header == null ? null : _header.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="validationModel", isRequired=true)
        @RuneAttribute(value="validationModel", isRequired=true)
        public ClearingEligibilityBuilder setValidationModel(ValidationModel _validationModel) {
            this.validationModel = _validationModel == null ? null : _validationModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="correlationAndOptionalSequenceModel", isRequired=true)
        @RuneAttribute(value="correlationAndOptionalSequenceModel", isRequired=true)
        public ClearingEligibilityBuilder setCorrelationAndOptionalSequenceModel(CorrelationAndOptionalSequenceModel _correlationAndOptionalSequenceModel) {
            this.correlationAndOptionalSequenceModel = _correlationAndOptionalSequenceModel == null ? null : _correlationAndOptionalSequenceModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="onBehalfOfModel")
        @RuneAttribute(value="onBehalfOfModel")
        public ClearingEligibilityBuilder setOnBehalfOfModel(OnBehalfOfModel _onBehalfOfModel) {
            this.onBehalfOfModel = _onBehalfOfModel == null ? null : _onBehalfOfModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="tradingEventsModel")
        @RuneAttribute(value="tradingEventsModel")
        public ClearingEligibilityBuilder setTradingEventsModel(TradingEventsModel _tradingEventsModel) {
            this.tradingEventsModel = _tradingEventsModel == null ? null : _tradingEventsModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="deClear")
        @RuneAttribute(value="deClear")
        public ClearingEligibilityBuilder setDeClear(DeClear _deClear) {
            this.deClear = _deClear == null ? null : _deClear.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="partyTradeIdentifier")
        @RuneAttribute(value="partyTradeIdentifier")
        public ClearingEligibilityBuilder setPartyTradeIdentifier(PartyTradeIdentifier _partyTradeIdentifier) {
            this.partyTradeIdentifier = _partyTradeIdentifier == null ? null : _partyTradeIdentifier.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="eligibleForClearing", isRequired=true)
        @RuneAttribute(value="eligibleForClearing", isRequired=true)
        public ClearingEligibilityBuilder setEligibleForClearing(Boolean _eligibleForClearing) {
            this.eligibleForClearing = _eligibleForClearing == null ? null : _eligibleForClearing;
            return this;
        }

        @Override
        @RosettaAttribute(value="clearingRequirements")
        @RuneAttribute(value="clearingRequirements")
        public ClearingEligibilityBuilder addClearingRequirements(ClearingRequirements _clearingRequirements) {
            if (_clearingRequirements != null) {
                this.clearingRequirements.add(_clearingRequirements.toBuilder());
            }
            return this;
        }

        @Override
        public ClearingEligibilityBuilder addClearingRequirements(ClearingRequirements _clearingRequirements, int idx) {
            this.getIndex(this.clearingRequirements, idx, () -> _clearingRequirements.toBuilder());
            return this;
        }

        @Override
        public ClearingEligibilityBuilder addClearingRequirements(List<? extends ClearingRequirements> clearingRequirementss) {
            if (clearingRequirementss != null) {
                for (ClearingRequirements clearingRequirements : clearingRequirementss) {
                    this.clearingRequirements.add(clearingRequirements.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="clearingRequirements")
        public ClearingEligibilityBuilder setClearingRequirements(List<? extends ClearingRequirements> clearingRequirementss) {
            this.clearingRequirements = clearingRequirementss == null ? new ArrayList<ClearingRequirements.ClearingRequirementsBuilder>() : (List)clearingRequirementss.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="partiesAndAccountsModel", isRequired=true)
        @RuneAttribute(value="partiesAndAccountsModel", isRequired=true)
        public ClearingEligibilityBuilder setPartiesAndAccountsModel(PartiesAndAccountsModel _partiesAndAccountsModel) {
            this.partiesAndAccountsModel = _partiesAndAccountsModel == null ? null : _partiesAndAccountsModel.toBuilder();
            return this;
        }

        @Override
        public ClearingEligibility build() {
            return new ClearingEligibilityImpl(this);
        }

        @Override
        public ClearingEligibilityBuilder toBuilder() {
            return this;
        }

        @Override
        public ClearingEligibilityBuilder prune() {
            super.prune();
            if (this.tradingEventsModel != null && !this.tradingEventsModel.prune().hasData()) {
                this.tradingEventsModel = null;
            }
            if (this.deClear != null && !this.deClear.prune().hasData()) {
                this.deClear = null;
            }
            if (this.partyTradeIdentifier != null && !this.partyTradeIdentifier.prune().hasData()) {
                this.partyTradeIdentifier = null;
            }
            this.clearingRequirements = this.clearingRequirements.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.partiesAndAccountsModel != null && !this.partiesAndAccountsModel.prune().hasData()) {
                this.partiesAndAccountsModel = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getTradingEventsModel() != null && this.getTradingEventsModel().hasData()) {
                return true;
            }
            if (this.getDeClear() != null && this.getDeClear().hasData()) {
                return true;
            }
            if (this.getPartyTradeIdentifier() != null && this.getPartyTradeIdentifier().hasData()) {
                return true;
            }
            if (this.getEligibleForClearing() != null) {
                return true;
            }
            if (this.getClearingRequirements() != null && this.getClearingRequirements().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getPartiesAndAccountsModel() != null && this.getPartiesAndAccountsModel().hasData();
        }

        @Override
        public ClearingEligibilityBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            ClearingEligibilityBuilder o = (ClearingEligibilityBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getTradingEventsModel(), (RosettaModelObjectBuilder)o.getTradingEventsModel(), this::setTradingEventsModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDeClear(), (RosettaModelObjectBuilder)o.getDeClear(), this::setDeClear);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPartyTradeIdentifier(), (RosettaModelObjectBuilder)o.getPartyTradeIdentifier(), this::setPartyTradeIdentifier);
            merger.mergeRosetta(this.getClearingRequirements(), o.getClearingRequirements(), this::getOrCreateClearingRequirements);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPartiesAndAccountsModel(), (RosettaModelObjectBuilder)o.getPartiesAndAccountsModel(), this::setPartiesAndAccountsModel);
            merger.mergeBasic((Object)this.getEligibleForClearing(), (Object)o.getEligibleForClearing(), this::setEligibleForClearing, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ClearingEligibility _that = (ClearingEligibility)this.getType().cast(o);
            if (!Objects.equals(this.tradingEventsModel, _that.getTradingEventsModel())) {
                return false;
            }
            if (!Objects.equals(this.deClear, _that.getDeClear())) {
                return false;
            }
            if (!Objects.equals(this.partyTradeIdentifier, _that.getPartyTradeIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.eligibleForClearing, _that.getEligibleForClearing())) {
                return false;
            }
            if (!ListEquals.listEquals(this.clearingRequirements, _that.getClearingRequirements())) {
                return false;
            }
            return Objects.equals(this.partiesAndAccountsModel, _that.getPartiesAndAccountsModel());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.tradingEventsModel != null ? this.tradingEventsModel.hashCode() : 0);
            _result = 31 * _result + (this.deClear != null ? this.deClear.hashCode() : 0);
            _result = 31 * _result + (this.partyTradeIdentifier != null ? this.partyTradeIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.eligibleForClearing != null ? this.eligibleForClearing.hashCode() : 0);
            _result = 31 * _result + (this.clearingRequirements != null ? this.clearingRequirements.hashCode() : 0);
            _result = 31 * _result + (this.partiesAndAccountsModel != null ? this.partiesAndAccountsModel.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "ClearingEligibilityBuilder {tradingEventsModel=" + this.tradingEventsModel + ", deClear=" + this.deClear + ", partyTradeIdentifier=" + this.partyTradeIdentifier + ", eligibleForClearing=" + this.eligibleForClearing + ", clearingRequirements=" + this.clearingRequirements + ", partiesAndAccountsModel=" + this.partiesAndAccountsModel + '}' + " " + super.toString();
        }
    }

    public static interface ClearingEligibilityBuilder
    extends ClearingEligibility,
    ResponseMessage.ResponseMessageBuilder {
        public TradingEventsModel.TradingEventsModelBuilder getOrCreateTradingEventsModel();

        @Override
        public TradingEventsModel.TradingEventsModelBuilder getTradingEventsModel();

        public DeClear.DeClearBuilder getOrCreateDeClear();

        @Override
        public DeClear.DeClearBuilder getDeClear();

        public PartyTradeIdentifier.PartyTradeIdentifierBuilder getOrCreatePartyTradeIdentifier();

        @Override
        public PartyTradeIdentifier.PartyTradeIdentifierBuilder getPartyTradeIdentifier();

        public ClearingRequirements.ClearingRequirementsBuilder getOrCreateClearingRequirements(int var1);

        public List<? extends ClearingRequirements.ClearingRequirementsBuilder> getClearingRequirements();

        public PartiesAndAccountsModel.PartiesAndAccountsModelBuilder getOrCreatePartiesAndAccountsModel();

        @Override
        public PartiesAndAccountsModel.PartiesAndAccountsModelBuilder getPartiesAndAccountsModel();

        @Override
        public ClearingEligibilityBuilder setFpmlVersion(String var1);

        @Override
        public ClearingEligibilityBuilder setExpectedBuild(Integer var1);

        @Override
        public ClearingEligibilityBuilder setActualBuild(Integer var1);

        @Override
        public ClearingEligibilityBuilder setHeader(ResponseMessageHeader var1);

        @Override
        public ClearingEligibilityBuilder setValidationModel(ValidationModel var1);

        @Override
        public ClearingEligibilityBuilder setCorrelationAndOptionalSequenceModel(CorrelationAndOptionalSequenceModel var1);

        @Override
        public ClearingEligibilityBuilder setOnBehalfOfModel(OnBehalfOfModel var1);

        public ClearingEligibilityBuilder setTradingEventsModel(TradingEventsModel var1);

        public ClearingEligibilityBuilder setDeClear(DeClear var1);

        public ClearingEligibilityBuilder setPartyTradeIdentifier(PartyTradeIdentifier var1);

        public ClearingEligibilityBuilder setEligibleForClearing(Boolean var1);

        public ClearingEligibilityBuilder addClearingRequirements(ClearingRequirements var1);

        public ClearingEligibilityBuilder addClearingRequirements(ClearingRequirements var1, int var2);

        public ClearingEligibilityBuilder addClearingRequirements(List<? extends ClearingRequirements> var1);

        public ClearingEligibilityBuilder setClearingRequirements(List<? extends ClearingRequirements> var1);

        public ClearingEligibilityBuilder setPartiesAndAccountsModel(PartiesAndAccountsModel var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("fpmlVersion"), String.class, (Object)this.getFpmlVersion(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("expectedBuild"), Integer.class, (Object)this.getExpectedBuild(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("actualBuild"), Integer.class, (Object)this.getActualBuild(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("header"), processor, ResponseMessageHeader.ResponseMessageHeaderBuilder.class, (RosettaModelObjectBuilder)this.getHeader(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("validationModel"), processor, ValidationModel.ValidationModelBuilder.class, (RosettaModelObjectBuilder)this.getValidationModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("correlationAndOptionalSequenceModel"), processor, CorrelationAndOptionalSequenceModel.CorrelationAndOptionalSequenceModelBuilder.class, (RosettaModelObjectBuilder)this.getCorrelationAndOptionalSequenceModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("onBehalfOfModel"), processor, OnBehalfOfModel.OnBehalfOfModelBuilder.class, (RosettaModelObjectBuilder)this.getOnBehalfOfModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("tradingEventsModel"), processor, TradingEventsModel.TradingEventsModelBuilder.class, this.getTradingEventsModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("deClear"), processor, DeClear.DeClearBuilder.class, this.getDeClear(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("partyTradeIdentifier"), processor, PartyTradeIdentifier.PartyTradeIdentifierBuilder.class, this.getPartyTradeIdentifier(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("eligibleForClearing"), Boolean.class, (Object)this.getEligibleForClearing(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("clearingRequirements"), processor, ClearingRequirements.ClearingRequirementsBuilder.class, this.getClearingRequirements(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("partiesAndAccountsModel"), processor, PartiesAndAccountsModel.PartiesAndAccountsModelBuilder.class, this.getPartiesAndAccountsModel(), new AttributeMeta[0]);
        }

        @Override
        public ClearingEligibilityBuilder prune();
    }

    public static class ClearingEligibilityImpl
    extends ResponseMessage.ResponseMessageImpl
    implements ClearingEligibility {
        private final TradingEventsModel tradingEventsModel;
        private final DeClear deClear;
        private final PartyTradeIdentifier partyTradeIdentifier;
        private final Boolean eligibleForClearing;
        private final List<? extends ClearingRequirements> clearingRequirements;
        private final PartiesAndAccountsModel partiesAndAccountsModel;

        protected ClearingEligibilityImpl(ClearingEligibilityBuilder builder) {
            super(builder);
            this.tradingEventsModel = Optional.ofNullable(builder.getTradingEventsModel()).map(f -> f.build()).orElse(null);
            this.deClear = Optional.ofNullable(builder.getDeClear()).map(f -> f.build()).orElse(null);
            this.partyTradeIdentifier = Optional.ofNullable(builder.getPartyTradeIdentifier()).map(f -> f.build()).orElse(null);
            this.eligibleForClearing = builder.getEligibleForClearing();
            this.clearingRequirements = Optional.ofNullable(builder.getClearingRequirements()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.partiesAndAccountsModel = Optional.ofNullable(builder.getPartiesAndAccountsModel()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="tradingEventsModel")
        @RuneAttribute(value="tradingEventsModel")
        public TradingEventsModel getTradingEventsModel() {
            return this.tradingEventsModel;
        }

        @Override
        @RosettaAttribute(value="deClear")
        @RuneAttribute(value="deClear")
        public DeClear getDeClear() {
            return this.deClear;
        }

        @Override
        @RosettaAttribute(value="partyTradeIdentifier")
        @RuneAttribute(value="partyTradeIdentifier")
        public PartyTradeIdentifier getPartyTradeIdentifier() {
            return this.partyTradeIdentifier;
        }

        @Override
        @RosettaAttribute(value="eligibleForClearing", isRequired=true)
        @RuneAttribute(value="eligibleForClearing", isRequired=true)
        public Boolean getEligibleForClearing() {
            return this.eligibleForClearing;
        }

        @Override
        @RosettaAttribute(value="clearingRequirements")
        @RuneAttribute(value="clearingRequirements")
        public List<? extends ClearingRequirements> getClearingRequirements() {
            return this.clearingRequirements;
        }

        @Override
        @RosettaAttribute(value="partiesAndAccountsModel", isRequired=true)
        @RuneAttribute(value="partiesAndAccountsModel", isRequired=true)
        public PartiesAndAccountsModel getPartiesAndAccountsModel() {
            return this.partiesAndAccountsModel;
        }

        @Override
        public ClearingEligibility build() {
            return this;
        }

        @Override
        public ClearingEligibilityBuilder toBuilder() {
            ClearingEligibilityBuilder builder = ClearingEligibility.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ClearingEligibilityBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getTradingEventsModel()).ifPresent(builder::setTradingEventsModel);
            Optional.ofNullable(this.getDeClear()).ifPresent(builder::setDeClear);
            Optional.ofNullable(this.getPartyTradeIdentifier()).ifPresent(builder::setPartyTradeIdentifier);
            Optional.ofNullable(this.getEligibleForClearing()).ifPresent(builder::setEligibleForClearing);
            Optional.ofNullable(this.getClearingRequirements()).ifPresent(builder::setClearingRequirements);
            Optional.ofNullable(this.getPartiesAndAccountsModel()).ifPresent(builder::setPartiesAndAccountsModel);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ClearingEligibility _that = (ClearingEligibility)this.getType().cast(o);
            if (!Objects.equals(this.tradingEventsModel, _that.getTradingEventsModel())) {
                return false;
            }
            if (!Objects.equals(this.deClear, _that.getDeClear())) {
                return false;
            }
            if (!Objects.equals(this.partyTradeIdentifier, _that.getPartyTradeIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.eligibleForClearing, _that.getEligibleForClearing())) {
                return false;
            }
            if (!ListEquals.listEquals(this.clearingRequirements, _that.getClearingRequirements())) {
                return false;
            }
            return Objects.equals(this.partiesAndAccountsModel, _that.getPartiesAndAccountsModel());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.tradingEventsModel != null ? this.tradingEventsModel.hashCode() : 0);
            _result = 31 * _result + (this.deClear != null ? this.deClear.hashCode() : 0);
            _result = 31 * _result + (this.partyTradeIdentifier != null ? this.partyTradeIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.eligibleForClearing != null ? this.eligibleForClearing.hashCode() : 0);
            _result = 31 * _result + (this.clearingRequirements != null ? this.clearingRequirements.hashCode() : 0);
            _result = 31 * _result + (this.partiesAndAccountsModel != null ? this.partiesAndAccountsModel.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "ClearingEligibility {tradingEventsModel=" + this.tradingEventsModel + ", deClear=" + this.deClear + ", partyTradeIdentifier=" + this.partyTradeIdentifier + ", eligibleForClearing=" + this.eligibleForClearing + ", clearingRequirements=" + this.clearingRequirements + ", partiesAndAccountsModel=" + this.partiesAndAccountsModel + '}' + " " + super.toString();
        }
    }
}

