/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.cd;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.cd.CreditDefaultSwap;
import fpml.consolidated.cd.CreditOptionStrike;
import fpml.consolidated.cd.meta.CreditDefaultSwapOptionMeta;
import fpml.consolidated.fpmlenum.OptionTypeEnum;
import fpml.consolidated.option.shared.OptionBaseExtended;
import fpml.consolidated.option.shared.OptionDenominationModel;
import fpml.consolidated.option.shared.OptionFeature;
import fpml.consolidated.option.shared.OptionSettlementModel;
import fpml.consolidated.option.shared.Premium;
import fpml.consolidated.shared.BuyerSellerModel;
import fpml.consolidated.shared.Exercise;
import fpml.consolidated.shared.ExerciseProcedure;
import fpml.consolidated.shared.Money;
import fpml.consolidated.shared.NotionalAmountReference;
import fpml.consolidated.shared.ProductModel;
import fpml.consolidated.shared.SwaptionPhysicalSettlement;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="CreditDefaultSwapOption", builder=CreditDefaultSwapOptionBuilderImpl.class, version="1.1.0")
@RuneDataType(value="CreditDefaultSwapOption", model="fpml", builder=CreditDefaultSwapOptionBuilderImpl.class, version="1.1.0")
public interface CreditDefaultSwapOption
extends OptionBaseExtended {
    public static final CreditDefaultSwapOptionMeta metaData = new CreditDefaultSwapOptionMeta();

    public SwaptionPhysicalSettlement getClearingInstructions();

    public CreditOptionStrike getStrike();

    public CreditDefaultSwap getCreditDefaultSwap();

    @Override
    public CreditDefaultSwapOption build();

    @Override
    public CreditDefaultSwapOptionBuilder toBuilder();

    public static CreditDefaultSwapOptionBuilder builder() {
        return new CreditDefaultSwapOptionBuilderImpl();
    }

    default public RosettaMetaData<? extends CreditDefaultSwapOption> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends CreditDefaultSwapOption> getType() {
        return CreditDefaultSwapOption.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("productModel"), processor, ProductModel.class, this.getProductModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("buyerSellerModel"), processor, BuyerSellerModel.class, this.getBuyerSellerModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("optionType"), OptionTypeEnum.class, (Object)this.getOptionType(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("premium"), processor, Premium.class, this.getPremium(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("exercise"), processor, Exercise.class, this.getExercise(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("exerciseProcedure"), processor, ExerciseProcedure.class, this.getExerciseProcedure(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("feature"), processor, OptionFeature.class, this.getFeature(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("notionalReference"), processor, NotionalAmountReference.class, this.getNotionalReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("notionalAmount"), processor, Money.class, this.getNotionalAmount(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("optionDenominationModel"), processor, OptionDenominationModel.class, this.getOptionDenominationModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("optionSettlementModel"), processor, OptionSettlementModel.class, this.getOptionSettlementModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("clearingInstructions"), processor, SwaptionPhysicalSettlement.class, this.getClearingInstructions(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("strike"), processor, CreditOptionStrike.class, this.getStrike(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("creditDefaultSwap"), processor, CreditDefaultSwap.class, this.getCreditDefaultSwap(), new AttributeMeta[0]);
    }

    public static class CreditDefaultSwapOptionBuilderImpl
    extends OptionBaseExtended.OptionBaseExtendedBuilderImpl
    implements CreditDefaultSwapOptionBuilder {
        protected SwaptionPhysicalSettlement.SwaptionPhysicalSettlementBuilder clearingInstructions;
        protected CreditOptionStrike.CreditOptionStrikeBuilder strike;
        protected CreditDefaultSwap.CreditDefaultSwapBuilder creditDefaultSwap;

        @Override
        @RosettaAttribute(value="clearingInstructions")
        @RuneAttribute(value="clearingInstructions")
        public SwaptionPhysicalSettlement.SwaptionPhysicalSettlementBuilder getClearingInstructions() {
            return this.clearingInstructions;
        }

        @Override
        public SwaptionPhysicalSettlement.SwaptionPhysicalSettlementBuilder getOrCreateClearingInstructions() {
            SwaptionPhysicalSettlement.SwaptionPhysicalSettlementBuilder result = this.clearingInstructions != null ? this.clearingInstructions : (this.clearingInstructions = SwaptionPhysicalSettlement.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="strike", isRequired=true)
        @RuneAttribute(value="strike", isRequired=true)
        public CreditOptionStrike.CreditOptionStrikeBuilder getStrike() {
            return this.strike;
        }

        @Override
        public CreditOptionStrike.CreditOptionStrikeBuilder getOrCreateStrike() {
            CreditOptionStrike.CreditOptionStrikeBuilder result = this.strike != null ? this.strike : (this.strike = CreditOptionStrike.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="creditDefaultSwap", isRequired=true)
        @RuneAttribute(value="creditDefaultSwap", isRequired=true)
        public CreditDefaultSwap.CreditDefaultSwapBuilder getCreditDefaultSwap() {
            return this.creditDefaultSwap;
        }

        @Override
        public CreditDefaultSwap.CreditDefaultSwapBuilder getOrCreateCreditDefaultSwap() {
            CreditDefaultSwap.CreditDefaultSwapBuilder result = this.creditDefaultSwap != null ? this.creditDefaultSwap : (this.creditDefaultSwap = CreditDefaultSwap.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="productModel")
        @RuneAttribute(value="productModel")
        public CreditDefaultSwapOptionBuilder setProductModel(ProductModel _productModel) {
            this.productModel = _productModel == null ? null : _productModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public CreditDefaultSwapOptionBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="buyerSellerModel", isRequired=true)
        @RuneAttribute(value="buyerSellerModel", isRequired=true)
        public CreditDefaultSwapOptionBuilder setBuyerSellerModel(BuyerSellerModel _buyerSellerModel) {
            this.buyerSellerModel = _buyerSellerModel == null ? null : _buyerSellerModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="optionType", isRequired=true)
        @RuneAttribute(value="optionType", isRequired=true)
        public CreditDefaultSwapOptionBuilder setOptionType(OptionTypeEnum _optionType) {
            this.optionType = _optionType == null ? null : _optionType;
            return this;
        }

        @Override
        @RosettaAttribute(value="premium")
        @RuneAttribute(value="premium")
        public CreditDefaultSwapOptionBuilder setPremium(Premium _premium) {
            this.premium = _premium == null ? null : _premium.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="exercise", isRequired=true)
        @RuneAttribute(value="exercise", isRequired=true)
        public CreditDefaultSwapOptionBuilder setExercise(Exercise _exercise) {
            this.exercise = _exercise == null ? null : _exercise.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="exerciseProcedure")
        @RuneAttribute(value="exerciseProcedure")
        public CreditDefaultSwapOptionBuilder setExerciseProcedure(ExerciseProcedure _exerciseProcedure) {
            this.exerciseProcedure = _exerciseProcedure == null ? null : _exerciseProcedure.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="feature")
        @RuneAttribute(value="feature")
        public CreditDefaultSwapOptionBuilder setFeature(OptionFeature _feature) {
            this.feature = _feature == null ? null : _feature.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="notionalReference")
        @RuneAttribute(value="notionalReference")
        public CreditDefaultSwapOptionBuilder setNotionalReference(NotionalAmountReference _notionalReference) {
            this.notionalReference = _notionalReference == null ? null : _notionalReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="notionalAmount")
        @RuneAttribute(value="notionalAmount")
        public CreditDefaultSwapOptionBuilder setNotionalAmount(Money _notionalAmount) {
            this.notionalAmount = _notionalAmount == null ? null : _notionalAmount.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="optionDenominationModel")
        @RuneAttribute(value="optionDenominationModel")
        public CreditDefaultSwapOptionBuilder setOptionDenominationModel(OptionDenominationModel _optionDenominationModel) {
            this.optionDenominationModel = _optionDenominationModel == null ? null : _optionDenominationModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="optionSettlementModel", isRequired=true)
        @RuneAttribute(value="optionSettlementModel", isRequired=true)
        public CreditDefaultSwapOptionBuilder setOptionSettlementModel(OptionSettlementModel _optionSettlementModel) {
            this.optionSettlementModel = _optionSettlementModel == null ? null : _optionSettlementModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="clearingInstructions")
        @RuneAttribute(value="clearingInstructions")
        public CreditDefaultSwapOptionBuilder setClearingInstructions(SwaptionPhysicalSettlement _clearingInstructions) {
            this.clearingInstructions = _clearingInstructions == null ? null : _clearingInstructions.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="strike", isRequired=true)
        @RuneAttribute(value="strike", isRequired=true)
        public CreditDefaultSwapOptionBuilder setStrike(CreditOptionStrike _strike) {
            this.strike = _strike == null ? null : _strike.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="creditDefaultSwap", isRequired=true)
        @RuneAttribute(value="creditDefaultSwap", isRequired=true)
        public CreditDefaultSwapOptionBuilder setCreditDefaultSwap(CreditDefaultSwap _creditDefaultSwap) {
            this.creditDefaultSwap = _creditDefaultSwap == null ? null : _creditDefaultSwap.toBuilder();
            return this;
        }

        @Override
        public CreditDefaultSwapOption build() {
            return new CreditDefaultSwapOptionImpl(this);
        }

        @Override
        public CreditDefaultSwapOptionBuilder toBuilder() {
            return this;
        }

        @Override
        public CreditDefaultSwapOptionBuilder prune() {
            super.prune();
            if (this.clearingInstructions != null && !this.clearingInstructions.prune().hasData()) {
                this.clearingInstructions = null;
            }
            if (this.strike != null && !this.strike.prune().hasData()) {
                this.strike = null;
            }
            if (this.creditDefaultSwap != null && !this.creditDefaultSwap.prune().hasData()) {
                this.creditDefaultSwap = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getClearingInstructions() != null && this.getClearingInstructions().hasData()) {
                return true;
            }
            if (this.getStrike() != null && this.getStrike().hasData()) {
                return true;
            }
            return this.getCreditDefaultSwap() != null && this.getCreditDefaultSwap().hasData();
        }

        @Override
        public CreditDefaultSwapOptionBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            CreditDefaultSwapOptionBuilder o = (CreditDefaultSwapOptionBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getClearingInstructions(), (RosettaModelObjectBuilder)o.getClearingInstructions(), this::setClearingInstructions);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getStrike(), (RosettaModelObjectBuilder)o.getStrike(), this::setStrike);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCreditDefaultSwap(), (RosettaModelObjectBuilder)o.getCreditDefaultSwap(), this::setCreditDefaultSwap);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            CreditDefaultSwapOption _that = (CreditDefaultSwapOption)this.getType().cast(o);
            if (!Objects.equals(this.clearingInstructions, _that.getClearingInstructions())) {
                return false;
            }
            if (!Objects.equals(this.strike, _that.getStrike())) {
                return false;
            }
            return Objects.equals(this.creditDefaultSwap, _that.getCreditDefaultSwap());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.clearingInstructions != null ? this.clearingInstructions.hashCode() : 0);
            _result = 31 * _result + (this.strike != null ? this.strike.hashCode() : 0);
            _result = 31 * _result + (this.creditDefaultSwap != null ? this.creditDefaultSwap.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "CreditDefaultSwapOptionBuilder {clearingInstructions=" + this.clearingInstructions + ", strike=" + this.strike + ", creditDefaultSwap=" + this.creditDefaultSwap + '}' + " " + super.toString();
        }
    }

    public static interface CreditDefaultSwapOptionBuilder
    extends CreditDefaultSwapOption,
    OptionBaseExtended.OptionBaseExtendedBuilder {
        public SwaptionPhysicalSettlement.SwaptionPhysicalSettlementBuilder getOrCreateClearingInstructions();

        @Override
        public SwaptionPhysicalSettlement.SwaptionPhysicalSettlementBuilder getClearingInstructions();

        public CreditOptionStrike.CreditOptionStrikeBuilder getOrCreateStrike();

        @Override
        public CreditOptionStrike.CreditOptionStrikeBuilder getStrike();

        public CreditDefaultSwap.CreditDefaultSwapBuilder getOrCreateCreditDefaultSwap();

        @Override
        public CreditDefaultSwap.CreditDefaultSwapBuilder getCreditDefaultSwap();

        @Override
        public CreditDefaultSwapOptionBuilder setProductModel(ProductModel var1);

        @Override
        public CreditDefaultSwapOptionBuilder setId(String var1);

        @Override
        public CreditDefaultSwapOptionBuilder setBuyerSellerModel(BuyerSellerModel var1);

        @Override
        public CreditDefaultSwapOptionBuilder setOptionType(OptionTypeEnum var1);

        @Override
        public CreditDefaultSwapOptionBuilder setPremium(Premium var1);

        @Override
        public CreditDefaultSwapOptionBuilder setExercise(Exercise var1);

        @Override
        public CreditDefaultSwapOptionBuilder setExerciseProcedure(ExerciseProcedure var1);

        @Override
        public CreditDefaultSwapOptionBuilder setFeature(OptionFeature var1);

        @Override
        public CreditDefaultSwapOptionBuilder setNotionalReference(NotionalAmountReference var1);

        @Override
        public CreditDefaultSwapOptionBuilder setNotionalAmount(Money var1);

        @Override
        public CreditDefaultSwapOptionBuilder setOptionDenominationModel(OptionDenominationModel var1);

        @Override
        public CreditDefaultSwapOptionBuilder setOptionSettlementModel(OptionSettlementModel var1);

        public CreditDefaultSwapOptionBuilder setClearingInstructions(SwaptionPhysicalSettlement var1);

        public CreditDefaultSwapOptionBuilder setStrike(CreditOptionStrike var1);

        public CreditDefaultSwapOptionBuilder setCreditDefaultSwap(CreditDefaultSwap var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("productModel"), processor, ProductModel.ProductModelBuilder.class, (RosettaModelObjectBuilder)this.getProductModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("buyerSellerModel"), processor, BuyerSellerModel.BuyerSellerModelBuilder.class, (RosettaModelObjectBuilder)this.getBuyerSellerModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("optionType"), OptionTypeEnum.class, (Object)this.getOptionType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("premium"), processor, Premium.PremiumBuilder.class, (RosettaModelObjectBuilder)this.getPremium(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("exercise"), processor, Exercise.ExerciseBuilder.class, (RosettaModelObjectBuilder)this.getExercise(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("exerciseProcedure"), processor, ExerciseProcedure.ExerciseProcedureBuilder.class, (RosettaModelObjectBuilder)this.getExerciseProcedure(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("feature"), processor, OptionFeature.OptionFeatureBuilder.class, (RosettaModelObjectBuilder)this.getFeature(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("notionalReference"), processor, NotionalAmountReference.NotionalAmountReferenceBuilder.class, (RosettaModelObjectBuilder)this.getNotionalReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("notionalAmount"), processor, Money.MoneyBuilder.class, (RosettaModelObjectBuilder)this.getNotionalAmount(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("optionDenominationModel"), processor, OptionDenominationModel.OptionDenominationModelBuilder.class, (RosettaModelObjectBuilder)this.getOptionDenominationModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("optionSettlementModel"), processor, OptionSettlementModel.OptionSettlementModelBuilder.class, (RosettaModelObjectBuilder)this.getOptionSettlementModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("clearingInstructions"), processor, SwaptionPhysicalSettlement.SwaptionPhysicalSettlementBuilder.class, this.getClearingInstructions(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("strike"), processor, CreditOptionStrike.CreditOptionStrikeBuilder.class, this.getStrike(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("creditDefaultSwap"), processor, CreditDefaultSwap.CreditDefaultSwapBuilder.class, this.getCreditDefaultSwap(), new AttributeMeta[0]);
        }

        @Override
        public CreditDefaultSwapOptionBuilder prune();
    }

    public static class CreditDefaultSwapOptionImpl
    extends OptionBaseExtended.OptionBaseExtendedImpl
    implements CreditDefaultSwapOption {
        private final SwaptionPhysicalSettlement clearingInstructions;
        private final CreditOptionStrike strike;
        private final CreditDefaultSwap creditDefaultSwap;

        protected CreditDefaultSwapOptionImpl(CreditDefaultSwapOptionBuilder builder) {
            super(builder);
            this.clearingInstructions = Optional.ofNullable(builder.getClearingInstructions()).map(f -> f.build()).orElse(null);
            this.strike = Optional.ofNullable(builder.getStrike()).map(f -> f.build()).orElse(null);
            this.creditDefaultSwap = Optional.ofNullable(builder.getCreditDefaultSwap()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="clearingInstructions")
        @RuneAttribute(value="clearingInstructions")
        public SwaptionPhysicalSettlement getClearingInstructions() {
            return this.clearingInstructions;
        }

        @Override
        @RosettaAttribute(value="strike", isRequired=true)
        @RuneAttribute(value="strike", isRequired=true)
        public CreditOptionStrike getStrike() {
            return this.strike;
        }

        @Override
        @RosettaAttribute(value="creditDefaultSwap", isRequired=true)
        @RuneAttribute(value="creditDefaultSwap", isRequired=true)
        public CreditDefaultSwap getCreditDefaultSwap() {
            return this.creditDefaultSwap;
        }

        @Override
        public CreditDefaultSwapOption build() {
            return this;
        }

        @Override
        public CreditDefaultSwapOptionBuilder toBuilder() {
            CreditDefaultSwapOptionBuilder builder = CreditDefaultSwapOption.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CreditDefaultSwapOptionBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getClearingInstructions()).ifPresent(builder::setClearingInstructions);
            Optional.ofNullable(this.getStrike()).ifPresent(builder::setStrike);
            Optional.ofNullable(this.getCreditDefaultSwap()).ifPresent(builder::setCreditDefaultSwap);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            CreditDefaultSwapOption _that = (CreditDefaultSwapOption)this.getType().cast(o);
            if (!Objects.equals(this.clearingInstructions, _that.getClearingInstructions())) {
                return false;
            }
            if (!Objects.equals(this.strike, _that.getStrike())) {
                return false;
            }
            return Objects.equals(this.creditDefaultSwap, _that.getCreditDefaultSwap());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.clearingInstructions != null ? this.clearingInstructions.hashCode() : 0);
            _result = 31 * _result + (this.strike != null ? this.strike.hashCode() : 0);
            _result = 31 * _result + (this.creditDefaultSwap != null ? this.creditDefaultSwap.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "CreditDefaultSwapOption {clearingInstructions=" + this.clearingInstructions + ", strike=" + this.strike + ", creditDefaultSwap=" + this.creditDefaultSwap + '}' + " " + super.toString();
        }
    }
}

