/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.business.events;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.business.events.AmountRef;
import fpml.consolidated.business.events.MoneyRef;
import fpml.consolidated.business.events.UnitQuantityRef;
import fpml.consolidated.business.events.meta.ReportingNotionalChangeModelMeta;
import fpml.consolidated.fpmlenum.NotionalChangeEnum;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="ReportingNotionalChangeModel", builder=ReportingNotionalChangeModelBuilderImpl.class, version="1.1.0")
@RuneDataType(value="ReportingNotionalChangeModel", model="fpml", builder=ReportingNotionalChangeModelBuilderImpl.class, version="1.1.0")
public interface ReportingNotionalChangeModel
extends RosettaModelObject {
    public static final ReportingNotionalChangeModelMeta metaData = new ReportingNotionalChangeModelMeta();

    public NotionalChangeEnum getNotionalChange();

    public List<? extends MoneyRef> getChangeInNotional();

    public List<? extends AmountRef> getChangeInNumberOfOptions();

    public List<? extends UnitQuantityRef> getChangeInQuantity();

    public ReportingNotionalChangeModel build();

    public ReportingNotionalChangeModelBuilder toBuilder();

    public static ReportingNotionalChangeModelBuilder builder() {
        return new ReportingNotionalChangeModelBuilderImpl();
    }

    default public RosettaMetaData<? extends ReportingNotionalChangeModel> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends ReportingNotionalChangeModel> getType() {
        return ReportingNotionalChangeModel.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("notionalChange"), NotionalChangeEnum.class, (Object)this.getNotionalChange(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("changeInNotional"), processor, MoneyRef.class, this.getChangeInNotional(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("changeInNumberOfOptions"), processor, AmountRef.class, this.getChangeInNumberOfOptions(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("changeInQuantity"), processor, UnitQuantityRef.class, this.getChangeInQuantity(), new AttributeMeta[0]);
    }

    public static class ReportingNotionalChangeModelBuilderImpl
    implements ReportingNotionalChangeModelBuilder {
        protected NotionalChangeEnum notionalChange;
        protected List<MoneyRef.MoneyRefBuilder> changeInNotional = new ArrayList<MoneyRef.MoneyRefBuilder>();
        protected List<AmountRef.AmountRefBuilder> changeInNumberOfOptions = new ArrayList<AmountRef.AmountRefBuilder>();
        protected List<UnitQuantityRef.UnitQuantityRefBuilder> changeInQuantity = new ArrayList<UnitQuantityRef.UnitQuantityRefBuilder>();

        @Override
        @RosettaAttribute(value="notionalChange")
        @RuneAttribute(value="notionalChange")
        public NotionalChangeEnum getNotionalChange() {
            return this.notionalChange;
        }

        @Override
        @RosettaAttribute(value="changeInNotional")
        @RuneAttribute(value="changeInNotional")
        public List<? extends MoneyRef.MoneyRefBuilder> getChangeInNotional() {
            return this.changeInNotional;
        }

        @Override
        public MoneyRef.MoneyRefBuilder getOrCreateChangeInNotional(int index) {
            if (this.changeInNotional == null) {
                this.changeInNotional = new ArrayList<MoneyRef.MoneyRefBuilder>();
            }
            return (MoneyRef.MoneyRefBuilder)this.getIndex(this.changeInNotional, index, () -> {
                MoneyRef.MoneyRefBuilder newChangeInNotional = MoneyRef.builder();
                return newChangeInNotional;
            });
        }

        @Override
        @RosettaAttribute(value="changeInNumberOfOptions")
        @RuneAttribute(value="changeInNumberOfOptions")
        public List<? extends AmountRef.AmountRefBuilder> getChangeInNumberOfOptions() {
            return this.changeInNumberOfOptions;
        }

        @Override
        public AmountRef.AmountRefBuilder getOrCreateChangeInNumberOfOptions(int index) {
            if (this.changeInNumberOfOptions == null) {
                this.changeInNumberOfOptions = new ArrayList<AmountRef.AmountRefBuilder>();
            }
            return (AmountRef.AmountRefBuilder)this.getIndex(this.changeInNumberOfOptions, index, () -> {
                AmountRef.AmountRefBuilder newChangeInNumberOfOptions = AmountRef.builder();
                return newChangeInNumberOfOptions;
            });
        }

        @Override
        @RosettaAttribute(value="changeInQuantity")
        @RuneAttribute(value="changeInQuantity")
        public List<? extends UnitQuantityRef.UnitQuantityRefBuilder> getChangeInQuantity() {
            return this.changeInQuantity;
        }

        @Override
        public UnitQuantityRef.UnitQuantityRefBuilder getOrCreateChangeInQuantity(int index) {
            if (this.changeInQuantity == null) {
                this.changeInQuantity = new ArrayList<UnitQuantityRef.UnitQuantityRefBuilder>();
            }
            return (UnitQuantityRef.UnitQuantityRefBuilder)this.getIndex(this.changeInQuantity, index, () -> {
                UnitQuantityRef.UnitQuantityRefBuilder newChangeInQuantity = UnitQuantityRef.builder();
                return newChangeInQuantity;
            });
        }

        @Override
        @RosettaAttribute(value="notionalChange")
        @RuneAttribute(value="notionalChange")
        public ReportingNotionalChangeModelBuilder setNotionalChange(NotionalChangeEnum _notionalChange) {
            this.notionalChange = _notionalChange == null ? null : _notionalChange;
            return this;
        }

        @Override
        @RosettaAttribute(value="changeInNotional")
        @RuneAttribute(value="changeInNotional")
        public ReportingNotionalChangeModelBuilder addChangeInNotional(MoneyRef _changeInNotional) {
            if (_changeInNotional != null) {
                this.changeInNotional.add(_changeInNotional.toBuilder());
            }
            return this;
        }

        @Override
        public ReportingNotionalChangeModelBuilder addChangeInNotional(MoneyRef _changeInNotional, int idx) {
            this.getIndex(this.changeInNotional, idx, () -> _changeInNotional.toBuilder());
            return this;
        }

        @Override
        public ReportingNotionalChangeModelBuilder addChangeInNotional(List<? extends MoneyRef> changeInNotionals) {
            if (changeInNotionals != null) {
                for (MoneyRef moneyRef : changeInNotionals) {
                    this.changeInNotional.add(moneyRef.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="changeInNotional")
        public ReportingNotionalChangeModelBuilder setChangeInNotional(List<? extends MoneyRef> changeInNotionals) {
            this.changeInNotional = changeInNotionals == null ? new ArrayList<MoneyRef.MoneyRefBuilder>() : (List)changeInNotionals.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="changeInNumberOfOptions")
        @RuneAttribute(value="changeInNumberOfOptions")
        public ReportingNotionalChangeModelBuilder addChangeInNumberOfOptions(AmountRef _changeInNumberOfOptions) {
            if (_changeInNumberOfOptions != null) {
                this.changeInNumberOfOptions.add(_changeInNumberOfOptions.toBuilder());
            }
            return this;
        }

        @Override
        public ReportingNotionalChangeModelBuilder addChangeInNumberOfOptions(AmountRef _changeInNumberOfOptions, int idx) {
            this.getIndex(this.changeInNumberOfOptions, idx, () -> _changeInNumberOfOptions.toBuilder());
            return this;
        }

        @Override
        public ReportingNotionalChangeModelBuilder addChangeInNumberOfOptions(List<? extends AmountRef> changeInNumberOfOptionss) {
            if (changeInNumberOfOptionss != null) {
                for (AmountRef amountRef : changeInNumberOfOptionss) {
                    this.changeInNumberOfOptions.add(amountRef.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="changeInNumberOfOptions")
        public ReportingNotionalChangeModelBuilder setChangeInNumberOfOptions(List<? extends AmountRef> changeInNumberOfOptionss) {
            this.changeInNumberOfOptions = changeInNumberOfOptionss == null ? new ArrayList<AmountRef.AmountRefBuilder>() : (List)changeInNumberOfOptionss.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="changeInQuantity")
        @RuneAttribute(value="changeInQuantity")
        public ReportingNotionalChangeModelBuilder addChangeInQuantity(UnitQuantityRef _changeInQuantity) {
            if (_changeInQuantity != null) {
                this.changeInQuantity.add(_changeInQuantity.toBuilder());
            }
            return this;
        }

        @Override
        public ReportingNotionalChangeModelBuilder addChangeInQuantity(UnitQuantityRef _changeInQuantity, int idx) {
            this.getIndex(this.changeInQuantity, idx, () -> _changeInQuantity.toBuilder());
            return this;
        }

        @Override
        public ReportingNotionalChangeModelBuilder addChangeInQuantity(List<? extends UnitQuantityRef> changeInQuantitys) {
            if (changeInQuantitys != null) {
                for (UnitQuantityRef unitQuantityRef : changeInQuantitys) {
                    this.changeInQuantity.add(unitQuantityRef.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="changeInQuantity")
        public ReportingNotionalChangeModelBuilder setChangeInQuantity(List<? extends UnitQuantityRef> changeInQuantitys) {
            this.changeInQuantity = changeInQuantitys == null ? new ArrayList<UnitQuantityRef.UnitQuantityRefBuilder>() : (List)changeInQuantitys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public ReportingNotionalChangeModel build() {
            return new ReportingNotionalChangeModelImpl(this);
        }

        @Override
        public ReportingNotionalChangeModelBuilder toBuilder() {
            return this;
        }

        @Override
        public ReportingNotionalChangeModelBuilder prune() {
            this.changeInNotional = this.changeInNotional.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.changeInNumberOfOptions = this.changeInNumberOfOptions.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.changeInQuantity = this.changeInQuantity.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getNotionalChange() != null) {
                return true;
            }
            if (this.getChangeInNotional() != null && this.getChangeInNotional().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getChangeInNumberOfOptions() != null && this.getChangeInNumberOfOptions().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getChangeInQuantity() != null && this.getChangeInQuantity().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public ReportingNotionalChangeModelBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            ReportingNotionalChangeModelBuilder o = (ReportingNotionalChangeModelBuilder)other;
            merger.mergeRosetta(this.getChangeInNotional(), o.getChangeInNotional(), this::getOrCreateChangeInNotional);
            merger.mergeRosetta(this.getChangeInNumberOfOptions(), o.getChangeInNumberOfOptions(), this::getOrCreateChangeInNumberOfOptions);
            merger.mergeRosetta(this.getChangeInQuantity(), o.getChangeInQuantity(), this::getOrCreateChangeInQuantity);
            merger.mergeBasic((Object)this.getNotionalChange(), (Object)o.getNotionalChange(), this::setNotionalChange, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ReportingNotionalChangeModel _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.notionalChange, (Object)_that.getNotionalChange())) {
                return false;
            }
            if (!ListEquals.listEquals(this.changeInNotional, _that.getChangeInNotional())) {
                return false;
            }
            if (!ListEquals.listEquals(this.changeInNumberOfOptions, _that.getChangeInNumberOfOptions())) {
                return false;
            }
            return ListEquals.listEquals(this.changeInQuantity, _that.getChangeInQuantity());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.notionalChange != null ? ((Object)((Object)this.notionalChange)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.changeInNotional != null ? this.changeInNotional.hashCode() : 0);
            _result = 31 * _result + (this.changeInNumberOfOptions != null ? this.changeInNumberOfOptions.hashCode() : 0);
            _result = 31 * _result + (this.changeInQuantity != null ? this.changeInQuantity.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ReportingNotionalChangeModelBuilder {notionalChange=" + (Object)((Object)this.notionalChange) + ", changeInNotional=" + this.changeInNotional + ", changeInNumberOfOptions=" + this.changeInNumberOfOptions + ", changeInQuantity=" + this.changeInQuantity + '}';
        }
    }

    public static interface ReportingNotionalChangeModelBuilder
    extends ReportingNotionalChangeModel,
    RosettaModelObjectBuilder {
        public MoneyRef.MoneyRefBuilder getOrCreateChangeInNotional(int var1);

        public List<? extends MoneyRef.MoneyRefBuilder> getChangeInNotional();

        public AmountRef.AmountRefBuilder getOrCreateChangeInNumberOfOptions(int var1);

        public List<? extends AmountRef.AmountRefBuilder> getChangeInNumberOfOptions();

        public UnitQuantityRef.UnitQuantityRefBuilder getOrCreateChangeInQuantity(int var1);

        public List<? extends UnitQuantityRef.UnitQuantityRefBuilder> getChangeInQuantity();

        public ReportingNotionalChangeModelBuilder setNotionalChange(NotionalChangeEnum var1);

        public ReportingNotionalChangeModelBuilder addChangeInNotional(MoneyRef var1);

        public ReportingNotionalChangeModelBuilder addChangeInNotional(MoneyRef var1, int var2);

        public ReportingNotionalChangeModelBuilder addChangeInNotional(List<? extends MoneyRef> var1);

        public ReportingNotionalChangeModelBuilder setChangeInNotional(List<? extends MoneyRef> var1);

        public ReportingNotionalChangeModelBuilder addChangeInNumberOfOptions(AmountRef var1);

        public ReportingNotionalChangeModelBuilder addChangeInNumberOfOptions(AmountRef var1, int var2);

        public ReportingNotionalChangeModelBuilder addChangeInNumberOfOptions(List<? extends AmountRef> var1);

        public ReportingNotionalChangeModelBuilder setChangeInNumberOfOptions(List<? extends AmountRef> var1);

        public ReportingNotionalChangeModelBuilder addChangeInQuantity(UnitQuantityRef var1);

        public ReportingNotionalChangeModelBuilder addChangeInQuantity(UnitQuantityRef var1, int var2);

        public ReportingNotionalChangeModelBuilder addChangeInQuantity(List<? extends UnitQuantityRef> var1);

        public ReportingNotionalChangeModelBuilder setChangeInQuantity(List<? extends UnitQuantityRef> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("notionalChange"), NotionalChangeEnum.class, (Object)this.getNotionalChange(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("changeInNotional"), processor, MoneyRef.MoneyRefBuilder.class, this.getChangeInNotional(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("changeInNumberOfOptions"), processor, AmountRef.AmountRefBuilder.class, this.getChangeInNumberOfOptions(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("changeInQuantity"), processor, UnitQuantityRef.UnitQuantityRefBuilder.class, this.getChangeInQuantity(), new AttributeMeta[0]);
        }

        public ReportingNotionalChangeModelBuilder prune();
    }

    public static class ReportingNotionalChangeModelImpl
    implements ReportingNotionalChangeModel {
        private final NotionalChangeEnum notionalChange;
        private final List<? extends MoneyRef> changeInNotional;
        private final List<? extends AmountRef> changeInNumberOfOptions;
        private final List<? extends UnitQuantityRef> changeInQuantity;

        protected ReportingNotionalChangeModelImpl(ReportingNotionalChangeModelBuilder builder) {
            this.notionalChange = builder.getNotionalChange();
            this.changeInNotional = Optional.ofNullable(builder.getChangeInNotional()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.changeInNumberOfOptions = Optional.ofNullable(builder.getChangeInNumberOfOptions()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.changeInQuantity = Optional.ofNullable(builder.getChangeInQuantity()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="notionalChange")
        @RuneAttribute(value="notionalChange")
        public NotionalChangeEnum getNotionalChange() {
            return this.notionalChange;
        }

        @Override
        @RosettaAttribute(value="changeInNotional")
        @RuneAttribute(value="changeInNotional")
        public List<? extends MoneyRef> getChangeInNotional() {
            return this.changeInNotional;
        }

        @Override
        @RosettaAttribute(value="changeInNumberOfOptions")
        @RuneAttribute(value="changeInNumberOfOptions")
        public List<? extends AmountRef> getChangeInNumberOfOptions() {
            return this.changeInNumberOfOptions;
        }

        @Override
        @RosettaAttribute(value="changeInQuantity")
        @RuneAttribute(value="changeInQuantity")
        public List<? extends UnitQuantityRef> getChangeInQuantity() {
            return this.changeInQuantity;
        }

        @Override
        public ReportingNotionalChangeModel build() {
            return this;
        }

        @Override
        public ReportingNotionalChangeModelBuilder toBuilder() {
            ReportingNotionalChangeModelBuilder builder = ReportingNotionalChangeModel.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ReportingNotionalChangeModelBuilder builder) {
            Optional.ofNullable(this.getNotionalChange()).ifPresent(builder::setNotionalChange);
            Optional.ofNullable(this.getChangeInNotional()).ifPresent(builder::setChangeInNotional);
            Optional.ofNullable(this.getChangeInNumberOfOptions()).ifPresent(builder::setChangeInNumberOfOptions);
            Optional.ofNullable(this.getChangeInQuantity()).ifPresent(builder::setChangeInQuantity);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ReportingNotionalChangeModel _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.notionalChange, (Object)_that.getNotionalChange())) {
                return false;
            }
            if (!ListEquals.listEquals(this.changeInNotional, _that.getChangeInNotional())) {
                return false;
            }
            if (!ListEquals.listEquals(this.changeInNumberOfOptions, _that.getChangeInNumberOfOptions())) {
                return false;
            }
            return ListEquals.listEquals(this.changeInQuantity, _that.getChangeInQuantity());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.notionalChange != null ? ((Object)((Object)this.notionalChange)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.changeInNotional != null ? this.changeInNotional.hashCode() : 0);
            _result = 31 * _result + (this.changeInNumberOfOptions != null ? this.changeInNumberOfOptions.hashCode() : 0);
            _result = 31 * _result + (this.changeInQuantity != null ? this.changeInQuantity.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ReportingNotionalChangeModel {notionalChange=" + (Object)((Object)this.notionalChange) + ", changeInNotional=" + this.changeInNotional + ", changeInNumberOfOptions=" + this.changeInNumberOfOptions + ", changeInQuantity=" + this.changeInQuantity + '}';
        }
    }
}

