/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.business.events;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.business.events.EventValuationModel;
import fpml.consolidated.business.events.TradePackage;
import fpml.consolidated.business.events.TradeReferenceInformationModel;
import fpml.consolidated.business.events.meta.ClearingStatusItemMeta;
import fpml.consolidated.doc.ClearingStatusValue;
import fpml.consolidated.doc.Reason;
import fpml.consolidated.doc.Trade;
import fpml.consolidated.doc.TradeIdentifier;
import fpml.consolidated.shared.PartyReference;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="ClearingStatusItem", builder=ClearingStatusItemBuilderImpl.class, version="1.1.0")
@RuneDataType(value="ClearingStatusItem", model="fpml", builder=ClearingStatusItemBuilderImpl.class, version="1.1.0")
public interface ClearingStatusItem
extends RosettaModelObject {
    public static final ClearingStatusItemMeta metaData = new ClearingStatusItemMeta();

    public List<? extends TradeIdentifier> getTradeIdentifier();

    public TradeReferenceInformationModel getTradeReferenceInformationModel();

    public Trade getTrade();

    public TradePackage getTradePackage();

    public EventValuationModel getEventValuationModel();

    public ClearingStatusValue getClearingStatusValue();

    public ZonedDateTime getUpdatedDateTime();

    public List<? extends Reason> getReason();

    public List<? extends PartyReference> getStatusAppliesTo();

    public ClearingStatusItem build();

    public ClearingStatusItemBuilder toBuilder();

    public static ClearingStatusItemBuilder builder() {
        return new ClearingStatusItemBuilderImpl();
    }

    default public RosettaMetaData<? extends ClearingStatusItem> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends ClearingStatusItem> getType() {
        return ClearingStatusItem.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("tradeIdentifier"), processor, TradeIdentifier.class, this.getTradeIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("tradeReferenceInformationModel"), processor, TradeReferenceInformationModel.class, this.getTradeReferenceInformationModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("trade"), processor, Trade.class, this.getTrade(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("tradePackage"), processor, TradePackage.class, this.getTradePackage(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("eventValuationModel"), processor, EventValuationModel.class, this.getEventValuationModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("clearingStatusValue"), processor, ClearingStatusValue.class, this.getClearingStatusValue(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("updatedDateTime"), ZonedDateTime.class, (Object)this.getUpdatedDateTime(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("reason"), processor, Reason.class, this.getReason(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("statusAppliesTo"), processor, PartyReference.class, this.getStatusAppliesTo(), new AttributeMeta[0]);
    }

    public static class ClearingStatusItemBuilderImpl
    implements ClearingStatusItemBuilder {
        protected List<TradeIdentifier.TradeIdentifierBuilder> tradeIdentifier = new ArrayList<TradeIdentifier.TradeIdentifierBuilder>();
        protected TradeReferenceInformationModel.TradeReferenceInformationModelBuilder tradeReferenceInformationModel;
        protected Trade.TradeBuilder trade;
        protected TradePackage.TradePackageBuilder tradePackage;
        protected EventValuationModel.EventValuationModelBuilder eventValuationModel;
        protected ClearingStatusValue.ClearingStatusValueBuilder clearingStatusValue;
        protected ZonedDateTime updatedDateTime;
        protected List<Reason.ReasonBuilder> reason = new ArrayList<Reason.ReasonBuilder>();
        protected List<PartyReference.PartyReferenceBuilder> statusAppliesTo = new ArrayList<PartyReference.PartyReferenceBuilder>();

        @Override
        @RosettaAttribute(value="tradeIdentifier")
        @RuneAttribute(value="tradeIdentifier")
        public List<? extends TradeIdentifier.TradeIdentifierBuilder> getTradeIdentifier() {
            return this.tradeIdentifier;
        }

        @Override
        public TradeIdentifier.TradeIdentifierBuilder getOrCreateTradeIdentifier(int index) {
            if (this.tradeIdentifier == null) {
                this.tradeIdentifier = new ArrayList<TradeIdentifier.TradeIdentifierBuilder>();
            }
            return (TradeIdentifier.TradeIdentifierBuilder)this.getIndex(this.tradeIdentifier, index, () -> {
                TradeIdentifier.TradeIdentifierBuilder newTradeIdentifier = TradeIdentifier.builder();
                return newTradeIdentifier;
            });
        }

        @Override
        @RosettaAttribute(value="tradeReferenceInformationModel")
        @RuneAttribute(value="tradeReferenceInformationModel")
        public TradeReferenceInformationModel.TradeReferenceInformationModelBuilder getTradeReferenceInformationModel() {
            return this.tradeReferenceInformationModel;
        }

        @Override
        public TradeReferenceInformationModel.TradeReferenceInformationModelBuilder getOrCreateTradeReferenceInformationModel() {
            TradeReferenceInformationModel.TradeReferenceInformationModelBuilder result = this.tradeReferenceInformationModel != null ? this.tradeReferenceInformationModel : (this.tradeReferenceInformationModel = TradeReferenceInformationModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="trade")
        @RuneAttribute(value="trade")
        public Trade.TradeBuilder getTrade() {
            return this.trade;
        }

        @Override
        public Trade.TradeBuilder getOrCreateTrade() {
            Trade.TradeBuilder result = this.trade != null ? this.trade : (this.trade = Trade.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="tradePackage")
        @RuneAttribute(value="tradePackage")
        public TradePackage.TradePackageBuilder getTradePackage() {
            return this.tradePackage;
        }

        @Override
        public TradePackage.TradePackageBuilder getOrCreateTradePackage() {
            TradePackage.TradePackageBuilder result = this.tradePackage != null ? this.tradePackage : (this.tradePackage = TradePackage.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="eventValuationModel")
        @RuneAttribute(value="eventValuationModel")
        public EventValuationModel.EventValuationModelBuilder getEventValuationModel() {
            return this.eventValuationModel;
        }

        @Override
        public EventValuationModel.EventValuationModelBuilder getOrCreateEventValuationModel() {
            EventValuationModel.EventValuationModelBuilder result = this.eventValuationModel != null ? this.eventValuationModel : (this.eventValuationModel = EventValuationModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="clearingStatusValue", isRequired=true)
        @RuneAttribute(value="clearingStatusValue", isRequired=true)
        public ClearingStatusValue.ClearingStatusValueBuilder getClearingStatusValue() {
            return this.clearingStatusValue;
        }

        @Override
        public ClearingStatusValue.ClearingStatusValueBuilder getOrCreateClearingStatusValue() {
            ClearingStatusValue.ClearingStatusValueBuilder result = this.clearingStatusValue != null ? this.clearingStatusValue : (this.clearingStatusValue = ClearingStatusValue.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="updatedDateTime")
        @RuneAttribute(value="updatedDateTime")
        public ZonedDateTime getUpdatedDateTime() {
            return this.updatedDateTime;
        }

        @Override
        @RosettaAttribute(value="reason")
        @RuneAttribute(value="reason")
        public List<? extends Reason.ReasonBuilder> getReason() {
            return this.reason;
        }

        @Override
        public Reason.ReasonBuilder getOrCreateReason(int index) {
            if (this.reason == null) {
                this.reason = new ArrayList<Reason.ReasonBuilder>();
            }
            return (Reason.ReasonBuilder)this.getIndex(this.reason, index, () -> {
                Reason.ReasonBuilder newReason = Reason.builder();
                return newReason;
            });
        }

        @Override
        @RosettaAttribute(value="statusAppliesTo")
        @RuneAttribute(value="statusAppliesTo")
        public List<? extends PartyReference.PartyReferenceBuilder> getStatusAppliesTo() {
            return this.statusAppliesTo;
        }

        @Override
        public PartyReference.PartyReferenceBuilder getOrCreateStatusAppliesTo(int index) {
            if (this.statusAppliesTo == null) {
                this.statusAppliesTo = new ArrayList<PartyReference.PartyReferenceBuilder>();
            }
            return (PartyReference.PartyReferenceBuilder)this.getIndex(this.statusAppliesTo, index, () -> {
                PartyReference.PartyReferenceBuilder newStatusAppliesTo = PartyReference.builder();
                return newStatusAppliesTo;
            });
        }

        @Override
        @RosettaAttribute(value="tradeIdentifier")
        @RuneAttribute(value="tradeIdentifier")
        public ClearingStatusItemBuilder addTradeIdentifier(TradeIdentifier _tradeIdentifier) {
            if (_tradeIdentifier != null) {
                this.tradeIdentifier.add(_tradeIdentifier.toBuilder());
            }
            return this;
        }

        @Override
        public ClearingStatusItemBuilder addTradeIdentifier(TradeIdentifier _tradeIdentifier, int idx) {
            this.getIndex(this.tradeIdentifier, idx, () -> _tradeIdentifier.toBuilder());
            return this;
        }

        @Override
        public ClearingStatusItemBuilder addTradeIdentifier(List<? extends TradeIdentifier> tradeIdentifiers) {
            if (tradeIdentifiers != null) {
                for (TradeIdentifier tradeIdentifier : tradeIdentifiers) {
                    this.tradeIdentifier.add(tradeIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="tradeIdentifier")
        public ClearingStatusItemBuilder setTradeIdentifier(List<? extends TradeIdentifier> tradeIdentifiers) {
            this.tradeIdentifier = tradeIdentifiers == null ? new ArrayList<TradeIdentifier.TradeIdentifierBuilder>() : (List)tradeIdentifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="tradeReferenceInformationModel")
        @RuneAttribute(value="tradeReferenceInformationModel")
        public ClearingStatusItemBuilder setTradeReferenceInformationModel(TradeReferenceInformationModel _tradeReferenceInformationModel) {
            this.tradeReferenceInformationModel = _tradeReferenceInformationModel == null ? null : _tradeReferenceInformationModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="trade")
        @RuneAttribute(value="trade")
        public ClearingStatusItemBuilder setTrade(Trade _trade) {
            this.trade = _trade == null ? null : _trade.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="tradePackage")
        @RuneAttribute(value="tradePackage")
        public ClearingStatusItemBuilder setTradePackage(TradePackage _tradePackage) {
            this.tradePackage = _tradePackage == null ? null : _tradePackage.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="eventValuationModel")
        @RuneAttribute(value="eventValuationModel")
        public ClearingStatusItemBuilder setEventValuationModel(EventValuationModel _eventValuationModel) {
            this.eventValuationModel = _eventValuationModel == null ? null : _eventValuationModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="clearingStatusValue", isRequired=true)
        @RuneAttribute(value="clearingStatusValue", isRequired=true)
        public ClearingStatusItemBuilder setClearingStatusValue(ClearingStatusValue _clearingStatusValue) {
            this.clearingStatusValue = _clearingStatusValue == null ? null : _clearingStatusValue.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="updatedDateTime")
        @RuneAttribute(value="updatedDateTime")
        public ClearingStatusItemBuilder setUpdatedDateTime(ZonedDateTime _updatedDateTime) {
            this.updatedDateTime = _updatedDateTime == null ? null : _updatedDateTime;
            return this;
        }

        @Override
        @RosettaAttribute(value="reason")
        @RuneAttribute(value="reason")
        public ClearingStatusItemBuilder addReason(Reason _reason) {
            if (_reason != null) {
                this.reason.add(_reason.toBuilder());
            }
            return this;
        }

        @Override
        public ClearingStatusItemBuilder addReason(Reason _reason, int idx) {
            this.getIndex(this.reason, idx, () -> _reason.toBuilder());
            return this;
        }

        @Override
        public ClearingStatusItemBuilder addReason(List<? extends Reason> reasons) {
            if (reasons != null) {
                for (Reason reason : reasons) {
                    this.reason.add(reason.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="reason")
        public ClearingStatusItemBuilder setReason(List<? extends Reason> reasons) {
            this.reason = reasons == null ? new ArrayList<Reason.ReasonBuilder>() : (List)reasons.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="statusAppliesTo")
        @RuneAttribute(value="statusAppliesTo")
        public ClearingStatusItemBuilder addStatusAppliesTo(PartyReference _statusAppliesTo) {
            if (_statusAppliesTo != null) {
                this.statusAppliesTo.add(_statusAppliesTo.toBuilder());
            }
            return this;
        }

        @Override
        public ClearingStatusItemBuilder addStatusAppliesTo(PartyReference _statusAppliesTo, int idx) {
            this.getIndex(this.statusAppliesTo, idx, () -> _statusAppliesTo.toBuilder());
            return this;
        }

        @Override
        public ClearingStatusItemBuilder addStatusAppliesTo(List<? extends PartyReference> statusAppliesTos) {
            if (statusAppliesTos != null) {
                for (PartyReference partyReference : statusAppliesTos) {
                    this.statusAppliesTo.add(partyReference.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="statusAppliesTo")
        public ClearingStatusItemBuilder setStatusAppliesTo(List<? extends PartyReference> statusAppliesTos) {
            this.statusAppliesTo = statusAppliesTos == null ? new ArrayList<PartyReference.PartyReferenceBuilder>() : (List)statusAppliesTos.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public ClearingStatusItem build() {
            return new ClearingStatusItemImpl(this);
        }

        @Override
        public ClearingStatusItemBuilder toBuilder() {
            return this;
        }

        @Override
        public ClearingStatusItemBuilder prune() {
            this.tradeIdentifier = this.tradeIdentifier.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.tradeReferenceInformationModel != null && !this.tradeReferenceInformationModel.prune().hasData()) {
                this.tradeReferenceInformationModel = null;
            }
            if (this.trade != null && !this.trade.prune().hasData()) {
                this.trade = null;
            }
            if (this.tradePackage != null && !this.tradePackage.prune().hasData()) {
                this.tradePackage = null;
            }
            if (this.eventValuationModel != null && !this.eventValuationModel.prune().hasData()) {
                this.eventValuationModel = null;
            }
            if (this.clearingStatusValue != null && !this.clearingStatusValue.prune().hasData()) {
                this.clearingStatusValue = null;
            }
            this.reason = this.reason.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.statusAppliesTo = this.statusAppliesTo.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getTradeIdentifier() != null && this.getTradeIdentifier().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getTradeReferenceInformationModel() != null && this.getTradeReferenceInformationModel().hasData()) {
                return true;
            }
            if (this.getTrade() != null && this.getTrade().hasData()) {
                return true;
            }
            if (this.getTradePackage() != null && this.getTradePackage().hasData()) {
                return true;
            }
            if (this.getEventValuationModel() != null && this.getEventValuationModel().hasData()) {
                return true;
            }
            if (this.getClearingStatusValue() != null && this.getClearingStatusValue().hasData()) {
                return true;
            }
            if (this.getUpdatedDateTime() != null) {
                return true;
            }
            if (this.getReason() != null && this.getReason().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getStatusAppliesTo() != null && this.getStatusAppliesTo().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public ClearingStatusItemBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            ClearingStatusItemBuilder o = (ClearingStatusItemBuilder)other;
            merger.mergeRosetta(this.getTradeIdentifier(), o.getTradeIdentifier(), this::getOrCreateTradeIdentifier);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getTradeReferenceInformationModel(), (RosettaModelObjectBuilder)o.getTradeReferenceInformationModel(), this::setTradeReferenceInformationModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getTrade(), (RosettaModelObjectBuilder)o.getTrade(), this::setTrade);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getTradePackage(), (RosettaModelObjectBuilder)o.getTradePackage(), this::setTradePackage);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getEventValuationModel(), (RosettaModelObjectBuilder)o.getEventValuationModel(), this::setEventValuationModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getClearingStatusValue(), (RosettaModelObjectBuilder)o.getClearingStatusValue(), this::setClearingStatusValue);
            merger.mergeRosetta(this.getReason(), o.getReason(), this::getOrCreateReason);
            merger.mergeRosetta(this.getStatusAppliesTo(), o.getStatusAppliesTo(), this::getOrCreateStatusAppliesTo);
            merger.mergeBasic((Object)this.getUpdatedDateTime(), (Object)o.getUpdatedDateTime(), this::setUpdatedDateTime, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ClearingStatusItem _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.tradeIdentifier, _that.getTradeIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.tradeReferenceInformationModel, _that.getTradeReferenceInformationModel())) {
                return false;
            }
            if (!Objects.equals(this.trade, _that.getTrade())) {
                return false;
            }
            if (!Objects.equals(this.tradePackage, _that.getTradePackage())) {
                return false;
            }
            if (!Objects.equals(this.eventValuationModel, _that.getEventValuationModel())) {
                return false;
            }
            if (!Objects.equals(this.clearingStatusValue, _that.getClearingStatusValue())) {
                return false;
            }
            if (!Objects.equals(this.updatedDateTime, _that.getUpdatedDateTime())) {
                return false;
            }
            if (!ListEquals.listEquals(this.reason, _that.getReason())) {
                return false;
            }
            return ListEquals.listEquals(this.statusAppliesTo, _that.getStatusAppliesTo());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.tradeIdentifier != null ? this.tradeIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.tradeReferenceInformationModel != null ? this.tradeReferenceInformationModel.hashCode() : 0);
            _result = 31 * _result + (this.trade != null ? this.trade.hashCode() : 0);
            _result = 31 * _result + (this.tradePackage != null ? this.tradePackage.hashCode() : 0);
            _result = 31 * _result + (this.eventValuationModel != null ? this.eventValuationModel.hashCode() : 0);
            _result = 31 * _result + (this.clearingStatusValue != null ? this.clearingStatusValue.hashCode() : 0);
            _result = 31 * _result + (this.updatedDateTime != null ? this.updatedDateTime.hashCode() : 0);
            _result = 31 * _result + (this.reason != null ? this.reason.hashCode() : 0);
            _result = 31 * _result + (this.statusAppliesTo != null ? this.statusAppliesTo.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ClearingStatusItemBuilder {tradeIdentifier=" + this.tradeIdentifier + ", tradeReferenceInformationModel=" + this.tradeReferenceInformationModel + ", trade=" + this.trade + ", tradePackage=" + this.tradePackage + ", eventValuationModel=" + this.eventValuationModel + ", clearingStatusValue=" + this.clearingStatusValue + ", updatedDateTime=" + this.updatedDateTime + ", reason=" + this.reason + ", statusAppliesTo=" + this.statusAppliesTo + '}';
        }
    }

    public static interface ClearingStatusItemBuilder
    extends ClearingStatusItem,
    RosettaModelObjectBuilder {
        public TradeIdentifier.TradeIdentifierBuilder getOrCreateTradeIdentifier(int var1);

        public List<? extends TradeIdentifier.TradeIdentifierBuilder> getTradeIdentifier();

        public TradeReferenceInformationModel.TradeReferenceInformationModelBuilder getOrCreateTradeReferenceInformationModel();

        @Override
        public TradeReferenceInformationModel.TradeReferenceInformationModelBuilder getTradeReferenceInformationModel();

        public Trade.TradeBuilder getOrCreateTrade();

        @Override
        public Trade.TradeBuilder getTrade();

        public TradePackage.TradePackageBuilder getOrCreateTradePackage();

        @Override
        public TradePackage.TradePackageBuilder getTradePackage();

        public EventValuationModel.EventValuationModelBuilder getOrCreateEventValuationModel();

        @Override
        public EventValuationModel.EventValuationModelBuilder getEventValuationModel();

        public ClearingStatusValue.ClearingStatusValueBuilder getOrCreateClearingStatusValue();

        @Override
        public ClearingStatusValue.ClearingStatusValueBuilder getClearingStatusValue();

        public Reason.ReasonBuilder getOrCreateReason(int var1);

        public List<? extends Reason.ReasonBuilder> getReason();

        public PartyReference.PartyReferenceBuilder getOrCreateStatusAppliesTo(int var1);

        public List<? extends PartyReference.PartyReferenceBuilder> getStatusAppliesTo();

        public ClearingStatusItemBuilder addTradeIdentifier(TradeIdentifier var1);

        public ClearingStatusItemBuilder addTradeIdentifier(TradeIdentifier var1, int var2);

        public ClearingStatusItemBuilder addTradeIdentifier(List<? extends TradeIdentifier> var1);

        public ClearingStatusItemBuilder setTradeIdentifier(List<? extends TradeIdentifier> var1);

        public ClearingStatusItemBuilder setTradeReferenceInformationModel(TradeReferenceInformationModel var1);

        public ClearingStatusItemBuilder setTrade(Trade var1);

        public ClearingStatusItemBuilder setTradePackage(TradePackage var1);

        public ClearingStatusItemBuilder setEventValuationModel(EventValuationModel var1);

        public ClearingStatusItemBuilder setClearingStatusValue(ClearingStatusValue var1);

        public ClearingStatusItemBuilder setUpdatedDateTime(ZonedDateTime var1);

        public ClearingStatusItemBuilder addReason(Reason var1);

        public ClearingStatusItemBuilder addReason(Reason var1, int var2);

        public ClearingStatusItemBuilder addReason(List<? extends Reason> var1);

        public ClearingStatusItemBuilder setReason(List<? extends Reason> var1);

        public ClearingStatusItemBuilder addStatusAppliesTo(PartyReference var1);

        public ClearingStatusItemBuilder addStatusAppliesTo(PartyReference var1, int var2);

        public ClearingStatusItemBuilder addStatusAppliesTo(List<? extends PartyReference> var1);

        public ClearingStatusItemBuilder setStatusAppliesTo(List<? extends PartyReference> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("tradeIdentifier"), processor, TradeIdentifier.TradeIdentifierBuilder.class, this.getTradeIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("tradeReferenceInformationModel"), processor, TradeReferenceInformationModel.TradeReferenceInformationModelBuilder.class, this.getTradeReferenceInformationModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("trade"), processor, Trade.TradeBuilder.class, this.getTrade(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("tradePackage"), processor, TradePackage.TradePackageBuilder.class, this.getTradePackage(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("eventValuationModel"), processor, EventValuationModel.EventValuationModelBuilder.class, this.getEventValuationModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("clearingStatusValue"), processor, ClearingStatusValue.ClearingStatusValueBuilder.class, this.getClearingStatusValue(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("updatedDateTime"), ZonedDateTime.class, (Object)this.getUpdatedDateTime(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("reason"), processor, Reason.ReasonBuilder.class, this.getReason(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("statusAppliesTo"), processor, PartyReference.PartyReferenceBuilder.class, this.getStatusAppliesTo(), new AttributeMeta[0]);
        }

        public ClearingStatusItemBuilder prune();
    }

    public static class ClearingStatusItemImpl
    implements ClearingStatusItem {
        private final List<? extends TradeIdentifier> tradeIdentifier;
        private final TradeReferenceInformationModel tradeReferenceInformationModel;
        private final Trade trade;
        private final TradePackage tradePackage;
        private final EventValuationModel eventValuationModel;
        private final ClearingStatusValue clearingStatusValue;
        private final ZonedDateTime updatedDateTime;
        private final List<? extends Reason> reason;
        private final List<? extends PartyReference> statusAppliesTo;

        protected ClearingStatusItemImpl(ClearingStatusItemBuilder builder) {
            this.tradeIdentifier = Optional.ofNullable(builder.getTradeIdentifier()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.tradeReferenceInformationModel = Optional.ofNullable(builder.getTradeReferenceInformationModel()).map(f -> f.build()).orElse(null);
            this.trade = Optional.ofNullable(builder.getTrade()).map(f -> f.build()).orElse(null);
            this.tradePackage = Optional.ofNullable(builder.getTradePackage()).map(f -> f.build()).orElse(null);
            this.eventValuationModel = Optional.ofNullable(builder.getEventValuationModel()).map(f -> f.build()).orElse(null);
            this.clearingStatusValue = Optional.ofNullable(builder.getClearingStatusValue()).map(f -> f.build()).orElse(null);
            this.updatedDateTime = builder.getUpdatedDateTime();
            this.reason = Optional.ofNullable(builder.getReason()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.statusAppliesTo = Optional.ofNullable(builder.getStatusAppliesTo()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="tradeIdentifier")
        @RuneAttribute(value="tradeIdentifier")
        public List<? extends TradeIdentifier> getTradeIdentifier() {
            return this.tradeIdentifier;
        }

        @Override
        @RosettaAttribute(value="tradeReferenceInformationModel")
        @RuneAttribute(value="tradeReferenceInformationModel")
        public TradeReferenceInformationModel getTradeReferenceInformationModel() {
            return this.tradeReferenceInformationModel;
        }

        @Override
        @RosettaAttribute(value="trade")
        @RuneAttribute(value="trade")
        public Trade getTrade() {
            return this.trade;
        }

        @Override
        @RosettaAttribute(value="tradePackage")
        @RuneAttribute(value="tradePackage")
        public TradePackage getTradePackage() {
            return this.tradePackage;
        }

        @Override
        @RosettaAttribute(value="eventValuationModel")
        @RuneAttribute(value="eventValuationModel")
        public EventValuationModel getEventValuationModel() {
            return this.eventValuationModel;
        }

        @Override
        @RosettaAttribute(value="clearingStatusValue", isRequired=true)
        @RuneAttribute(value="clearingStatusValue", isRequired=true)
        public ClearingStatusValue getClearingStatusValue() {
            return this.clearingStatusValue;
        }

        @Override
        @RosettaAttribute(value="updatedDateTime")
        @RuneAttribute(value="updatedDateTime")
        public ZonedDateTime getUpdatedDateTime() {
            return this.updatedDateTime;
        }

        @Override
        @RosettaAttribute(value="reason")
        @RuneAttribute(value="reason")
        public List<? extends Reason> getReason() {
            return this.reason;
        }

        @Override
        @RosettaAttribute(value="statusAppliesTo")
        @RuneAttribute(value="statusAppliesTo")
        public List<? extends PartyReference> getStatusAppliesTo() {
            return this.statusAppliesTo;
        }

        @Override
        public ClearingStatusItem build() {
            return this;
        }

        @Override
        public ClearingStatusItemBuilder toBuilder() {
            ClearingStatusItemBuilder builder = ClearingStatusItem.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ClearingStatusItemBuilder builder) {
            Optional.ofNullable(this.getTradeIdentifier()).ifPresent(builder::setTradeIdentifier);
            Optional.ofNullable(this.getTradeReferenceInformationModel()).ifPresent(builder::setTradeReferenceInformationModel);
            Optional.ofNullable(this.getTrade()).ifPresent(builder::setTrade);
            Optional.ofNullable(this.getTradePackage()).ifPresent(builder::setTradePackage);
            Optional.ofNullable(this.getEventValuationModel()).ifPresent(builder::setEventValuationModel);
            Optional.ofNullable(this.getClearingStatusValue()).ifPresent(builder::setClearingStatusValue);
            Optional.ofNullable(this.getUpdatedDateTime()).ifPresent(builder::setUpdatedDateTime);
            Optional.ofNullable(this.getReason()).ifPresent(builder::setReason);
            Optional.ofNullable(this.getStatusAppliesTo()).ifPresent(builder::setStatusAppliesTo);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ClearingStatusItem _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.tradeIdentifier, _that.getTradeIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.tradeReferenceInformationModel, _that.getTradeReferenceInformationModel())) {
                return false;
            }
            if (!Objects.equals(this.trade, _that.getTrade())) {
                return false;
            }
            if (!Objects.equals(this.tradePackage, _that.getTradePackage())) {
                return false;
            }
            if (!Objects.equals(this.eventValuationModel, _that.getEventValuationModel())) {
                return false;
            }
            if (!Objects.equals(this.clearingStatusValue, _that.getClearingStatusValue())) {
                return false;
            }
            if (!Objects.equals(this.updatedDateTime, _that.getUpdatedDateTime())) {
                return false;
            }
            if (!ListEquals.listEquals(this.reason, _that.getReason())) {
                return false;
            }
            return ListEquals.listEquals(this.statusAppliesTo, _that.getStatusAppliesTo());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.tradeIdentifier != null ? this.tradeIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.tradeReferenceInformationModel != null ? this.tradeReferenceInformationModel.hashCode() : 0);
            _result = 31 * _result + (this.trade != null ? this.trade.hashCode() : 0);
            _result = 31 * _result + (this.tradePackage != null ? this.tradePackage.hashCode() : 0);
            _result = 31 * _result + (this.eventValuationModel != null ? this.eventValuationModel.hashCode() : 0);
            _result = 31 * _result + (this.clearingStatusValue != null ? this.clearingStatusValue.hashCode() : 0);
            _result = 31 * _result + (this.updatedDateTime != null ? this.updatedDateTime.hashCode() : 0);
            _result = 31 * _result + (this.reason != null ? this.reason.hashCode() : 0);
            _result = 31 * _result + (this.statusAppliesTo != null ? this.statusAppliesTo.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ClearingStatusItem {tradeIdentifier=" + this.tradeIdentifier + ", tradeReferenceInformationModel=" + this.tradeReferenceInformationModel + ", trade=" + this.trade + ", tradePackage=" + this.tradePackage + ", eventValuationModel=" + this.eventValuationModel + ", clearingStatusValue=" + this.clearingStatusValue + ", updatedDateTime=" + this.updatedDateTime + ", reason=" + this.reason + ", statusAppliesTo=" + this.statusAppliesTo + '}';
        }
    }
}

