/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.asset;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.asset.InstrumentType;
import fpml.consolidated.asset.UnderlyingAsset;
import fpml.consolidated.asset.meta.SimpleFraMeta;
import fpml.consolidated.shared.ClearanceSystem;
import fpml.consolidated.shared.DayCountFraction;
import fpml.consolidated.shared.ExchangeId;
import fpml.consolidated.shared.IdentifiedCurrency;
import fpml.consolidated.shared.InstrumentId;
import fpml.consolidated.shared.Period;
import fpml.consolidated.shared.ProductReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="SimpleFra", builder=SimpleFraBuilderImpl.class, version="1.1.0")
@RuneDataType(value="SimpleFra", model="fpml", builder=SimpleFraBuilderImpl.class, version="1.1.0")
public interface SimpleFra
extends UnderlyingAsset {
    public static final SimpleFraMeta metaData = new SimpleFraMeta();

    public Period getStartTerm();

    public Period getEndTerm();

    public DayCountFraction getDayCountFraction();

    @Override
    public SimpleFra build();

    @Override
    public SimpleFraBuilder toBuilder();

    public static SimpleFraBuilder builder() {
        return new SimpleFraBuilderImpl();
    }

    default public RosettaMetaData<? extends SimpleFra> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends SimpleFra> getType() {
        return SimpleFra.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("instrumentId"), processor, InstrumentId.class, this.getInstrumentId(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("instrumentType"), processor, InstrumentType.class, this.getInstrumentType(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("description"), String.class, (Object)this.getDescription(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("currency"), processor, IdentifiedCurrency.class, this.getCurrency(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("exchangeId"), processor, ExchangeId.class, this.getExchangeId(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("clearanceSystem"), processor, ClearanceSystem.class, this.getClearanceSystem(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("definition"), processor, ProductReference.class, this.getDefinition(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("startTerm"), processor, Period.class, this.getStartTerm(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("endTerm"), processor, Period.class, this.getEndTerm(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("dayCountFraction"), processor, DayCountFraction.class, this.getDayCountFraction(), new AttributeMeta[0]);
    }

    public static class SimpleFraBuilderImpl
    extends UnderlyingAsset.UnderlyingAssetBuilderImpl
    implements SimpleFraBuilder {
        protected Period.PeriodBuilder startTerm;
        protected Period.PeriodBuilder endTerm;
        protected DayCountFraction.DayCountFractionBuilder dayCountFraction;

        @Override
        @RosettaAttribute(value="startTerm")
        @RuneAttribute(value="startTerm")
        public Period.PeriodBuilder getStartTerm() {
            return this.startTerm;
        }

        @Override
        public Period.PeriodBuilder getOrCreateStartTerm() {
            Period.PeriodBuilder result = this.startTerm != null ? this.startTerm : (this.startTerm = Period.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="endTerm")
        @RuneAttribute(value="endTerm")
        public Period.PeriodBuilder getEndTerm() {
            return this.endTerm;
        }

        @Override
        public Period.PeriodBuilder getOrCreateEndTerm() {
            Period.PeriodBuilder result = this.endTerm != null ? this.endTerm : (this.endTerm = Period.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="dayCountFraction")
        @RuneAttribute(value="dayCountFraction")
        public DayCountFraction.DayCountFractionBuilder getDayCountFraction() {
            return this.dayCountFraction;
        }

        @Override
        public DayCountFraction.DayCountFractionBuilder getOrCreateDayCountFraction() {
            DayCountFraction.DayCountFractionBuilder result = this.dayCountFraction != null ? this.dayCountFraction : (this.dayCountFraction = DayCountFraction.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public SimpleFraBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="instrumentId", isRequired=true)
        @RuneAttribute(value="instrumentId", isRequired=true)
        public SimpleFraBuilder addInstrumentId(InstrumentId _instrumentId) {
            if (_instrumentId != null) {
                this.instrumentId.add(_instrumentId.toBuilder());
            }
            return this;
        }

        @Override
        public SimpleFraBuilder addInstrumentId(InstrumentId _instrumentId, int idx) {
            this.getIndex(this.instrumentId, idx, () -> _instrumentId.toBuilder());
            return this;
        }

        @Override
        public SimpleFraBuilder addInstrumentId(List<? extends InstrumentId> instrumentIds) {
            if (instrumentIds != null) {
                for (InstrumentId instrumentId : instrumentIds) {
                    this.instrumentId.add(instrumentId.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="instrumentId")
        public SimpleFraBuilder setInstrumentId(List<? extends InstrumentId> instrumentIds) {
            this.instrumentId = instrumentIds == null ? new ArrayList() : (List)instrumentIds.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="instrumentType")
        @RuneAttribute(value="instrumentType")
        public SimpleFraBuilder addInstrumentType(InstrumentType _instrumentType) {
            if (_instrumentType != null) {
                this.instrumentType.add(_instrumentType.toBuilder());
            }
            return this;
        }

        @Override
        public SimpleFraBuilder addInstrumentType(InstrumentType _instrumentType, int idx) {
            this.getIndex(this.instrumentType, idx, () -> _instrumentType.toBuilder());
            return this;
        }

        @Override
        public SimpleFraBuilder addInstrumentType(List<? extends InstrumentType> instrumentTypes) {
            if (instrumentTypes != null) {
                for (InstrumentType instrumentType : instrumentTypes) {
                    this.instrumentType.add(instrumentType.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="instrumentType")
        public SimpleFraBuilder setInstrumentType(List<? extends InstrumentType> instrumentTypes) {
            this.instrumentType = instrumentTypes == null ? new ArrayList() : (List)instrumentTypes.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="description")
        @RuneAttribute(value="description")
        public SimpleFraBuilder setDescription(String _description) {
            this.description = _description == null ? null : _description;
            return this;
        }

        @Override
        @RosettaAttribute(value="currency")
        @RuneAttribute(value="currency")
        public SimpleFraBuilder setCurrency(IdentifiedCurrency _currency) {
            this.currency = _currency == null ? null : _currency.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="exchangeId")
        @RuneAttribute(value="exchangeId")
        public SimpleFraBuilder setExchangeId(ExchangeId _exchangeId) {
            this.exchangeId = _exchangeId == null ? null : _exchangeId.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="clearanceSystem")
        @RuneAttribute(value="clearanceSystem")
        public SimpleFraBuilder setClearanceSystem(ClearanceSystem _clearanceSystem) {
            this.clearanceSystem = _clearanceSystem == null ? null : _clearanceSystem.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="definition")
        @RuneAttribute(value="definition")
        public SimpleFraBuilder setDefinition(ProductReference _definition) {
            this.definition = _definition == null ? null : _definition.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="startTerm")
        @RuneAttribute(value="startTerm")
        public SimpleFraBuilder setStartTerm(Period _startTerm) {
            this.startTerm = _startTerm == null ? null : _startTerm.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="endTerm")
        @RuneAttribute(value="endTerm")
        public SimpleFraBuilder setEndTerm(Period _endTerm) {
            this.endTerm = _endTerm == null ? null : _endTerm.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="dayCountFraction")
        @RuneAttribute(value="dayCountFraction")
        public SimpleFraBuilder setDayCountFraction(DayCountFraction _dayCountFraction) {
            this.dayCountFraction = _dayCountFraction == null ? null : _dayCountFraction.toBuilder();
            return this;
        }

        @Override
        public SimpleFra build() {
            return new SimpleFraImpl(this);
        }

        @Override
        public SimpleFraBuilder toBuilder() {
            return this;
        }

        @Override
        public SimpleFraBuilder prune() {
            super.prune();
            if (this.startTerm != null && !this.startTerm.prune().hasData()) {
                this.startTerm = null;
            }
            if (this.endTerm != null && !this.endTerm.prune().hasData()) {
                this.endTerm = null;
            }
            if (this.dayCountFraction != null && !this.dayCountFraction.prune().hasData()) {
                this.dayCountFraction = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getStartTerm() != null && this.getStartTerm().hasData()) {
                return true;
            }
            if (this.getEndTerm() != null && this.getEndTerm().hasData()) {
                return true;
            }
            return this.getDayCountFraction() != null && this.getDayCountFraction().hasData();
        }

        @Override
        public SimpleFraBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            SimpleFraBuilder o = (SimpleFraBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getStartTerm(), (RosettaModelObjectBuilder)o.getStartTerm(), this::setStartTerm);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getEndTerm(), (RosettaModelObjectBuilder)o.getEndTerm(), this::setEndTerm);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDayCountFraction(), (RosettaModelObjectBuilder)o.getDayCountFraction(), this::setDayCountFraction);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            SimpleFra _that = (SimpleFra)this.getType().cast(o);
            if (!Objects.equals(this.startTerm, _that.getStartTerm())) {
                return false;
            }
            if (!Objects.equals(this.endTerm, _that.getEndTerm())) {
                return false;
            }
            return Objects.equals(this.dayCountFraction, _that.getDayCountFraction());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.startTerm != null ? this.startTerm.hashCode() : 0);
            _result = 31 * _result + (this.endTerm != null ? this.endTerm.hashCode() : 0);
            _result = 31 * _result + (this.dayCountFraction != null ? this.dayCountFraction.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "SimpleFraBuilder {startTerm=" + this.startTerm + ", endTerm=" + this.endTerm + ", dayCountFraction=" + this.dayCountFraction + '}' + " " + super.toString();
        }
    }

    public static interface SimpleFraBuilder
    extends SimpleFra,
    UnderlyingAsset.UnderlyingAssetBuilder {
        public Period.PeriodBuilder getOrCreateStartTerm();

        @Override
        public Period.PeriodBuilder getStartTerm();

        public Period.PeriodBuilder getOrCreateEndTerm();

        @Override
        public Period.PeriodBuilder getEndTerm();

        public DayCountFraction.DayCountFractionBuilder getOrCreateDayCountFraction();

        @Override
        public DayCountFraction.DayCountFractionBuilder getDayCountFraction();

        @Override
        public SimpleFraBuilder setId(String var1);

        @Override
        public SimpleFraBuilder addInstrumentId(InstrumentId var1);

        @Override
        public SimpleFraBuilder addInstrumentId(InstrumentId var1, int var2);

        @Override
        public SimpleFraBuilder addInstrumentId(List<? extends InstrumentId> var1);

        @Override
        public SimpleFraBuilder setInstrumentId(List<? extends InstrumentId> var1);

        @Override
        public SimpleFraBuilder addInstrumentType(InstrumentType var1);

        @Override
        public SimpleFraBuilder addInstrumentType(InstrumentType var1, int var2);

        @Override
        public SimpleFraBuilder addInstrumentType(List<? extends InstrumentType> var1);

        @Override
        public SimpleFraBuilder setInstrumentType(List<? extends InstrumentType> var1);

        @Override
        public SimpleFraBuilder setDescription(String var1);

        @Override
        public SimpleFraBuilder setCurrency(IdentifiedCurrency var1);

        @Override
        public SimpleFraBuilder setExchangeId(ExchangeId var1);

        @Override
        public SimpleFraBuilder setClearanceSystem(ClearanceSystem var1);

        @Override
        public SimpleFraBuilder setDefinition(ProductReference var1);

        public SimpleFraBuilder setStartTerm(Period var1);

        public SimpleFraBuilder setEndTerm(Period var1);

        public SimpleFraBuilder setDayCountFraction(DayCountFraction var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("instrumentId"), processor, InstrumentId.InstrumentIdBuilder.class, this.getInstrumentId(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("instrumentType"), processor, InstrumentType.InstrumentTypeBuilder.class, this.getInstrumentType(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("description"), String.class, (Object)this.getDescription(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("currency"), processor, IdentifiedCurrency.IdentifiedCurrencyBuilder.class, (RosettaModelObjectBuilder)this.getCurrency(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("exchangeId"), processor, ExchangeId.ExchangeIdBuilder.class, (RosettaModelObjectBuilder)this.getExchangeId(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("clearanceSystem"), processor, ClearanceSystem.ClearanceSystemBuilder.class, (RosettaModelObjectBuilder)this.getClearanceSystem(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("definition"), processor, ProductReference.ProductReferenceBuilder.class, (RosettaModelObjectBuilder)this.getDefinition(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("startTerm"), processor, Period.PeriodBuilder.class, this.getStartTerm(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("endTerm"), processor, Period.PeriodBuilder.class, this.getEndTerm(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("dayCountFraction"), processor, DayCountFraction.DayCountFractionBuilder.class, this.getDayCountFraction(), new AttributeMeta[0]);
        }

        @Override
        public SimpleFraBuilder prune();
    }

    public static class SimpleFraImpl
    extends UnderlyingAsset.UnderlyingAssetImpl
    implements SimpleFra {
        private final Period startTerm;
        private final Period endTerm;
        private final DayCountFraction dayCountFraction;

        protected SimpleFraImpl(SimpleFraBuilder builder) {
            super(builder);
            this.startTerm = Optional.ofNullable(builder.getStartTerm()).map(f -> f.build()).orElse(null);
            this.endTerm = Optional.ofNullable(builder.getEndTerm()).map(f -> f.build()).orElse(null);
            this.dayCountFraction = Optional.ofNullable(builder.getDayCountFraction()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="startTerm")
        @RuneAttribute(value="startTerm")
        public Period getStartTerm() {
            return this.startTerm;
        }

        @Override
        @RosettaAttribute(value="endTerm")
        @RuneAttribute(value="endTerm")
        public Period getEndTerm() {
            return this.endTerm;
        }

        @Override
        @RosettaAttribute(value="dayCountFraction")
        @RuneAttribute(value="dayCountFraction")
        public DayCountFraction getDayCountFraction() {
            return this.dayCountFraction;
        }

        @Override
        public SimpleFra build() {
            return this;
        }

        @Override
        public SimpleFraBuilder toBuilder() {
            SimpleFraBuilder builder = SimpleFra.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(SimpleFraBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getStartTerm()).ifPresent(builder::setStartTerm);
            Optional.ofNullable(this.getEndTerm()).ifPresent(builder::setEndTerm);
            Optional.ofNullable(this.getDayCountFraction()).ifPresent(builder::setDayCountFraction);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            SimpleFra _that = (SimpleFra)this.getType().cast(o);
            if (!Objects.equals(this.startTerm, _that.getStartTerm())) {
                return false;
            }
            if (!Objects.equals(this.endTerm, _that.getEndTerm())) {
                return false;
            }
            return Objects.equals(this.dayCountFraction, _that.getDayCountFraction());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.startTerm != null ? this.startTerm.hashCode() : 0);
            _result = 31 * _result + (this.endTerm != null ? this.endTerm.hashCode() : 0);
            _result = 31 * _result + (this.dayCountFraction != null ? this.dayCountFraction.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "SimpleFra {startTerm=" + this.startTerm + ", endTerm=" + this.endTerm + ", dayCountFraction=" + this.dayCountFraction + '}' + " " + super.toString();
        }
    }
}

