/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.asset;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.asset.Commission;
import fpml.consolidated.asset.EquityPriceModel;
import fpml.consolidated.asset.PriceSequence;
import fpml.consolidated.asset.QuotationCharacteristics;
import fpml.consolidated.asset.meta.PriceMeta;
import fpml.consolidated.shared.AmountReference;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="Price", builder=PriceBuilderImpl.class, version="1.1.0")
@RuneDataType(value="Price", model="fpml", builder=PriceBuilderImpl.class, version="1.1.0")
public interface Price
extends RosettaModelObject {
    public static final PriceMeta metaData = new PriceMeta();

    public Commission getCommission();

    public PriceSequence getPriceSequence();

    public AmountReference getAmountRelativeTo();

    public EquityPriceModel getEquityPriceModel();

    public BigDecimal getCleanNetPrice();

    public QuotationCharacteristics getQuotationCharacteristics();

    public Price build();

    public PriceBuilder toBuilder();

    public static PriceBuilder builder() {
        return new PriceBuilderImpl();
    }

    default public RosettaMetaData<? extends Price> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends Price> getType() {
        return Price.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("commission"), processor, Commission.class, this.getCommission(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("priceSequence"), processor, PriceSequence.class, this.getPriceSequence(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("amountRelativeTo"), processor, AmountReference.class, this.getAmountRelativeTo(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("equityPriceModel"), processor, EquityPriceModel.class, this.getEquityPriceModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("cleanNetPrice"), BigDecimal.class, (Object)this.getCleanNetPrice(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("quotationCharacteristics"), processor, QuotationCharacteristics.class, this.getQuotationCharacteristics(), new AttributeMeta[0]);
    }

    public static class PriceBuilderImpl
    implements PriceBuilder {
        protected Commission.CommissionBuilder commission;
        protected PriceSequence.PriceSequenceBuilder priceSequence;
        protected AmountReference.AmountReferenceBuilder amountRelativeTo;
        protected EquityPriceModel.EquityPriceModelBuilder equityPriceModel;
        protected BigDecimal cleanNetPrice;
        protected QuotationCharacteristics.QuotationCharacteristicsBuilder quotationCharacteristics;

        @Override
        @RosettaAttribute(value="commission")
        @RuneAttribute(value="commission")
        public Commission.CommissionBuilder getCommission() {
            return this.commission;
        }

        @Override
        public Commission.CommissionBuilder getOrCreateCommission() {
            Commission.CommissionBuilder result = this.commission != null ? this.commission : (this.commission = Commission.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="priceSequence")
        @RuneAttribute(value="priceSequence")
        public PriceSequence.PriceSequenceBuilder getPriceSequence() {
            return this.priceSequence;
        }

        @Override
        public PriceSequence.PriceSequenceBuilder getOrCreatePriceSequence() {
            PriceSequence.PriceSequenceBuilder result = this.priceSequence != null ? this.priceSequence : (this.priceSequence = PriceSequence.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="amountRelativeTo")
        @RuneAttribute(value="amountRelativeTo")
        public AmountReference.AmountReferenceBuilder getAmountRelativeTo() {
            return this.amountRelativeTo;
        }

        @Override
        public AmountReference.AmountReferenceBuilder getOrCreateAmountRelativeTo() {
            AmountReference.AmountReferenceBuilder result = this.amountRelativeTo != null ? this.amountRelativeTo : (this.amountRelativeTo = AmountReference.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="equityPriceModel")
        @RuneAttribute(value="equityPriceModel")
        public EquityPriceModel.EquityPriceModelBuilder getEquityPriceModel() {
            return this.equityPriceModel;
        }

        @Override
        public EquityPriceModel.EquityPriceModelBuilder getOrCreateEquityPriceModel() {
            EquityPriceModel.EquityPriceModelBuilder result = this.equityPriceModel != null ? this.equityPriceModel : (this.equityPriceModel = EquityPriceModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="cleanNetPrice")
        @RuneAttribute(value="cleanNetPrice")
        public BigDecimal getCleanNetPrice() {
            return this.cleanNetPrice;
        }

        @Override
        @RosettaAttribute(value="quotationCharacteristics")
        @RuneAttribute(value="quotationCharacteristics")
        public QuotationCharacteristics.QuotationCharacteristicsBuilder getQuotationCharacteristics() {
            return this.quotationCharacteristics;
        }

        @Override
        public QuotationCharacteristics.QuotationCharacteristicsBuilder getOrCreateQuotationCharacteristics() {
            QuotationCharacteristics.QuotationCharacteristicsBuilder result = this.quotationCharacteristics != null ? this.quotationCharacteristics : (this.quotationCharacteristics = QuotationCharacteristics.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="commission")
        @RuneAttribute(value="commission")
        public PriceBuilder setCommission(Commission _commission) {
            this.commission = _commission == null ? null : _commission.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="priceSequence")
        @RuneAttribute(value="priceSequence")
        public PriceBuilder setPriceSequence(PriceSequence _priceSequence) {
            this.priceSequence = _priceSequence == null ? null : _priceSequence.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="amountRelativeTo")
        @RuneAttribute(value="amountRelativeTo")
        public PriceBuilder setAmountRelativeTo(AmountReference _amountRelativeTo) {
            this.amountRelativeTo = _amountRelativeTo == null ? null : _amountRelativeTo.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="equityPriceModel")
        @RuneAttribute(value="equityPriceModel")
        public PriceBuilder setEquityPriceModel(EquityPriceModel _equityPriceModel) {
            this.equityPriceModel = _equityPriceModel == null ? null : _equityPriceModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="cleanNetPrice")
        @RuneAttribute(value="cleanNetPrice")
        public PriceBuilder setCleanNetPrice(BigDecimal _cleanNetPrice) {
            this.cleanNetPrice = _cleanNetPrice == null ? null : _cleanNetPrice;
            return this;
        }

        @Override
        @RosettaAttribute(value="quotationCharacteristics")
        @RuneAttribute(value="quotationCharacteristics")
        public PriceBuilder setQuotationCharacteristics(QuotationCharacteristics _quotationCharacteristics) {
            this.quotationCharacteristics = _quotationCharacteristics == null ? null : _quotationCharacteristics.toBuilder();
            return this;
        }

        @Override
        public Price build() {
            return new PriceImpl(this);
        }

        @Override
        public PriceBuilder toBuilder() {
            return this;
        }

        @Override
        public PriceBuilder prune() {
            if (this.commission != null && !this.commission.prune().hasData()) {
                this.commission = null;
            }
            if (this.priceSequence != null && !this.priceSequence.prune().hasData()) {
                this.priceSequence = null;
            }
            if (this.amountRelativeTo != null && !this.amountRelativeTo.prune().hasData()) {
                this.amountRelativeTo = null;
            }
            if (this.equityPriceModel != null && !this.equityPriceModel.prune().hasData()) {
                this.equityPriceModel = null;
            }
            if (this.quotationCharacteristics != null && !this.quotationCharacteristics.prune().hasData()) {
                this.quotationCharacteristics = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getCommission() != null && this.getCommission().hasData()) {
                return true;
            }
            if (this.getPriceSequence() != null && this.getPriceSequence().hasData()) {
                return true;
            }
            if (this.getAmountRelativeTo() != null && this.getAmountRelativeTo().hasData()) {
                return true;
            }
            if (this.getEquityPriceModel() != null && this.getEquityPriceModel().hasData()) {
                return true;
            }
            if (this.getCleanNetPrice() != null) {
                return true;
            }
            return this.getQuotationCharacteristics() != null && this.getQuotationCharacteristics().hasData();
        }

        public PriceBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            PriceBuilder o = (PriceBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCommission(), (RosettaModelObjectBuilder)o.getCommission(), this::setCommission);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPriceSequence(), (RosettaModelObjectBuilder)o.getPriceSequence(), this::setPriceSequence);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAmountRelativeTo(), (RosettaModelObjectBuilder)o.getAmountRelativeTo(), this::setAmountRelativeTo);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getEquityPriceModel(), (RosettaModelObjectBuilder)o.getEquityPriceModel(), this::setEquityPriceModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getQuotationCharacteristics(), (RosettaModelObjectBuilder)o.getQuotationCharacteristics(), this::setQuotationCharacteristics);
            merger.mergeBasic((Object)this.getCleanNetPrice(), (Object)o.getCleanNetPrice(), this::setCleanNetPrice, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Price _that = this.getType().cast(o);
            if (!Objects.equals(this.commission, _that.getCommission())) {
                return false;
            }
            if (!Objects.equals(this.priceSequence, _that.getPriceSequence())) {
                return false;
            }
            if (!Objects.equals(this.amountRelativeTo, _that.getAmountRelativeTo())) {
                return false;
            }
            if (!Objects.equals(this.equityPriceModel, _that.getEquityPriceModel())) {
                return false;
            }
            if (!Objects.equals(this.cleanNetPrice, _that.getCleanNetPrice())) {
                return false;
            }
            return Objects.equals(this.quotationCharacteristics, _that.getQuotationCharacteristics());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.commission != null ? this.commission.hashCode() : 0);
            _result = 31 * _result + (this.priceSequence != null ? this.priceSequence.hashCode() : 0);
            _result = 31 * _result + (this.amountRelativeTo != null ? this.amountRelativeTo.hashCode() : 0);
            _result = 31 * _result + (this.equityPriceModel != null ? this.equityPriceModel.hashCode() : 0);
            _result = 31 * _result + (this.cleanNetPrice != null ? this.cleanNetPrice.hashCode() : 0);
            _result = 31 * _result + (this.quotationCharacteristics != null ? this.quotationCharacteristics.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "PriceBuilder {commission=" + this.commission + ", priceSequence=" + this.priceSequence + ", amountRelativeTo=" + this.amountRelativeTo + ", equityPriceModel=" + this.equityPriceModel + ", cleanNetPrice=" + this.cleanNetPrice + ", quotationCharacteristics=" + this.quotationCharacteristics + '}';
        }
    }

    public static interface PriceBuilder
    extends Price,
    RosettaModelObjectBuilder {
        public Commission.CommissionBuilder getOrCreateCommission();

        @Override
        public Commission.CommissionBuilder getCommission();

        public PriceSequence.PriceSequenceBuilder getOrCreatePriceSequence();

        @Override
        public PriceSequence.PriceSequenceBuilder getPriceSequence();

        public AmountReference.AmountReferenceBuilder getOrCreateAmountRelativeTo();

        @Override
        public AmountReference.AmountReferenceBuilder getAmountRelativeTo();

        public EquityPriceModel.EquityPriceModelBuilder getOrCreateEquityPriceModel();

        @Override
        public EquityPriceModel.EquityPriceModelBuilder getEquityPriceModel();

        public QuotationCharacteristics.QuotationCharacteristicsBuilder getOrCreateQuotationCharacteristics();

        @Override
        public QuotationCharacteristics.QuotationCharacteristicsBuilder getQuotationCharacteristics();

        public PriceBuilder setCommission(Commission var1);

        public PriceBuilder setPriceSequence(PriceSequence var1);

        public PriceBuilder setAmountRelativeTo(AmountReference var1);

        public PriceBuilder setEquityPriceModel(EquityPriceModel var1);

        public PriceBuilder setCleanNetPrice(BigDecimal var1);

        public PriceBuilder setQuotationCharacteristics(QuotationCharacteristics var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("commission"), processor, Commission.CommissionBuilder.class, this.getCommission(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("priceSequence"), processor, PriceSequence.PriceSequenceBuilder.class, this.getPriceSequence(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("amountRelativeTo"), processor, AmountReference.AmountReferenceBuilder.class, this.getAmountRelativeTo(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("equityPriceModel"), processor, EquityPriceModel.EquityPriceModelBuilder.class, this.getEquityPriceModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("cleanNetPrice"), BigDecimal.class, (Object)this.getCleanNetPrice(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("quotationCharacteristics"), processor, QuotationCharacteristics.QuotationCharacteristicsBuilder.class, this.getQuotationCharacteristics(), new AttributeMeta[0]);
        }

        public PriceBuilder prune();
    }

    public static class PriceImpl
    implements Price {
        private final Commission commission;
        private final PriceSequence priceSequence;
        private final AmountReference amountRelativeTo;
        private final EquityPriceModel equityPriceModel;
        private final BigDecimal cleanNetPrice;
        private final QuotationCharacteristics quotationCharacteristics;

        protected PriceImpl(PriceBuilder builder) {
            this.commission = Optional.ofNullable(builder.getCommission()).map(f -> f.build()).orElse(null);
            this.priceSequence = Optional.ofNullable(builder.getPriceSequence()).map(f -> f.build()).orElse(null);
            this.amountRelativeTo = Optional.ofNullable(builder.getAmountRelativeTo()).map(f -> f.build()).orElse(null);
            this.equityPriceModel = Optional.ofNullable(builder.getEquityPriceModel()).map(f -> f.build()).orElse(null);
            this.cleanNetPrice = builder.getCleanNetPrice();
            this.quotationCharacteristics = Optional.ofNullable(builder.getQuotationCharacteristics()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="commission")
        @RuneAttribute(value="commission")
        public Commission getCommission() {
            return this.commission;
        }

        @Override
        @RosettaAttribute(value="priceSequence")
        @RuneAttribute(value="priceSequence")
        public PriceSequence getPriceSequence() {
            return this.priceSequence;
        }

        @Override
        @RosettaAttribute(value="amountRelativeTo")
        @RuneAttribute(value="amountRelativeTo")
        public AmountReference getAmountRelativeTo() {
            return this.amountRelativeTo;
        }

        @Override
        @RosettaAttribute(value="equityPriceModel")
        @RuneAttribute(value="equityPriceModel")
        public EquityPriceModel getEquityPriceModel() {
            return this.equityPriceModel;
        }

        @Override
        @RosettaAttribute(value="cleanNetPrice")
        @RuneAttribute(value="cleanNetPrice")
        public BigDecimal getCleanNetPrice() {
            return this.cleanNetPrice;
        }

        @Override
        @RosettaAttribute(value="quotationCharacteristics")
        @RuneAttribute(value="quotationCharacteristics")
        public QuotationCharacteristics getQuotationCharacteristics() {
            return this.quotationCharacteristics;
        }

        @Override
        public Price build() {
            return this;
        }

        @Override
        public PriceBuilder toBuilder() {
            PriceBuilder builder = Price.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(PriceBuilder builder) {
            Optional.ofNullable(this.getCommission()).ifPresent(builder::setCommission);
            Optional.ofNullable(this.getPriceSequence()).ifPresent(builder::setPriceSequence);
            Optional.ofNullable(this.getAmountRelativeTo()).ifPresent(builder::setAmountRelativeTo);
            Optional.ofNullable(this.getEquityPriceModel()).ifPresent(builder::setEquityPriceModel);
            Optional.ofNullable(this.getCleanNetPrice()).ifPresent(builder::setCleanNetPrice);
            Optional.ofNullable(this.getQuotationCharacteristics()).ifPresent(builder::setQuotationCharacteristics);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Price _that = this.getType().cast(o);
            if (!Objects.equals(this.commission, _that.getCommission())) {
                return false;
            }
            if (!Objects.equals(this.priceSequence, _that.getPriceSequence())) {
                return false;
            }
            if (!Objects.equals(this.amountRelativeTo, _that.getAmountRelativeTo())) {
                return false;
            }
            if (!Objects.equals(this.equityPriceModel, _that.getEquityPriceModel())) {
                return false;
            }
            if (!Objects.equals(this.cleanNetPrice, _that.getCleanNetPrice())) {
                return false;
            }
            return Objects.equals(this.quotationCharacteristics, _that.getQuotationCharacteristics());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.commission != null ? this.commission.hashCode() : 0);
            _result = 31 * _result + (this.priceSequence != null ? this.priceSequence.hashCode() : 0);
            _result = 31 * _result + (this.amountRelativeTo != null ? this.amountRelativeTo.hashCode() : 0);
            _result = 31 * _result + (this.equityPriceModel != null ? this.equityPriceModel.hashCode() : 0);
            _result = 31 * _result + (this.cleanNetPrice != null ? this.cleanNetPrice.hashCode() : 0);
            _result = 31 * _result + (this.quotationCharacteristics != null ? this.quotationCharacteristics.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "Price {commission=" + this.commission + ", priceSequence=" + this.priceSequence + ", amountRelativeTo=" + this.amountRelativeTo + ", equityPriceModel=" + this.equityPriceModel + ", cleanNetPrice=" + this.cleanNetPrice + ", quotationCharacteristics=" + this.quotationCharacteristics + '}';
        }
    }
}

