/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.asset;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.asset.PriceQuoteUnits;
import fpml.consolidated.asset.meta.ExchangeTradedOptionSequenceMeta;
import fpml.consolidated.shared.Currency;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="ExchangeTradedOptionSequence", builder=ExchangeTradedOptionSequenceBuilderImpl.class, version="1.1.0")
@RuneDataType(value="ExchangeTradedOptionSequence", model="fpml", builder=ExchangeTradedOptionSequenceBuilderImpl.class, version="1.1.0")
public interface ExchangeTradedOptionSequence
extends RosettaModelObject {
    public static final ExchangeTradedOptionSequenceMeta metaData = new ExchangeTradedOptionSequenceMeta();

    public BigDecimal getStrike();

    public Currency getStrikeCurrency();

    public PriceQuoteUnits getStrikeUnits();

    public ExchangeTradedOptionSequence build();

    public ExchangeTradedOptionSequenceBuilder toBuilder();

    public static ExchangeTradedOptionSequenceBuilder builder() {
        return new ExchangeTradedOptionSequenceBuilderImpl();
    }

    default public RosettaMetaData<? extends ExchangeTradedOptionSequence> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends ExchangeTradedOptionSequence> getType() {
        return ExchangeTradedOptionSequence.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("strike"), BigDecimal.class, (Object)this.getStrike(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("strikeCurrency"), processor, Currency.class, this.getStrikeCurrency(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("strikeUnits"), processor, PriceQuoteUnits.class, this.getStrikeUnits(), new AttributeMeta[0]);
    }

    public static class ExchangeTradedOptionSequenceBuilderImpl
    implements ExchangeTradedOptionSequenceBuilder {
        protected BigDecimal strike;
        protected Currency.CurrencyBuilder strikeCurrency;
        protected PriceQuoteUnits.PriceQuoteUnitsBuilder strikeUnits;

        @Override
        @RosettaAttribute(value="strike")
        @RuneAttribute(value="strike")
        public BigDecimal getStrike() {
            return this.strike;
        }

        @Override
        @RosettaAttribute(value="strikeCurrency")
        @RuneAttribute(value="strikeCurrency")
        public Currency.CurrencyBuilder getStrikeCurrency() {
            return this.strikeCurrency;
        }

        @Override
        public Currency.CurrencyBuilder getOrCreateStrikeCurrency() {
            Currency.CurrencyBuilder result = this.strikeCurrency != null ? this.strikeCurrency : (this.strikeCurrency = Currency.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="strikeUnits")
        @RuneAttribute(value="strikeUnits")
        public PriceQuoteUnits.PriceQuoteUnitsBuilder getStrikeUnits() {
            return this.strikeUnits;
        }

        @Override
        public PriceQuoteUnits.PriceQuoteUnitsBuilder getOrCreateStrikeUnits() {
            PriceQuoteUnits.PriceQuoteUnitsBuilder result = this.strikeUnits != null ? this.strikeUnits : (this.strikeUnits = PriceQuoteUnits.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="strike")
        @RuneAttribute(value="strike")
        public ExchangeTradedOptionSequenceBuilder setStrike(BigDecimal _strike) {
            this.strike = _strike == null ? null : _strike;
            return this;
        }

        @Override
        @RosettaAttribute(value="strikeCurrency")
        @RuneAttribute(value="strikeCurrency")
        public ExchangeTradedOptionSequenceBuilder setStrikeCurrency(Currency _strikeCurrency) {
            this.strikeCurrency = _strikeCurrency == null ? null : _strikeCurrency.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="strikeUnits")
        @RuneAttribute(value="strikeUnits")
        public ExchangeTradedOptionSequenceBuilder setStrikeUnits(PriceQuoteUnits _strikeUnits) {
            this.strikeUnits = _strikeUnits == null ? null : _strikeUnits.toBuilder();
            return this;
        }

        @Override
        public ExchangeTradedOptionSequence build() {
            return new ExchangeTradedOptionSequenceImpl(this);
        }

        @Override
        public ExchangeTradedOptionSequenceBuilder toBuilder() {
            return this;
        }

        @Override
        public ExchangeTradedOptionSequenceBuilder prune() {
            if (this.strikeCurrency != null && !this.strikeCurrency.prune().hasData()) {
                this.strikeCurrency = null;
            }
            if (this.strikeUnits != null && !this.strikeUnits.prune().hasData()) {
                this.strikeUnits = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getStrike() != null) {
                return true;
            }
            if (this.getStrikeCurrency() != null && this.getStrikeCurrency().hasData()) {
                return true;
            }
            return this.getStrikeUnits() != null && this.getStrikeUnits().hasData();
        }

        public ExchangeTradedOptionSequenceBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            ExchangeTradedOptionSequenceBuilder o = (ExchangeTradedOptionSequenceBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getStrikeCurrency(), (RosettaModelObjectBuilder)o.getStrikeCurrency(), this::setStrikeCurrency);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getStrikeUnits(), (RosettaModelObjectBuilder)o.getStrikeUnits(), this::setStrikeUnits);
            merger.mergeBasic((Object)this.getStrike(), (Object)o.getStrike(), this::setStrike, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ExchangeTradedOptionSequence _that = this.getType().cast(o);
            if (!Objects.equals(this.strike, _that.getStrike())) {
                return false;
            }
            if (!Objects.equals(this.strikeCurrency, _that.getStrikeCurrency())) {
                return false;
            }
            return Objects.equals(this.strikeUnits, _that.getStrikeUnits());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.strike != null ? this.strike.hashCode() : 0);
            _result = 31 * _result + (this.strikeCurrency != null ? this.strikeCurrency.hashCode() : 0);
            _result = 31 * _result + (this.strikeUnits != null ? this.strikeUnits.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ExchangeTradedOptionSequenceBuilder {strike=" + this.strike + ", strikeCurrency=" + this.strikeCurrency + ", strikeUnits=" + this.strikeUnits + '}';
        }
    }

    public static interface ExchangeTradedOptionSequenceBuilder
    extends ExchangeTradedOptionSequence,
    RosettaModelObjectBuilder {
        public Currency.CurrencyBuilder getOrCreateStrikeCurrency();

        @Override
        public Currency.CurrencyBuilder getStrikeCurrency();

        public PriceQuoteUnits.PriceQuoteUnitsBuilder getOrCreateStrikeUnits();

        @Override
        public PriceQuoteUnits.PriceQuoteUnitsBuilder getStrikeUnits();

        public ExchangeTradedOptionSequenceBuilder setStrike(BigDecimal var1);

        public ExchangeTradedOptionSequenceBuilder setStrikeCurrency(Currency var1);

        public ExchangeTradedOptionSequenceBuilder setStrikeUnits(PriceQuoteUnits var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("strike"), BigDecimal.class, (Object)this.getStrike(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("strikeCurrency"), processor, Currency.CurrencyBuilder.class, this.getStrikeCurrency(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("strikeUnits"), processor, PriceQuoteUnits.PriceQuoteUnitsBuilder.class, this.getStrikeUnits(), new AttributeMeta[0]);
        }

        public ExchangeTradedOptionSequenceBuilder prune();
    }

    public static class ExchangeTradedOptionSequenceImpl
    implements ExchangeTradedOptionSequence {
        private final BigDecimal strike;
        private final Currency strikeCurrency;
        private final PriceQuoteUnits strikeUnits;

        protected ExchangeTradedOptionSequenceImpl(ExchangeTradedOptionSequenceBuilder builder) {
            this.strike = builder.getStrike();
            this.strikeCurrency = Optional.ofNullable(builder.getStrikeCurrency()).map(f -> f.build()).orElse(null);
            this.strikeUnits = Optional.ofNullable(builder.getStrikeUnits()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="strike")
        @RuneAttribute(value="strike")
        public BigDecimal getStrike() {
            return this.strike;
        }

        @Override
        @RosettaAttribute(value="strikeCurrency")
        @RuneAttribute(value="strikeCurrency")
        public Currency getStrikeCurrency() {
            return this.strikeCurrency;
        }

        @Override
        @RosettaAttribute(value="strikeUnits")
        @RuneAttribute(value="strikeUnits")
        public PriceQuoteUnits getStrikeUnits() {
            return this.strikeUnits;
        }

        @Override
        public ExchangeTradedOptionSequence build() {
            return this;
        }

        @Override
        public ExchangeTradedOptionSequenceBuilder toBuilder() {
            ExchangeTradedOptionSequenceBuilder builder = ExchangeTradedOptionSequence.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ExchangeTradedOptionSequenceBuilder builder) {
            Optional.ofNullable(this.getStrike()).ifPresent(builder::setStrike);
            Optional.ofNullable(this.getStrikeCurrency()).ifPresent(builder::setStrikeCurrency);
            Optional.ofNullable(this.getStrikeUnits()).ifPresent(builder::setStrikeUnits);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ExchangeTradedOptionSequence _that = this.getType().cast(o);
            if (!Objects.equals(this.strike, _that.getStrike())) {
                return false;
            }
            if (!Objects.equals(this.strikeCurrency, _that.getStrikeCurrency())) {
                return false;
            }
            return Objects.equals(this.strikeUnits, _that.getStrikeUnits());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.strike != null ? this.strike.hashCode() : 0);
            _result = 31 * _result + (this.strikeCurrency != null ? this.strikeCurrency.hashCode() : 0);
            _result = 31 * _result + (this.strikeUnits != null ? this.strikeUnits.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ExchangeTradedOptionSequence {strike=" + this.strike + ", strikeCurrency=" + this.strikeCurrency + ", strikeUnits=" + this.strikeUnits + '}';
        }
    }
}

