/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.common.settlement;

import cdm.observable.asset.Money;
import cdm.observable.asset.metafields.ReferenceWithMetaMoney;
import cdm.product.common.settlement.meta.PercentageRuleMeta;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="PercentageRule", builder=PercentageRuleBuilderImpl.class, version="7.0.0-dev.52")
@RuneDataType(value="PercentageRule", model="cdm", builder=PercentageRuleBuilderImpl.class, version="7.0.0-dev.52")
public interface PercentageRule
extends RosettaModelObject {
    public static final PercentageRuleMeta metaData = new PercentageRuleMeta();

    public BigDecimal getPaymentPercent();

    public ReferenceWithMetaMoney getNotionalAmountReference();

    public PercentageRule build();

    public PercentageRuleBuilder toBuilder();

    public static PercentageRuleBuilder builder() {
        return new PercentageRuleBuilderImpl();
    }

    default public RosettaMetaData<? extends PercentageRule> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends PercentageRule> getType() {
        return PercentageRule.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("paymentPercent"), BigDecimal.class, (Object)this.getPaymentPercent(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("notionalAmountReference"), processor, ReferenceWithMetaMoney.class, this.getNotionalAmountReference(), new AttributeMeta[0]);
    }

    public static class PercentageRuleBuilderImpl
    implements PercentageRuleBuilder {
        protected BigDecimal paymentPercent;
        protected ReferenceWithMetaMoney.ReferenceWithMetaMoneyBuilder notionalAmountReference;

        @Override
        @RosettaAttribute(value="paymentPercent", isRequired=true)
        @RuneAttribute(value="paymentPercent", isRequired=true)
        public BigDecimal getPaymentPercent() {
            return this.paymentPercent;
        }

        @Override
        @RosettaAttribute(value="notionalAmountReference", isRequired=true)
        @RuneAttribute(value="notionalAmountReference", isRequired=true)
        public ReferenceWithMetaMoney.ReferenceWithMetaMoneyBuilder getNotionalAmountReference() {
            return this.notionalAmountReference;
        }

        @Override
        public ReferenceWithMetaMoney.ReferenceWithMetaMoneyBuilder getOrCreateNotionalAmountReference() {
            ReferenceWithMetaMoney.ReferenceWithMetaMoneyBuilder result = this.notionalAmountReference != null ? this.notionalAmountReference : (this.notionalAmountReference = ReferenceWithMetaMoney.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="paymentPercent", isRequired=true)
        @RuneAttribute(value="paymentPercent", isRequired=true)
        public PercentageRuleBuilder setPaymentPercent(BigDecimal _paymentPercent) {
            this.paymentPercent = _paymentPercent == null ? null : _paymentPercent;
            return this;
        }

        @Override
        @RosettaAttribute(value="notionalAmountReference", isRequired=true)
        @RuneAttribute(value="notionalAmountReference", isRequired=true)
        public PercentageRuleBuilder setNotionalAmountReference(ReferenceWithMetaMoney _notionalAmountReference) {
            this.notionalAmountReference = _notionalAmountReference == null ? null : _notionalAmountReference.toBuilder();
            return this;
        }

        @Override
        public PercentageRuleBuilder setNotionalAmountReferenceValue(Money _notionalAmountReference) {
            this.getOrCreateNotionalAmountReference().setValue(_notionalAmountReference);
            return this;
        }

        @Override
        public PercentageRule build() {
            return new PercentageRuleImpl(this);
        }

        @Override
        public PercentageRuleBuilder toBuilder() {
            return this;
        }

        @Override
        public PercentageRuleBuilder prune() {
            if (this.notionalAmountReference != null && !this.notionalAmountReference.prune().hasData()) {
                this.notionalAmountReference = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getPaymentPercent() != null) {
                return true;
            }
            return this.getNotionalAmountReference() != null && this.getNotionalAmountReference().hasData();
        }

        public PercentageRuleBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            PercentageRuleBuilder o = (PercentageRuleBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getNotionalAmountReference(), (RosettaModelObjectBuilder)o.getNotionalAmountReference(), this::setNotionalAmountReference);
            merger.mergeBasic((Object)this.getPaymentPercent(), (Object)o.getPaymentPercent(), this::setPaymentPercent, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            PercentageRule _that = this.getType().cast(o);
            if (!Objects.equals(this.paymentPercent, _that.getPaymentPercent())) {
                return false;
            }
            return Objects.equals(this.notionalAmountReference, _that.getNotionalAmountReference());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.paymentPercent != null ? this.paymentPercent.hashCode() : 0);
            _result = 31 * _result + (this.notionalAmountReference != null ? this.notionalAmountReference.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "PercentageRuleBuilder {paymentPercent=" + this.paymentPercent + ", notionalAmountReference=" + this.notionalAmountReference + '}';
        }
    }

    public static interface PercentageRuleBuilder
    extends PercentageRule,
    RosettaModelObjectBuilder {
        public ReferenceWithMetaMoney.ReferenceWithMetaMoneyBuilder getOrCreateNotionalAmountReference();

        @Override
        public ReferenceWithMetaMoney.ReferenceWithMetaMoneyBuilder getNotionalAmountReference();

        public PercentageRuleBuilder setPaymentPercent(BigDecimal var1);

        public PercentageRuleBuilder setNotionalAmountReference(ReferenceWithMetaMoney var1);

        public PercentageRuleBuilder setNotionalAmountReferenceValue(Money var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("paymentPercent"), BigDecimal.class, (Object)this.getPaymentPercent(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("notionalAmountReference"), processor, ReferenceWithMetaMoney.ReferenceWithMetaMoneyBuilder.class, this.getNotionalAmountReference(), new AttributeMeta[0]);
        }

        public PercentageRuleBuilder prune();
    }

    public static class PercentageRuleImpl
    implements PercentageRule {
        private final BigDecimal paymentPercent;
        private final ReferenceWithMetaMoney notionalAmountReference;

        protected PercentageRuleImpl(PercentageRuleBuilder builder) {
            this.paymentPercent = builder.getPaymentPercent();
            this.notionalAmountReference = Optional.ofNullable(builder.getNotionalAmountReference()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="paymentPercent", isRequired=true)
        @RuneAttribute(value="paymentPercent", isRequired=true)
        public BigDecimal getPaymentPercent() {
            return this.paymentPercent;
        }

        @Override
        @RosettaAttribute(value="notionalAmountReference", isRequired=true)
        @RuneAttribute(value="notionalAmountReference", isRequired=true)
        public ReferenceWithMetaMoney getNotionalAmountReference() {
            return this.notionalAmountReference;
        }

        @Override
        public PercentageRule build() {
            return this;
        }

        @Override
        public PercentageRuleBuilder toBuilder() {
            PercentageRuleBuilder builder = PercentageRule.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(PercentageRuleBuilder builder) {
            Optional.ofNullable(this.getPaymentPercent()).ifPresent(builder::setPaymentPercent);
            Optional.ofNullable(this.getNotionalAmountReference()).ifPresent(builder::setNotionalAmountReference);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            PercentageRule _that = this.getType().cast(o);
            if (!Objects.equals(this.paymentPercent, _that.getPaymentPercent())) {
                return false;
            }
            return Objects.equals(this.notionalAmountReference, _that.getNotionalAmountReference());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.paymentPercent != null ? this.paymentPercent.hashCode() : 0);
            _result = 31 * _result + (this.notionalAmountReference != null ? this.notionalAmountReference.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "PercentageRule {paymentPercent=" + this.paymentPercent + ", notionalAmountReference=" + this.notionalAmountReference + '}';
        }
    }
}

