/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.asset.validation.datarule;

import cdm.observable.asset.CreditIndex;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="CreditIndexIndexFactor")
@ImplementedBy(value=Default.class)
public interface CreditIndexIndexFactor
extends Validator<CreditIndex> {
    public static final String NAME = "CreditIndexIndexFactor";
    public static final String DEFINITION = "if indexFactor exists then indexFactor >= 0 and indexFactor <= 1";

    public static class NoOp
    implements CreditIndexIndexFactor {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, CreditIndex creditIndex) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements CreditIndexIndexFactor {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, CreditIndex creditIndex) {
            ComparisonResult result = this.executeDataRule(creditIndex);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)CreditIndexIndexFactor.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"CreditIndex", (RosettaPath)path, (String)CreditIndexIndexFactor.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)CreditIndexIndexFactor.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"CreditIndex", (RosettaPath)path, (String)CreditIndexIndexFactor.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(CreditIndex creditIndex) {
            try {
                if (ExpressionOperators.exists((Mapper)MapperS.of((Object)creditIndex).map("getIndexFactor", _creditIndex -> _creditIndex.getIndexFactor())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperators.greaterThanEquals((Mapper)MapperS.of((Object)creditIndex).map("getIndexFactor", _creditIndex -> _creditIndex.getIndexFactor()), (Mapper)MapperS.of((Object)BigDecimal.valueOf(0L)), (CardinalityOperator)CardinalityOperator.All).and(ExpressionOperators.lessThanEquals((Mapper)MapperS.of((Object)creditIndex).map("getIndexFactor", _creditIndex -> _creditIndex.getIndexFactor()), (Mapper)MapperS.of((Object)BigDecimal.valueOf(1L)), (CardinalityOperator)CardinalityOperator.All));
                }
                return ComparisonResult.successEmptyOperand((String)"");
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

