/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.asset;

import cdm.base.datetime.Period;
import cdm.base.staticdata.asset.common.AssetClassEnum;
import cdm.base.staticdata.asset.common.AssetIdentifier;
import cdm.base.staticdata.asset.common.Taxonomy;
import cdm.base.staticdata.asset.rates.InflationRateIndexEnum;
import cdm.base.staticdata.asset.rates.metafields.FieldWithMetaInflationRateIndexEnum;
import cdm.base.staticdata.party.LegalEntity;
import cdm.observable.asset.IndexBase;
import cdm.observable.asset.meta.InflationIndexMeta;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.metafields.FieldWithMetaString;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="InflationIndex", builder=InflationIndexBuilderImpl.class, version="7.0.0-dev.52")
@RuneDataType(value="InflationIndex", model="cdm", builder=InflationIndexBuilderImpl.class, version="7.0.0-dev.52")
public interface InflationIndex
extends IndexBase {
    public static final InflationIndexMeta metaData = new InflationIndexMeta();

    public FieldWithMetaInflationRateIndexEnum getInflationRateIndex();

    public Period getIndexTenor();

    @Override
    public InflationIndex build();

    @Override
    public InflationIndexBuilder toBuilder();

    public static InflationIndexBuilder builder() {
        return new InflationIndexBuilderImpl();
    }

    default public RosettaMetaData<? extends InflationIndex> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends InflationIndex> getType() {
        return InflationIndex.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("identifier"), processor, AssetIdentifier.class, this.getIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("taxonomy"), processor, Taxonomy.class, this.getTaxonomy(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("isExchangeListed"), Boolean.class, (Object)this.getIsExchangeListed(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("exchange"), processor, LegalEntity.class, this.getExchange(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("relatedExchange"), processor, LegalEntity.class, this.getRelatedExchange(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("name"), processor, FieldWithMetaString.class, this.getName(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("provider"), processor, LegalEntity.class, this.getProvider(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("assetClass"), AssetClassEnum.class, (Object)this.getAssetClass(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("inflationRateIndex"), processor, FieldWithMetaInflationRateIndexEnum.class, this.getInflationRateIndex(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("indexTenor"), processor, Period.class, this.getIndexTenor(), new AttributeMeta[0]);
    }

    public static class InflationIndexBuilderImpl
    extends IndexBase.IndexBaseBuilderImpl
    implements InflationIndexBuilder {
        protected FieldWithMetaInflationRateIndexEnum.FieldWithMetaInflationRateIndexEnumBuilder inflationRateIndex;
        protected Period.PeriodBuilder indexTenor;

        @Override
        @RosettaAttribute(value="inflationRateIndex", isRequired=true)
        @RuneAttribute(value="inflationRateIndex", isRequired=true)
        public FieldWithMetaInflationRateIndexEnum.FieldWithMetaInflationRateIndexEnumBuilder getInflationRateIndex() {
            return this.inflationRateIndex;
        }

        @Override
        public FieldWithMetaInflationRateIndexEnum.FieldWithMetaInflationRateIndexEnumBuilder getOrCreateInflationRateIndex() {
            FieldWithMetaInflationRateIndexEnum.FieldWithMetaInflationRateIndexEnumBuilder result = this.inflationRateIndex != null ? this.inflationRateIndex : (this.inflationRateIndex = FieldWithMetaInflationRateIndexEnum.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="indexTenor")
        @RuneAttribute(value="indexTenor")
        public Period.PeriodBuilder getIndexTenor() {
            return this.indexTenor;
        }

        @Override
        public Period.PeriodBuilder getOrCreateIndexTenor() {
            Period.PeriodBuilder result = this.indexTenor != null ? this.indexTenor : (this.indexTenor = Period.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="identifier", isRequired=true)
        @RuneAttribute(value="identifier", isRequired=true)
        public InflationIndexBuilder addIdentifier(AssetIdentifier _identifier) {
            if (_identifier != null) {
                this.identifier.add(_identifier.toBuilder());
            }
            return this;
        }

        @Override
        public InflationIndexBuilder addIdentifier(AssetIdentifier _identifier, int idx) {
            this.getIndex(this.identifier, idx, () -> _identifier.toBuilder());
            return this;
        }

        @Override
        public InflationIndexBuilder addIdentifier(List<? extends AssetIdentifier> identifiers) {
            if (identifiers != null) {
                for (AssetIdentifier assetIdentifier : identifiers) {
                    this.identifier.add(assetIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="identifier")
        public InflationIndexBuilder setIdentifier(List<? extends AssetIdentifier> identifiers) {
            this.identifier = identifiers == null ? new ArrayList() : (List)identifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="taxonomy")
        @RuneAttribute(value="taxonomy")
        public InflationIndexBuilder addTaxonomy(Taxonomy _taxonomy) {
            if (_taxonomy != null) {
                this.taxonomy.add(_taxonomy.toBuilder());
            }
            return this;
        }

        @Override
        public InflationIndexBuilder addTaxonomy(Taxonomy _taxonomy, int idx) {
            this.getIndex(this.taxonomy, idx, () -> _taxonomy.toBuilder());
            return this;
        }

        @Override
        public InflationIndexBuilder addTaxonomy(List<? extends Taxonomy> taxonomys) {
            if (taxonomys != null) {
                for (Taxonomy taxonomy : taxonomys) {
                    this.taxonomy.add(taxonomy.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="taxonomy")
        public InflationIndexBuilder setTaxonomy(List<? extends Taxonomy> taxonomys) {
            this.taxonomy = taxonomys == null ? new ArrayList() : (List)taxonomys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="isExchangeListed")
        @RuneAttribute(value="isExchangeListed")
        public InflationIndexBuilder setIsExchangeListed(Boolean _isExchangeListed) {
            this.isExchangeListed = _isExchangeListed == null ? null : _isExchangeListed;
            return this;
        }

        @Override
        @RosettaAttribute(value="exchange")
        @RuneAttribute(value="exchange")
        public InflationIndexBuilder setExchange(LegalEntity _exchange) {
            this.exchange = _exchange == null ? null : _exchange.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="relatedExchange")
        @RuneAttribute(value="relatedExchange")
        public InflationIndexBuilder addRelatedExchange(LegalEntity _relatedExchange) {
            if (_relatedExchange != null) {
                this.relatedExchange.add(_relatedExchange.toBuilder());
            }
            return this;
        }

        @Override
        public InflationIndexBuilder addRelatedExchange(LegalEntity _relatedExchange, int idx) {
            this.getIndex(this.relatedExchange, idx, () -> _relatedExchange.toBuilder());
            return this;
        }

        @Override
        public InflationIndexBuilder addRelatedExchange(List<? extends LegalEntity> relatedExchanges) {
            if (relatedExchanges != null) {
                for (LegalEntity legalEntity : relatedExchanges) {
                    this.relatedExchange.add(legalEntity.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="relatedExchange")
        public InflationIndexBuilder setRelatedExchange(List<? extends LegalEntity> relatedExchanges) {
            this.relatedExchange = relatedExchanges == null ? new ArrayList() : (List)relatedExchanges.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="name")
        @RuneAttribute(value="name")
        public InflationIndexBuilder setName(FieldWithMetaString _name) {
            this.name = _name == null ? null : _name.toBuilder();
            return this;
        }

        @Override
        public InflationIndexBuilder setNameValue(String _name) {
            this.getOrCreateName().setValue(_name);
            return this;
        }

        @Override
        @RosettaAttribute(value="provider")
        @RuneAttribute(value="provider")
        public InflationIndexBuilder setProvider(LegalEntity _provider) {
            this.provider = _provider == null ? null : _provider.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="assetClass")
        @RuneAttribute(value="assetClass")
        public InflationIndexBuilder setAssetClass(AssetClassEnum _assetClass) {
            this.assetClass = _assetClass == null ? null : _assetClass;
            return this;
        }

        @Override
        @RosettaAttribute(value="inflationRateIndex", isRequired=true)
        @RuneAttribute(value="inflationRateIndex", isRequired=true)
        public InflationIndexBuilder setInflationRateIndex(FieldWithMetaInflationRateIndexEnum _inflationRateIndex) {
            this.inflationRateIndex = _inflationRateIndex == null ? null : _inflationRateIndex.toBuilder();
            return this;
        }

        @Override
        public InflationIndexBuilder setInflationRateIndexValue(InflationRateIndexEnum _inflationRateIndex) {
            this.getOrCreateInflationRateIndex().setValue(_inflationRateIndex);
            return this;
        }

        @Override
        @RosettaAttribute(value="indexTenor")
        @RuneAttribute(value="indexTenor")
        public InflationIndexBuilder setIndexTenor(Period _indexTenor) {
            this.indexTenor = _indexTenor == null ? null : _indexTenor.toBuilder();
            return this;
        }

        @Override
        public InflationIndex build() {
            return new InflationIndexImpl(this);
        }

        @Override
        public InflationIndexBuilder toBuilder() {
            return this;
        }

        @Override
        public InflationIndexBuilder prune() {
            super.prune();
            if (this.inflationRateIndex != null && !this.inflationRateIndex.prune().hasData()) {
                this.inflationRateIndex = null;
            }
            if (this.indexTenor != null && !this.indexTenor.prune().hasData()) {
                this.indexTenor = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getInflationRateIndex() != null) {
                return true;
            }
            return this.getIndexTenor() != null && this.getIndexTenor().hasData();
        }

        @Override
        public InflationIndexBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            InflationIndexBuilder o = (InflationIndexBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getInflationRateIndex(), (RosettaModelObjectBuilder)o.getInflationRateIndex(), this::setInflationRateIndex);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getIndexTenor(), (RosettaModelObjectBuilder)o.getIndexTenor(), this::setIndexTenor);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            InflationIndex _that = (InflationIndex)this.getType().cast(o);
            if (!Objects.equals(this.inflationRateIndex, _that.getInflationRateIndex())) {
                return false;
            }
            return Objects.equals(this.indexTenor, _that.getIndexTenor());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.inflationRateIndex != null ? this.inflationRateIndex.hashCode() : 0);
            _result = 31 * _result + (this.indexTenor != null ? this.indexTenor.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "InflationIndexBuilder {inflationRateIndex=" + this.inflationRateIndex + ", indexTenor=" + this.indexTenor + '}' + " " + super.toString();
        }
    }

    public static interface InflationIndexBuilder
    extends InflationIndex,
    IndexBase.IndexBaseBuilder {
        public FieldWithMetaInflationRateIndexEnum.FieldWithMetaInflationRateIndexEnumBuilder getOrCreateInflationRateIndex();

        @Override
        public FieldWithMetaInflationRateIndexEnum.FieldWithMetaInflationRateIndexEnumBuilder getInflationRateIndex();

        public Period.PeriodBuilder getOrCreateIndexTenor();

        @Override
        public Period.PeriodBuilder getIndexTenor();

        @Override
        public InflationIndexBuilder addIdentifier(AssetIdentifier var1);

        @Override
        public InflationIndexBuilder addIdentifier(AssetIdentifier var1, int var2);

        @Override
        public InflationIndexBuilder addIdentifier(List<? extends AssetIdentifier> var1);

        @Override
        public InflationIndexBuilder setIdentifier(List<? extends AssetIdentifier> var1);

        @Override
        public InflationIndexBuilder addTaxonomy(Taxonomy var1);

        @Override
        public InflationIndexBuilder addTaxonomy(Taxonomy var1, int var2);

        @Override
        public InflationIndexBuilder addTaxonomy(List<? extends Taxonomy> var1);

        @Override
        public InflationIndexBuilder setTaxonomy(List<? extends Taxonomy> var1);

        @Override
        public InflationIndexBuilder setIsExchangeListed(Boolean var1);

        @Override
        public InflationIndexBuilder setExchange(LegalEntity var1);

        @Override
        public InflationIndexBuilder addRelatedExchange(LegalEntity var1);

        @Override
        public InflationIndexBuilder addRelatedExchange(LegalEntity var1, int var2);

        @Override
        public InflationIndexBuilder addRelatedExchange(List<? extends LegalEntity> var1);

        @Override
        public InflationIndexBuilder setRelatedExchange(List<? extends LegalEntity> var1);

        @Override
        public InflationIndexBuilder setName(FieldWithMetaString var1);

        @Override
        public InflationIndexBuilder setNameValue(String var1);

        @Override
        public InflationIndexBuilder setProvider(LegalEntity var1);

        @Override
        public InflationIndexBuilder setAssetClass(AssetClassEnum var1);

        public InflationIndexBuilder setInflationRateIndex(FieldWithMetaInflationRateIndexEnum var1);

        public InflationIndexBuilder setInflationRateIndexValue(InflationRateIndexEnum var1);

        public InflationIndexBuilder setIndexTenor(Period var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("identifier"), processor, AssetIdentifier.AssetIdentifierBuilder.class, this.getIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("taxonomy"), processor, Taxonomy.TaxonomyBuilder.class, this.getTaxonomy(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("isExchangeListed"), Boolean.class, (Object)this.getIsExchangeListed(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("exchange"), processor, LegalEntity.LegalEntityBuilder.class, (RosettaModelObjectBuilder)this.getExchange(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("relatedExchange"), processor, LegalEntity.LegalEntityBuilder.class, this.getRelatedExchange(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("name"), processor, FieldWithMetaString.FieldWithMetaStringBuilder.class, (RosettaModelObjectBuilder)this.getName(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("provider"), processor, LegalEntity.LegalEntityBuilder.class, (RosettaModelObjectBuilder)this.getProvider(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("assetClass"), AssetClassEnum.class, (Object)this.getAssetClass(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("inflationRateIndex"), processor, FieldWithMetaInflationRateIndexEnum.FieldWithMetaInflationRateIndexEnumBuilder.class, this.getInflationRateIndex(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("indexTenor"), processor, Period.PeriodBuilder.class, this.getIndexTenor(), new AttributeMeta[0]);
        }

        @Override
        public InflationIndexBuilder prune();
    }

    public static class InflationIndexImpl
    extends IndexBase.IndexBaseImpl
    implements InflationIndex {
        private final FieldWithMetaInflationRateIndexEnum inflationRateIndex;
        private final Period indexTenor;

        protected InflationIndexImpl(InflationIndexBuilder builder) {
            super(builder);
            this.inflationRateIndex = Optional.ofNullable(builder.getInflationRateIndex()).map(f -> f.build()).orElse(null);
            this.indexTenor = Optional.ofNullable(builder.getIndexTenor()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="inflationRateIndex", isRequired=true)
        @RuneAttribute(value="inflationRateIndex", isRequired=true)
        public FieldWithMetaInflationRateIndexEnum getInflationRateIndex() {
            return this.inflationRateIndex;
        }

        @Override
        @RosettaAttribute(value="indexTenor")
        @RuneAttribute(value="indexTenor")
        public Period getIndexTenor() {
            return this.indexTenor;
        }

        @Override
        public InflationIndex build() {
            return this;
        }

        @Override
        public InflationIndexBuilder toBuilder() {
            InflationIndexBuilder builder = InflationIndex.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(InflationIndexBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getInflationRateIndex()).ifPresent(builder::setInflationRateIndex);
            Optional.ofNullable(this.getIndexTenor()).ifPresent(builder::setIndexTenor);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            InflationIndex _that = (InflationIndex)this.getType().cast(o);
            if (!Objects.equals(this.inflationRateIndex, _that.getInflationRateIndex())) {
                return false;
            }
            return Objects.equals(this.indexTenor, _that.getIndexTenor());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.inflationRateIndex != null ? this.inflationRateIndex.hashCode() : 0);
            _result = 31 * _result + (this.indexTenor != null ? this.indexTenor.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "InflationIndex {inflationRateIndex=" + this.inflationRateIndex + ", indexTenor=" + this.indexTenor + '}' + " " + super.toString();
        }
    }
}

